/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hpt.gateway;

import com.ibm.hpt.gateway.ApplicationLinkage;
import com.ibm.vgj.cso.CSOException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class ApplicationLinkageManager
extends Thread {
    public static final String COPYRIGHT = "(C) Copyright IBM Corp. 1999, 2000";
    public static final String VERSION = "4.5";
    Properties linkageProperties;
    public String linkageFile;

    public ApplicationLinkageManager() {
        this.linkageProperties = new Properties();
    }

    public ApplicationLinkageManager(String string) throws CSOException {
        Object[] objectArray = new Object[]{" ", " "};
        this.linkageProperties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.linkageProperties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("ApplicationLinkageManager: Error: gateway properties file, " + string + ", not found." + fileNotFoundException);
            objectArray[0] = fileNotFoundException;
            objectArray[1] = "ApplicationLinkageManager:gateway properties file, " + string;
            throw new CSOException("CSO7819E", objectArray);
        }
        catch (IOException iOException) {
            System.err.println("ApplicationLinkageManager: Error loading or closing gateway properties file. " + iOException);
            objectArray[0] = iOException;
            objectArray[1] = "ApplicationLinkageManager:gateway properties file, " + string;
            throw new CSOException("CSO7819E", objectArray);
        }
        this.setLinkageFile(string);
        this.start();
    }

    public synchronized ApplicationLinkage getLinkage(String string) throws CSOException {
        ApplicationLinkage applicationLinkage = null;
        boolean bl = true;
        String string2 = null;
        String string3 = "CSOKEYNOTFOUND";
        int n = string.length() + 1;
        while (n >= 0) {
            if (bl) {
                string2 = string;
                bl = false;
            } else {
                string2 = String.valueOf(string.substring(0, n)) + "*";
            }
            string3 = this.linkageProperties.getProperty("application." + string2, "CSOKEYNOTFOUND");
            if (!string3.equals("CSOKEYNOTFOUND")) {
                n = -1;
            }
            --n;
        }
        if (string3.equals("CSOKEYNOTFOUND")) {
            return null;
        }
        applicationLinkage = new ApplicationLinkage();
        applicationLinkage.setAppName(string);
        applicationLinkage.setCommType(this.getLinkageProperty("commtype", string2, string3));
        applicationLinkage.setContable(this.getLinkageProperty("contable", string2, string3));
        applicationLinkage.setGatewayHostname(this.getLinkageProperty("gatewayhostname", string2, string3));
        String string4 = this.getLinkageProperty("gatewayport", string2, string3);
        if (string4 != null) {
            applicationLinkage.setGatewayPort(new Integer(string4));
        } else {
            applicationLinkage.setGatewayPort(null);
        }
        applicationLinkage.setCtgLocation(this.getLinkageProperty("ctgLocation", string2, string3));
        applicationLinkage.setCtgPort(this.getLinkageProperty("ctgPort", string2, string3));
        applicationLinkage.setLocation(this.getLinkageProperty("location", string2, string3));
        string4 = this.getLinkageProperty("serverid", string2, string3);
        if (string4 != null && string4.equals("*")) {
            applicationLinkage.setServerid(string);
        } else {
            if (string4 == null) {
                string4 = new String();
            }
            applicationLinkage.setServerid(string4);
        }
        string4 = this.getLinkageProperty("javaProperty", string2, string3);
        if (string4 != null) {
            applicationLinkage.setJavaPackage(string4);
        } else {
            applicationLinkage.setJavaPackage("");
        }
        applicationLinkage.setURL(this.getLinkageProperty("URL", string2, string3));
        applicationLinkage.setIMSDestId(this.getLinkageProperty("imsdestid", string2, string3));
        applicationLinkage.setIMSGroupId(this.getLinkageProperty("imsgroupid", string2, string3));
        applicationLinkage.setTcpPort(this.getLinkageProperty("tcpport", string2, string3));
        applicationLinkage.setLibrary(this.getLinkageProperty("library", string2, string3));
        string4 = this.getLinkageProperty("remoteapptype", string2, string3);
        if (string4 != null && string4.equalsIgnoreCase("VGJAVA")) {
            applicationLinkage.setAppType(3L);
        }
        applicationLinkage.setAppLinkageManger(this);
        bl = true;
        string2 = null;
        string3 = "CSOKEYNOTFOUND";
        n = string.length() + 1;
        while (n >= 0) {
            if (bl) {
                string2 = string;
                bl = false;
            } else {
                string2 = String.valueOf(string.substring(0, n)) + "*";
            }
            string3 = this.linkageProperties.getProperty("application." + string2 + ".traceFlag", "CSOKEYNOTFOUND");
            if (!string3.equals("CSOKEYNOTFOUND")) {
                n = -1;
            }
            --n;
        }
        if (!string3.equals("CSOKEYNOTFOUND")) {
            applicationLinkage.setTraceFlag(string3);
        }
        return applicationLinkage.validate();
    }

    public String getLinkageFile() {
        return this.linkageFile;
    }

    public Properties getLinkageProperties() {
        return this.linkageProperties;
    }

    String getLinkageProperty(String string, String string2, String string3) {
        String string4;
        String string5 = this.linkageProperties.getProperty("application." + string2 + "." + string);
        if (string5 == null) {
            string5 = this.linkageProperties.getProperty("serverLinkage." + string3 + "." + string);
        }
        if ((string4 = string5) != null) {
            return string4.trim();
        }
        return string4;
    }

    public void run() {
        boolean bl = false;
        String string = null;
        while (!bl) {
            string = this.linkageProperties.getProperty("hptGateway.propertiesRefreshInterval");
            if (string == null || string.equals("0")) {
                System.out.println("No more refreshing of gateway properties file, " + this.linkageFile + ".");
                bl = true;
                continue;
            }
            try {
                System.out.println("hptGateway properties file, " + this.linkageFile + ", refresh interval: " + string + " minute(s).");
                Thread.sleep(new Long(string.trim()) * 60000L);
                System.out.println("Starting refresh of gateway properties file, " + this.linkageFile + ".");
            }
            catch (Exception exception) {
                System.err.println("ApplicationLinkageManager:run(): Error: " + exception);
                bl = true;
                break;
            }
            Properties properties = new Properties();
            try {
                String string2 = this.getLinkageFile();
                FileInputStream fileInputStream = new FileInputStream(string2);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (Exception exception) {
                System.err.println("ApplicationLinkageManager: Error: " + exception);
            }
            this.setLinkageProperties(properties);
        }
    }

    public void setLinkageFile(String string) {
        this.linkageFile = string;
    }

    public synchronized void setLinkageProperties(Properties properties) {
        this.linkageProperties = properties;
    }
}

