/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hpt.gateway;

import com.ibm.hpt.gateway.ApplicationLinkageManager;
import com.ibm.vgj.cso.CSOException;
import com.ibm.vgj.cso.CSOUtil;

public class ApplicationLinkage {
    public static final String COPYRIGHT = "(C) Copyright IBM Corp. 1999, 2000";
    public static final String VERSION = "4.5";
    private String appName;
    private String commType;
    private String contable;
    private String location;
    private String serverid;
    private String gatewayHostname;
    private Integer gatewayPort;
    private String ctgLocation;
    private String ctgPort;
    private int byteOrder;
    private String codePage;
    private String javaPackage;
    private String IMSDestId;
    private String IMSGroupId;
    private String tcpPort;
    private ApplicationLinkageManager appLinkageManger;
    public String traceFlag;
    public String library;
    private long appType;
    private String _url;
    private boolean bTrace = false;

    public ApplicationLinkage() {
        this.appName = "";
        this.commType = "";
        this.contable = "";
        this.location = "";
        this.serverid = "";
        this.gatewayHostname = "";
        this.gatewayPort = new Integer(0);
        this.ctgLocation = "";
        this.ctgPort = "";
        this.byteOrder = 0;
        this.codePage = "";
        this.javaPackage = "";
        this.IMSDestId = "        ";
        this.IMSGroupId = "        ";
        this.tcpPort = "";
        this.traceFlag = "0";
        this.library = "";
        this.appType = 0L;
    }

    public ApplicationLinkage(String string, String string2, String string3, String string4, String string5) {
        this.appName = string;
        this.commType = string2;
        this.contable = string3;
        this.location = string4;
        this.serverid = string5;
        this.library = "";
        this.gatewayHostname = "";
        this.gatewayPort = new Integer(0);
        this.ctgLocation = "";
        this.ctgPort = "";
        this.byteOrder = 0;
        this.codePage = "";
        this.javaPackage = "";
        this.IMSDestId = "        ";
        this.IMSGroupId = "        ";
        this.tcpPort = "";
        this.traceFlag = "0";
        this.appType = 0L;
    }

    public ApplicationLinkage(String string, String string2, String string3, String string4, String string5, String string6) {
        this.appName = string;
        this.commType = string2;
        this.contable = string3;
        this.location = string4;
        this.serverid = string5;
        this.library = string6;
        this.gatewayHostname = "";
        this.gatewayPort = new Integer(0);
        this.byteOrder = 0;
        this.codePage = "";
        this.javaPackage = "";
        this.IMSDestId = "        ";
        this.IMSGroupId = "        ";
        this.tcpPort = "";
        this.traceFlag = "0";
        this.appType = 0L;
    }

    public ApplicationLinkageManager getAppLinkageManger() {
        return this.appLinkageManger;
    }

    public String getAppName() {
        return this.appName;
    }

    public long getAppType() {
        return this.appType;
    }

    public int getByteOrder() {
        return this.byteOrder;
    }

    public String getCodePage() {
        return this.codePage;
    }

    public String getCommType() {
        return this.commType;
    }

    public String getContable() {
        return this.contable;
    }

    public String getCtgLocation() {
        return this.ctgLocation;
    }

    public String getCtgPort() {
        return this.ctgPort;
    }

    public String getGatewayHostname() {
        return this.gatewayHostname;
    }

    public int getGatewayPort() {
        if (this.gatewayPort == null) {
            return 0;
        }
        return this.gatewayPort;
    }

    public String getIMSDestId() {
        return this.IMSDestId;
    }

    public String getIMSGroupId() {
        return this.IMSGroupId;
    }

    public String getJavaPackage() {
        return this.javaPackage;
    }

    public String getLibrary() {
        return this.library;
    }

    public String getLocation() {
        return this.location;
    }

    public String getServerid() {
        return this.serverid;
    }

    public String getTcpPort() {
        return this.tcpPort;
    }

    public boolean getTrace() {
        return this.bTrace;
    }

    public String getTraceFlag() {
        return this.traceFlag;
    }

    public String getURL() {
        return this._url;
    }

    public void setAppLinkageManger(ApplicationLinkageManager applicationLinkageManager) {
        this.appLinkageManger = applicationLinkageManager;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public void setAppType(long l) {
        this.appType = l;
    }

    public void setByteOrder(int n) {
        this.byteOrder = n;
    }

    public void setCodePage(String string) {
        this.codePage = string;
    }

    public void setCommType(String string) {
        this.commType = string;
    }

    public void setContable(String string) throws CSOException {
        this.contable = string;
        try {
            this.setByteOrder(CSOUtil.getByteOrder((String)string));
            this.setCodePage(CSOUtil.getCodePage((String)string));
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{" "};
            System.err.println("ApplicationLinkage: Error setting byteOrder or codePage with conversion table " + string + ". " + exception);
            objectArray[0] = string;
            throw new CSOException("CSO7020E", objectArray);
        }
    }

    public void setCtgLocation(String string) {
        this.ctgLocation = string;
    }

    public void setCtgPort(String string) {
        this.ctgPort = string;
    }

    public void setGatewayHostname(String string) {
        this.gatewayHostname = string;
    }

    public void setGatewayPort(Integer n) {
        this.gatewayPort = n;
    }

    public void setIMSDestId(String string) {
        this.IMSDestId = string;
    }

    public void setIMSGroupId(String string) {
        this.IMSGroupId = string;
    }

    public void setJavaPackage(String string) {
        this.javaPackage = string;
    }

    public void setLibrary(String string) {
        this.library = string;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setServerid(String string) {
        this.serverid = string;
    }

    public void setTcpPort(String string) {
        this.tcpPort = string;
    }

    public void setTrace(boolean bl) {
        this.bTrace = bl;
    }

    public void setTraceFlag(String string) {
        if (string == null) {
            string = "0";
        }
        this.traceFlag = string.trim();
        this.setTrace(this.traceFlag.equals("1"));
    }

    public void setURL(String string) {
        this._url = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("Linkage for ");
        stringBuffer.append(this.getAppName());
        stringBuffer.append(":");
        stringBuffer.append("\ncommtype=");
        stringBuffer.append(this.getCommType());
        stringBuffer.append("\njavaProperty=");
        stringBuffer.append(this.getJavaPackage());
        stringBuffer.append("\ncontable=");
        stringBuffer.append(this.getContable());
        stringBuffer.append(" (codepage=");
        stringBuffer.append(this.getCodePage());
        stringBuffer.append(" byteorder=");
        switch (this.getByteOrder()) {
            case 0: {
                stringBuffer.append('I');
                break;
            }
            case 1: {
                stringBuffer.append('X');
                break;
            }
            case 2: {
                stringBuffer.append('E');
                break;
            }
            case 3: {
                stringBuffer.append('J');
            }
        }
        stringBuffer.append(")");
        stringBuffer.append("\nlocation=");
        stringBuffer.append(this.getLocation());
        stringBuffer.append("\nserverid=");
        stringBuffer.append(this.getServerid());
        stringBuffer.append("\nctgLocation=");
        stringBuffer.append(this.getCtgLocation());
        stringBuffer.append("\nctgPort=");
        stringBuffer.append(this.getCtgPort());
        stringBuffer.append("\nimsdestid=");
        stringBuffer.append(this.getIMSDestId());
        stringBuffer.append("\nimsgroupid=");
        stringBuffer.append(this.getIMSGroupId());
        stringBuffer.append("\ntcpport=");
        stringBuffer.append(this.getTcpPort());
        stringBuffer.append("\ntraceFlag=");
        stringBuffer.append(this.getTraceFlag());
        stringBuffer.append("\nlibrary=");
        stringBuffer.append(this.getLibrary());
        stringBuffer.append("\nremoteapptype=");
        switch ((int)this.getAppType()) {
            case 0: {
                stringBuffer.append("VG");
                break;
            }
            case 1: {
                stringBuffer.append("NONVG");
                break;
            }
            case 2: {
                stringBuffer.append("ITF");
                break;
            }
            case 3: {
                stringBuffer.append("VGJAVA");
            }
        }
        stringBuffer.append("\ngatewayhostname=");
        stringBuffer.append(this.getGatewayHostname());
        stringBuffer.append("\ngatewayport=");
        stringBuffer.append(this.getGatewayPort());
        stringBuffer.append("\nURL=");
        stringBuffer.append(this.getURL());
        return stringBuffer.toString();
    }

    public ApplicationLinkage validate() throws CSOException {
        if (this.getCommType() == null || this.getCommType().trim().length() == 0) {
            throw new CSOException("Required CSO Linkage parameter, commtype, was not specified");
        }
        if (this.getCommType().equalsIgnoreCase("direct")) {
            if (this.contable == null || !this.contable.toUpperCase().startsWith("CSOB")) {
                this.setCodePage(CSOUtil.getLocalEncoding());
                this.setByteOrder(3);
            }
        } else {
            if (this.contable == null || this.contable.trim().length() == 0) {
                throw new CSOException("Required CSO Linkage parameter, contable, was not specified");
            }
            if (this.location == null || this.location.trim().length() == 0) {
                throw new CSOException("Required CSO Linkage parameter, location, was not specified");
            }
            if (this.getCommType().equalsIgnoreCase("tcpip")) {
                if (this.serverid == null || this.serverid.trim().length() == 0) {
                    throw new CSOException("Required CSO Linkage parameter, serverid, was not specified");
                }
            } else if (this.getCommType().equalsIgnoreCase("cicseci")) {
                if (this.serverid == null || this.serverid.trim().length() == 0) {
                    throw new CSOException("Required CSO Linkage parameter, serverid, was not specified");
                }
                if (this.ctgLocation == null && this.ctgPort != null || this.ctgLocation != null && this.ctgPort == null) {
                    throw new CSOException("Required CSO Linkage parameter, ctgLocation or ctgPort, was not specified");
                }
            } else if (this.getCommType().equalsIgnoreCase("tcpims")) {
                if (this.tcpPort == null || this.tcpPort.trim().length() == 0) {
                    throw new CSOException("Required CSO Linkage parameter, tcpport, was not specified");
                }
                if (this.IMSDestId == null || this.IMSDestId.trim().length() == 0) {
                    throw new CSOException("Required CSO Linkage parameter, imsdestid, was not specified");
                }
            } else if (this.getCommType().equalsIgnoreCase("as400")) {
                if (this.library == null || this.library.trim().length() == 0) {
                    throw new CSOException("Required CSO Linkage parameter, library, was not specified");
                }
            } else {
                throw new CSOException("CommType, " + this.getCommType() + ", is invalid");
            }
        }
        return this;
    }
}

