

#include <stdio.h>
 
#include "RTTypes.h"
#include "RTVecOps.h"



/*
 *******************************************************************************
 *
 *  Name:  surf_tri_normals
 *
 *  Purpose: this routine determines the normals for a set of triangles 
 *           specified by a surface structure.  The vertices of the tri-
 *           angles are already in eye coordinates when this routine is
 *           called due to a caching mechanism for data points in eye
 *           coordinates.
 *
 *
 *
 *  Input Parameters
 *
 *     data - data points in eye coordinates
 *
 *
 *  Output Parameters
 *
 *     sptr - ptr to structure defining surface
 *
 *******************************************************************************
 */
void
    surf_tri_norms(Surface *sptr, Vector *data)
      {

       Triangle *tptr;     /* pointer to current triangle structure */
       Vector pts[3];      /* array to make code more understandable */
       Vector Pa, Pb;      /* vectors used to find normal for triangle */
       Vector N_vec;       /* normal vector for current triangle */

       int i, j;


/*
 *     cycle through each triangle in the surface
 */
       for (i=0; i<sptr->num_triang; i++)  {
           tptr = &sptr->triangs[i];
           vset (&tptr->ce,  (float) 0.0,  (float) 0.0,  (float) 0.0);

/*
 *         put triangle vertices in a separate array
 *         (it just makes code more readable to me)
 */
           for (j=0; j<3; j++)  {
               pts[j] = data[tptr->v[j]];
               tptr->ce = Vector_Sum(&tptr->ce, &pts[j]);
              }

/*
 *         calculate centroid of triangle
 */
           tptr->ce = VectorScaler_Division(&tptr->ce, (float)3.0);

/*
 *         calculate normal vector for triangle
 */
           Pa = Vector_Difference( &pts[1], &pts[0] );
           Pb = Vector_Difference( &pts[2], &pts[0] );

           Cross_Product(&Pa, &Pb, &N_vec);
           tptr->normal = VectorScaler_Division(&N_vec, vector_len(&N_vec));
          }

      }



/*
 *******************************************************************************
 *
 *  Name:  surf_tri_normals
 *
 *  Purpose:  this routine determines the approximate normals for each vertex
 *            in the triangles for a specified surface.  Since a vertex may
 *            be in more than one surface, the is a point normals array for
 *            each surface in an object.
 *
 *
 *
 *  Input Parameters
 *
 *     data - data points in eye coordinates
 *
 *
 *  Output Parameters
 *
 *     sptr - ptr to structure defining surface
 *
 *******************************************************************************
 */
void
    surf_pt_norms(Surface *sptr, Vector *pnorms, int nvert)
      {
       Triangle *tptr;

       int i, vertex[501];


/*
 *     initialize point normals array
 */

	   for (i=0; i<500; i++)
		   vertex[i] = 0;

       for (i=0; i<nvert; i++)
           vset(&pnorms[i],  (float) 0.0,  (float) 0.0,  (float) 0.0);

/*
 +++++++++++++++++++++++++++++++++++++++++++++++++
 *  cycle through each triangle in the surface
 +++++++++++++++++++++++++++++++++++++++++++++++++
 */
       for (i=0; i<sptr->num_triang; i++)  {
           tptr = &sptr->triangs[i];

/*
 *         add triangle normal into normal for each vertex for that triangle
 */		   
		   for (int j=0; j<3; j++)  {
			   pnorms[tptr->v[j]] = Vector_Sum(&pnorms[tptr->v[j]], &tptr->normal);

		      }

           vertex[tptr->v[0]] +=1;
           vertex[tptr->v[1]] +=1;
           vertex[tptr->v[2]] +=1;
          }

/*
 +++++++++++++++++++++++++++++++++++++++++++++++++
 +++++++++++++++++++++++++++++++++++++++++++++++++
 * 
 *     normalize all point normals for surface
 */
       for (i=0; i<nvert; i++)  {
           if (vector_len(&pnorms[i]) != 0.0)
               pnorms[i] = VectorScaler_Division(&pnorms[i],
                                                        vector_len(&pnorms[i]));
         }

 }



