

#include <windows.h>
//#define  _INC_WINDOWS
#include <winsock.h>

#include <stdio.h>

#include "RTTypes.h"
#include "RTVecOps.h"

#include "RTScreen.h"
#include "RTObjOps.h"

#include "RTIMOps.h"
#include "RayTrace.h"

#include "calypso.H"



#define MAX_HOSTNAME_LENGTH  100

sockaddr_in addr;
int RT_sd;
char hostname [MAX_HOSTNAME_LENGTH];





int num_T = 0;
int nIter = 2;

/*
 *
 *
 *  initialize picture region
 *
 *
 */
Region work_reg = {SX_WORLD_MIN_DEFAULT, SY_WORLD_MIN_DEFAULT,
                   SX_WORLD_MAX_DEFAULT, SY_WORLD_MAX_DEFAULT};



Boolean  debug_flag = FALSE;
Boolean  triangle_flag = FALSE;
Boolean  super_sample_flag = FALSE;

Boolean XmitPixelsFlag = FALSE;
Boolean WritePixelsFlag = FALSE;

void PixelDisplaySetup();

Sphere_Obj  sph = { (float) 40.0,  (float) 40.0,  (float) 40.0,
					(float) 20.0,  (float) 20.0,  (float) 20.0};


PROCESS_INFORMATION ProcInfo;
STARTUPINFO         StartStruct;





void 
   CalypsoMain(int argc, char *argv[])
      {
       char config_file[50];
       char opt;            /* gets command line option */
       int i, j;


	   InitCalypso(sizeof SharedType, (char **) &shared);

	   memset(config_file, 0, 50);


       debug_flag = FALSE;
       triangle_flag = FALSE;
       super_sample_flag = FALSE;
/*
 +++++++++++++++++++++++++++++++++++++++++++++++++
 *  get command line arguements
 +++++++++++++++++++++++++++++++++++++++++++++++++
 */ 
	   i = 1;

       while (i < argc)  {

	       if (argv[i][0] != '-')  {
		       printf ("***** Error:  Command line option not preceeded by argument");
			   printf (" -- EXITING *****\n");
			   printf ("Option was:  %s\n", argv[i]);
			   exit(0);
			  }
		   else
		       opt = argv[i++][1];

           switch(opt)  {

/*
 *             handle option to specify raytrace configuration files
 */ 
               case 'c':

			      if (argv[i][0] == '-')  {
		              printf ("***** Error:  Illegal option for command line argument");
					  printf (" -- EXITING *****\n");
			          printf ("Argument was:  -%c   Option was:  %s\n", opt, argv[i]);
			          exit(0);
			         }
			      else
                      strcpy(config_file, argv[i++]);

                  break;

/*
 *             handle option for printing debug output
 */ 
               case 'd':

                  debug_flag = TRUE;
                  break;

/*
 *             handle option to specify number of parallel iterations
 */ 
               case 'i':
			      if (argv[i][0] == '-')  {
		              printf ("***** Error:  Illegal option for command line argument");
					  printf (" -- EXITING *****\n");
			          printf ("Argument was:  -%c   Option was:  %s\n", opt, argv[i]);
			          exit(0);
			         }
			      else	{
					  nIter = atoi(argv[i++]);
				     }

                  break;

/*
 *             handle option to specify triangle flag
 */ 
               case 'r':

                  triangle_flag = TRUE;
                  break;

/*
 *             handle option to turn on super sampling
 */ 
               case 's':

                  super_sample_flag = TRUE;
                  break;

/*
 *             handle option to specify number of thread segments in each parallel section
 */ 
               case 't':
			      if (argv[i][0] == '-')  {
		              printf ("***** Error:  Illegal option for command line argument");
					  printf (" -- EXITING *****\n");
			          printf ("Argument was:  -%c   Option was:  %s\n", opt, argv[i]);
			          exit(0);
			         }
			      else  {
					  num_T = atoi(argv[i++]);
					  printf ("***** Error:  Thread Count MUST Be Greater Than 0 -- EXITING *****\n");
					  exit(0);
				     }

                  break;

/*
 *             handle undefined options
 */ 
               default:

                  printf (" ***** Error:  Invalid Command Line Argument: %c -- EXITING *****\n",
                         opt);
                  exit(0);
                  break;

              }  /* end -- switch(opt) */

          }  /* end -- while */


/*
 *     Tests for fatal command line omissions
 *		- now limited omission of configuration file
 */

       if (strcmp(config_file, "") == 0)  {
	       printf ("***** Error:  No Configuration File Specified -- EXITING *****\n");
		   exit(0);
		  }

/*
 *     initialization
 */
       shared->obj_num = 1;

       shared->PhongConst = (float) 15.0;

	   shared->depth_limit = MAX_DEPTH;

       shared->obj_list[0].label = SPHERE;
       shared->obj_list[0].ptr  = (char *) &sph;

       for (i=0; i< LIGHTS_MAX; i++)  {

           shared->lights[i].directed = FALSE;
           shared->lights[i].on = FALSE;

           vset(&shared->lights[i].L_pt, (float) 0.0,  (float) 0.0,  (float) 0.0);
           vset(&shared->lights[i].L_a,  (float) 0.0,  (float)-2.0,  (float) 0.0);
           vset(&shared->lights[i].I,    (float) 1.0,  (float) 1.0,  (float) 1.0);
 
           shared->lights[i].ro = (float) 10.0;
           shared->lights[i].cos_delta = (float) 0.0;
          }

       shared->Sh_Heap.allocated_space = 0;
       shared->Sh_Heap.free_space_ptr = shared->Sh_Heap.free_space;
  
       RT_Configure(config_file);

/*
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 +  calculate normals for polygon mesh objects
 +     - calculate triangle normals
 +     - calculate approximate normals at vertices
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */
       Poly_Mesh_Obj  *obj_ptr;

       for (i=0; i<shared->obj_num; i++)  {

           if (shared->obj_list[i].label == POLY_MESH)  {
               obj_ptr = (Poly_Mesh_Obj *) shared->obj_list[i].ptr;


               for (j=0; j<obj_ptr->num_surf; j++)  {

                   surf_tri_norms(&obj_ptr->surfs[j], obj_ptr->data);

                   surf_pt_norms(&obj_ptr->surfs[j], obj_ptr->surf_norms[j],
                                 obj_ptr->num_vert);

                  } /* end -- for each surface in object */

              }  /* end -- if object is poly mesh object */

          } /* end -- for each object */


	   if (num_T <= 0)  {
	       printf ("***** Error:  Number of thread segments not specified -- ");
	       printf ("EXITING *****\n");
		   exit(0);
		  }

	   if (nIter == 0)
	       nIter = 5;

	   PixelDisplaySetup();

       RayTrace();

	   if (WritePixelsFlag)  {
           fclose(ofp);
	      }

	   shutdown(RT_sd, 1);
	   closesocket(RT_sd);
	   Sleep(10000);
       exit(0);
      }



/*
 *******************************************************************************
 *
 *  Name:  PixelDisplaySetup
 *
 *  Purpose:
 *
 *
 *
 *  Input Parameters
 *
 *     none
 *
 *
 *  Output Parameters
 *
 *     none
 *
 *******************************************************************************
 */
void PixelDisplaySetup()
   {
	BOOL rv;
	char CmdLine[300];
	int len;
	int width, height;


	width =   shared->vp.scr_reg.max_pt.x - shared->vp.scr_reg.min_pt.x + 1;
    height =  shared->vp.scr_reg.max_pt.y - shared->vp.scr_reg.min_pt.y + 1;


	if ((RT_sd = socket(AF_INET, SOCK_STREAM, 0)) == -1)  {
		perror("Socket Creation Error:  ");
		exit(1);
	   }

	if (gethostname(hostname, MAX_HOSTNAME_LENGTH) == -1)  {
		perror("Get Hostname Error:  ");
		exit(1);
	   }

	addr.sin_addr.s_addr = INADDR_ANY;
	addr.sin_port = 0;
	addr.sin_family = AF_INET;

	if (bind(RT_sd, (sockaddr *) &addr, sizeof(addr)) == -1)  {
		perror("Bind Error:  ");
		exit(1);
	   }

	if (listen(RT_sd, FD_SETSIZE) == -1)  {
		perror("Listen Error:  ");
		exit(1);
	   }

	XmitPixelsFlag = TRUE;


	len = sizeof(addr);

	if (getsockname(RT_sd, (struct sockaddr *) &addr, &len) == SOCKET_ERROR)  {
		perror("Getsockname Error:  ");
		exit(1);
	   }

	sprintf(CmdLine, "PixDsply.exe  -h %d  -w %d  -s %s %d", height, width, hostname,
		                                                       ntohs(addr.sin_port) );
	StartStruct.cb			= sizeof(STARTUPINFO);
	StartStruct.lpReserved	= NULL;
	StartStruct.lpDesktop	= NULL;
	StartStruct.lpTitle		= NULL;
//  StartStruct.dwFlags		= STARTF_USESHOWWINDOW;
	StartStruct.cbReserved2	= 0;
	StartStruct.lpReserved2	= NULL;
//  StartStruct.wShowWindow	= SW_MAXIMIZE;
				  
	rv = CreateProcess( "PixDsply.exe",
						CmdLine,		// Commandline Arguments
						NULL,			// Process Security Attributes - none
						NULL,			// Thread Security Attributes - none
						FALSE,			// Inherit Parents Attributes - no
						0,				// Additional Attributes - none
						NULL,			// Environment Pointer
						NULL,			// Current Directory
						&StartStruct,	// Startup Information Structure
						&ProcInfo);		// Process Information Structure

	if (!rv)  {
		printf ("***** Error:  Display Process Creation Failed");
		printf (" -- EXITING *****\n");
		exit(1);
	   }

   }


