;*******************************************************}
;                                                       }
;       Turbo Pascal Version 7.0                        }
;       Graphic Vision Unit (GDos)                      }
;                                                       }
;       Copyright 1997,2000 Jason G Burgon              }
;                                                       }
;*******************************************************}

IDEAL
%TITLE "INTR"
%NOINCL

P286
include "gdos.inc"

IFDEF _DPMI_

DATASEG
           extrn  SelectorInc:WORD
ENDS

CODESEG
    public IntrApp      ; Call the given protected mode interrupt
    public MsDosPM

    proc MsDosPM

ELSE

CODESEG

   public MsDos         ; Call the DOS interrupt $21
   public Intr          ; Call the given (real mode) interrupt
   public IntrApp       ; Call the given application (real-mode) interrupt

   proc MsDos

ENDIF
            pop   si
            pop   dx
            pop   cx
            pop   bx
            mov   al,21h
            push  ax
            push  bx
            push  cx
            push  dx
            push  si
   endp

P8086
            proc IntrApp
IFNDEF _DPMI_
            proc Intr
            endp Intr
ENDIF
            arg IntNo:Byte, Regs:PRegisters
            push  ds
P386

 ; Self-modifying code is required here to set the Int X interrupt number

     IFDEF _DPMI_
            mov   ax,cs
            add   ax,[SelectorInc]
            push  ax                        ; Save CS + SelectorInc
            mov   ds,ax
            push  [word ptr ds:Interrupt]   ; Save self-modified byte
            mov   al,[IntNo]
	    mov   [byte ptr ds:Interrupt+1],al
     ELSE
            push  [word ptr cs:Interrupt]   ; Save self-modified byte
            mov   al,[IntNo]
            mov   [byte ptr cs:Interrupt+1],al
     ENDIF
            lds   si,[Regs]
            mov   ebx,[si+TRegisters.EBX]   ; EBX = Regs.EBX
            mov   ecx,[si+TRegisters.ECX]   ; ECX = Regs.ECX
            push  [si+TRegisters.EAX]       ; push user EAX on stack
            mov   edx,[si+TRegisters.EDX]   ; EDX = Regs.EDX
            mov   ebp,[si+TRegisters.EBP]   ; BP = Regs.BP
            push  [si+TRegisters.ESI]       ; push user ESI on stack
            mov   edi,[si+TRegisters.EDI]   ; EDI = Regs.EDI
    IFDEF _DPMI_
            mov   ax,[si+TRegisters.ES]
            verr  ax
            jnz   @@1
            xor   ax,ax
@@1:        mov   es,ax                     ; ES = Regs.ES or zero
            mov   ax,[si+TRegisters.DS]
            verr  ax
            jnz   @@2
            xor   ax,ax
@@2:        mov   ds,ax                     ; DS = Regs.ES or zero
    ELSE
            mov   es,[si+TRegisters.ES]     ; ES = Regs.ES
            mov   ds,[si+TRegisters.DS]     ; DS = Regs.DS Regs not available
    ENDIF
            pop   esi                       ; SI = Regs.ESI
            pop   eax                       ; AX = Regs.EAX

Interrupt:  int   0

            pushf                           ; push new Regs.Flags
            push  ds                        ; push new Regs.DS
            push  esi                       ; push new Regs.SI
            push  ebp                       ; push new Regs.BP
            mov   bp,sp                     ; Restore stack frame
            add   bp,4 * (type Word) + 2 * (type dword) ; Restore local BP
            lds   si,[Regs]                 ; DS:SI = @Regs
            mov   [si+TRegisters.EAX],eax
            mov   [si+TRegisters.EBX],ebx
            mov   [si+TRegisters.ECX],ecx
            mov   [si+TRegisters.EDX],edx
            mov   [si+TRegisters.EDI],edi
            mov   [si+TRegisters.ES],es
            pop   [si+TRegisters.EBP]       ; pop new Regs.BP
            pop   [si+TRegisters.ESI]       ; pop new Regs.SI
            pop   [si+TRegisters.DS]        ; pop new Regs.DS
            pop   [si+TRegisters.Flags]     ; pop new Regs.Flags
    IFDEF _DPMI_
            pop   ds                        ; DS = CS + SelectorInc
	    pop   [word ptr ds:Interrupt]   ; Restore Self-modified byte
    ELSE
	    pop   [word ptr cs:Interrupt]   ; Restore Self-modified byte
    ENDIF
            pop   ds                        ; Restore global DS
P8086
            ret
endp

ENDS

END
