/* Version of 94/04/23 by Peter Kanis */
/************************************************************************
*  Project     : TSTNGEN                     DATE    : 12.04.94         *
*  Module      : DEMO                        VERSION : 1                *
*  Filename    : tstdemo.c                   AUTHOR  : Peter J. Kanis   *
*************************************************************************
*                                                                       *
*  Description : Demo Program for Test Engine.                          *
*                                                                       *
*  Export      :                                                        *
*                                                                       *
*  Defines     : Compile with define TST_NGEN for macros to work.       *
*                                                                       *
*************************************************************************
*                                                                       *
*  (c) ADD Consulting  All Rights Reserved                              *
*                                                                       *
*  The use of this code by third parties is licenced under contractual  *
*  agreements.                                                          *
*                                                                       *
*************************************************************************/



#define     INCL_DOS
#define     INCL_BASE
#define     INCL_ERRORS
#include    <os2.h>
#include    <stdio.h>
#include    <malloc.h>
#include    <process.h>
#include    <stddef.h>
#include    <string.h>
#include    <tstngen.h>
#include    <files.h>


HEV         sem1, sem2, sem3, sem4, sem5, sem6;
ULONG       delay = 1000L;
char        scr_path[256];

void testthread(void *);

int main(int argc, char *argv[])

    {
    USHORT      i, *j, rc;
    char        test_str[ 128];
    HSCRIPT     psc;
    ULONG       drv;
    char        drv_str[ 4],
                path[ 128],
                fname[ 256];
    
    /***************** Initialize The test NGEN ******************/

    psc = TstInitTest( argc, argv);
    if (!psc)
        {
        printf("Something went seriously wrong !!");
        exit(1);
        }
    
    /***** get the path for script files ********************************/
    
    FileParsePath( argv[ 1], &drv, drv_str, path, fname);
    sprintf( scr_path, "%s%s\\", drv_str, path);
    
    /***** switch global dumping file on ********************************/
    
    TstDumpOnOff( TST_TRON);
    
    /***** Create semaphores for synchronisation ************************/
    
    DosCreateEventSem( NULL, &sem1, 0L, FALSE);
    DosCreateEventSem( NULL, &sem2, 0L, FALSE);
    DosCreateEventSem( NULL, &sem3, 0L, FALSE);
    DosCreateEventSem( NULL, &sem4, 0L, FALSE);
    DosCreateEventSem( NULL, &sem5, 0L, FALSE);
    DosCreateEventSem( NULL, &sem6, 0L, FALSE);
    
    /***** Start 3 separate threads each with a script file *************/
    
    for (i = 2;i <= 4;i++) 
        {
        j = (PUSHORT) malloc( sizeof( USHORT));
        *j = i;
        if (_beginthread( testthread, NULL, 8192, (PVOID)j) < 0)
            {
            TstWriteTrace( " failed to start thread %u..\n", i);
            exit( 4);
            }

        }
    
    /***** Wait for the threads to have started *************************/
    
    DosWaitEventSem( sem1, SEM_INDEFINITE_WAIT);
    DosWaitEventSem( sem2, SEM_INDEFINITE_WAIT);
    DosWaitEventSem( sem3, SEM_INDEFINITE_WAIT);
    
    /***** read the script file line by line ****************************/
    
    rc = TstReadScriptLine( psc, test_str);
    while( rc == 0)
        {
        
        /***** Trace using function interface ***************************/
        
        TstWriteTrace("Read string '%s' from script file TEST.SPT, result = %u", test_str, rc);
        DosSleep( delay);
        
        /***** read the next line from the script ***********************/
        
        rc = TstReadScriptLine( psc, test_str);
        }
    
    /***** close the script & trace files *******************************/
        
    TstCloseScript( psc);
    TstWriteTrace("Closed script file");   
    TstCloseTrace();
    TstWriteTrace("Closed Trace file");   
    
    /***** wait for the other threads to end ****************************/
    
    DosWaitEventSem( sem4, SEM_INDEFINITE_WAIT);
    TstWriteTrace("sem4 Cleared -> Thread 2 terminated");
    DosWaitEventSem( sem5, SEM_INDEFINITE_WAIT);
    TstWriteTrace("sem5 Cleared -> Thread 3 terminated");
    DosWaitEventSem( sem6, SEM_INDEFINITE_WAIT);
    TstWriteTrace("sem6 Cleared -> Thread 4 terminated");
    
    /***** close global dumping *****************************************/
        
    TstDumpOnOff( TST_TROFF);
    
    /***** deregister the whole process *********************************/
    
    TstStopProcess();
    exit(0);
    return(0);
    
    }   /* end of main() */


/************************************************************************/
/* Thread function for reading other scripts.                           */
/************************************************************************/

void testthread(void *p)

    {
    USHORT      j;
    USHORT      rc;
    char        thr_name[128];
    char        test_str[128];
    char        scr_name[128];
    HSCRIPT     psc;
    
    /***** Post the relevant semaphore **********************************/
    
    j = *(PUSHORT)p;
    switch( j)
        {
        case 2 :
            DosPostEventSem( sem1);
            break;
        
        case 3 :
            DosPostEventSem( sem2);
            break;
            
        case 4 :
            DosPostEventSem( sem3);
            break;
        }
    
    /***** Trace with macro *********************************************/
    
    TST_TRACE( "Thread %d started", j, 0, 0, 0);    
    
    /***** determine script file name ***********************************/
    
    sprintf( thr_name, "TEST%u", j);
    sprintf( scr_name, "%s%s.SPT", scr_path, thr_name);
    
    /***** register the current thread with Test Engine/2 ***************/
    
    TST_REG( thr_name);
    
    /***** open the script file *****************************************/
    
    psc = TstOpenScriptFile( scr_name);
    
    /***** read script line by line *************************************/
    
    if (psc)
        {
        TST_TRACE( "Opened script file %s for thread %d", scr_name, j, 0, 0);
        rc = TstReadScriptLine( psc, test_str);
        while( rc == 0)
            {
        
            /***** trace with macro *************************************/

            TST_TRACE( "Read string '%s' from script file TEST.SPT, result = %u", test_str, rc, 0, 0);
            DosSleep( delay);
            rc = TstReadScriptLine( psc, test_str);
            }
    
        /***** close all the files **************************************/
        
        TstCloseScript( psc);
        TST_TRACE( "Closed script file", 0, 0, 0, 0);   
        TST_CLOSE();
        TST_TRACE( "Closed Trace file", 0, 0, 0, 0);   
        }
    
    /***** post the relevant semaphore **********************************/
        
    switch( j)
        {
        case 2 :
            DosPostEventSem( sem4);
            TST_TRACE( "Thread Terminates, cleared semaphore 'sem4'", 0, 0, 0, 0);
            break;
        
        case 3 :
            DosPostEventSem( sem5);
            TST_TRACE( "Thread Terminates, cleared semaphore 'sem5'", 0, 0, 0, 0);
            break;
            
        case 4 :
            DosPostEventSem( sem6);
            TST_TRACE( "Thread Terminates, cleared semaphore 'sem6'", 0, 0, 0, 0);
            break;
        }
    
    /***** Deregister the thread ****************************************/
    
    TST_END();
    
    }   /* end of testthread() */
    

/***********************************************************************/
/*                                                                     */
/*                    (c) ADD Consulting 1993                          */
/*                                                                     */
/*                           END OF FILE.                              */
/*                                                                     */
/***********************************************************************/

