/*  dos.h

    Defines structs, unions, macros, and functions for dealing
    with MSDOS and the Intel iAPX86 microprocessor family.

*/
/*
 *      C/C++ Run Time Library - Version 1.5
 *
 *      Copyright (c) 1987, 1994 by Borland International
 *      All Rights Reserved.
 *
 */

#ifndef __DOS_H
#define __DOS_H

#if !defined(___DEFS_H)
#include <_defs.h>
#endif


#if !defined(RC_INVOKED)

#if defined(__STDC__)
#pragma warn -nak
#endif

#endif  /* !RC_INVOKED */




#if !defined(RC_INVOKED)
#pragma option -a-
#endif


#ifdef _MT

#ifdef __cplusplus
extern "C" {
#endif
extern  int * _RTLENTRY _EXPFUNC __errno(void);
extern  int * _RTLENTRY _EXPFUNC __doserrno(void);
#ifdef  __cplusplus
}
#endif
#define errno (*__errno())
#define _doserrno (*__doserrno())

#else

extern  int _RTLENTRY _EXPDATA errno;
extern  int _RTLENTRY _EXPDATA _doserrno;

#endif

#if !defined(__STDC__)
#define environ  _environ
#endif

/* Variables */
extern  int const _RTLENTRY _EXPDATA _8087;
extern  int       _RTLENTRY _EXPDATA _argc;
extern  char    **_RTLENTRY _EXPDATA _argv;
extern  char    **_RTLENTRY _EXPDATA _environ;

extern  unsigned char _RTLENTRY _EXPDATA _osmajor;
extern  unsigned char _RTLENTRY _EXPDATA _osminor;
extern  unsigned      _RTLENTRY _EXPDATA _osversion;
extern  unsigned      _RTLENTRY _EXPDATA _version;


#define FA_NORMAL   0x00        /* Normal file, no attributes */
#define FA_RDONLY   0x01        /* Read only attribute */
#define FA_HIDDEN   0x02        /* Hidden file */
#define FA_SYSTEM   0x04        /* System file */
#define FA_LABEL    0x08        /* Volume label */
#define FA_DIREC    0x10        /* Directory */
#define FA_ARCH     0x20        /* Archive */

/* MSC names for file attributes */

#define _A_NORMAL   0x00        /* Normal file, no attributes */
#define _A_RDONLY   0x01        /* Read only attribute */
#define _A_HIDDEN   0x02        /* Hidden file */
#define _A_SYSTEM   0x04        /* System file */
#define _A_VOLID    0x08        /* Volume label */
#define _A_SUBDIR   0x10        /* Directory */
#define _A_ARCH     0x20        /* Archive */

struct COUNTRY {
    int co_date;
    char    co_curr[5];
    char    co_thsep[2];
    char    co_desep[2];
    char    co_dtsep[2];
    char    co_tmsep[2];
    char    co_currstyle;
    char    co_digits;
    char    co_time;
    long    co_case;
    char    co_dasep[2];
    char    co_fill[10];
};

struct  dfree   {
    unsigned df_avail;
    unsigned df_total;
    unsigned df_bsec;
    unsigned df_sclus;
};

struct  diskfree_t {
    unsigned total_clusters;
    unsigned avail_clusters;
    unsigned sectors_per_cluster;
    unsigned bytes_per_sector;
};

struct  time    {
    unsigned char   ti_min;     /* Minutes */
    unsigned char   ti_hour;    /* Hours */
    unsigned char   ti_hund;    /* Hundredths of seconds */
    unsigned char   ti_sec;     /* Seconds */
};

struct  dostime_t {
    unsigned char hour;         /* Hours */
    unsigned char minute;       /* Minutes */
    unsigned char second;       /* Seconds */
    unsigned char hsecond;      /* Hundredths of seconds */
};

struct  date    {
    int         da_year;    /* Year - 1980 */
    char        da_day;     /* Day of the month */
    char        da_mon;     /* Month (1 = Jan) */
};

struct  dosdate_t {
    unsigned char day;      /* 1-31 */
    unsigned char month;    /* 1-12 */
    unsigned int  year;     /* 1980 - 2099 */
    unsigned char dayofweek;/* 0 - 6 (0=Sunday) */
};

#ifndef _FFBLK_DEF
#define _FFBLK_DEF
struct  ffblk   {
    long            ff_reserved;
    long            ff_fsize;
    unsigned long   ff_attrib;
    unsigned short  ff_ftime;
    unsigned short  ff_fdate;
    char            ff_name[256];
};
#endif  /* __FFBLK_DEF */

/* The MSC find_t structure corresponds exactly to the ffblk structure */
struct  find_t {
    long            reserved;
    long            size;              /* size of file */
    unsigned long   attrib;            /* attribute byte for matched file */
    unsigned short  wr_time;           /* time of last write to file */
    unsigned short  wr_date;           /* date of last write to file */
    char            name[256];         /* asciiz name of matched file */
};


#define SEEK_CUR    1
#define SEEK_END    2
#define SEEK_SET    0


#ifdef __cplusplus
extern "C" {
#endif

struct COUNTRY * _RTLENTRY _EXPFUNC country( int __xcode, struct COUNTRY *__cp);
long        _RTLENTRY _EXPFUNC dostounix( struct date *__d, struct time *__t );

unsigned    _RTLENTRY _EXPFUNC _dos_close( int __fd );
unsigned    _RTLENTRY _EXPFUNC _dos_creat( const char * __pathP, unsigned __attr, int * __fd );
unsigned    _RTLENTRY _EXPFUNC _dos_creatnew( const char * __pathP, unsigned __attr, int * __fd );
unsigned    _RTLENTRY _EXPFUNC _dos_findfirst( const char * __path, unsigned __attrib, struct find_t *__finfo );
unsigned    _RTLENTRY _EXPFUNC _dos_findnext( struct find_t *__finfo );
void        _RTLENTRY _EXPFUNC _dos_getdate( struct dosdate_t *__datep );
unsigned    _RTLENTRY _EXPFUNC _dos_getdiskfree( unsigned __drive, struct diskfree_t *__dtable );
void        _RTLENTRY _EXPFUNC _dos_getdrive( unsigned *__drive );
unsigned    _RTLENTRY _EXPFUNC _dos_getfileattr( const char * __filename, unsigned *__attrib );
unsigned    _RTLENTRY _EXPFUNC _dos_getftime( int __fd, unsigned *__date, unsigned *__time );
void        _RTLENTRY _EXPFUNC _dos_gettime( struct dostime_t *__timep );
unsigned    _RTLENTRY _EXPFUNC _dos_open( const char * __pathP, unsigned __oflag, int * __fd );
unsigned    _RTLENTRY _EXPFUNC _dos_read( int __fd, void * __buf, unsigned __len, unsigned *__nread );
unsigned    _RTLENTRY _EXPFUNC _dos_setdate( struct dosdate_t *__datep );
void        _RTLENTRY _EXPFUNC _dos_setdrive( unsigned __drive, unsigned *__ndrives );
unsigned    _RTLENTRY _EXPFUNC _dos_setfileattr( const char * __filename, unsigned __attrib );
unsigned    _RTLENTRY _EXPFUNC _dos_setftime( int __fd, unsigned __date, unsigned __time );
unsigned    _RTLENTRY _EXPFUNC _dos_settime( struct dostime_t *__timep );
unsigned    _RTLENTRY _EXPFUNC _dos_write( int __fd, void * __buf, unsigned __len, unsigned *__nread );

#if !defined(RC_INVOKED)
#pragma obsolete _dos_close
#pragma obsolete _dos_creat
#pragma obsolete _dos_creatnew
#pragma obsolete _dos_findfirst
#pragma obsolete _dos_findnext
#pragma obsolete _dos_getdate
#pragma obsolete _dos_getdiskfree
#pragma obsolete _dos_getdrive
#pragma obsolete _dos_getfileattr
#pragma obsolete _dos_getftime
#pragma obsolete _dos_gettime
#pragma obsolete _dos_open
#pragma obsolete _dos_read
#pragma obsolete _dos_setdate
#pragma obsolete _dos_setdrive
#pragma obsolete _dos_setfileattr
#pragma obsolete _dos_setftime
#pragma obsolete _dos_settime
#pragma obsolete _dos_write
#endif

void        _RTLENTRYF _EXPFUNC getdate( struct date *__datep );
void        _RTLENTRY _EXPFUNC getdfree( unsigned char __drive,
                 struct dfree*__dtable );
int         _RTLENTRY _EXPFUNC _getdrive( void );
void        _RTLENTRYF _EXPFUNC gettime( struct time *__timep );
int         _RTLENTRY _EXPFUNC getverify( void );

void        _RTLENTRY _EXPFUNC setdate( struct date *__datep );
void        _RTLENTRY _EXPFUNC settime( struct time *__timep );
void        _RTLENTRY _EXPFUNC setverify( int __value );

void        _RTLENTRY _EXPFUNC _sleep( unsigned __seconds );

void        _RTLENTRY _EXPFUNC unixtodos( long __time, struct date *__d,
                              struct time *__t );
int         _RTLENTRYF _EXPFUNC unlink( const char * __path );

#define sleep(unsigned) _sleep(unsigned)

/* Inline functions.
 */
void                 __int__( int __interruptnum );

#define disable( ) __emit__( (unsigned char )( 0xfa ) ) /* MSC name */
#define enable( )  __emit__( (unsigned char )( 0xfb ) ) /* MSC name */
#define _disable( ) __emit__( (unsigned char )( 0xfa ) ) /* MSC name */
#define _enable( )  __emit__( (unsigned char )( 0xfb ) ) /* MSC name */

#define geninterrupt( i ) __int__( i )      /* Interrupt instruction */

#ifdef __cplusplus
}
#endif

#if !defined(RC_INVOKED)
#pragma option -a. /* restore default packing */
#endif



#if !defined(RC_INVOKED)

#if defined(__STDC__)
#pragma warn .nak
#endif

#endif  /* !RC_INVOKED */


#endif  /* __DOS_H */
