// Copyright 1992 by Borland International

//
// BPMCC.H
//


#if !defined(__BPMCC_H)

#define __BPMCC_H

#if !defined(WORKSHOP_INVOKED)

#if !defined(OS2_INCLUDED)
#include <os2.h>
#endif



#endif


// Purpose:    Borland Presentation  Manager Custom Controls  (BPMCC)

#define BPMCCVERSION	0x0100   // version 1.00



// from version 1.02 onward BPMCCGetversion returns a DWORD
// The low-order word contains the version number
// and the high-order word contains the locale

#define BPMCC_LOCALE_US     1
#define BPMCC_LOCALE_JAPAN  2



// Borland custom control classes

#define BUTTON_CLASS	"BorBtn"	// Our Bitmap Buttons
#define RADIO_CLASS	"BorRadio"	// Our Radio Buttons
#define CHECK_CLASS	"BorCheck"	// Our Check Boxes
#define SHADE_CLASS	"BorShade"	// Our shade boxes & lines

// button style definitions:

#define BBS_PUSHBUTTON       0x0000L
#define BBS_CHECKBOX         0x0001L
#define BBS_AUTOCHECKBOX     0x0002L
#define BBS_RADIOBUTTON      0x0003L
#define BBS_AUTORADIOBUTTON  0x0004L
#define BBS_3STATE           0x0005L
#define BBS_AUTO3STATE       0x0006L
#define BBS_PRIMARYSTYLES    0x000FL

#define BBS_PARENTNOTIFY     0x0020L	// Notify parent of TAB keys and focus
#define BBS_BITMAP           0x0040L	// this is a bitmap static
#define BBS_HELP             0x0100L    // generate WM_HELP instead of WM_COMMAND
#define BBS_SYSCOMMAND	     0x0200L
#define BBS_DEFAULT          0x0400L
#define BBS_NOPOINTERFOCUS   0x0800L
#define BBS_GRAYONLY         0x1000L 	// Control always on gray background
#define BBS_NOCURSORSELECT   0x2000L
#define BBS_OWNERDRAW        0x8000L	// let parent paint via WM_DRAWITEM


// messages

#define BBM_SETBITS       ( BM_SETDEFAULT + 10)

// notifications

#define BBN_SETFOCUS      ( BN_PAINT + 10)
#define BBN_SETFOCUSMOUSE ( BN_PAINT + 11)
#define BBN_GOTATAB       ( BN_PAINT + 12)
#define BBN_GOTABTAB      ( BN_PAINT + 13)

// Add'l Owner Draw notification code for check boxes & radio buttons

#define BBDS_CHECKED  0x0800


#define BSS_GROUP     1L  // recessed group box
#define BSS_HDIP      2L  // horizontal border
#define BSS_VDIP      3L  // vertical border
#define BSS_HBUMP     4L  // horizontal speed bump
#define BSS_VBUMP     5L  // vertical speed bump
#define BSS_RGROUP    6L  // raised group box
#define BSS_TYPEMASK  7L  // mask off shade type

#define BSS_CAPTION   0x8000L // Set off the caption
#define BSS_CTLCOLOR  0x4000L // Send WM_CTLCOLOR messages to parent of control
#define BSS_NOPREFIX  0x2000L // ~ in caption does not underline following letter
#define BSS_GRAYONLY  0x1000L // always use gray background
#define BSS_LEFT      0x0000L // Caption is left-justified
#define BSS_CENTER    0x0100L // Caption is centered
#define BSS_RIGHT     0x0200L // Caption is right-justified
#define BSS_ALIGNMASK 0x0300L


#if !defined(EXPORT)
#define EXPORT _export
#endif

#if !defined(PASCAL)
#define PASCAL _pascal
#endif

#if defined( __cplusplus )
extern "C" {
#endif  /* __cplusplus */


extern ULONG  EXPORT PASCAL BPMCCGetVersion( void);
extern USHORT EXPORT PASCAL BPMCCMessageBox(HWND hwndParent, HWND hwndOwner, PSZ pszText,
					    PSZ pszTitle,USHORT usWindow, ULONG flStyle);

#if defined( __cplusplus )
}
#endif  /* __cplusplus */

#endif  /* __BPMCC_H */

