/* update installation disks                                      */
/* 05.20.2000: initial version (0.1)                              */
/* 06.04.2000: added support for incorporating DD Fixpak (0.2)    */
/* 08.19.2000: made it more robust                                */
/* 08.27.2000: made it look nicer (0.3)                           */
/* 09.24.2000: perliminary support bootable CD added              */
/* 09.30.2000: added support for virtual floppy                   */
/* 10.01.2000: small improvements                                 */
/* 11.08.2000: parameters moved to configuration files            */
/* 12.04.2000: added support for lxlite                           */
/* 01.19.2001: copyfromfloppy removed (not needed any more)       */
/* 01.27.2001: minor change for go4it2.cmd                        */
/* 02.25.2001: fixed copyfromfloppy problem                       */
/*             extended path statements in cdboot config.sys      */
/* 02.27.2001: added support for updated boot diskettes           */
/* 03.03.2001: solved problem with CD-config.sys after phase1     */
/* 03.11.2001: solved problem with ea data. sf (xcopy -> copydir) */
/*             added code to handle Warp 3 update                 */
/* 03.18.2001: improved code to handle Warp 3                     */
/* 03.29.2001: added support to incorporate dummy and new ADD's   */
/* 03.30.2001: do not add dani driver if we use Warp 3 (-> trap)  */
/* 04.07.2001: added paramaters to control dani and dummy drivers */
/* 04.15.2001: really fixed copyfromfloppy problem                */
/* 04.16.2001: remove copyfromfloppy from config.sys              */
/* 04.19.2001: fixed labeling problem of boot disk                */

/* get command line parameters */
parse arg cddir fpdir n.errors n.warnings n.elapsed log ver expert add_dani add_dummy f1dir f2dir
if datatype(f1dir) = 'NUM' then do
	vers = f1dir
	f1dir = ''
end

if iddir = '' | fpdir = '' then do
	say
	say ' Update OS/2 installation diskettes with fixpak.'
	say ' Usage: updif <directory installation CD> <directory fixpak files>'
	say ' Example: updif e:\updcd\burn e:\updcd\fix'
	exit 1
end

/* we need to know the absolute path */
cdir  = directory()
fpdir = directory(fpdir)
cdir  = directory(cdir) 
cddir = directory(cddir) 
cdir  = directory(cdir)
iddir = cddir||'\DISKIMGS\OS2\35'
exdir = cddir||'\DISKIMGS'

/* reset some variables */
if log = '' then log = 'updif.log'
if ver = '' then ver = '1.5'
if n.errors = '' then n.errors = 0
if n.warnings = '' then n.warnings = 0
if n.elapsed = '' then n.elapsed = 0
if expert  = '' then expert = 1

/* load configuration file */
cfgfile = 'updcd.cfg'
do while lines(cfgfile)
	l = linein(cfgfile)
	interpret l
end
rc = lineout(cfgfile)

/* learn drive letter floppy */
call rxfuncadd sysdriveinfo, rexxutil, sysdriveinfo
parse value sysdriveinfo(flpdrv) with . . flpsz .
if flpsz <> 1457664 then flpdrv = 'A:' /* use A: otherwise */

/* reset screen */
say '1B'x || '[36;44m'
say '1B'x || '[1m'
'@cls'
call rxfuncadd syscurstate, rexxutil, syscurstate
call syscurstate off
call rxfuncadd sysfiletree, rexxutil, sysfiletree
say '1B'x || '[2;2HUpdate OS/2 installation CD-ROM, version 'ver
say '1B'x || '[4;2HTarget directory      : 'substr(flpdrv'\', 1, 50)
say '1B'x || '[5;2HSource directory      : 'substr(iddir, 1, 50)
say '1B'x || '[7;2HCurrent activity      : 'substr('Thinking...', 1, 50)
say '1B'x || '[8;2HTarget object         : 'substr('Searching...', 1, 50)
say '1B'x || '[9;2HSource object         : 'substr('Searching...', 1, 50)
say '1B'x || '[11;2HUpdate action         : 'substr('Searching...', 1, 50)
say '1B'x || '[12;2HUpdate return code    : 0'
say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
say '1B'x || '[15;2HNumber of errors      : 'n.errors
say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
say '1B'x || '[17;2HUpdate log            : 'log
say '1B'x || '[19;2H'

rc = lineout(log, 'Info: Creating installation floppies from 'iddir' and 'fpdir'... ('date() time()', version 'ver')')
rc = lineout(log)
call create_flop 'DISK0'
call report_status
call create_flop 'DISK1_CD'
call report_status
if datatype(vers) <> 'NUM' then do
	call create_flop 'DISK2'
	call report_status
end

if n.elapsed > 0 then do
	rc = lineout('result.out', n.errors||' '||n.warnings, 1)
end
exit 

/* create and update install floppy */
create_flop: procedure expose log iddir fpdir cddir exdir n. ver flpdrv compress f1dir f2dir vers add_dummy add_dani

	parse arg disk
	image = iddir || '\' || disk || '.dsk'

	/* create installation floppy */
	say '1B'x || '[7;26HCreating 'disk
	rcode = 1
	do while rcode <> 0
		/* ask the user to do something useful :-) */
		say '1B'x || '[19;2HPlease insert a blank floppy in drive 'flpdrv' and press ENTER'
		if expert = 0 then '@pause >nul 2>>&1'
		say '1B'x || '[19;2H'substr(' ', 1, 70)
		if (f1dir <> '' & disk = 'DISK1_CD') then do
			call deldir flpdrv
			call execute '@xcopy 'f1dir'\* 'flpdrv' /H/O/T/R'
			call execute '@label 'flpdrv'DISK 1'
		end
		else if (f2dir <> '' & disk = 'DISK2') then do
			call deldir flpdrv
			call execute '@xcopy 'f2dir'\* 'flpdrv' /H/O/T/R'
			call execute '@label 'flpdrv'DISK 2'
		end
		else
			call execute '@'exdir'\loaddskf 'image flpdrv' /Y /Q /S /F '
		rcode = result
		if rcode <> 0 then do
			say '1B'x || '[19;2HError creating floppy, press any key to try it again'
			'@pause >nul 2>>&1'
		end
	end

	/* create some space */
	if stream(flpdrv'\bundle', 'c', 'query exists') <> '' then call execute '@del 'flpdrv'\bundle'
	if stream(flpdrv'\readme.ins', 'c', 'query exists') <> '' then call execute '@del 'flpdrv'\readme.ins'
	if stream(flpdrv'\readme.cid', 'c', 'query exists') <> '' then call execute '@del 'flpdrv'\readme.cid'
	if stream(flpdrv'\IBM2FLPY.ADD', 'c', 'query exists') <> '' then call execute '@del 'flpdrv'\ibm2*'
	if stream(flpdrv'\xdfloppy.flt', 'c', 'query exists') <> '' then '@echo dummy > 'flpdrv'\xdfloppy.flt'

	if translate(disk) = 'DISK1_CD' & datatype(vers) = 'NUM' then do
		/* do not update keyboard.dcp on boot floppy 1 (no space) */
		call execute '@copy fix\keyboard.dcp fix\keyboard.org'
		call execute '@del  fix\keyboard.dcp'

		/* delete editor */
		if stream(flpdrv'\tedit.exe',    'c', 'query exists') <> '' then call execute '@del 'flpdrv'\tedit.*'

		/* do not update aic7870.add on boot floppy 1 (no space) */ 
		call execute '@copy fix\aic7870.add fix\aic7870.org'
		call execute '@del fix\aic7870.add'

		/* delete some drivers */
		if stream(flpdrv'\btscsi.add',   'c', 'query exists') <> '' then call execute '@del 'flpdrv'\btscsi.add'
		if stream(flpdrv'\dpt20xx.add',  'c', 'query exists') <> '' then call execute '@del 'flpdrv'\dpt20xx.add'
	end

	/* update floppy */
	'@del result.out >nul 2>>&1'
	'@call updcd 'flpdrv fpdir n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
	res = linein('result.out')
	rc = lineout('result.out')
	parse var res n.errors n.warnings

	/* postprocessing floppy */
	say '1B'x || '[7;26H'substr('Postprocessing 'disk, 1, 50)

	if translate(disk) = 'DISK0' then do

		call execute '@del 'flpdrv'\os2krnli'

		if n.elapsed > 0 then do

			call copydir flpdrv cddir'\updcd\bootimg\DISK_0_1.IMG'

			if compress = 1 then do
				/* clean up */
				call deldir 'tmp' 
				call execute '@mkdir tmp'
				call execute '@mkdir tmp\disk0'
				call execute '@xcopy 'cddir'\updcd\bootimg\DISK_0_1.IMG\* tmp\disk0\.'
				call execute '@copy 'fpdir'\os2krnl tmp\disk0\os2krnli'
			end

			call execute '@copy 'fpdir'\os2krnl 'cddir'\updcd\bootimg\DISK_0_1.IMG\.'
		end

		call execute '@copy 'fpdir'\os2krnl 'flpdrv'\os2krnli'

		if n.elapsed > 0 & compress = 1 then do
			call execute '@lxlite tmp\disk0\*'
			call execute '@del 'flpdrv'\os2krnli'
			call execute '@xcopy tmp\disk0\* 'flpdrv
		end

	end

	if translate(disk) = 'DISK1_CD' then do
		config_file = flpdrv'\CONFIG.SYS'
		i = 1
		do while lines(config_file)
			l.i = linein(config_file)
			i = i+1
		end
		rc = lineout(config_file)
		l.0 = i - 1
		call execute '@del 'config_file
		do i = 1 to l.0
			if pos('XDFLOPPY',   translate(l.i)) > 0 then iterate /* remove XDF driver   */
			if pos('COPYFROMFLOPPY', translate(l.i)) > 0 then iterate; /* remove copyfromfloppy */
			rc = lineout(config_file, l.i)
		end
		rc = lineout(config_file)

		if stream('fix\keyboard.org', 'c', 'query exists') <> '' then do
			/* restore keyboard.dcp */
			call execute '@copy fix\keyboard.org fix\keyboard.dcp'
			call execute '@del  fix\keyboard.org'
			/* do update aic7870.add on the CD */
			call execute '@copy fix\aic7870.org fix\aic7870.add'
			call execute '@del fix\aic7870.org'
		end

		/* replace PS/2 drivers with dummy */
		call execute '@copy newinst\nulldev.sys 'flpdrv'\IBM2SCSI.ADD'
		call execute '@copy newinst\nulldev.sys 'flpdrv'\IBM2FLPY.ADD'
		call execute '@copy newinst\nulldev.sys 'flpdrv'\IBM2ADSK.ADD'

		if n.elapsed > 0 then do
			call copydir flpdrv cddir'\updcd\bootimg\DISK_0_1.IMG'

			if compress = 1 then do
				call execute '@mkdir tmp'
				call execute '@mkdir tmp\disk1'
				call copydir flpdrv 'tmp\disk1'
			end

			config_file = cddir'\updcd\bootimg\DISK_0_1.IMG\CONFIG.SYS'
			i = 1
			do while lines(config_file)
				l.i = linein(config_file)
				i = i+1
			end
			rc = lineout(config_file)
			l.0 = i - 1
			call execute '@copy 'config_file cddir'\updcd\bootimg\.'
			call execute '@del 'config_file

			/* change things */
			do i = 1 to l.0
				select 
					when pos('COPYFROMFLOPPY', translate(l.i)) > 0 then nop; /* remove copyfromfloppy */
					when pos('IBM1FLPY.ADD', translate(l.i)) > 0 & datatype(vers) <> 'NUM' then do
						rc = lineout(config_file, 'basedev=IBM1FLPY.ADD /A:0 /FORCE:1 /U:0 /F:2.88MB')
					end
					when pos('IBMIDECD.FLT', translate(l.i)) > 0 then do
						rc = lineout(config_file, l.i)
						if datatype(vers) = 'NUM' then 
							rc = lineout(config_file, 'BASEDEV=CD_BOOT.FLT /D:2')
						else 
							rc = lineout(config_file, 'BASEDEV=CD_BOOT.FLT /D:3')
					end
					when pos('LIBPATH=', translate(l.i)) > 0 then do
						rc = lineout(config_file, l.i||'y:\os2image\disk_0;y:\os2image\disk_2;y:\os2image\disk_3;')
					end
					when pos('SET PATH=', translate(l.i)) > 0 then do
						rc = lineout(config_file, l.i||';y:\os2image\disk_0;y:\os2image\disk_2;y:\os2image\disk_3;')
					end
					when pos('SET DPATH=', translate(l.i)) > 0 then do
						rc = lineout(config_file, l.i||';y:\os2image\disk_0;y:\os2image\disk_2;y:\os2image\disk_3;')
					end
					otherwise
						rc = lineout(config_file, l.i)
				end
			end

			/* append to config.sys */
			rc = lineout(config_file, 'SET BOOTEDFROMCD=YES')
			rc = lineout(config_file, 'RESERVEDRIVELETTER=X')
			rc = lineout(config_file)

			/* append to after phase1 config.sys */
			'@echo RESERVEDRIVELETTER=X >> 'cddir'\updcd\bootimg\config.sys'
		end

		if n.elapsed > 0 & compress = 1 then do
			call execute '@lxlite tmp\disk1\*'
			call execute '@del 'flpdrv'\aic7870.add'
			call execute '@xcopy tmp\disk1\* 'flpdrv
			call execute '@lxlite 'cddir'\updcd\bootimg\DISK_0_1.IMG\*'

			/* add the dani driver if it is there for non Warp 3 systems */
			if add_dani = 1 & if stream('addons\21_DNIDE\DaniS506.ADD', 'c', 'query exists') <> '' & datatype(vers) <> 'NUM' then do

				/* add to floppy */
				call execute '@del 'flpdrv'\ibm1s506.add'
				call execute '@copy addons\21_DNIDE\DaniS506.ADD 'flpdrv'\ibm1s506.add'

				/* add to boot image */
				call execute '@del 'cddir'\updcd\bootimg\DISK_0_1.IMG\ibm1s506.add'
				call execute '@copy addons\21_DNIDE\DaniS506.ADD 'cddir'\updcd\bootimg\DISK_0_1.IMG\ibm1s506.add'

				/* add to fix directory */
				call execute '@copy addons\21_DNIDE\DaniS506.ADD fix\ibm1s506.add'
			end

		end

		/* replace some SCSI drivers with DANI's dummy driver  */
		if add_dummy = 1 then do
			/* this will give enough space to incorporate new ones */
			if stream(flpdrv'\aha152x.add', 'c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\aha152x.add'
			if stream(flpdrv'\aha154x.add', 'c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\aha154x.add'
	    if stream(flpdrv'\aha164x.add', 'c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\aha164x.add'
	    if stream(flpdrv'\aha174x.add', 'c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\aha174x.add'
	    if stream(flpdrv'\aic7770.add', 'c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\aic7770.add'
	    if stream(flpdrv'\btscsi.add',  'c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\btscsi.add'
	    if stream(flpdrv'\dac960.add',  'c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\dac960.add'
	    if stream(flpdrv'\dpt20xx.add', 'c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\dpt20xx.add'
	    if stream(flpdrv'\fd16-700.add','c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\fd16-700.add'
	    if stream(flpdrv'\fd7000ex.add','c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\fd7000ex.add'
	    if stream(flpdrv'\fd8xx.add',   'c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\fd8xx.add'
	    if stream(flpdrv'\flashpt.add', 'c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\flashpt.add'
	    if stream(flpdrv'\ql10os2.add', 'c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\ql10os2.add'
	    if stream(flpdrv'\ql40os2.add', 'c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\ql40os2.add'
	    if stream(flpdrv'\ql510.add',   'c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\ql510.add'
	    if stream(flpdrv'\tmv1scsi.add','c', 'query exists') <> '' then call execute '@copy newinst\nulldev.sys 'flpdrv'\tmv1scsi.add'
		end
	
		/* put back dummy for deleted drivers */
		if datatype(vers) = 'NUM' then do
    	call execute '@copy newinst\nulldev.sys 'flpdrv'\btscsi.add'
    	call execute '@copy newinst\nulldev.sys 'flpdrv'\dpt20xx.add'
		end

		/* add drivers if they are placed in newinst */
		if add_dummy = 1 then do
			if stream('fix\aic78u2.add', 'c', 'query exists') <> '' then call execute '@copy fix\aic78u2.add newinst\.'
			rc = SysFileTree('newinst\*.add', 'drivers.', 'FO')
			do i = 1 to drivers.0
		   		call execute '@copy 'drivers.i flpdrv'\.'
					if n.elapsed > 0 then call execute '@copy 'drivers.i cddir'\updcd\bootimg\DISK_0_1.IMG\.'
					drivers.i = translate(substr(drivers.i, lastpos('\', drivers.i)+1))
					gevonden = 0
					do while lines(flpdrv'\config.sys')
						l = translate(linein(flpdrv'\config.sys'))
						if l = 'BASEDEV='drivers.i then gevonden = 1
					end
					call lineout flpdrv'\config.sys'
					if gevonden = 0 then do
						'@echo BASEDEV='drivers.i' >> 'flpdrv'\config.sys'
						if n.elapsed > 0 then do
							'@echo BASEDEV='drivers.i' >> 'cddir'\updcd\bootimg\DISK_0_1.IMG\config.sys'
							'@echo BASEDEV='drivers.i' >> 'cddir'\updcd\bootimg\config.sys'
						end
					end
			end
		end
	end

	if translate(disk) = 'DISK2' then do

		if n.elapsed > 0 then do
			call copydir flpdrv cddir'\updcd\bootimg\DISK_2.IMG'

			if compress = 1 then do
				call execute '@mkdir tmp'
				call execute '@mkdir tmp\disk2'
				call execute '@xcopy 'cddir'\updcd\bootimg\DISK_2.IMG\* tmp\disk2\.'
				call execute '@lxlite tmp\disk2\*'
				if stream(flpdrv'\sysinst2.exe', 'c', 'query exists') <> '' then call execute '@del 'flpdrv'\sysinst2.exe'
				call execute '@xcopy tmp\disk2\* 'flpdrv
				call execute '@lxlite 'cddir'\updcd\bootimg\DISK_2.IMG\*'
			end

		end

	end

	/* generate updated image */
	say '1B'x || '[4;2HTarget directory      : 'substr(iddir, 1, 50)
	say '1B'x || '[5;2HSource directory      : 'substr(flpdrv'\', 1, 50)
	say '1B'x || '[7;26H'substr('Updating CD image', 1, 50)
	say '1B'x || '[19;2H'substr(' ', 1, 70)
	call execute '@savedskf 'flpdrv image

	/* clean up */
	call deldir 'tmp' 

return

/* execute command, display it and write to log */ 
execute: procedure expose log n. iddir flpdrv

	parse arg comm
	parse upper var comm comm1 comm2 comm3 comm4 rest
	say '1B'x || '[8;26H'substr(comm3, 1, 50)
	say '1B'x || '[9;26H'substr(comm2, 1, 50)
	say '1B'x || '[11;26H'substr(comm1, 2, 50)
	comm '>nul 2>>&1'
	rcode = rc
	say '1B'x || '[12;26H'rcode' '

	if rcode <> 0 then do
		rc = lineout(log, 'Error: 'comm' (rc='rcode')')
		rc = lineout(log)
		n.errors = n.errors + 1
	end
	else do
		rc = lineout(log, 'Info: 'comm' (rc='rcode')')
		rc = lineout(log)
	end

	call report_status

return rcode

/* display status */
report_status: procedure expose n. iddir flpdrv

	say '1B'x || '[4;2HTarget directory      : 'substr(flpdrv'\', 1, 50)
	say '1B'x || '[5;2HSource directory      : 'substr(iddir, 1, 50)
	say '1B'x || '[7;2HCurrent activity      : 'substr('Thinking...', 1, 50)
	say '1B'x || '[8;2HTarget object         : 'substr('Searching...', 1, 50)
	say '1B'x || '[9;2HSource object         : 'substr('Searching...', 1, 50)
	say '1B'x || '[11;2HUpdate action         : 'substr('Searching...', 1, 50)
	say '1B'x || '[12;2HUpdate return code    : 0'
	say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
	say '1B'x || '[15;2HNumber of errors      : 'n.errors
	say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
	say '1B'x || '[19;2H'

return

DelDir: procedure expose n. log iddir flpdrv

	parse arg Directory
	DirSpec = Directory || '\*'

	/* delete subdirectories */
	rc = SysFileTree(DirSpec, Subdirs, 'DO', '*****', '-*---')
	do i = 1 to Subdirs.0
   		call DelDir Subdirs.i
	end

	/* delete files */
	rc = SysFileTree(DirSpec, Files, 'FO', '*****', '-*---')
	do i = 1 to Files.0
			if pos('EA DATA. SF', Files.i) = 0 then call execute '@del 'Files.i
  end

	/* delete directory */
	cdir = directory()
	d = directory(Directory)
	cdir = directory(cdir)
	if d <> '' & substr(Directory, 2) <> ':' then call execute '@rmdir 'Directory

return

/* copy files from sdir to tdir except ea data. sf */
CopyDir: procedure expose log n.

	parse arg sdir tdir 

	call SysFileTree sdir'\*', ini., "FO", , '**---'
	do i=1 to ini.0
		if pos('EA DATA. SF', translate(ini.i)) = 0 then do
			'@copy 'ini.i tdir'\. >nul 2>>&1'
			rcode = rc
			if rcode <> 0 then do
				rc = lineout(log, 'Error: @copy 'ini.i tdir'\. (rc='rcode')')
				rc = lineout(log)
				n.errors = n.errors + 1
			end
			else do
				rc = lineout(log, 'Info: @copy 'ini.i tdir'\. (rc='rcode')')
				rc = lineout(log)
			end
		end
	end
	call report_status

return
