/* update OS/2 installation CD-ROM                                */
/* 05.13.2000: initial version, supported sel. install only       */
/* 05.21.2000: added support for clean installation of OS/2       */
/* 06.04.2000: bug fixing, improved installation image      			*/
/*             provided support for incorporating dd fixpak       */
/*             improved interface, error logging and reporting    */
/* 06.12.2000: bug fixing, improved performance, made updcd.cmd   */
/*             language independent, added support for mpts fp    */
/* 07.23.2000: bug fixing, added support for peer fp, improved    */
/*             OS/2 fixpak incorporation, simplified plug-in      */
/*             structure, added support for tcp/ip fp, added      */
/*             partial update of FI database (not finished)       */
/* 08.14.2000: added support for Feature Installer update         */
/*             added support for TCP/IP 4.x, NS 4.61 and JDK 1.1  */
/*             improved FI database update (still not finished)   */
/* 08.20.2000: added preliminary WSeB support (0.7)               */
/* 09.23.2000: bug fixing                                         */
/* 09.30.2000: changed to work with virtual floppy                */
/* 10.01.2000: added postprocessing plug-in for TCP/IP fpk        */
/* 10.10.2000: added syslevel update                              */
/* 10.25.2000: added support for 32-bits tcp/ip fixpaks           */
/* 01.26.2001: changed zip-detection method (-z -> -t -qq, *.zip) */
/* 02.27.2001: fixed displaying file xxx deleted messages         */
/* 03.03.2001: added support for pmfax lite                       */
/* 03.11.2001: added some code to support Warp 3 updates          */
/* 03.17.2001: detection of required changed to support Warp 3    */
/* 03.19.2001: solved problem with FI db update for Warp 3        */
/* 03.28.2001: added support to incorporate new ADD's             */
/* 04.26.2001: added support to remove java 1.0.2                 */
/* 04.27.2001: fixed problem with incorporating 32 bit TCP fpks   */
/* 05.02.2001: added support for IP08603 (LS fixpak)              */
/* 05.04.2001: fixed problem with updating zip files              */
/* 05.05.2001: added support for JAVA run-time fix                */

/* read parameters */
parse upper arg cddir fpdir n.errors n.warnings n.elapsed log ver vers

/* check directories */
if cddir = '' | fpdir = '' then do
	say
	say ' Update OS/2 installation CD-ROM with fixpaks.'
	say ' Usage: updcd <directory OS/2 CD-ROM> <directory fixpak files>'
	say ' Example: updcd d:\w4cd d:\fp13'
	say ' The fixpak files must be uncompressed, see the readme and prpfp.cmd!'
	exit 1
end

/* floppy drive */
flpdrv = cddir

/* need to know absolute path */
cdir  = directory()
fpdir = directory(fpdir) 
cdir  = directory(cdir)
cddir = directory(cddir) 
cdir  = directory(cdir)

/* reset some variables */
if ver = '' then ver   = '1.5'
if log = '' then log   = 'updcd.log'
if n.errors = '' then n.errors = 0
if n.warnings = '' then n.warnings = 0
if n.elapsed = '' then n.elapsed = 0
fibase.0 = 0

/* reset screen */
'@mode 80,25'
'@ansi on >NUL'
say '1B'x || '[36;44m'
say '1B'x || '[1m'
'@cls'
call rxfuncadd syscurstate, rexxutil, syscurstate
call syscurstate off
say '1B'x || '[2;2HUpdate OS/2 installation CD-ROM, version 'ver
say '1B'x || '[4;2HTarget directory      : 'cddir
say '1B'x || '[5;2HSource directory      : 'fpdir
say '1B'x || '[7;2HCurrent activity      : 'substr('Thinking...', 1, 50)
say '1B'x || '[8;2HTarget object         : 'substr('Searching...', 1, 50)
say '1B'x || '[9;2HSource object         : 'substr('Searching...', 1, 50)
say '1B'x || '[11;2HUpdate action         : 'substr('Searching...', 1, 50)
say '1B'x || '[12;2HUpdate return code    : 0'
say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
say '1B'x || '[15;2HNumber of errors      : 'n.errors
say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
say '1B'x || '[17;2HUpdate log            : 'log
say '1B'x || '[19;2H'

/* determine Warp version */
if stream(cddir'\vcu.exe', 'c', 'query exists') <> '' then fibase.wseb = 1
else fibase.wseb = 0
if datatype(vers) = 'NUM' then fibase.warp3 = 1
else fibase.warp3 = 0

/* scanning fixpak directory */
rc = RxFuncAdd('SysFileTree', 'RexxUtil', 'SysFileTree')
if fibase.wseb = 0 then do
	rc = SysFileTree(fpdir || '\srv_prod.*', sysfls., "FO")  
	rc = SysFileTree(fpdir || '\*', ffp.full., "FO") 
end
else do
	rc = SysFileTree(fpdir || '\srv_prod.*', sysfls., "FSO")  
	rc = SysFileTree(fpdir || '\*', ffp.full., "FSO") /* need SMP files too */
end
if rc <> 0 then do
		rc=lineout(log, 'Error: 'fpdir' seems not to be a fixpack directory!')
		n.errors = n.errors + 1
end 
do i = 1 to sysfls.0 /* read srv_prod files */
	sysfls.i.data = charin(sysfls.i, 1, chars(sysfls.i))
	call stream sysfls.i, "C", "Close"
end
do i=1 to ffp.full.0
	ffp.i = translate(filespec('NAME', ffp.full.i))
	ffp.full.i = translate(ffp.full.i)
end
ffp.0 = ffp.full.0

/* start updating files */
rc = lineout(log, 'Info: Updating install files in 'cddir' with fixpak files in 'fpdir'... ('date() time()', version: 'ver')')

/* determine what to do */
if cddir <> flpdrv'\' then do 

	/* incorporate OS/2 and DD fixpak */
	if stream(fpdir'\os2krnl', 'c', 'query exists') <> '' then do

		/* regular update */ 
		call update cddir||'\os2image\DEBUG' 
		call update cddir||'\os2image\DISK_0'
		call update cddir||'\os2image\DISK_1'
		call update cddir||'\os2image\DISK_2'
		call update cddir||'\os2image\DISK_3'
		call update cddir||'\os2image\DISK_4'
		call update cddir||'\os2image\DISK_5'
		call update cddir||'\os2image\DISK_6'
		call update cddir||'\os2image\DISK_7'
		call update cddir||'\os2image\DISK_8'
		call update cddir||'\os2image\DISK_9'
		call update cddir||'\os2image\DISK_10'
		call update cddir||'\os2image\DISK_11'
		call update cddir||'\os2image\DISK_12'
		call update cddir||'\os2image\DISK_13'
		call update cddir||'\os2image\DISK_14'
		call update cddir||'\os2image\DISK_15'
		call update cddir||'\os2image\DISK_16'
		call update cddir||'\os2image\DISP_1'
		call update cddir||'\os2image\DISP_2'
		call update cddir||'\os2image\DISP_3'
		call update cddir||'\os2image\DISP_4'
		call update cddir||'\os2image\SYM_1'
		call update cddir||'\os2image\SYM_2'
		call update cddir||'\os2image\SYM_3'
		call update cddir||'\os2image\SYM_4'
		call update cddir||'\os2image\SYM_5'

		if fibase.warp3 = 0 then do
			call update cddir||'\os2image\DISK_17'
			call update cddir||'\os2image\DISK_18'
			call update cddir||'\os2image\DISK_19'
			call update cddir||'\os2image\DISK_20'
			call update cddir||'\os2image\DISK_21'
			call update cddir||'\os2image\DISK_22'
			call update cddir||'\os2image\DISK_23'
			call update cddir||'\os2image\DISK_24'
			call update cddir||'\os2image\DISK_25'
			call update cddir||'\os2image\DISK_26'
			call update cddir||'\os2image\DISK_27'
			call update cddir||'\os2image\DISK_28'
			call update cddir||'\os2image\DISK_29'
			call update cddir||'\os2image\DISK_30'
			call update cddir||'\os2image\DISK_31'
			call update cddir||'\os2image\DISK_32'
			call update cddir||'\os2image\DISK_33'
			call update cddir||'\os2image\DISK_34'
			call update cddir||'\os2image\DISK_35'
			call update cddir||'\os2image\DISK_W1'
			call update cddir||'\os2image\DISK_W2'
			call update cddir||'\os2image\DISK_W3'
			call update cddir||'\os2image\DISK_W4'
			call update cddir||'\os2image\DISK_W5'
			call update cddir||'\os2image\DISP_5'
			call update cddir||'\os2image\FI\SYSMGT'
			call update cddir||'\os2image\FI\DAX'
			call update cddir||'\os2image\FI\SECURITY'
			call update cddir||'\CID\EXE' 
		end

		if fibase.wseb = 0 & fibase.warp3 = 0 then do /* only for Warp 4 */
			call update cddir||'\os2image\DISK_36'
			call update cddir||'\os2image\DISK_37'
			call update cddir||'\os2image\DISK_38'
			call update cddir||'\os2image\DISK_39'
			call update cddir||'\os2image\FI\VT'
			call update cddir||'\os2image\FI\COACHES'
			call update cddir||'\CID\IMG\SVAGENT'
		end
		else if fibase.warp3 = 0 then do	/* only for WSeB */
			call update cddir||'\os2image\DISP_6'
			call update cddir||'\os2image\FI\LVMGUI'
		end
		else do /* only for Warp 3 */
			call update cddir||'\os2image\DMPD1'
			call update cddir||'\os2image\DMPD2'
		end

		/* update FI database */
		if fibase.warp3 = 0 then call update_FI_data

		/* add new drivers if they are there */
		rc = SysFileTree('newinst\*.add', 'drivers.', 'FO')
		do i = 1 to drivers.0
				call execute '@copy 'drivers.i' fix\.'
				drivers.i = translate(substr(drivers.i, lastpos('\', drivers.i)+1))
				call add2bundle drivers.i 'os2image\disk_0\bundle \OS2\BOOT'
				call add2bundle drivers.i location.scsiadds
				call execute '@del fix\'drivers.i
		end
		if stream('newinst\aic78u2.add', 'c', 'query exists') <> '' then call execute '@del newinst\aic78u2.add'

		/* postprocessing to include new functions from fixpak */
		call postprocess 'basefpk.pin'

		/* postprocess FI database */
		if fibase.warp3 = 0 then call postprocess_fibase 

		/* put our readme on CD */
		call place_readme

	end

	/* incorporate printer fixpak */
	else if (stream(fpdir'\pscript.drv', 'c', 'query exists') <> '' | stream(fpdir'\plotters.drv', 'c', 'query exists') <> '' | stream(fpdir'\laserjet.drv', 'c', 'query exists') <> '' | stream(fpdir'\omni.drv', 'c', 'query exists') <> '') then do

		/* regular update */
		call update cddir||'\os2image\PMDD_1'
		call update cddir||'\os2image\PMDD_2'
		call update cddir||'\os2image\PMDD_3'
		call update cddir||'\os2image\PMDD_4'
		call update cddir||'\os2image\PMDD_5'
		call update cddir||'\os2image\PMDD_6'
		if fibase.wseb <> 0 then call update cddir||'\os2image\PMDD_7'

	end

	/* incorporate MPTS fixpak */
	else if stream(fpdir'\afinet.sys', 'c', 'query exists') <> '' then do

		/* regular update */
		call update cddir

		/* if target is not peer mpts than do postprocessing */
		if stream(cddir'\peerrmt.exe', 'c', 'query exists') = '' then 
			call postprocess 'mptsfpk.pin'

	end

	/* incorporate PEER\LS fixpak */
	else if stream(fpdir'\net.exe', 'c', 'query exists') <> '' then do
		
		/* regular update */
		if stream(cddir'\CID\IMG\IBMPEER\peerrmt.exe', 'c', 'query exists') <> '' then
			call update cddir'\CID\IMG\IBMPEER'
		else do
			call update cddir'\CID\server\ibmls'
			call update cddir'\cid\server\kaajnyh'
		end

		/* postprocessing */
		call postprocess 'peerfpk.pin'

	end

	/* incorporate TCP/IP fixpak */
	else if stream(fpdir'\ftp.exe', 'c', 'query exists') <> '' then do
		
		/* find out path to TCPAPPS */
		tcpdir = 'CID\IMG\TCPAPPS'
		if stream(cddir'\'tcpdir'\install.exe', 'c', 'query exists') = '' & stream(cddir'\'tcpdir'\tcpinst.exe', 'c', 'query exists') = '' then tcpdir = 'CID\SERVER\TCPAPPS' 

		/* regular update */
		call update cddir'\'tcpdir

		/* postprocessing for 16-bits TCP/IP */
		if stream(cddir'\'tcpdir'\base1.zip', 'c', 'query exists') <> '' then call postprocess 'tcppfpk.pin'

		/* update FI database for 32-bits TCP/IP */
		else do
			fibase.tcpip = 1
			call update_FI_data
		end

	end

	/* incorporate JAVA fixpak */
	else if stream(fpdir'\java.exe', 'c', 'query exists') <> '' then do

		/* regular update */
		fibase.java = 1

		if stream(cddir'\CID\IMG\java\install.exe', 'c', 'query exists') <> '' then
			call update cddir||'\CID\IMG\JAVA'
		else
			call update cddir||'\CID\server\JAVA'

		/* update FI database for JAVA */
		call update_FI_data

	end

	/* incorporate PMFax lite */
	else if stream(fpdir'\faxworks.exe', 'c', 'query exists') <> '' then do

		/* regular update */
		fibase.fax = 1
		call update cddir||'\os2image\FI\BONUSPAK\FAXWORKS'

		/* update FI database for FaxWorks */
		call update_FI_data

		/* postprocessing */
		call postprocess 'pmfaxlt.pin'

		/* postprocess FI database */
		/* call postprocess_fibase */

	end

	/* cannot handle this fixpak */
	else do
		say 'Panic, I do not know what to do with this fixpak!'
		rc = lineout(log, 'Error: Panic, I do not know what to do with this fixpak!')
		n.errors = n.errors + 1
		if n.elapsed > 0 then do
			/* if go4it called us than we should make a report */
			rc = lineout('result.out', n.errors||' '||n.warnings, 1)
		end
		exit 1
	end

	/* log not used fixpak files */
	do i = 1 to ffp.0
		filename = translate(ffp.i, '_', '.')
		if (updated.filename <> 1) & (pos('SRV_PROD', filename)) = 0 then do
			n.warnings = n.warnings + 1
			rc = lineout(log, 'Warning: Fixpak file 'ffp.i' was not used!')
		end
	end

	/* log not updated FI records */
	do i = 1 to fibase.0
		if updated.i <> 1 then do
			n.warnings = n.warnings + 1
			rc = lineout(log, 'Warning: Update 'fibase.i' was not included in FI database!')
		end
	end

	say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
	say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
	say '1B'x || '[19;2H'

end

/* update installation floppy */
else do
	call update flpdrv
end

if n.elapsed > 0 then do
	/* if go4it called us than we should make a report */
	rc = lineout('result.out', n.errors||' '||n.warnings, 1)
end
else do
	/* signal fatal errors */
	if n.errors > 0 then 	say '1B'x || '[19;2HThere were one or more errors detected, Check updcd.log!'
	else say '1B'x || '[19;2HUpdate is completed succesfully!'
end

exit 

/* update directory with fixpak */
update: procedure expose fpdir log ffp. n. updated. fibase. location. sysfls.

	parse arg cddir 
	say '1B'x || '[7;26HUpdating 'substr(cddir, 1, 41)
	say '1B'x || '[8;26H'substr('Searching...', 1, 50)
	say '1B'x || '[9;26H'substr('Searching...', 1, 50)
	say '1B'x || '[11;26H'substr('Searching...', 1, 50)
	say '1B'x || '[19;2H'
	rc=lineout(log, 'Info: Updating  'cddir'...')

	/* rc=lineout(log, 'Info: sysfls 'sysfls.0) */

	/* scanning and updating directory */
	rc = SysFileTree(cddir || '\*', fcd.full., "FSO",,'**---') 
	if rc <> 0 then do
		rc=lineout(log, 'Error: 'cddir' seems not to be an image directory!')
		n.errors = n.errors + 1
   	return
	end
	do i=1 to fcd.full.0	/* process all files in this directory */

			/* translate filenames to uppercase */
			fcd.i = translate(filespec('NAME', fcd.full.i))
			if fcd.i = 'EA DATA. SF' then iterate
			fcd.full.i = translate(fcd.full.i)

			/* determine which type of file we have */
			if test_compressed_file(fcd.full.i) then 
				call update_compressed_file /* packed file */
			else if (test_zipped_file(fcd.full.i) & fcd.i <> 'LVMGUI.ZIP' & fcd.i <> 'CLASSES.ZIP') then /* skip lvmgui.zip */
				call update_zipped_file     /* zipped file */
			else	
				call update_uncompressed_file /* plain file */
	end

	/* display status */
	call report_status
	
return

/* update compressed file (bundle) */
update_compressed_file: procedure expose fcd. ffp. i log updated. n. location. sysfls.

	rcode = 0
	dummy = 'dummy.txt'
	tmp='$unpk$.txt'

	/* create and process list of packed files */
	found = 0
	'@unpack 'fcd.full.i' /show > 'tmp
	f=linein(tmp)
	do while lines(tmp)
		l = translate(linein(tmp))  /* transform to uppercase */
		p = lastpos('\', l)
		if p <> 0 then do
			dpath = substr(l, 3, p-2) /* relative location (path) of packed file */
			l = substr(l, p+1)        /* name of packed file without path */
		end
		else do
			dpath = ''
			l = substr(l, 3)
		end

		/* remember location of special files */
		select 
			when l = 'FIBASE.RSP' then do
				location.fibase = fcd.full.i
			end
			when l = 'DKBASE.RSP' then do
				location.dkbase = fcd.full.i
			end
			when l = 'MTSH.DLL' then do
				location.mmparts = substr(fcd.full.i, pos('\OS2IMAGE\', fcd.full.i)+1)
			end
			when l = 'APM.SYS' then do
				location.apm = substr(fcd.full.i, pos('\OS2IMAGE\', fcd.full.i)+1)
			end
			when l = 'PCMCIA.SYS' then do
				location.pcmcia = substr(fcd.full.i, pos('\OS2IMAGE\', fcd.full.i)+1)
			end
			when l = 'COURIER.BGA' & fcd.i = 'COURIER.BMP' then do
				location.courier = substr(fcd.full.i, pos('\OS2IMAGE\', fcd.full.i)+1)
			end
			when l = 'HIMEM.SYS' & fcd.i = 'DOS' then do
				location.dos = substr(fcd.full.i, pos('\OS2IMAGE\', fcd.full.i)+1)
			end
			when l = 'WINASPI.DLL' & fcd.i = 'WINENV' then do
				location.winenv = substr(fcd.full.i, pos('\OS2IMAGE\', fcd.full.i)+1)
			end
			when l = 'TIMES.BGA' & fcd.i = 'TIMES.BMP' then do
				location.times = substr(fcd.full.i, pos('\OS2IMAGE\', fcd.full.i)+1)
			end
			when l = 'LIBCS.DLL' & fcd.i = 'REQUIRED' then do
				location.required = substr(fcd.full.i, pos('\OS2IMAGE\', fcd.full.i)+1)
			end
			when l = 'MDMI.DLL' & fcd.i = 'PACK0' then do
				location.pack = substr(fcd.full.i, pos('\OS2IMAGE\', fcd.full.i)+1)
			end
			when l = 'HELV.BGA' & fcd.i = 'HELV.BMP' then do
				location.helv = substr(fcd.full.i, pos('\OS2IMAGE\', fcd.full.i)+1)
			end
			when l = 'JOIN.TXT' & fcd.i = 'OPENGL' then do
				location.opengl = substr(fcd.full.i, pos('\OS2IMAGE\', fcd.full.i)+1)
			end
			when l = 'JOIN.TXT' & fcd.i = 'PACK0' then do
				location.mmtemp = substr(fcd.full.i, pos('\OS2IMAGE\', fcd.full.i)+1)
			end
			when l = 'AIC7870.ADD' & fcd.i = 'SCSIADDS' then do
				location.scsiadds = substr(fcd.full.i, pos('\OS2IMAGE\', fcd.full.i)+1)
			end
			otherwise nop;
		end

		match = 0
		do j=1 to ffp.0             /* try to find a match in the fixpak */
			/* say ffp.j "=" l */
			if ffp.j = l then do /* update packed file */
				/* skip matching UNI SMP files */
				if ((pos('\SMP', dpath) > 0 | pos('\WARP45_S', dpath) > 0) & pos('\SMP', ffp.full.j) = 0) | ((pos('\SMP', dpath) = 0 & pos('\WARP45_S', dpath) = 0) & pos('\SMP', ffp.full.j) > 0) then do
					iterate
				end
				rcode = 0
				if found = 0 then do
					found = 1	/* remember we did update this bundle */
					'@pack2 'dummy f' /A >nul 2>&1' /* ensure bundle will not become */
					if rc <> 0 then rcode = rc      /* empty after deleting old file */
				end
				dpath = dpath || l
				'@pack2 'dpath f' /R >nul 2>&1'
				if rc <> 0 then rcode = rc
				'@pack2 'ffp.full.j f '/H:'dpath' /A >nul 2>&1'
				if rc <> 0 then rcode = rc
				match = 1

				/* report */
				say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(f||'->'||l), 1, 50))), 1, 50)
				say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(ffp.full.j), 1, 50))), 1, 50)
				say '1B'x || '[11;26HPack          '
				say '1B'x || '[12;26H'rcode' '
				if rcode <> 0 then do
					rc=lineout(log, 'Error: 'f||'->'||l' <= 'ffp.full.j' rc='rcode)
					n.errors = n.errors + 1
				end
				else
					rc=lineout(log, 'Info: 'f||'->'||l' <= 'ffp.full.j' rc='rcode)
				filename = translate(ffp.j, '_', '.')
				updated.filename = 1
				call report_status
			end
		end

/* not ready yet, should unpack file before updating */

		/* try to update non-matching syslevel files */
		if pos('SYSLEVEL.', l) > 0 & match = 0 then do
			rc = lineout(log, 'Info: Update syslevel file: 'l)
			/* call update_syslevel_file ??? */
		end

	end
	rc=lineout(tmp)
	'@del 'tmp' >nul 2>>&1'

	/* lets see if the packed file matches an other packed file in fp */
	if found = 0 then
		do j=1 to ffp.0 /* compare fixpak files to this bundle */
			if ffp.j = fcd.i then do /* there is a match */
				/* skip matching UNI SMP files */
				if ((pos('\SMP', fcd.full.i) > 0 | pos('\WARP45_S', fcd.full.i) > 0) & pos('\SMP', ffp.full.j) = 0) | ((pos('\SMP', fcd.full.i) = 0 & pos('\WARP45_S', fcd.full.i) = 0) & pos('\SMP', ffp.full.j) > 0) then do
					iterate
				end
				if test_compressed_file(ffp.full.j) then do /* this fp file is compressed! */

					/* update */
					'@copy 'ffp.full.j fcd.full.i' >nul 2>&1'
					if rc <> 0 then rcode = rc

					/* report */
					say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(fcd.full.i), 1, 50))), 1, 50)
					say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(ffp.full.j), 1, 50))), 1, 50)
					say '1B'x || '[11;26HCopy          '
					say '1B'x || '[12;26H'rcode' '

					/* report */
					if rcode <> 0 then do
						rc=lineout(log, 'Error: 'fcd.full.i' <- 'ffp.full.j' rc='rcode)
						n.errors = n.errors + 1
					end
					else
						rc=lineout(log, 'Info: 'fcd.full.i' <- 'ffp.full.j' rc='rcode)
					filename = translate(ffp.j, '_', '.')
					updated.filename = 1
					call report_status
				end
		end
	end
	else do
		'@pack2 'dummy f' /R >nul 2>&1'
		if rc <> 0 then rcode = rc
		if rcode <> 0 then do
			rc=lineout(log, 'Error: Remove dummy rc='rcode)
			n.errors = n.errors + 1
			call report_status
		end
	end

	if rcode <> 0 then rcode = 1
		
return rcode


/* update zipped file */
update_zipped_file: procedure expose fcd. ffp. i log updated. n. sysfls. slfh. st.

	/* clean up temp directory if needed */
	/* abuse zip to do this quick and dirty */
	cdir = directory()
	if directory('.\tmp') <> '' then do
		cdir = directory(cdir)
		'@.\zip.exe -rm tmp.zip tmp\* >nul 2>>&1'
		'@rmdir tmp >nul 2>>&1'
		'@del tmp.zip >nul 2>>&1'
		rc=lineout(log, 'Warning: Temp directory was not empty!')
		n.warnings = n.warnings + 1
		call report_status
	end

	rcode = 0
	tmp='$unzp$.txt'

	/* create and process list of zipped files */
	found = 0
	'@unzip -l 'fcd.full.i' > 'tmp
	line = linein(tmp)
	parse var line . f
	f = space(translate(f, '\', '/'))
	do while lines(tmp)
		line = translate(linein(tmp))
		parse var line . . . . . l
		p = lastpos('/', l)
		if p <> 0 then do
			dpath = substr(l, 1, p-1) /* relative location (path) of zipped file */
			l = substr(l, p+1)        /* name of zipped file without path */
		end
		else do
			dpath = '.'
			l = space(l)
		end

		match = 0
		do j=1 to ffp.0             /* try to find a match in the fixpak */
			/* say ffp.j "=" l */
			if ffp.j = l then do /* update zipped file */
				/* skip matching UNI SMP files */
				if ((pos('\SMP', dpath) > 0 | pos('\WARP45_S', dpath) > 0) & pos('\SMP', ffp.full.j) = 0) | ((pos('\SMP', dpath) = 0 & pos('\WARP45_S', dpath) = 0) & pos('\SMP', ffp.full.j) > 0) then do
					iterate
				end
				if found = 0 then do
					found = 1	/* remember we did update this zip */
					rcode = 0
					'@mkdir tmp >nul 2>>&1'
					if rcode <> 0 then rcode = rc
					'@unzip -o 'fcd.full.i '-d tmp >nul 2>>&1' /* unzip it */
					if rc <> 0 then rcode = rc 
					/* report */
					if rcode <> 0 then do
						rc=lineout(log, 'Error: Unzip 'fcd.full.i' rc='rcode)
						n.errors = n.errors + 1
						call report_status
					end
					else
						rc=lineout(log, 'Info: Unzip 'fcd.full.i' rc='rcode)
				end

				'@copy 'ffp.full.j 'tmp\'space(translate(dpath, '\', '/'))'\'l' >nul 2>>&1'
				if rc <> 0 then rcode = rc
				match = 1

				/* report */
				say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(f||'->'||l), 1, 50))), 1, 50)
				say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(ffp.full.j), 1, 50))), 1, 50)
				say '1B'x || '[11;26HZip           '
				say '1B'x || '[12;26H'rcode' '
				if rcode <> 0 then do
					rc=lineout(log, 'Error: 'f||'->'||l' <- 'ffp.full.j' rc='rcode)
					n.errors = n.errors + 1
					call report_status
				end
				else
					rc=lineout(log, 'Info: 'f||'->'||l' <- 'ffp.full.j' rc='rcode)
				filename = translate(ffp.j, '_', '.')
				updated.filename = 1
				call report_status
			end
		end

		/* try to update non-matching syslevel files */
		if pos('SYSLEVEL.', l) > 0 & match = 0 then do
			if found = 0 then do
		 		'@unzip -o 'fcd.full.i '-d tmp >nul 2>>&1' /* unzip it */
				if rc <> 0 then rcode = rc 
				found = 1
			end
			call update_syslevel_file 'tmp\'space(translate(dpath, '\', '/'))'\'l
		end

	end
	rc=lineout(tmp)
	'@del 'tmp' >nul 2>>&1'

	/* lets see if the packed file matches an other packed file in fp */
	if found = 0 then
		do j=1 to ffp.0 /* compare fixpak files to this zip */
			if translate(ffp.j) = translate(fcd.i) then do /* there is a match */
				/* skip matching UNI SMP files */
				if ((pos('\SMP', fcd.full.i) > 0 | pos('\WARP45_S', fcd.full.i) > 0) & pos('\SMP', ffp.full.j) = 0) | ((pos('\SMP', fcd.full.i) = 0 & pos('\WARP45_S', fcd.full.i) = 0) & pos('\SMP', ffp.full.j) > 0) then do
					iterate
				end
				if test_zipped_file(ffp.full.j) then do /* this fp file is zipped! */

					/* update */
					'@mkdir tmp >nul 2>>&1'
					if rcode <> 0 then rcode = rc
					'@unzip -o 'fcd.full.i '-d .\tmp >nul 2>>&1' /* unzip it */
					if rcode <> 0 then rcode = rc
					'@unzip -o 'ffp.full.j '-d .\tmp >nul 2>>&1' /* unzip it */
					if rcode <> 0 then rcode = rc
					'@cd tmp'
					if rcode <> 0 then rcode = rc
					'@del 'fcd.full.i' >nul 2>>&1'
					if rcode <> 0 then rcode = rc
					'@..\zip.exe -mkr 'fcd.full.i '* >nul 2>>&1'
					if rcode <> 0 then rcode = rc
					'@cd ..'
					if rcode <> 0 then rcode = rc
					'@rmdir tmp >nul 2>>&1'
					if rcode <> 0 then rcode = rc

					/* report */
					say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(fcd.full.i), 1, 50))), 1, 50)
					say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(ffp.full.j), 1, 50))), 1, 50)
					say '1B'x || '[11;26HCopy          '
					say '1B'x || '[12;26H'rcode' '
					if rcode <> 0 then do
						rc=lineout(log, 'Error: 'fcd.full.i' <- 'ffp.full.j' rc='rcode)
						n.errors = n.errors + 1
						call report_status
					end
					else
						rc=lineout(log, 'Info: 'fcd.full.i' <- 'ffp.full.j' rc='rcode)
					filename = translate(ffp.j, '_', '.')
					updated.filename = 1
					call report_status
				end
		end
	end
	else do

		/* zip file */
		'@cd tmp >nul 2>>&1'
		if rcode <> 0 then rcode = rc
		'@del 'fcd.full.i' >nul 2>>&1'
		if rcode <> 0 then rcode = rc
		'@..\zip.exe -mkr 'fcd.full.i '* >nul 2>>&1'
		if rcode <> 0 then rcode = rc
		'@cd .. >nul 2>>&1'
		if rcode <> 0 then rcode = rc
		'@rmdir tmp >nul 2>>&1'
		if rcode <> 0 then rcode = rc

		/* report */
		if rcode <> 0 then do
			rc=lineout(log, 'Error: Zippen 'fcd.full.i' rc='rcode)
			n.errors = n.errors + 1
			call report_status
		end
		else
			rc=lineout(log, 'Info: Zippen 'fcd.full.i' rc='rcode)
	end

	if rcode <> 0 then rcode = 1
		
return rcode


/* update uncompressed file */
update_uncompressed_file: procedure expose fcd. ffp. i log updated. n. fibase. sysfls. slfh. st.

	rcode = 0
	match = 0
	do j=1 to ffp.0
		if ffp.j = fcd.i then do /* match */
			/* skip matching UNI SMP files */
			if ((pos('\SMP', fcd.full.i) > 0 | pos('\WARP45_S', fcd.full.i) > 0) & pos('\SMP', ffp.full.j) = 0) | ((pos('\SMP', fcd.full.i) = 0 & pos('\WARP45_S', fcd.full.i) = 0) & pos('\SMP', ffp.full.j) > 0) then do
				iterate
			end
			'@copy 'ffp.full.j fcd.full.i' >nul 2>&1'
			match = 1
			rcode = rc
			if (pos('\FI\', fcd.full.i) > 0 | fibase.tcpip = 1 | fibase.java = 1) then do /* is it a FI file? */
				k = fibase.0 + 1
				fibase.k = fcd.full.i	/* remember it */
				fibase.0 = fibase.0 + 1
			end
			say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(fcd.full.i), 1, 50))), 1, 50)
			say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(ffp.full.j), 1, 50))), 1, 50)
			say '1B'x || '[11;26HCopy          '
			say '1B'x || '[12;26H'rcode' '
			if rcode <> 0 then do
				rc=lineout(log, 'Error: 'fcd.full.i' <- 'ffp.full.j' rc='rcode)
				n.errors = n.errors + 1
				call report_status
			end
			else
				rc=lineout(log, 'Info: 'fcd.full.i' <- 'ffp.full.j' rc='rcode)
			filename = translate(ffp.j, '_', '.')
			updated.filename = 1
			call report_status
		end
	end

	/* try to update non-matching syslevel files */
	if pos('SYSLEVEL.', fcd.i) > 0 & match = 0 then do
		call update_syslevel_file fcd.full.i
	end
	if rcode <> 0 then rcode = 1

return rcode


/* test file to see if it is compressed */
/* return 1 = compressed     */
/* return 0 = not compressed */
test_compressed_file: procedure

	parse arg f

	tmp='$unpk$.txt'
	'@unpack 'f' /show >'tmp
	l=linein(tmp)
	l=linein(tmp)
	if substr(l, 1, 2) = '->' then rcode = 1
	else rcode = 0
	rc=lineout(tmp)
	'@del 'tmp' >nul 2>>&1'

return rcode


/* test file to see if it is zipped */
/* return 1 = zipped     */
/* return 0 = not zipped */
test_zipped_file: procedure

	parse upper arg f

	if pos('.ZIP', f) = 0 then return 0

	'@unzip -t -qq 'f' >nul 2>>&1'
	if rc = 0 then rcode = 1
	else rcode = 0

return rcode


/* execute postprocessing command, display and log */
execute: procedure expose log n. updated.

	parse arg comm
	rcode = 0

	parse upper var comm comm1 comm2 comm3 comm4 rest
	/* do not copy or pack if file does not exist */
	rc = SysFileTree(comm2, tmp., "FSO") 
	if (comm1 <> '@COPY' & comm1 <> '@PACK2' & comm1 <> '@DEL' & comm1 <> '@XCOPY') | (stream(comm2, 'c', 'query exists') <> '') | (tmp.0 > 0) then do
		comm' >nul 2>>&1'
		if rc <> 0 then rcode = rc
	end
	else do /* log warning */
		rc = lineout(log, 'Warning: Fixpak file 'comm2' does not exist!')
		n.warnings = n.warnings + 1
		call report_status
		return
	end
	comm = comm ||' rc='rcode

	if comm1 = '@..\ZIP.EXE' then do	
		say '1B'x || '[8;26H'substr(comm3, 1, 50)
		say '1B'x || '[9;26H'substr(comm4, 1, 50)
		say '1B'x || '[11;26HZip         '
	end
	else if comm1 = '@MKDIR' | comm1 = '@RMDIR' | comm1 = '@CD' then do	
		nop;
	end
	else if comm1 = '@UNZIP' then do	
		say '1B'x || '[8;26H'substr(rest, 1, 50)
		say '1B'x || '[9;26H'substr(comm3, 1, 50)
		say '1B'x || '[11;26HUnzip         '
	end
	else do
		say '1B'x || '[8;26H'substr(comm3, 1, 50)
		say '1B'x || '[9;26H'substr(comm2, 1, 50)
		say '1B'x || '[11;26H'substr(comm1, 2, 50)
	end
	say '1B'x || '[12;26H'rcode' '

	if rcode <> 0 then do
		rc=lineout(log, 'Error: 'comm)
		n.errors = n.errors + 1
		call report_status
	end
	else
		rc=lineout(log, 'Info: 'comm)

	filename = substr(comm2, lastpos('\', comm2)+1)
	filename = translate(filename, '_', '.')
	updated.filename = 1

	call report_status

return 

/* add new file to zip */
add2zip: procedure expose fpdir cddir log n. updated.
	parse arg zip path files

	call execute '@mkdir tmp'
	call execute '@unzip -o 'cddir'\'zip' -d tmp'
	call execute '@cd tmp'
	
	do while length(files) > 0 
		parse var files file files
		if stream(fpdir'\'file, 'c', 'query exists') <> '' then call execute '@copy 'fpdir'\'file path
	end

/*	call execute '@..\zip.exe -mkr 'cddir'\'zip path'\* '*/
	call execute '@..\zip.exe -mkr 'cddir'\'zip '* '
	call execute '@cd .. '
	call execute '@rmdir tmp '

return

/* postprocessing steps using plugin module */
postprocess: procedure expose log n. cddir fpdir updated. location. fibase.

	parse arg plugin
	if stream(plugin, 'c', 'query exists') <> '' then do
		say '1B'x || '[7;26H'substr('Postprocessing files...', 1, 50)
		rc = lineout(log, 'Info: Postprocessing files...')
		call report_status

		q = 1
		fibase.srvdiag.0 = 0
		do while lines(plugin)
			l = linein(plugin)
			parse upper var l w1 w2 w3 w4 w5

			/* found new FI file */
			if pos('COPY', w3) > 0 & pos('\FI\', w5) > 0 then do

				/* found feature srvdiag */
				if pos('\SYSMGT\OS2\SYSTEM\TRACE\', w5) > 0 then do
					fibase.srvdiag.q = filespec('name', space(w4))
					if stream(fpdir'\'fibase.srvdiag.q, 'c', 'query exists') <> '' then do
						fibase.srvdiag.0 = fibase.srvdiag.0 + 1
						q = q + 1
					end
				end

				/* found feature ??? */

			end
			interpret l
		end
	end
	else do
		rc = lineout(log, 'Warning: Plug-in 'plugin' does not exist!')
		n.warnings = n.warnings + 1
		call report_status	
	end

return


/* place readme.1st on CD-ROM */
place_readme: procedure expose cddir ver

	rme  = cddir"\readme.1st"
	if stream(rme, 'c', 'query exists') = '' then do
		rc = lineout(rme, " ")
		rc = lineout(rme, "                             Important! Please read!")
		rc = lineout(rme, "             This OS/2 CD-ROM was updated with UpdateCD version "ver)
		rc = lineout(rme, "                            Use it at your own risk!")
		rc = lineout(rme, "                           For more information visit:")
		rc = lineout(rme, "                http://xenia.sote.hu/~kadzsol/rexx/sajat/updcd.htm")
		rc = lineout(rme, "                              "date() time())
		rc = lineout(rme)
	end

return

/* display status */
report_status: procedure expose n.

	say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
	say '1B'x || '[15;2HNumber of errors      : 'n.errors
	say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
	say '1B'x || '[19;2H'

return

/* update FI administration (*.ini files) */
update_FI_data: procedure expose fibase. n. log updated. location. cddir

	rcode = 0
	say '1B'x || '[7;26H'substr('Updating FI database...', 1, 50)
	rc = lineout(log, 'Info: Updating FI database...')
	say '1B'x || '[8;26H'substr('Searching...', 1, 50)
	say '1B'x || '[9;26H'substr('Searching...', 1, 50)
	say '1B'x || '[11;26HUpdate        '
	say '1B'x || '[12;26H0 '
	call report_status

	/* locate ini files */
	if (fibase.tcpip <> 1 & fibase.java <> 1) then do /* not TCP/IP or JAVA FI */
		ini_root = substr(fibase.1, 1, pos('\FI\', fibase.1)+2)
		'@echo 'location.fibase' > fibase.loc'
	end
	else if fibase.tcpip = 1 then do
		if stream(cddir'\cid\img\tcpapps\install.exe', 'c', 'query exists') = '' then ini_root = cddir'\CID\SERVER\TCPAPPS\INSTALL\TCPINST' 
		else ini_root = cddir'\CID\IMG\TCPAPPS\INSTALL\TCPINST'
	end
	else if fibase.java = 1 then do
		if stream(cddir'\CID\IMG\java\install.exe', 'c', 'query exists') = '' then ini_root = cddir'\CID\SERVER\JAVA\EN'
		else ini_root = cddir'\CID\IMG\JAVA\EN'
	end
	rc = SysFileTree(ini_root'\instdata.ini', ini_file., "FSO",,'**---') 

	/* unpack response files */
	if (fibase.tcpip <> 1 & fibase.java <> 1 & fibase.fax <> 1) then do
		call execute '@unpack 'location.fibase ini_root' /N:FIBASE.RSP'
		if fibase.wseb = 0 then call execute '@unpack 'location.fibase ini_root' /N:DKBASE.RSP' 	/* only for Warp 4 */
	end

	/* add response files to ini list */
	i = ini_file.0 + 1
	if (fibase.tcpip <> 1 & fibase.java <> 1 & fibase.fax <> 1) then
		ini_file.i = ini_root'\FIBASE.RSP'
	else if fibase.tcpip = 1 then do
		if stream(cddir'\cid\img\tcpapps\install.exe', 'c', 'query exists') = '' then ini_file.i = cddir'\CID\SERVER\TCPAPPS\INSTALL\tcpinst.rsp'
		else ini_file.i = cddir'\CID\IMG\TCPAPPS\INSTALL\tcpinst.rsp'
	end
	else if fibase.java = 1 then do
		if stream(cddir'\CID\IMG\java\install.exe', 'c', 'query exists') = '' then ini_file.i = cddir'\CID\SERVER\JAVA\EN\RSPJAVA.RSP'
		else ini_file.i = cddir'\CID\IMG\JAVA\EN\RSPJAVA.RSP'
	end
	if (fibase.wseb = 0 & fibase.tcpip <> 1 & fibase.java <> 1 & fibase.fax <> 1) then do /* only for Warp 4 */
		j = ini_file.0 + 2
		ini_file.j = ini_root'\DKBASE.RSP'
		ini_file.0 = ini_file.0 + 2
	end
	else if fibase.fax <> 1 then ini_file.0 = ini_file.0 + 1

	/* update ini files */
	do j = 1 to ini_file.0

		say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(ini_file.j), 1, 50))), 1, 50)
		say '1B'x || '[9;26H'substr('Searching...', 1, 50)
		call report_status

		/* read ini file */
		i=1
		do while lines(ini_file.j)
			l.i = linein(ini_file.j)
			i=i+1
		end
		l.0 = i - 1
		rc = lineout(ini_file.j)
		if rc <> 0 then rcode = rc

		/* update records */
		updated = 0
		do i = 1 to l.0

			parse value l.i with id '=' data
			if id = '		SourceFileName' then do
				do k = 1 to fibase.0
					sfile = translate(filespec('name', fibase.k))
					if translate(data) = sfile then do
						updated.k = 1 /* remember we did update the record of this file */
						say '1B'x || '[9;26H'substr(filespec("name", fibase.k), 1, 50)
						rc = lineout(log, 'Info: Updating FI record of 'fibase.k'.')
						do while id <> '		TargetPath'
							i = i + 1
							parse value l.i with id '=' data

							select
								when id = '		CreationDate' | id = '		LastAccessDate' | id = '		LastWriteDate' then do
									parse value stream(fibase.k, 'c', 'query datetime') with data1 '-' data2 '-' data3 .
									if data3 > 80 then data3 = data3 - 80 /* should work til 2080 */
									else data3 = data3 + 20
									l.i = id'='data1'-'data2'-'data3
								end
								when id = '		CreationTime'	| id = '		LastAccessTime' | id = '		LastWriteTime' then do
									parse value stream(fibase.k, 'c', 'query datetime') with . data
									l.i = id'='space(data)
								end
								otherwise 		nop;
							end /* select */

						end
						updated = 1
						leave k
					end
				end
			end

		end

		/* write new ini */
		if updated = 1 then do
			rc = lineout(ini_file.j, ,1)
			if rc <> 0 then rcode = rc

			do i = 1 to l.0
				rc = lineout(ini_file.j, l.i)
				if rc <> 0 then rcode = rc
			end
			rc = lineout(ini_file.j)
			if rc <> 0 then rcode = rc

		end

		/* report errors */
		if rcode <> 0 then do
			rc = lineout(log, 'Error: Update 'fibase.k' unsuccessful!')
			n.errors = n.errors + 1
			call report_status
		end

	end
	
	/* repack and remove OS/2 response files */
	if (fibase.tcpip <> 1 & fibase.java <> 1 & fibase.fax <> 1) then do
		'@pack2 \OS2\INSTALL\FIBASE.RSP 'location.fibase' /R >nul 2>>&1'
		call execute '@pack2 'ini_root'\FIBASE.RSP 'location.fibase' /H:\OS2\INSTALL\ /A'
		'@del 'ini_root'\FIBASE.RSP >nul 2>>&1'
		if fibase.wseb = 0 then do /* only Warp 4 */
			'@pack2 \OS2\INSTALL\DKBASE.RSP 'location.fibase' /R >nul 2>>&1'
			call execute '@pack2 'ini_root'\DKBASE.RSP 'location.fibase' /H:\OS2\INSTALL\ /A'
			'@del 'ini_root'\DKBASE.RSP >nul 2>>&1'
		end
	end

return 

/* postprocess FI database */
postprocess_fibase: PROCEDURE EXPOSE fibase. location. log fpdir n.

	/* locate ini files */
	ini_root  = substr(fibase.1, 1, pos('\FI\', fibase.1)+2)
	rc = SysFileTree(ini_root'\instdata.ini', ini_file., "FSO",,'**---') 

	/* unpack response files */
	call execute '@unpack 'location.fibase ini_root' /N:FIBASE.RSP'
	if fibase.wseb = 0 then call execute '@unpack 'location.fibase ini_root' /N:DKBASE.RSP'

	/* do update files */
	call add2fibase ini_root'\fibase.rsp' srvdiag
	if fibase.wseb = 0 then call add2fibase ini_root'\dkbase.rsp' srvdiag

	/* repack and remove response files */
	'@pack2 \OS2\INSTALL\FIBASE.RSP 'location.fibase' /R >nul 2>>&1'
	call execute '@pack2 'ini_root'\FIBASE.RSP 'location.fibase' /H:\OS2\INSTALL\ /A'
	'@del 'ini_root'\FIBASE.RSP >nul 2>>&1'
	if fibase.wseb = 0 then do
		'@pack2 \OS2\INSTALL\DKBASE.RSP 'location.fibase' /R >nul 2>>&1'
		call execute '@pack2 'ini_root'\DKBASE.RSP 'location.fibase' /H:\OS2\INSTALL\ /A'
		'@del 'ini_root'\DKBASE.RSP >nul 2>>&1'
	end

return


/* add file to FI database */
/* not yet finished */
add2fibase: procedure expose fibase. log fpdir n.

	parse upper arg ini feature
	found_feature = 0
	total_files = 0
	i = 1
	l.0 = 0

	select
		when feature = 'SRVDIAG' then do

			/* read original file in */
			do while lines(ini)
				l.i = linein(ini)
	
				/* total number of original files */
				if pos('	TotalFiles=', l.i) > 0 & total_files = 0 then do
					parse value l.i with '	TotalFiles=' total_files 
				end

				/* found our feature */
				if pos(feature'=(', l.i) > 0 then do
					found_feature = 1
				end
	
				/* start to add new records */
				if pos('	File=(', l.i) > 0 & found_feature = 1 then do	
	
					found_feature = 0	
	
					do j = 1 to fibase.srvdiag.0

						file = fibase.srvdiag.j
						ffile = fpdir'\'file
						rc = lineout(log, 'Info: Adding fixpak file 'file' to FI database.')
		
						i = i + 1; l.i = '		EAMediaIndex=0'
						i = i + 1; l.i = '		PartCount=1'
						s = stream(ffile, 'c', 'query size')
						i = i + 1; l.i = '		PartSize='s	
						i = i + 1; l.i = '		MediaIndex=1'
						i = i + 1; l.i = '		Source={SourceDrive}\{SourcePath}\OS2\SYSTEM\TRACE\'file
						i = i + 1; l.i = '		SourcePath={SourceDrive}\{SourcePath}\OS2\SYSTEM\TRACE'
						i = i + 1; l.i = '		SourceFileName='file
						i = i + 1; l.i = '		SourceChecksum=0'
						i = i + 1; l.i = '		SourceEASize=4'
						parse value stream(ffile, 'c', 'query datetime') with data1 '-' data2 '-' data3 .
						if data3 > 80 then data3 = data3 - 80 /* should work til 2080 */
						else data3 = data3 + 20
						i = i + 1; l.i = '		CreationDate='data1'-'data2'-'data3
						parse value stream(ffile, 'c', 'query datetime') with . data
						i = i + 1; l.i = '		CreationTime='space(data)
						i = i + 1; l.i = '		LastAccessDate='data1'-'data2'-'data3
						i = i + 1; l.i = '		LastAccessTime='space(data)
						i = i + 1; l.i = '		LastWriteDate='data1'-'data2'-'data3
						i = i + 1; l.i = '		LastWriteTime='space(data)
						i = i + 1; l.i = '		CBFile='s
						s1 = trunc(s/512); 
						s2 = s/512 - s1
						if s2 > 0 then s2 = 1 
						else s2 = 0	
						s = (s1 + s2) * 512
						i = i + 1; l.i = '		CBFileAlloc='s
						i = i + 1; l.i = '		AttrFile=32'
						i = i + 1; l.i = '		TargetPath={TargetDrive}\OS2\SYSTEM\TRACE'
						i = i + 1; l.i = '		TargetFileName='file
						i = i + 1; l.i = '		MediaPath={SysMgtMediaPath}\OS2\SYSTEM\TRACE'
						i = i + 1; l.i = '		MediaFileName='file
						i = i + 1; l.i = '		MediaNumber=0'
						i = i + 1; l.i = '		CompressionID=0'
						i = i + 1; l.i = '		Flags=1'
						i = i + 1; l.i = '		TargetAttrib=0'
						i = i + 1; l.i = '	)'
						i = i + 1; l.i = '	File=('
	
						if total_files <> 0 then total_files = total_files + 1

					end /* fibase */

				end /* found feature */
	
				l.0 = i
				i = i + 1	

			end /* do lines */

			/* write out new ini */		
			rc = lineout(ini)
			'@del 'ini
			do i = 1 to l.0
				if pos('	TotalFiles=', l.i) > 0 & total_files > 0 then do
					rc = lineout(ini, '	TotalFiles='total_files)
					total_files = 0
				end
				else do
					rc = lineout(ini, l.i)
				end
			end
			rc = lineout(ini)

		end /* when srvdiag */

		otherwise nop;

	end /* select */

return

/* add file to bundle */
add2bundle: procedure expose fpdir cddir log n. updated.
	parse arg sfile tfile path 
	sfile = space(sfile)
	tfile = space(tfile)
	path  = space(path)

	if stream(fpdir'\'sfile, 'c', 'query exists') <> '' then do
		'@pack2 'path'\'sfile cddir'\'tfile' /R >nul 2>>&1'
		call execute '@pack2 'fpdir'\'sfile cddir'\'tfile' /H:'path'\ /A'
	end
	else do /* log warning */
		rc = lineout(log, 'Warning: Fixpak file 'fpdir'\'sfile' does not exist!')
		n.warnings = n.warnings + 1
		call report_status
		return
	end

return

/* this function updates the syslevel of a product according to */
/* information in the fixpak file srv_prod.*                    */
update_syslevel_file: procedure expose st. slfh. sysfls. log 

		parse arg sysfile

		/* find out which product it is */
		rc = lineout(log, 'Info: Found possible syslevel file: 'sysfile)
		rc = ReadSysLevel(sysfile)
		if rc = 0 then do
			rcode = 2 /* target is not readable */
			return rcode
		end
		if rc = 2 then do
			rcode = 9 /* target is not a syslevel file */
			return rcode
		end
		level1 = substr(st.achCsdLevel, 1, 3)
		level2 = substr(st.achCsdLevel, 4)
		name = substr(st.achSysName, 1, 20)

		/* rc = lineout(log, level2 '*' name) */

		/* let's see if we have an update for this */
		fixlevel = ''
		/* rc = lineout(log, 's'sysfls.0) */
		do s = 1 to sysfls.0
			/* rc = lineout(log, 'n'sysfls.s.data) */
			p = pos(level2, sysfls.s.data, 1)
			/* rc = lineout(log, 'p'p) */
			do while p > 0
				sysfls.s.CsdLevel = substr(sysfls.s.data, p-11, 8) 	/* CSD level     */
			 	sysfls.s.CsdPrev  = substr(sysfls.s.data, p, 5)		/* product level */
				sysfls.s.SysName  = substr(sysfls.s.data, p+5, 20) /* first 20 c of product name */
				p = pos(level2, sysfls.s.data, p+16)

				/* rc = lineout(log, sysfls.s.SysName '***' sysfls.s.CsdPrev '*' sysfls.s.CsdLevel) */
				/* found a fix which matches our product */
				if name = sysfls.s.SysName & level2 = sysfls.s.CsdPrev then do
					fixlevel = substr(sysfls.s.CsdLevel, 4)
					p = 0
					s = sysfls.0
					/* rc = lineout(log, '**' fixlevel) */
				end
			end
		end

		/* update SysLevel file */
		if fixlevel <> '' then do
			rc = SysFileTree(sysfile, 'junk.', "F",,'**---')  
			if rc <> 0 then do
				rcode = 3 /* cannot remove RO attribute */
				return rcode
			end
			st.achCsdLevel = level1 || fixlevel
			rc = WriteSysLevel(sysfile)
			if rc = 0 then do
				rcode = 4 /* cannot write to target */
				return rcode
			end
		rc=lineout(log, 'Info: Updated syslevel file: 'sysfile)
		end

return 0

/* Read SysLevel file */
ReadSysLevel: procedure expose slfh. st. 
call Trace OFF
parse arg fs

   res = 0
   if stream(fs,"C","Query Exists") <> "" then do
      data = charin(fs,1,chars(fs))
			call stream fs,"C","Close"

      slfh.usSignature   = c2x(reverse(substr(data,1,2)))     /* special # for id of syslevel file */
      slfh.achSignature  = substr(data,3,8)                   /* string to id slf file, must be 'SYSLEVEL' */

			/* check if it is a real syslevel file */
			if slfh.achSignature <> 'SYSLEVEL' then return 2

      slfh.achJulian     = substr(data,11,5)                  /* date of version */
      slfh.usSlfVersion  = c2x(reverse(substr(data,16,2)))    /* version of syslevel file, must be 1 */
      slfh.ausReserved   = c2x(substr(data,18,16))            /* reserved */
      slfh.ulTableOffset = c2d(reverse(substr(data,34,4)))    /* offset of SYSTABLE */

      /* Calculate table start */
      tblst = slfh.ulTableOffset+1

      st.usSysId       = c2x(reverse(substr(data, tblst+0,2))) /* identifies system /subsytem */
      st.bSysEdition   = c2x(substr(data, tblst+2,1))          /* edition of system, eg SE=00, EE=01 */
      st.bSysVersion   = c2x(substr(data, tblst+3,1))          /* version, eg 1.00=10, 1.10=11 */
      st.bSysModify    = c2x(substr(data, tblst+4,1))          /* modify, eg 1.00=00, 1.01=01 */
      st.usSysDate     = c2x(reverse(substr(data, tblst+5,2))) /* date of system */
      st.achCsdLevel   = substr(data, tblst+7,8)               /* subsytem CSD level, eg, XR?0000_ */
      st.achCsdPrev    = substr(data, tblst+15,8)              /* as above, except for prev system */
      st.achSysName    = substr(data, tblst+23,80)             /* Title of system / subsytem (ASCIIZ) */
      st.achCompId     = substr(data, tblst+103,9)             /* component ID of subsytem */
      st.bRefreshLevel = c2x(substr(data, tblst+112,1))
      st.achType       = substr(data, tblst+113,9)             /* Null terminated type (8 chars +'\0') */
      st.usReserved    = substr(data, tblst+122,12)            /* reserved, must be 0 */
      res = 1
   end
return res

/* Write SysLevel file */
WriteSysLevel: procedure expose slfh. st. 
call Trace OFF
parse arg fs

   res = 0
   if stream(fs,"C","Query Exists") <> "" then do

      data = charin(fs,1,chars(fs))
			call stream fs,"C","Close"

      rc = overlay(reverse(x2c(slfh.usSignature)), data, 1)        /* special # for id of syslevel file */
      rc = overlay(slfh.achSignature, data, 3)                     /* string to id slf file, must be 'SYSLEVEL' */
      rc = overlay(slfh.achJulian, data, 11)                       /* date of version */
      rc = overlay(reverse(x2c(slfh.usSlfVersion)), data, 16)      /* version of syslevel file, must be 1 */
      rc = overlay(x2c(slfh.ausReserved), data, 18)                /* reserved */
      rc = overlay(reverse(d2c(slfh.ulTableOffset)), data, 34)     /* offset of SYSTABLE */

      /* Calculate table start */
      tblst = slfh.ulTableOffset+1

      data = overlay(reverse(x2c(st.usSysId)), data, tblst+0)         /* identifies system /subsytem */
      data = overlay(x2c(st.bSysEdition), data, tblst+2)              /* edition of system, eg SE=00, EE=01 */
      data = overlay(x2c(st.bSysVersion), data, tblst+3)              /* version, eg 1.00=10, 1.10=11 */
      data = overlay(x2c(st.bSysModify), data,  tblst+4)              /* modify, eg 1.00=00, 1.01=01 */
      data = overlay(reverse(x2c(st.usSysDate)), data, tblst+5)       /* date of system */
      data = overlay(st.achCsdLevel, data, tblst+7)                   /* subsytem CSD level, eg, XR?0000_ */
      data = overlay(st.achCsdPrev, data, tblst+15)                   /* as above, except for prev system */
      data = overlay(st.achSysName, data, tblst+23)                   /* Title of system / subsytem (ASCIIZ) */
      data = overlay(st.achCompId, data,  tblst+103)                  /* component ID of subsytem */
      data = overlay(x2c(st.bRefreshLevel), data, tblst+112)
      data = overlay(st.achType, data, tblst+113)                     /* Null terminated type (8 chars +'\0') */
      data = overlay(st.usReserved, data, tblst+122)                  /* reserved, must be 0 */

      rc = charout(fs,data,1)
			if rc = 0 then res = 1
			call stream fs,"C","Close"
   end
return res
