/* prepare (uncompresses) fixpak files for updcd.cmd              */
/* 05.13.2000: initial version (0.1)                              */
/* 06.04.2000: added postprocessing to fix rexx problem           */
/*             added logging (0.2)                                */
/* 06.11.2000: bug fixing, made language independent (0.3)	  		*/
/*             added support for MPTS fixpak                      */
/* 07.23.2000: added support for PEER and TCP/IP fixpaks (0.4)		*/
/* 08.11.2000: added support for Feature Installer (0.5)          */
/* 08.22.2000: improved interface                                 */
/* 09.13.2000: adapted to wseb fixpak                             */
/* 09.24.2000: bug fixing                                         */
/* 09.30.2000: small improvements                                 */
/* 10.07.2000: small bug fixes                                    */
/* 10.10.2000: added syslevel update                              */
/* 01.27.2001: minor change (smp\new_dirs.os2) for go4it2.cmd     */
/* 03.11.2001: added some code to handle warp 3 update            */
/* 03.17.2001: added some code to handle warp 3 fixpak            */
/* 05.04.2001: added code to support ip08063                      */

parse arg fpdir n.errors n.warnings n.elapsed ver log vers

/* check parameter */
if fpdir = '' then do
	say 'Prepare fixpak files.'
	say 'Usage: prpfp.cmd <fixpak directory>'
	exit 1
end

/* we need to know the absolute path */
cdir  = directory()
fpdir = directory(fpdir) 
cdir  = directory(cdir)

/* reset some paramaters */
if log = '' then log = 'prpfp.log'
if ver = '' then ver = '0.7'
if n.errors = '' then n.errors = 0
if n.warnings = '' then n.warnings = 0
if n.elapsed = '' then n.elapsed = 0

/* reset screen */
say '1B'x || '[36;44m'
say '1B'x || '[1m'
'@cls'
call rxfuncadd syscurstate, rexxutil, syscurstate
call syscurstate off
say '1B'x || '[2;2HUpdate OS/2 installation CD-ROM, version 'ver
say '1B'x || '[4;2HTarget directory      : 'fpdir
say '1B'x || '[5;2HSource directory      : 'fpdir
say '1B'x || '[7;2HCurrent activity      : 'substr('Thinking...', 1, 50)
say '1B'x || '[8;2HTarget object         : 'substr('Searching...', 1, 50)
say '1B'x || '[9;2HSource object         : 'substr('Searching...', 1, 50)
say '1B'x || '[11;2HUpdate action         : 'substr('Searching...', 1, 50)
say '1B'x || '[12;2HUpdate return code    : 0'
say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
say '1B'x || '[15;2HNumber of errors      : 'n.errors
say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
say '1B'x || '[17;2HUpdate log            : 'log
say '1B'x || '[19;2H'

/* logging some info */
rc = lineout(log, 'Info: Preprocessing fixpak files in directory 'fpdir'... ('date() time()', version: 'ver')')
say '1B'x || '[7;26HPreprocessing fixpak...'

/* OS/2 fixpak */
if stream(fpdir'\os2krnl.___', 'c', 'query exists') <> '' | stream(fpdir'\os2krnl.un_', 'c', 'query exists') <> '' then do
	say '1B'x || '[7;26HPreparing OS/2 fixpak...'
	rc = lineout(log, 'Info: Found OS/2 fixpak.')
	if stream(fpdir'\new_dirs.os2', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\new_dirs.os2'
	if stream(fpdir'\CSBKEOS2.EXE', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\CSBKEOS2.EXE'
	if stream(fpdir'\CSEXTOS2.DLL', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\CSEXTOS2.DLL'
	if stream(fpdir'\CSEXTOS2.EXE', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\CSEXTOS2.EXE'
	if stream(fpdir'\os2krnl.un_', 'c', 'query exists') <> '' then do
		/* call execute '@del 'fpdir'\smp\new_dirs.os2' */
	end

	/* DD fixpak */
	if stream(fpdir'\srv_prod.bdd', 'c', 'query exists') <> '' then do
		rc = lineout(log, 'Info: Found DD fixpak.')
		if stream(fpdir'\srv_prod.bdd', 'c', 'query exists') <> '' then	call execute '@del 'fpdir'\srv_prod.bdd'
		if stream(fpdir'\new_dirs.bdd', 'c', 'query exists') <> '' then	call execute '@del 'fpdir'\new_dirs.bdd'
	end

	/* FI Setup */
	if stream(fpdir'\fisetup.exe', 'c', 'query exists') <> '' then do
		rc = lineout(log, 'Info: Found Feature Installer.')
		if stream(fpdir'\checkasd.exe', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\checkasd.exe'
		if stream(fpdir'\checkasd.msg', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\checkasd.msg'
		if stream(fpdir'\fisetmri.dll', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\fisetmri.dll'
		if stream(fpdir'\fisetup.exe ', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\fisetup.exe '
		if stream(fpdir'\readme      ', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\readme      '
		if stream(fpdir'\rejoinea.exe', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\rejoinea.exe'
	end
end

/* MPTS fixpak */
else if stream(fpdir'\afinet.sy_', 'c', 'query exists') <> '' then do
	say '1B'x || '[7;26HPreparing MPTS fixpak...'
	rc = lineout(log, 'Info: Found MPTS fixpak.')
	if stream(fpdir'\csbketrp.exe', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\csbketrp.exe'
	if stream(fpdir'\csexttrp.exe', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\csexttrp.exe'
end

/* PEER/LS fixpak */
else if stream(fpdir'\net.ex_', 'c', 'query exists') <> '' then do
	say '1B'x || '[7;26HPreparing PEER/LS fixpak...'
	rc = lineout(log, 'Info: Found PEER/LS fixpak.')

	/* peer cannot be installed with these new files */
	if stream(fpdir'\peer.ex_', 'c', 'query exists') <> '' then do
		if stream(fpdir'\peerrmt.ex_',  'c', 'query exists') <> '' then	call execute '@del 'fpdir'\PEERRMT.EX_' 
		if stream(fpdir'\lsiwdesk.ex_', 'c', 'query exists') <> '' then	call execute '@del 'fpdir'\LSIWDESK.EX_' 
	end

	/* these files are not needed */
	if stream(fpdir'\csexthfs.exe', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\csexthfs.exe'
	if stream(fpdir'\new_dirs.srv', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\new_dirs.srv'
end

/* TCP/IP fixpak */
else if stream(fpdir'\ppp.ex_', 'c', 'query exists') <> '' then do
	say '1B'x || '[7;26HPreparing TCP/IP fixpak...'
	rc = lineout(log, 'Info: Found TCP/IP fixpak.')
	if stream(fpdir'\CSINITCP.EXE', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\CSINITCP.EXE'
	if stream(fpdir'\CSBKETCP.EXE', 'c', 'query exists') <> '' then call execute '@del 'fpdir'\CSBKETCP.EXE'
end

/* scanning fixpak directory */
rc = RxFuncAdd('SysFileTree', 'RexxUtil', 'SysFileTree')
rc = SysFileTree(fpdir || '\*.??_', ffp.full., "FSO",,'**---') 
if rc <> 0 then do
		rc=lineout(log, 'Error: 'fpdir' seems not to be a fixpack directory!')
		exit 1
end 
/* unpack files */
do i=1 to ffp.full.0
	call execute '@unpack 'ffp.full.i filespec('drive', ffp.full.i)||filespec('path', ffp.full.i)||'. '
	if result = 0 then call execute '@del 'ffp.full.i
end

say '1B'x || '[7;26HPostprocessing files...'
rc = lineout(log, 'Info: Postprocessing files...')
if stream(fpdir'\os2krnl', 'c', 'query exists') <> '' & datatype(vers) <> 'NUM' then do
	call execute '@copy 'fpdir'\crexx.dll    'fpdir'\rexx.dll'
	call execute '@copy 'fpdir'\crexutil.dll 'fpdir'\rexxutil.dll'
	call execute '@copy 'fpdir'\crex.msg     'fpdir'\rex.msg'
	call execute '@del  'fpdir'\crexx.dll'
	call execute '@del  'fpdir'\crexutil.dll'
	call execute '@del  'fpdir'\crex.msg'
	if stream(fpdir'\vdma.sys', 'c', 'query exists') <> '' then do
		call execute '@copy 'fpdir'\vdma.sys     'fpdir'\vdmaat.sys'
		call execute '@del  'fpdir'\vdma.sys'
	end
end

if n.elapsed > 0 then rc = lineout('result.out', n.errors||' '||n.warnings, 1)
else rc = lineout(log, 'Detected 'n.errors' error(s) and 'n.warnings' warning(s) during processing.')

exit 

/* executes and reports commands */
execute: procedure expose log n.

	parse arg comm
	rcode = 0
	parse upper var comm comm1 comm2 comm3 comm4 rest
	/* do not copy or pack if file does not exist */
	if (comm1 <> '@COPY' & comm1 <> '@PACK2' & comm1 <> '@DEL') | (stream(comm2, 'c', 'query exists') <> '') then do
		comm' >nul 2>>&1'
		if rc <> 0 then rcode = rc
	end
	else do /* log warning */
		rc = lineout(log, 'Warning: Fixpak file 'comm2' does not exist!')
		n.warnings = n.warnings + 1
		call report_status
		return
	end

	if comm1 = '@DEL' then do	
		say '1B'x || '[9;26H'substr(comm2, 1, 50)
		say '1B'x || '[11;26H'substr(comm1, 2, 6)'         '
		say '1B'x || '[12;26H'rcode' '
	end
	else do
		say '1B'x || '[8;26H'substr(comm3, 1, 50)
		say '1B'x || '[9;26H'substr(comm2, 1, 50)
		say '1B'x || '[11;26H'substr(comm1, 2, 6)'         '
		say '1B'x || '[12;26H'rcode' '
	end

	if rcode <> 0 then do
		if rcode = 4 then do
			rc = lineout(log, 'Warning: 'comm' (rc='rcode')')
			n.warnings = n.warnings + 1
		end
		else do
			rc = lineout(log, 'Error: 'comm' (rc='rcode')')
			n.errors = n.errors + 1
		end
	end
	else do
			rc = lineout(log, 'Info: 'comm' (rc='rcode')')
	end

	call report_status

return rcode

/* display status */
report_status: procedure expose n.

	say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
	say '1B'x || '[15;2HNumber of errors      : 'n.errors
	say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
	say '1B'x || '[19;2H'

return