/* Create updcd folder and other objects */
/* Create updcd.cfg configuration file   */
/* Last modified on 05.09.2001           */

/* get arguments */
parse arg key

/* are you sure? */
say 'This program will create the UpdCD objects on your Desktop.'
say 'Press ENTER to continue or CTRL-C to exit.'
if key <> 'QUIET' then '@pause >nul'

/* load rexx functions */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/* updcd version */
version = 1.6

/* create objects */
path = directory()
rc1 = SysCreateObject("WPFolder", "UpdCD "version, "<WP_DESKTOP>", "OBJECTID=<UpdCD_Folder>", "R")  
rc2 = SysCreateObject("WPProgram", "Graphical Interface", "<UpdCD_Folder>", "EXENAME="path"\pmupdcd.exe;", "R")  
rc3 = SysCreateObject("WPProgram", "Readme", "<UpdCD_Folder>", "EXENAME=e.exe;PARAMETERS="path"\readme.eng;", "R")  
rc4 = SysCreateObject("WPProgram", "Default Configuration", "<UpdCD_Folder>", "EXENAME=e.exe;PARAMETERS="path"\updcd.cfg;", "R")  
rc5 = SysCreateObject("WPProgram", "LxLite Configuration", "<UpdCD_Folder>", "EXENAME=e.exe;PARAMETERS="path"\lxlite.cfg;", "R")  
rc6 = SysCreateObject("WPProgram", "Log", "<UpdCD_Folder>", "EXENAME=e.exe;PARAMETERS="path"\updcd.log;", "R")  
rc7 = SysCreateObject("WPUrl", "UpdCD HomePage", "<UpdCD_Folder>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://xenia.sote.hu/~kadzsol/rexx/sajat/updcd.htm;", "R")
rc8 = SysCreateObject("WPUrl", "UpdCD HomePage Mirror", "<UpdCD_Folder>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://www.quasarbbs.net/updcd/;", "R")
rc9 = SysCreateObject("WPUrl", "UpdCD Discussion Group", "<UpdCD_Folder>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=http://groups.yahoo.com/group/updcd/messages;", "R")
rc10 = SysCreateObject("WPUrl", "UpdCD FAQ", "<UpdCD_Folder>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=file:///"translate(translate(path,"|",":"), "/", "\")"/updcdfaq.htm;", "R")
rc11 = SysCreateObject("WPUrl", "Order Warp Update Kit", "<UpdCD_Folder>","NOTDEFAULTICON=YES;DEFAULTVIEW=CONTENTS;URL=file:///"translate(translate(path,"|",":"), "/", "\")"/wupdkit.htm;", "R")

if rc1 <> 1 | rc2 <> 1 | rc3 <> 1 | rc4 <> 1 | rc5 <> 1 | rc6 <> 1 | rc7 <> 1 | rc8 <> 1 | rc9 <> 1 | rc10 <> 1 | rc11 <> 1 then do
	say 'Error: some objects were not created.'
	say 'RC = 'rc1 rc2 rc3 rc4 rc5 rc6 rc7 rc8 rc9 rc10 rc11
	exit 9
end
else 
	say 'The required objects were created succesfully!'

/* create cfg file */
cfgfile = path'\updcd.cfg'
if stream(cfgfile, 'c', 'query exists') <> '' then do
	/* read old configuration */
	call Read_Config_File cfgfile
	/* make backup */
	bakfile = path'\updcd.bak'
	'@copy 'cfgfile' 'bakfile' >nul 2>>&1'
	/* delete old config */
	'@del 'cfgfile' >nul 2>>&1'
end
else do
	/* generate some defaults */
	burn 			= path"\burn"
	rc 				= sysdrivemap('C:', 'LOCAL')
	w4cd 			= substr(rc, lastpos(':', rc)-1)
	fixes 		= path"\fixes"
	updates 	= path"\updates"
	expert  	= 1
	log 			= path"\updcd.log"
	cdrprg  	= "record.cmd"
	flpdrv  	= translate("Y:")
	compress 	= 1 
	add_dani 	= 0 
	add_dummy = 1
	rootdir 	= directory()
	id.1  		= 0
	id.2  		= 1
	id.3  		= 0
	speed   	= 2
	tempdir 	= path
	tempraw 	= path"\temp.raw"
	source  	= rootdir"\burn"
	cdrdir  	= "c:\apps\cdrecord"
	svdc_drive = flpdrv
	burnlog 	= path"\burn.log"
	viewer  	= "more <"
	extrap  	= '' 
end

/* write config */
call Save_Config_File cfgfile

exit

/* read updcd.cfg */
Read_Config_File: 

    parse arg cfgfile

   do while lines(cfgfile)
        l=linein(cfgfile)
        interpret l
    end
    call lineout cfgfile 

    /* need to know full path */
    curdir = strip(directory(), , '\')
    if pos(':', fixes) = 0 then
        if substr(fixes, 1, 1) = '\' then fixes = translate(substr(curdir, 1, 2)||fixes)
        else fixes = translate(curdir'\'fixes)
    else fixes = translate(fixes)
    if pos(':', updates) = 0 then
        if substr(updates, 1, 1) = '\' then updates = translate(substr(curdir, 1, 2)||updates)
        else updates = translate(curdir'\'updates)
    else updates = translate(updates)
    if pos(':', w4cd) = 0 then
        if substr(w4cd, 1, 1) = '\' then w4cd = translate(substr(curdir, 1, 2)||w4cd)
        else w4cd = translate(curdir'\'w4cd)
    else w4cd = translate(w4cd)
    if pos(':', burn) = 0 then
        if substr(burn, 1, 1) = '\' then burn = translate(substr(curdir, 1, 2)||burn)
        else burn = translate(curdir'\'burn)
    else burn = translate(burn)

    if substr(flpdrv, 2, 1) <> ':' | length(flpdrv) <> 2 then 
        flpdrv = 'A:' 
    else
        flpdrv = translate(flpdrv)
    log = translate(log)

    id.1 = substr(device, 1, 1)
    id.2 = substr(device, 3, 1)
    id.3 = substr(device, 5, 1)
    if datatype(id.1) <> 'NUM' then id.1 = 0
    if datatype(id.2) <> 'NUM' then id.2 = 0
    if datatype(id.3) <> 'NUM' then id.3 = 0

    if Symbol('extrap') <> 'VAR' then extrap=""

    if pos(':', log) = 0 then
        if substr(log, 1, 1) = '\' then log = translate(substr(curdir, 1, 2)||log)
        else log = translate(curdir'\'log)
    else log = translate(log)

    if pos(':', burnlog) = 0 then
        if substr(burnlog, 1, 1) = '\' then burnlog = translate(substr(curdir, 1, 2)||burnlog)
        else burnlog = translate(curdir'\'burnlog)
    else burnlog = translate(burnlog)  

    if pos(':', tempraw) = 0 then
        if substr(tempraw, 1, 1) = '\' then tempraw = translate(substr(curdir, 1, 2)||tempraw)
        else tempraw = translate(curdir'\'tempraw)
    else tempraw = translate(tempraw)

    if pos(':', cdrdir) = 0 then
        if substr(cdrdir, 1, 1) = '\' then cdrdir = translate(substr(curdir, 1, 2)||cdrdir)
        else cdrdir = translate(curdir'\'cdrdir)
    else cdrdir = translate(cdrdir)

return

/* save updcd.cfg */
Save_Config_File: 

    parse arg cfgfile

    rc = SysFileDelete(cfgfile)
    rc = lineout(cfgfile, "/* UpdCD configuration file, edit with care! */")
    rc = lineout(cfgfile, " ")
    rc = lineout(cfgfile, "/* Go4It parameters */")
    rc = lineout(cfgfile, "burn    = '"burn"' /* location updated CD-ROM */")
    rc = lineout(cfgfile, "w4cd    = '"w4cd"' /* location original CD-ROM */")
    rc = lineout(cfgfile, "fixes   = '"fixes"' /* fixes directory */")
    rc = lineout(cfgfile, "updates = '"updates"' /* updates directory */")
    rc = lineout(cfgfile, "expert  = "expert" /* 0 = stop between steps */")
    rc = lineout(cfgfile, "log     = '"log"'  /* log file */")
    rc = lineout(cfgfile, "cdrprg  = 'record.cmd' /* cdrecord script */")
    rc = lineout(cfgfile, " ")
    rc = lineout(cfgfile, "/* updif parameters */")
    rc = lineout(cfgfile, "flpdrv  = translate('"flpdrv"') /* <----- change it match your virtual floppy */")
    rc = lineout(cfgfile, "compress = "compress" /* 0 = do not compress files on boot diskette */")
    rc = lineout(cfgfile, "add_dani = "add_dani" /* 0 = do not add DANI IDE if it is available as an addon */")
    rc = lineout(cfgfile, "add_dummy = "add_dummy" /* 0 = do not add new ADD's and do not replace SCSI drivers with dummy driver to save space */")

    rc = lineout(cfgfile, " ")
    rc = lineout(cfgfile, "/* record.cmd parameters */")
    rc = lineout(cfgfile, "rootdir = directory()")
    rc = lineout(cfgfile, "device  = '"id.1","id.2","id.3"' /* SCSI device ID */")
    rc = lineout(cfgfile, "speed   = "speed" /* burning speed  */")
    rc = lineout(cfgfile, "tempdir = '"strip(filespec('drive', tempraw)||filespec('path', tempraw), 'T', '\')"' /* imagefile dir  */")
    rc = lineout(cfgfile, "tempraw = '"tempraw"' /* ISO image file */")
    rc = lineout(cfgfile, "source  = rootdir'\burn' /* burn directory */")
    rc = lineout(cfgfile, "cdrdir  = '"cdrdir"' /* cdrecord dir   */")
    rc = lineout(cfgfile, "svdc_drive = flpdrv /* virtual flop   */")
    rc = lineout(cfgfile, "burnlog = '"burnlog"' /* burn log file  */")
    rc = lineout(cfgfile, "viewer  = 'more <'")
    rc = lineout(cfgfile, "extrap  = '"extrap"' /* Extra parameters for cdrecord/2 */")
    rc = lineout(cfgfile)

return