/* 05.08.2001: automatic MCP1 update procedure with support for the        */
/*             following components: Warp 4 FI products, 3rd party add-ons */

/* read command line parameters */
parse arg cddrive

/* load configuration file */
cfgfile = 'updcd.cfg'
do while lines(cfgfile)
	l = linein(cfgfile)
	interpret l
end
rc = lineout(cfgfile)

/* check cddrive value */
if substr(cddrive, 2) = ':' then w4cd = translate(cddrive)

/* make sure they exist */
'@mkdir 'burn' >nul 2>>&1'
'@mkdir 'fixes' >nul 2>>&1'
'@mkdir 'updates' >nul 2>>&1'

/* need to know absolute path */
cdir  	= directory()
burn 		= directory(burn)
cdir  	= directory(cdir)
fixes 	= directory(fixes)
cdir  	= directory(cdir)
updates = directory(updates)
cdir  	= directory(cdir)

/* log file */
if filespec('drive', log) = '' then log	= strip(cdir, 'T', '\')||'\'||log

/* updcd version */
ver = 1.6
n.errors = 0
n.warnings = 0
n.elapsed = time('E')

/* load rexxutil functions we need */
call rxfuncadd sysfiletree, rexxutil, sysfiletree
call rxfuncadd syscurstate, rexxutil, syscurstate

/* remember we were started */
'@echo go4it busy > go4it.bsy'

/* clean up things */
'@mode 80,25 >nul'
'@ansi on >NUL'
say '1B'x || '[36;44m'
say '1B'x || '[1m'
'@cls'
say
say ' Searching for components which can be integrated. Please wait!'
call syscurstate off

/* find fixpaks located in the subdirectory fixes */
say
startdir = fixes
fpk. = ''
rc = lineout(, " Fixpak:    Type:     Directory:")
rc = lineout(, " -------------------------------")
rc = SysFileTree(startdir'\srv_prod.*', ini., "FSO") 
do i = 1 to ini.0
	/* say ini.i */
	do while lines(ini.i)
		l=linein(ini.i)

		if pos('IBM OS/2 Base Device Drivers', l) > 0 & fpk.dd.fnd <> 1 then do
			fpk.dd.fnd = 1
			fpk.dd.typ = substr(l, pos('XR', l), 7)
			fpk.dd.num = substr(fpk.dd.typ, 5)
			fpk.dd.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.dd.dir = substr(fpk.dd.dir, 1, lastpos('\FIX\', fpk.dd.dir)-1)
			rc = lineout(, " "fpk.dd.typ  "   Driver    "fpk.dd.dir)
			fpk.dd.typ = 'XR'substr(fpk.dd.typ, 4)
			leave
		end

	end
	rc = lineout(ini.i)
end
if ini.0 = 0 then call lineout "", " Found nothing..."

/* find updated products located in the subdirectory updates */
say
startdir = updates
upd. = ''
rc = lineout(, " Update:    Type:     Directory:")
rc = lineout(, " -------------------------------")
rc = SysFileTree(startdir'\syslevel.*', ini., "FSO") 

do i = 1 to ini.0
	/* say ini.i */
	do while lines(ini.i)
		l=linein(ini.i)
	end
	rc = lineout(ini.i)
end
if ini.0 = 0 then call lineout "", " Found nothing..."

/* find addons and Warp 4 FI products */
say
if stream('addons\read.me', 'c', 'query exists') <> '' then do
			call sysfiletree 'addons\*', 'ini.', 'DO'
			rc = lineout(, ' Found 'ini.0-2' add-on products in 'directory()||'\ADDONS')
end
if stream('fi\fibase.rsp', 'c', 'query exists') <> '' then do
			call sysfiletree 'fi\*', 'ini.', 'DO'
			rc = lineout(, ' Found 'ini.0-1' Warp 4 Feature Installer products in 'directory()||'\FI')
end

/* determining language to use */
ini = w4cd'\os2image\disk_2\syslevel.os2'
if stream(ini, 'c', 'query exists') <> '' then do
	do while lines(ini)
			l=linein(ini)
			if pos('Convenience Package', l) > 0 then do
				lang = substr(l, pos('XR', l), 3)
				/* say lang */
			end
	end
	rc = lineout(ini)
end
else do
	Say
	Say ' No CD-ROM found! Exiting...'
	rc = lineout(log, 'Error: No CD-ROM found! Exiting...')
	'@del go4it.bsy >nul 2>>&1'
	exit 9
end

select
	when lang = 'XR0' then lang = 'EN (English)'
	when lang = 'XRG' then lang = 'DE (German)'
	when lang = 'XRN' then lang = 'NO (Norwegian)'
	when lang = 'XRV' then lang = 'TW (Thai)'
	when lang = 'XRF' then lang = 'FR (French)'
	when lang = 'XRI' then lang = 'IT (Italian)'
	when lang = 'XRJ' then lang = 'JP (Japanese)'
	when lang = 'XRK' then lang = 'KO (Korean)'
	when lang = 'XRB' then lang = 'BR (Brazilian)'
	when lang = 'XRC' then lang = 'CN (Chinese)'
	when lang = 'XRS' then lang = 'ES (Spanish)'
	when lang = 'XRD' then lang = 'DK (Danish)'
	when lang = 'XRL' then lang = 'FI (Finnish)'
	when lang = 'XRH' then lang = 'NL (Dutch)'
	when lang = 'XRY' then lang = 'HU (Hungarian)'
	when lang = 'XRR' then lang = 'RU (Russian)'
  when lang = 'XRA' then lang = 'AR (Arabic)'
	otherwise lang = 'Unknown (assuming English for universal products)'
end
rc = lineout(, " Detected language: "lang)

say
say ' Press any key to start the build process or CTRL-C to abort'
'@pause >nul'

/* switch off deldir if set */
ddir = value("DELDIR", , "OS2ENVIRONMENT")
if length(ddir) > 0 then do
	rc = lineout(log, 'Info: Switching off deldir...')
	ddir = value("DELDIR", "", "OS2ENVIRONMENT")
end

'@del 'log' >nul 2>>&1'
rc = lineout(log, 'Info: Searching for fixes and updates...')
rc = lineout(log, 'Info: Found fix 'fpk.dd.typ' Driver 'fpk.dd.dir)
rc = lineout(log, 'Info: Detected language: 'lang)
rc = lineout(log)
parse var lang w1 w2
lang = space(w1)
if lang = 'HU' | lang = 'RU' | lang = 'AR' | lang = 'Unknown' then lang = 'EN'

/**********************/
/* Clean up old image */
/**********************/

'@cls'
say '1B'x || '[2;2HUpdate OS/2 installation CD-ROM, version 'ver
say '1B'x || '[4;2HTarget directory      : 'burn
say '1B'x || '[5;2HSource directory      : 'burn
say '1B'x || '[7;2HCurrent activity      : 'substr('Cleaning up directory: 'burn, 1, 50)
say '1B'x || '[8;2HTarget object         : 'substr('Searching...', 1, 50)
say '1B'x || '[9;2HSource object         : 'substr('Searching...', 1, 50)
say '1B'x || '[11;2HUpdate action         : 'substr('Searching...', 1, 50)
say '1B'x || '[12;2HUpdate return code    : 0'
say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
say '1B'x || '[15;2HNumber of errors      : 'n.errors
say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
say '1B'x || '[17;2HUpdate log            : 'log
say '1B'x || '[19;2H'

/* clean directories */
call execute '@attrib -r -s -h -a * /s'

/* del eadata */
'@del "'burn'\os2image\disk_0\ea data. sf" >nul 2>>&1'
'@del "'burn'\os2image\disk_1\ea data. sf" >nul 2>>&1'
'@del "'burn'\os2image\disk_2\ea data. sf" >nul 2>>&1'

/* del other dirs */
call deldir burn'\fi' 
call deldir burn'\ecs' 
call deldir burn'\bootimgs' 
call deldir burn'\report' 
call deldir burn'\options' 
call deldir burn'\images' 
call deldir burn'\info'
call deldir burn'\books'
call deldir burn'\os2image'
call deldir burn'\ibminst'
call deldir burn'\cid'
call deldir burn'\diskimgs'
call deldir burn'\updcd'
call deldir burn'\warpsrv'
call deldir burn'\GRPWARE'
call deldir burn'\os2'
call deldir burn'\dos'
call deldir burn'\mmpm2'

/* clean our files in root */
rc = SysFileTree(burn'\*', ini., "FSO",,'**---')  
if stream(burn'\readme.1st',  'c', 'query exists') <> '' then call execute '@del 'burn'\readme.1st'
if stream(burn'\OS2SE20.SRC', 'c', 'query exists') <> '' then call execute '@del 'burn'\OS2SE20.SRC'
if stream(burn'\README.TXT',  'c', 'query exists') <> '' then call execute '@del 'burn'\README.TXT'
if stream(burn'\RSPINST.EXE', 'c', 'query exists') <> '' then call execute '@del 'burn'\RSPINST.EXE'
if stream(burn'\INSTALL.CMD', 'c', 'query exists') <> '' then call execute '@del 'burn'\INSTALL.CMD'
if stream(burn'\CDINST.CMD',  'c', 'query exists') <> '' then call execute '@del 'burn'\CDINST.CMD'
if stream(burn'\CDINST.BAT',  'c', 'query exists') <> '' then call execute '@del 'burn'\CDINST.BAT'
if stream(burn'\DMF_PS2.CMD', 'c', 'query exists') <> '' then call execute '@del 'burn'\DMF_PS2.CMD'
if stream(burn'\chkinst.exe', 'c', 'query exists') <> '' then call execute '@del 'burn'\chkinst.exe'
if stream(burn'\runtime.exe', 'c', 'query exists') <> '' then call execute '@del 'burn'\runtime.exe'
if stream(burn'\vcu.exe',     'c', 'query exists') <> '' then call execute '@del 'burn'\vcu.exe'
if stream(burn'\vcu.msg',     'c', 'query exists') <> '' then call execute '@del 'burn'\vcu.msg'
if stream(burn'\makedsks.cmd','c', 'query exists') <> '' then call execute '@del 'burn'\makedsks.CMD'
if stream(burn'\README',      'c', 'query exists') <> '' then call execute '@del 'burn'\README'
if stream(burn'\README.INS',  'c', 'query exists') <> '' then call execute '@del 'burn'\README.INS'
if stream(burn'\PRODDSKS.CMD','c', 'query exists') <> '' then call execute '@del 'burn'\PRODDSKS.CMD'
if stream(burn'\SAMPLE.RSP',  'c', 'query exists') <> '' then call execute '@del 'burn'\SAMPLE.RSP'

/* create some directories */
'@mkdir 'burn '>nul 2>&1'
call execute '@mkdir 'burn'\updcd'
call execute '@mkdir 'burn'\updcd\bootimg'
call execute '@mkdir 'burn'\updcd\bootimg\DISK_0_1.IMG'
call execute '@mkdir 'burn'\updcd\bootimg\DISK_2.IMG'

/*************************************/
/* Update installation floppy images */
/*************************************/
say '1B'x || '[4;26H'substr(burn, 1, 50)
say '1B'x || '[5;26H'substr(w4cd, 1, 50)
say '1B'x || '[7;26H'substr('Copying CD-ROM files', 1, 50)
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
call execute '@mkdir 'burn'\diskimgs'
call execute '@xcopy 'w4cd'\diskimgs\* 'burn'\diskimgs\. /H/O/T/R/V'
call execute '@mkdir 'burn'\diskimgs\os2'
call execute '@mkdir 'burn'\diskimgs\os2\35'
call execute '@copy 'w4cd'\diskimgs\os2\35\disk0.dsk 'burn'\diskimgs\os2\35\.'
call execute '@copy 'w4cd'\diskimgs\os2\35\disk1_cd.dsk 'burn'\diskimgs\os2\35\.'
call execute '@copy 'w4cd'\diskimgs\os2\35\disk2.dsk 'burn'\diskimgs\os2\35\.'

/* delete temp stuff from fix */
rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
do i = 1 to ini.0
	call execute '@del 'ini.i
end

/* copy boot disk files */
call execute '@'w4cd'\diskimgs\loaddskf 'w4cd'\diskimgs\os2\35\disk0.dsk 'flpdrv' /Y /Q /S /F '
call copydir flpdrv burn'\updcd\bootimg\DISK_0_1.IMG'
call execute '@'w4cd'\diskimgs\loaddskf 'w4cd'\diskimgs\os2\35\disk1_cd.dsk 'flpdrv' /Y /Q /S /F '
call copydir flpdrv burn'\updcd\bootimg\DISK_0_1.IMG'
call execute '@'w4cd'\diskimgs\loaddskf 'w4cd'\diskimgs\os2\35\disk2.dsk 'flpdrv' /Y /Q /S /F '
call copydir flpdrv burn'\updcd\bootimg\DISK_2.IMG'
call execute '@copy 'w4cd'\bootimgs\config.sys 'burn'\updcd\bootimg\.'

/* process the files */
call execute '@copy 'burn'\updcd\bootimg\DISK_0_1.IMG\os2krnli 'burn'\updcd\bootimg\DISK_0_1.IMG\os2krnl'
call execute '@del 'burn'\updcd\bootimg\DISK_0_1.IMG\os2krnli'

/* change config.sys */
config_file = burn'\updcd\bootimg\DISK_0_1.IMG\CONFIG.SYS'
i = 1
do while lines(config_file)
	l.i = linein(config_file)
	i = i+1
end
rc = lineout(config_file)
l.0 = i - 1
call execute '@del 'config_file
do i = 1 to l.0
	select 
					when pos('XDFLOPPY',   translate(l.i)) > 0 then nop; /* remove XDF driver   */
					when pos('COPYFROMFLOPPY', translate(l.i)) > 0 then nop; /* remove copyfromfloppy */
					when pos('IBM1FLPY.ADD', translate(l.i)) > 0 & datatype(vers) <> 'NUM' then do
						rc = lineout(config_file, 'basedev=IBM1FLPY.ADD /A:0 /FORCE:1 /U:0 /F:2.88MB')
					end
					when pos('IBMIDECD.FLT', translate(l.i)) > 0 then do
						rc = lineout(config_file, l.i)
						rc = lineout(config_file, 'BASEDEV=CD_BOOT.FLT /D:3')
					end
					when pos('LIBPATH=', translate(l.i)) > 0 then do
						rc = lineout(config_file, l.i||'y:\os2image\disk_0;y:\os2image\disk_2;y:\os2image\disk_3;')
					end
					when pos('SET PATH=', translate(l.i)) > 0 then do
						rc = lineout(config_file, l.i||';y:\os2image\disk_0;y:\os2image\disk_2;y:\os2image\disk_3;')
					end
					when pos('SET DPATH=', translate(l.i)) > 0 then do
						rc = lineout(config_file, l.i||';y:\os2image\disk_0;y:\os2image\disk_2;y:\os2image\disk_3;')
					end
					otherwise
						rc = lineout(config_file, l.i)
	end
end
rc = lineout(config_file, 'SET BOOTEDFROMCD=YES')
rc = lineout(config_file, 'RESERVEDRIVELETTER=X')
rc = lineout(config_file)
'@echo RESERVEDRIVELETTER=X >> 'burn'\updcd\bootimg\config.sys'

/* do the rest */
say '1B'x || '[4;26H'substr(burn, 1, 50)
say '1B'x || '[5;26H'substr(w4cd, 1, 50)
say '1B'x || '[7;26H'substr('Copying CD-ROM files', 1, 50)
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)

call execute '@xcopy 'w4cd'\* 'burn'\. /H/O/T/R/V'

call execute '@mkdir 'burn'\cid'
call execute '@xcopy 'w4cd'\cid\* 'burn'\cid\. /H/O/T/S/R/V/E'

call execute '@mkdir 'burn'\ibminst'
call execute '@xcopy 'w4cd'\ibminst\* 'burn'\ibminst\. /H/O/T/S/E/R/V'

call execute '@mkdir 'burn'\info'
call execute '@xcopy 'w4cd'\info\* 'burn'\info\. /H/O/T/S/E/R/V'

call execute '@mkdir 'burn'\options'
call execute '@xcopy 'w4cd'\options\* 'burn'\options\. /H/O/T/S/E/R/V'

call execute '@mkdir 'burn'\report'
call execute '@xcopy 'w4cd'\report\* 'burn'\report\. /H/O/T/S/E/R/V'

call execute '@mkdir 'burn'\books'
call execute '@xcopy 'w4cd'\books\* 'burn'\books\. /H/O/T/S/E/R/V'

call execute '@mkdir 'burn'\os2image'
call execute '@xcopy 'w4cd'\os2image\* 'burn'\os2image\. /H/O/T/S/R/V/E'

/* remove RO attribute */
rc = SysFileTree(burn'\*', ini., "FSO",,'**---')  
call execute '@attrib -r -s -h -a 'burn'\* /s'

/************************/
/* change CID procedure */
/************************/
rc = SysFileTree(burn'\ibminst\*', ini., "FSO",,'**---')  
call execute '@copy newinst\addons.cfg   'burn'\ibminst\tables'
call execute '@copy newinst\addon.fil    'burn'\ibminst\tables'
call execute '@copy newinst\StTimeV.Cmd  'burn'\ibminst'
call execute '@copy unzip.exe            'burn'\ibminst'
call execute '@copy 'burn'\ibminst\npconfig.exe 'burn'\ibminst\npcfg2.exe'
call execute '@copy newinst\npconfig.exe 'burn'\ibminst'
call execute '@copy vrobj.dll            'burn'\ibminst'
call execute '@copy newinst\tunecfg.cmd  'burn'\ibminst'
call execute '@copy newinst\tunecfg.cfg  'burn'\ibminst'
'@echo do not remove this file > 'burn'\ibminst\npconfig.mcp'

/* change mkrsp.cmd */
out = 'temp.out'
'@del 'out' >nul 2>>&1'
in = burn'\ibminst\mkrsp.cmd'
do while lines(in)
	l=linein(in)
	if pos('/* We completed successfully */', l) > 0 then do
		call lineout out, "/* zsolt begin */"
		call lineout out, "/* copy scripts for installing add-ons */"
		call lineout out, "'@copy 'tabledir'\ADDON.FIL 'cltdir'\ADDON.CMD'"
		call lineout out, "'@copy 'ibminstdir'\StTimeV.Cmd 'OS2_Drive'\OS2\.'"
		call lineout out, "/* zsolt end */"
		call lineout out, " "
	end
	call lineout out, l
end
call lineout in
call lineout out
'@copy 'out in' >nul 2>>&1'
'@del 'out' >nul 2>>&1'
in = burn'\ibminst\tables\lcudrvr.fil'
do while lines(in)
	l=linein(in)
	if pos('/* Cleanup srvifs */', l) > 0 then do
		call lineout out, "/* zsolt begin */"
		call lineout out, "/* Create icon for Warp 4 FI products */"
		call lineout out, "if stream(CD_Drive'\fi\fibase.rsp', 'c', 'query exists') <> '' then "
		call lineout out, "	'clifi /A:B /F:^<WP_INSTREMFOLDER^> /R:'CD_Drive'\FI\FIBASE.RSP'"
		call lineout out, " "
		call lineout out, "/* Create logdir, icons and call the addon.cmd if there is one */"
		call lineout out, "if stream(cltdir'\ADDON.CMD', 'C', 'QUERY EXISTS') \= '' then do"
		call lineout out, "	Call SysMkDir logsdir'\addon' "
		call lineout out, '	rc = SysCreateObject("WPProgram", "Selective Install^for AddOn Products", "<WP_INSTREMFOLDER>", "EXENAME="ibminstdir"\npconfig.exe;PARAMETERS=/REINSTALL;", "F")  '
		call lineout out, '	rc = SysCreateObject("WPProgram", "Selective UnInstall^for AddOn Products", "<WP_INSTREMFOLDER>", "EXENAME="ibminstdir"\npconfig.exe;PARAMETERS=/UNINSTALL;", "F") '
		call lineout out, "	'@call 'cltdir'\ADDON.CMD 'CD_Drive bootdrive percent_complete"
		call lineout out, "end"
		call lineout out, " "
	end
	call lineout out, l
end
call lineout in
call lineout out
'@copy 'out in' >nul 2>>&1'
'@del 'out' >nul 2>>&1'

/************************/
/* Add fixed getcfg.exe */
/************************/
call execute '@copy 'burn'\os2image\disk_3\getcfg.exe 'burn'\os2image\disk_3\getcfg2.exe'
call execute '@copy newinst\getcfg.exe 'burn'\os2image\disk_3\.'

/***********************************/
/* add Warp 4 FI products to updcd */
/***********************************/
if stream('fi\fibase.rsp', 'c', 'query exists') <> '' then do
	call execute '@mkdir 'burn'\fi'
	call execute '@xcopy fi\* 'burn'\fi\. /H/O/T/S/R/V/E'
end

/************************/
/* add UPDCD info to CD */
/************************/

call execute '@mkdir 'burn'\updcd\bin'
call execute '@copy *.cm? 'burn'\updcd\bin\.'
call execute '@copy *.exe 'burn'\updcd\bin\.'
call execute '@copy *.dll 'burn'\updcd\bin\.'
call execute '@copy *.msg 'burn'\updcd\bin\.'
call execute '@copy *.cfg 'burn'\updcd\bin\.'
call execute '@copy cd2boot   'burn'\updcd\bin\.'
call execute '@copy pmfaxlt.* 'burn'\updcd\bin\.'
call execute '@copy basefpk.* 'burn'\updcd\bin\.'
call execute '@copy mptsfpk.* 'burn'\updcd\bin\.'
call execute '@copy tcppfpk.* 'burn'\updcd\bin\.'
call execute '@copy peerfpk.* 'burn'\updcd\bin\.'
call execute '@mkdir 'burn'\updcd\doc'
call execute '@copy *.txt 'burn'\updcd\doc\.'
call execute '@copy readme.* 'burn'\updcd\doc\.'
call execute '@mkdir 'burn'\updcd\addons'
call execute '@xcopy addons\* 'burn'\updcd\addons\. /S/O/T/R/E/H'
call execute '@mkdir 'burn'\updcd\log'
rc = lineout(log, 'Info: Total number of errors  : 'n.errors)
rc = lineout(log, 'Info: Total number of warnings: 'n.warnings)
rc = lineout(log)
'@copy *.log 'burn'\updcd\log\. >nul 2>>&1'

/***********/
/* burn CD */
/***********/

if stream(cdrprg, 'c', 'query exists') <> '' then do
	say '1B'x || '[7;26H'substr('Calling script 'cdrprg' to burn CD.', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	say '1B'x || '[19;2H'
	'@call 'cdrprg n.errors n.warnings
end

/***********************/
/* clean up and report */
/***********************/
'@del result.out >nul'

/* signal fatal errors */
if n.errors > 0 then 	say '1B'x || '[19;2HThere were one or more errors detected, Check 'log'!'
else say '1B'x || '[19;2HUpdate is completed succesfully!'

'@del go4it.bsy >nul 2>>&1'
exit


/* delete directory */
DelDir: procedure expose n. log

	parse arg Directory
	DirSpec = Directory || '\*'

	/* delete subdirectories */
	rc = SysFileTree(DirSpec, Subdirs, 'DO', '*****', '-*---')
	do i = 1 to Subdirs.0
   		call DelDir Subdirs.i
	end

	/* delete files */
	rc = SysFileTree(DirSpec, Files, 'FO', '*****', '-*---')
	do i = 1 to Files.0
      call execute '@del 'Files.i
  end

	/* delete directory */
	cdir = directory()
	d = directory(Directory)
	cdir = directory(cdir)
	if d <> '' then call execute '@rmdir 'Directory

return

/* execute command, display it and write to log */ 
execute: procedure expose log n. iddir

	parse arg comm 
	rcode = 0

	parse upper var comm comm1 comm2 comm3 comm4 rest
	/* do not copy or pack if file does not exist */
	rc = SysFileTree(comm2, tmp., "FSO") 
	if (comm1 <> '@COPY' & comm1 <> '@PACK2' & comm1 <> '@DEL' & comm1 <> '@XCOPY') | (stream(comm2, 'c', 'query exists') <> '') | (tmp.0 > 0) then do
		comm' >nul 2>>&1'
		if rc <> 0 then rcode = rc
	end
	else do /* log warning */
		rc = lineout(log, 'Warning: 'comm2' does not exist!')
		n.warnings = n.warnings + 1
		call report_status
		return
	end
	comm = comm ||' rc='rcode

	if comm1 = '@..\ZIP.EXE' then do	
		say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(comm3), 1, 50))), 1, 50)
		say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(comm4), 1, 50))), 1, 50)
		say '1B'x || '[11;26HZip         '
	end
	else if comm1 = '@MKDIR' | comm1 = '@RMDIR' | comm1 = '@CD' then do	
		nop;
	end
	else if comm1 = '@UNZIP' then do	
		say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(rest), 1, 50))), 1, 50)
		say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(comm3), 1, 50))), 1, 50)
		say '1B'x || '[11;26HUnzip         '
	end
	else do 
		say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(comm3), 1, 50))), 1, 50)
		say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(comm2), 1, 50))), 1, 50)
		say '1B'x || '[11;26H'substr(comm1, 2, 50)
	end
	say '1B'x || '[12;26H'rcode' '

	if rcode <> 0 then do
		rc = lineout(log, 'Error: 'comm)
		rc = lineout(log)
		n.errors = n.errors + 1
	end
	else do
		rc = lineout(log, 'Info: 'comm)
		rc = lineout(log)
	end

	call report_status

return rcode

/* display status */
report_status: procedure expose n. 

	say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
	say '1B'x || '[15;2HNumber of errors      : 'n.errors
	say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
	say '1B'x || '[19;2H'

return

/* copy files from sdir to tdir except ea data. sf */
CopyDir: procedure expose log n.

	parse arg sdir tdir 

	call SysFileTree sdir'\*', ini., "FO", , '**---'
	do i=1 to ini.0
		if pos('EA DATA. SF', translate(ini.i)) = 0 then do
			'@copy 'ini.i tdir'\. >nul 2>>&1'
			rcode = rc
			if rcode <> 0 then do
				rc = lineout(log, 'Error: @copy 'ini.i tdir'\. (rc='rcode')')
				rc = lineout(log)
				n.errors = n.errors + 1
			end
			else do
				rc = lineout(log, 'Info: @copy 'ini.i tdir'\. (rc='rcode')')
				rc = lineout(log)
			end
		end
	end
	call report_status

return
