/* 01.27.2001: automatic WSeB update procedure with support for the  */
/*             following components: WSeB Fixpak 1/2, DD FPK 1/2,    */
/*             MPTS FPK 8621, MPTS 8700, TCP/IP 4.3, NS 4.61         */
/* 01.28.2001: fixed bug in handling log file name                   */
/* 03.09.2001: remove fibase.rsp from fixpak (bugggggy)              */
/*             added updated mkrsp.cmd                               */
/* 03.10.2001: added copying of getcfg.exe                           */
/* 03.24.2001: changed calling record.cmd                            */
/* 03.25.2001: fixed problem with updating sniffer                   */
/* 03.31.2001: fixed problem with creating installation disks        */
/* 04.07.2001: added paramaters to control dani and dummy drivers    */
/* 04.29.2001: added improved tunecfg which uses macro language      */
/* 05.04.2001: added support for IP08603 (LS fixpak) and JAVA update */
/* 05.07.2001: added support for JAVA run-time fix, and Warp4 FI     */
/* 05.09.2001: improved language detection                           */

/* read command line parameters */
parse arg cddrive

/* load configuration file */
cfgfile = 'updcd.cfg'
do while lines(cfgfile)
	l = linein(cfgfile)
	interpret l
end
rc = lineout(cfgfile)

/* check cddrive value */
if substr(cddrive, 2) = ':' then w4cd = translate(cddrive)

/* make sure they exist */
'@mkdir 'burn' >nul 2>>&1'
'@mkdir 'fixes' >nul 2>>&1'
'@mkdir 'updates' >nul 2>>&1'

/* need to know absolute path */
cdir  	= directory()
burn 		= directory(burn)
cdir  	= directory(cdir)
fixes 	= directory(fixes)
cdir  	= directory(cdir)
updates = directory(updates)
cdir  	= directory(cdir)

/* log file */
if filespec('drive', log) = '' then log	= strip(cdir, 'T', '\')||'\'||log

/* updcd version */
ver = 1.6
n.errors = 0
n.warnings = 0
n.elapsed = time('E')

/* load rexxutil functions we need */
call rxfuncadd sysfiletree, rexxutil, sysfiletree
call rxfuncadd syscurstate, rexxutil, syscurstate

/* remember we were started */
'@echo go4it busy > go4it.bsy'

/* clean up things */
'@mode 80,25 >nul'
'@ansi on >NUL'
say '1B'x || '[36;44m'
say '1B'x || '[1m'
'@cls'
say
say ' Searching for components which can be integrated. Please wait!'
call syscurstate off

/* find fixpaks located in the subdirectory fixes */
say
startdir = fixes
fpk. = ''
rc = lineout(, " Fixpak:    Type:     Directory:")
rc = lineout(, " -------------------------------")
rc = SysFileTree(startdir'\srv_prod.*', ini., "FSO") 
do i = 1 to ini.0
	/* say ini.i */
	do while lines(ini.i)
		l=linein(ini.i)
		if pos('Warp Server for e-business Base Operating System', l) > 0 & fpk.os2.fnd <> 1 then do
			fpk.os2.fnd = 1
			fpk.os2.typ = substr(l, pos('XR', l), 7)
			fpk.os2.num = substr(fpk.os2.typ, 5)
			fpk.os2.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.os2.dir = substr(fpk.os2.dir, 1, lastpos('\FIX\', fpk.os2.dir)-1)
			rc = lineout(, " "fpk.os2.typ"    OS/2      "fpk.os2.dir)
			fpk.os2.typ = 'XR'substr(fpk.os2.typ, 4)
			leave
		end
		if pos('IBM OS/2 Base Device Drivers', l) > 0 & fpk.dd.fnd <> 1 then do
			fpk.dd.fnd = 1
			fpk.dd.typ = substr(l, pos('XR', l), 7)
			fpk.dd.num = substr(fpk.dd.typ, 5)
			fpk.dd.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.dd.dir = substr(fpk.dd.dir, 1, lastpos('\FIX\', fpk.dd.dir)-1)
			rc = lineout(, " "fpk.dd.typ  "   Driver    "fpk.dd.dir)
			fpk.dd.typ = 'XR'substr(fpk.dd.typ, 4)
			leave
		end

		if (pos('IBM OS/2 TCP/IP Stack', l) > 0 | pos('IBM OS/2 Socket/Multi-Protocol Transport Services', l) > 0) & fpk.mpt.fnd <> 1 then do
			fpk.mpt.fnd = 1
			fpk.mpt.typ = substr(l, pos('WR', l), 7)
			fpk.mpt.num = substr(fpk.mpt.typ, 4)
			fpk.mpt.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.mpt.dir = substr(fpk.mpt.dir, 1, lastpos('\FIX\', fpk.mpt.dir)-1)
			rc = lineout(, " "fpk.mpt.typ"    MPTS      "fpk.mpt.dir)
			fpk.mpt.typ = 'WR'substr(fpk.mpt.typ, 4)
			leave
		end

		if pos('IBM OS/2 LAN Requester', l) > 0 & fpk.per.fnd <> 1 then do
			fpk.per.fnd = 1
			fpk.per.typ = substr(l, pos('IP', l), 7)
			fpk.per.num = substr(fpk.per.typ, 4)
			fpk.per.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.per.dir = substr(fpk.per.dir, 1, lastpos('\FIX\', fpk.per.dir)-1)
			rc = lineout(, " "fpk.per.typ"    LANS      "fpk.per.dir)
			fpk.per.typ = 'IP'substr(fpk.per.typ, 4)
			leave
		end

	end
	rc = lineout(ini.i)
end

/* find java fixpak */
rc = SysFileTree(startdir'\syslevel.jav', ini., "FSO") 
do i = 1 to ini.0
	do while lines(ini.i)
		l=linein(ini.i)
		if pos('Java Runtime', l) > 0 & fpk.jav.fnd <> 1 then do
			fpk.jav.fnd = 1
			fpk.jav.typ = substr(l, pos('XR', l), 7)
			fpk.jav.num = substr(fpk.jav.typ, 4)
			fpk.jav.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.jav.dir = translate(substr(fpk.jav.dir, 1, lastpos('\', fpk.jav.dir)-1))
			rc = lineout(, " "fpk.jav.typ"    JAVA      "fpk.jav.dir)
			leave
		end
	end
	rc = lineout(ini.i)
end

/* find updated products located in the subdirectory updates */
say
startdir = updates
upd. = ''
rc = lineout(, " Update:    Type:     Directory:")
rc = lineout(, " -------------------------------")
rc = SysFileTree(startdir'\syslevel.*', ini., "FSO") 

do i = 1 to ini.0
	/* say ini.i */
	do while lines(ini.i)
		l=linein(ini.i)
		if (pos('IBM OS/2 TCP/IP Stack', l) > 0 | pos('IBM OS/2 Socket/Multi-Protocol Transport Services', l) > 0) & upd.mpt.fnd <> 1 then do
			upd.mpt.fnd = 1
			upd.mpt.typ = substr(l, pos('WR', l), 7)
			upd.mpt.num = substr(upd.mpt.typ, 4)
			upd.mpt.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			upd.mpt.dir = substr(upd.mpt.dir, 1, lastpos('\MPTN', upd.mpt.dir)-1)
			rc = lineout(, " "upd.mpt.typ"    MPTS      "upd.mpt.dir)
			leave
		end
		if pos('IBM TCP/IP', l) > 0 & upd.tcp.fnd <> 1 then do
			upd.tcp.fnd = 1
			upd.tcp.typ = substr(l, pos('UN', l), 7)
			upd.tcp.num = substr(upd.tcp.typ, 4)
			upd.tcp.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			upd.tcp.dir = substr(upd.tcp.dir, 1, lastpos('\INSTALL', upd.tcp.dir)-1)
			rc = lineout(, " "upd.tcp.typ"    TCP/IP    "upd.tcp.dir)
			leave
		end
		if pos('Netscape Communicator 4.61', l) > 0 & upd.nsc.fnd <> 1 then do
			upd.nsc.fnd = 1
			upd.nsc.typ = substr(l, pos('XR', l), 7)
			upd.nsc.num = substr(upd.nsc.typ, 4)
			upd.nsc.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			rc = lineout(, " "upd.nsc.typ"    Netscape  "upd.nsc.dir)
			leave
		end
		if (pos('Java Runtime', l) > 0 | pos('JDK Runtime', l) > 0) & upd.jav.fnd <> 1 then do
			upd.jav.fnd = 1
			upd.jav.typ = substr(l, pos('XR', l), 7)
			upd.jav.num = substr(upd.jav.typ, 4)
			upd.jav.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			rc = lineout(, " "upd.jav.typ"    JAVA      "upd.jav.dir)
			leave
		end
	end
	rc = lineout(ini.i)
end

/* find addons and Warp 4 FI products */
say
if stream('addons\read.me', 'c', 'query exists') <> '' then do
			call sysfiletree 'addons\*', 'ini.', 'DO'
			rc = lineout(, ' Found 'ini.0-2' add-on products in 'directory()||'\ADDONS')
end
if stream('fi\fibase.rsp', 'c', 'query exists') <> '' then do
			call sysfiletree 'fi\*', 'ini.', 'DO'
			rc = lineout(, ' Found 'ini.0-1' Warp 4 Feature Installer products in 'directory()||'\FI')
end

/* determining language to use */
ini = w4cd'\os2image\disk_2\syslevel.os2'
if stream(ini, 'c', 'query exists') <> '' then do
	do while lines(ini)
			l=linein(ini)
			if pos('Warp Server', l) > 0 then do
				lang = substr(l, pos('XR', l), 3)
				/* say lang */
			end
	end
	rc = lineout(ini)
end
else do
	Say
	Say ' No CD-ROM found! Exiting...'
	rc = lineout(log, 'Error: No CD-ROM found! Exiting...')
	'@del go4it.bsy >nul 2>>&1'
	exit 9
end

select
	when lang = 'XR0' then lang = 'EN (English)'
	when lang = 'XRG' then lang = 'DE (German)'
	when lang = 'XRN' then lang = 'NO (Norwegian)'
	when lang = 'XRV' then lang = 'TW (Thai)'
	when lang = 'XRF' then lang = 'FR (French)'
	when lang = 'XRI' then lang = 'IT (Italian)'
	when lang = 'XRJ' then lang = 'JP (Japanese)'
	when lang = 'XRK' then lang = 'KO (Korean)'
	when lang = 'XRB' then lang = 'BR (Brazilian)'
	when lang = 'XRC' then lang = 'CN (Chinese)'
	when lang = 'XRS' then lang = 'ES (Spanish)'
	when lang = 'XRD' then lang = 'DK (Danish)'
	when lang = 'XRL' then lang = 'FI (Finnish)'
	when lang = 'XRH' then lang = 'NL (Dutch)'
	when lang = 'XRY' then lang = 'HU (Hungarian)'
	when lang = 'XRR' then lang = 'RU (Russian)'
  when lang = 'XRA' then lang = 'AR (Arabic)'
	otherwise lang = 'Unknown (assuming English for universal products)'
end
rc = lineout(, " Detected language: "lang)

say
say ' Press any key to start the build process or CTRL-C to abort'
'@pause >nul'

/* switch off deldir if set */
ddir = value("DELDIR", , "OS2ENVIRONMENT")
if length(ddir) > 0 then do
	rc = lineout(log, 'Info: Switching off deldir...')
	ddir = value("DELDIR", "", "OS2ENVIRONMENT")
end

'@del 'log' >nul 2>>&1'
rc = lineout(log, 'Info: Searching for fixes and updates...')
rc = lineout(log, 'Info: Found fix 'fpk.os2.typ' OS/2 'fpk.os2.dir)
rc = lineout(log, 'Info: Found fix 'fpk.dd.typ' Driver 'fpk.dd.dir)
rc = lineout(log, 'Info: Found fix 'fpk.mpt.typ' MPTS 'fpk.mpt.dir)
rc = lineout(log, 'Info: Found fix 'fpk.per.typ' LANS 'fpk.per.dir)
rc = lineout(log, 'Info: Found fix 'fpk.jav.typ' JAVA    'fpk.jav.dir)
rc = lineout(log, 'Info: Found update 'upd.mpt.typ' MPTS 'upd.mpt.dir)
rc = lineout(log, 'Info: Found update 'upd.tcp.typ' TCP/IP 'upd.tcp.dir)
rc = lineout(log, 'Info: Found update 'upd.jav.typ' JAVA 'upd.jav.dir)
rc = lineout(log, 'Info: Found update 'upd.nsc.typ' Netscape 'upd.nsc.dir)
rc = lineout(log, 'Info: Detected language: 'lang)
rc = lineout(log)
parse var lang w1 w2
lang = space(w1)
if lang = 'HU' | lang = 'RU' | lang = 'AR' | lang = 'Unknown' then lang = 'EN'

/* check if we have at least the base fixes */
if fpk.dd.dir = '' | fpk.os2.dir = '' then do
	Say 'At least the base OS/2 fixes should be present! Exiting...'
	rc = lineout(log, 'Error: At least the base OS/2 fixes should be present! Exiting...')
	'@del go4it.bsy >nul 2>>&1'
	exit 9
end

/**********************/
/* Clean up old image */
/**********************/

'@cls'
say '1B'x || '[2;2HUpdate OS/2 installation CD-ROM, version 'ver
say '1B'x || '[4;2HTarget directory      : 'burn
say '1B'x || '[5;2HSource directory      : 'burn
say '1B'x || '[7;2HCurrent activity      : 'substr('Cleaning up directory: 'burn, 1, 50)
say '1B'x || '[8;2HTarget object         : 'substr('Searching...', 1, 50)
say '1B'x || '[9;2HSource object         : 'substr('Searching...', 1, 50)
say '1B'x || '[11;2HUpdate action         : 'substr('Searching...', 1, 50)
say '1B'x || '[12;2HUpdate return code    : 0'
say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
say '1B'x || '[15;2HNumber of errors      : 'n.errors
say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
say '1B'x || '[17;2HUpdate log            : 'log
say '1B'x || '[19;2H'

/* clean directories */
call execute '@attrib -r -s -h -a * /s'

/* del eadata */
'@del "'burn'\os2image\disk_0\ea data. sf" >nul 2>>&1'
'@del "'burn'\os2image\disk_1\ea data. sf" >nul 2>>&1'
'@del "'burn'\os2image\disk_2\ea data. sf" >nul 2>>&1'

call deldir burn'\fi' 
call deldir burn'\ecs' 
call deldir burn'\bootimgs' 
call deldir burn'\report' 
call deldir burn'\options' 
call deldir burn'\images' 
call deldir burn'\info'
call deldir burn'\books'
call deldir burn'\os2image'
call deldir burn'\ibminst'
call deldir burn'\cid'
call deldir burn'\diskimgs'
call deldir burn'\updcd'
call deldir burn'\warpsrv'
call deldir burn'\GRPWARE'
call deldir burn'\os2'
call deldir burn'\dos'
call deldir burn'\mmpm2'

/* clean our files in root */
rc = SysFileTree(burn'\*', ini., "FSO",,'**---')  
if stream(burn'\readme.1st',  'c', 'query exists') <> '' then call execute '@del 'burn'\readme.1st'
if stream(burn'\OS2SE20.SRC', 'c', 'query exists') <> '' then call execute '@del 'burn'\OS2SE20.SRC'
if stream(burn'\README.TXT',  'c', 'query exists') <> '' then call execute '@del 'burn'\README.TXT'
if stream(burn'\RSPINST.EXE', 'c', 'query exists') <> '' then call execute '@del 'burn'\RSPINST.EXE'
if stream(burn'\INSTALL.CMD', 'c', 'query exists') <> '' then call execute '@del 'burn'\INSTALL.CMD'
if stream(burn'\CDINST.CMD',  'c', 'query exists') <> '' then call execute '@del 'burn'\CDINST.CMD'
if stream(burn'\CDINST.BAT',  'c', 'query exists') <> '' then call execute '@del 'burn'\CDINST.BAT'
if stream(burn'\DMF_PS2.CMD', 'c', 'query exists') <> '' then call execute '@del 'burn'\DMF_PS2.CMD'
if stream(burn'\chkinst.exe', 'c', 'query exists') <> '' then call execute '@del 'burn'\chkinst.exe'
if stream(burn'\runtime.exe', 'c', 'query exists') <> '' then call execute '@del 'burn'\runtime.exe'
if stream(burn'\vcu.exe',     'c', 'query exists') <> '' then call execute '@del 'burn'\vcu.exe'
if stream(burn'\vcu.msg',     'c', 'query exists') <> '' then call execute '@del 'burn'\vcu.msg'
if stream(burn'\makedsks.cmd','c', 'query exists') <> '' then call execute '@del 'burn'\makedsks.CMD'
if stream(burn'\README',      'c', 'query exists') <> '' then call execute '@del 'burn'\README'
if stream(burn'\README.INS',  'c', 'query exists') <> '' then call execute '@del 'burn'\README.INS'
if stream(burn'\PRODDSKS.CMD','c', 'query exists') <> '' then call execute '@del 'burn'\PRODDSKS.CMD'
if stream(burn'\SAMPLE.RSP',  'c', 'query exists') <> '' then call execute '@del 'burn'\SAMPLE.RSP'

/* create some directories */
'@mkdir 'burn '>nul 2>&1'
call execute '@mkdir 'burn'\updcd'
call execute '@mkdir 'burn'\updcd\bootimg'
call execute '@mkdir 'burn'\updcd\bootimg\DISK_0_1.IMG'
call execute '@mkdir 'burn'\updcd\bootimg\DISK_2.IMG'

/*************************************/
/* Update installation floppy images */
/*************************************/

say '1B'x || '[4;26H'substr(burn, 1, 50)
say '1B'x || '[5;26H'substr(w4cd, 1, 50)
say '1B'x || '[7;26H'substr('Copying CD-ROM files', 1, 50)
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
call execute '@mkdir 'burn'\diskimgs'
call execute '@xcopy 'w4cd'\diskimgs\* 'burn'\diskimgs\. /H/O/T/R/V'
call execute '@mkdir 'burn'\diskimgs\os2'
call execute '@mkdir 'burn'\diskimgs\os2\35'
call execute '@copy 'w4cd'\diskimgs\os2\35\disk0.dsk 'burn'\diskimgs\os2\35\.'
call execute '@copy 'w4cd'\diskimgs\os2\35\disk1_cd.dsk 'burn'\diskimgs\os2\35\.'
call execute '@copy 'w4cd'\diskimgs\os2\35\disk2.dsk 'burn'\diskimgs\os2\35\.'

/* delete temp stuff from fix */
rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
do i = 1 to ini.0
	call execute '@del 'ini.i
end

/* first copy the stuff we need to the fix directory */
say '1B'x || '[7;26H'substr('Copying base OS/2 fixes', 1, 50)
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
call execute '@xcopy 'fpk.dd.dir'\fix\bdd.1\*  fix\.'
call execute '@xcopy 'fpk.dd.dir'\fix\bdd.4\*  fix\.'
if fpk.dd.num = 1 then call execute '@xcopy 'fpk.dd.dir'\fix\bdd.5\*  fix\.'
call execute '@xcopy 'fpk.os2.dir'\fix\os2.1\* fix\.'
call execute '@xcopy 'fpk.os2.dir'\fix\os2.2\* fix\.'
call execute '@xcopy 'fpk.os2.dir'\fix\os2.4\* fix\.'
'@rmdir fix\smp >nul 2>>&1'
call execute '@mkdir fix\smp'
call execute '@xcopy 'fpk.os2.dir'\fix\os2.3\* fix\smp\.'
call execute '@xcopy 'fpk.os2.dir'\fix\os2.5\* fix\smp\.'

/* then prepare it */
'@del result.out >nul 2>&1'
'@call prpfp fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) ver log
res = linein('result.out')
rc = lineout('result.out')
parse var res n.errors n.warnings

/* finally run update */
say '1B'x || '[7;26H'substr('Updating installation floppy images', 1, 50)
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
'@del result.out >nul'
'@call updif 'burn' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver expert add_dani add_dummy
res = linein('result.out')
rc = lineout('result.out')
parse var res n.errors n.warnings 

/* do the rest */
say '1B'x || '[4;26H'substr(burn, 1, 50)
say '1B'x || '[5;26H'substr(w4cd, 1, 50)
say '1B'x || '[7;26H'substr('Copying CD-ROM files', 1, 50)
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)

call execute '@xcopy 'w4cd'\* 'burn'\. /H/O/T/R/V'

call execute '@mkdir 'burn'\cid'
call execute '@xcopy 'w4cd'\cid\* 'burn'\cid\. /H/O/T/S/R/V/E'

call execute '@mkdir 'burn'\ibminst'
call execute '@xcopy 'w4cd'\ibminst\* 'burn'\ibminst\. /H/O/T/S/E/R/V'

call execute '@mkdir 'burn'\info'
call execute '@xcopy 'w4cd'\info\* 'burn'\info\. /H/O/T/S/E/R/V'

call execute '@mkdir 'burn'\books'
call execute '@xcopy 'w4cd'\books\* 'burn'\books\. /H/O/T/S/E/R/V'

call execute '@mkdir 'burn'\os2image'
call execute '@xcopy 'w4cd'\os2image\* 'burn'\os2image\. /H/O/T/S/R/V/E'

/* remove RO attribute */
rc = SysFileTree(burn'\*', ini., "FSO",,'**---')  
call execute '@attrib -r -s -h -a 'burn'\* /s'

/********************************************************************/
/* incorporate OS/2 and Device Driver fixpaks and Feature Installer */
/********************************************************************/

/* run update */
'@del result.out >nul'
'@copy basefpk.wsb basefpk.pin >nul'
if stream('fix\fibase.rsp', 'c', 'query exists') <> '' then call execute '@del fix\fibase.rsp' /* this files seems to cause trouble */
'@call updcd 'burn' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
res = linein('result.out')
rc = lineout('result.out')
parse var res n.errors n.warnings 

/* and delete temp stuff from fix */
rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
do i = 1 to ini.0
	call execute '@del 'ini.i
end
call execute '@rmdir fix\smp'

if expert = 0 then do
	say '1B'x || '[19;2HPress any key to continue or CTRL-C to abort'
	'@pause >nul'
	say '1B'x || '[19;2H                                            '
end

/******************************************/
/* incorporate MPTS replacement and fixes */
/******************************************/

if upd.mpt.dir <> '' then do
	/* delete old mpts */
	rc = SysFileTree(burn'\cid\server\mpts\*', ini., "FSO",,'**---')  
	do i = 1 to ini.0
		call execute '@del 'ini.i
	end

	/* copy replacement mpts */
	say '1B'x || '[7;26H'substr('Copying MPTS update', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	call execute '@xcopy 'upd.mpt.dir'\* 'burn'\cid\server\mpts\. /H/O/T/S/R/V/E'
end

/* add mpts fixpak */
if fpk.mpt.dir <> '' then do
		/* copy fix */
		say '1B'x || '[7;26H'substr('Copying MPTS fixpak', 1, 50)
		say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
		call execute '@xcopy 'fpk.mpt.dir'\fix\MPT.1\* fix\.'
		call execute '@xcopy 'fpk.mpt.dir'\fix\TRP.2\* fix\.'
		call execute '@xcopy 'fpk.mpt.dir'\fix\DHC.3\* fix\.'
		call execute '@xcopy 'fpk.mpt.dir'\fix\SIF.4\* fix\.'
		call execute '@xcopy 'fpk.mpt.dir'\fix\LCU.5\* fix\.'

		/* then prepare it */
		'@del result.out >nul'
		'@call prpfp fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) ver log
		res = linein('result.out')
		rc = lineout('result.out')
		parse var res n.errors n.warnings 

		/* finally run update */
		'@del result.out >nul'
		'@call updcd 'burn'\cid\server\mpts fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
		res = linein('result.out')
		rc = lineout('result.out')
		parse var res n.errors n.warnings 

		/* and delete temp stuff from fix */
		rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
		do i = 1 to ini.0
			call execute '@del 'ini.i
		end
end

/* update sniffer */
if stream(burn'\cid\server\MPTS\APPLETS\MPTSAPLT.ZIP', 'c', 'query exists') <> '' then do
		call execute '@unzip -jCo 'burn'\cid\server\MPTS\APPLETS\MPTSAPLT.ZIP APPLETS\OS2SNIFF.EXE  -d 'burn'\ibminst\. '
		call execute '@unzip -jCo 'burn'\cid\server\MPTS\APPLETS\MPTSAPLT.ZIP APPLETS\NCD.DLL       -d 'burn'\ibminst\. '
		call execute '@unzip -jCo 'burn'\cid\server\MPTS\APPLETS\MPTSAPLT.ZIP APPLETS\NCD.MSG       -d 'burn'\ibminst\. '
		call execute '@copy 'burn'\ibminst\os2sniff.exe 'burn'\ibminst\clbsniff.exe'
		call execute '@copy 'burn'\ibminst\ncd.dll 'burn'\ibminst\clbncd.dll'
end
else if stream(burn'\CID\IMG\MPTS\UTILITY\APPLETS\MPTSAPLT.ZIP', 'c', 'query exists') <> '' then do
	call execute '@unzip -jCo 'burn'\CID\IMG\MPTS\UTILITY\APPLETS\MPTSAPLT.ZIP APPLETS\OS2SNIFF.EXE  -d 'burn'\ibminst\. '
	call execute '@unzip -jCo 'burn'\CID\IMG\MPTS\UTILITY\APPLETS\MPTSAPLT.ZIP APPLETS\NCD.DLL       -d 'burn'\ibminst\. '
	call execute '@unzip -jCo 'burn'\CID\IMG\MPTS\UTILITY\APPLETS\MPTSAPLT.ZIP APPLETS\NCD.MSG       -d 'burn'\ibminst\. '
	call execute '@copy 'burn'\ibminst\os2sniff.exe 'burn'\ibminst\clbsniff.exe'
	call execute '@copy 'burn'\ibminst\ncd.dll 'burn'\ibminst\clbncd.dll'
end

/* update files in \cid\nif with updated mpts */
if stream(burn'\cid\server\MPTS\ibmcom\protocol\protocol.ZIP', 'c', 'query exists') <> '' then do
	call deldir burn'\cid\nifs'
	call execute '@mkdir 'burn'\cid\nifs'
	call execute '@mkdir 'burn'\cid\nifs\macs'
	call execute '@mkdir 'burn'\cid\nifs\protocol'
	call execute '@unzip -jo 'burn'\cid\server\mpts\ibmcom\protocol\protocol.zip -d 'burn'\cid\nifs'
	call execute '@unzip -jo 'burn'\cid\server\mpts\ibmcom\protocol\protocol.zip -d 'burn'\cid\nifs\protocol'
	call execute '@unzip -jo 'burn'\cid\server\mpts\ibmcom\macs\macs.zip         -d 'burn'\cid\nifs'
	call execute '@unzip -jo 'burn'\cid\server\mpts\ibmcom\macs\macs.zip         -d 'burn'\cid\nifs\macs'
end

if expert = 0 then do
		say '1B'x || '[19;2HPress any key to continue or CTRL-C to abort'
		'@pause >nul'
		say '1B'x || '[19;2H                                            '
end

/*********************************/
/* incorporate LAN Server fixpak */
/*********************************/

if fpk.per.dir <> '' then do
	/* copy fix */
	say '1B'x || '[7;26H'substr('Copying PEER fixpak', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	call execute '@xcopy 'fpk.per.dir'\fix\REQ.1\* fix\.'
	call execute '@xcopy 'fpk.per.dir'\fix\UPE.2\* fix\.'
	call execute '@xcopy 'fpk.per.dir'\fix\HFS.3\* fix\.'
	call execute '@xcopy 'fpk.per.dir'\fix\MUG.4\* fix\.'
	call execute '@xcopy 'fpk.per.dir'\fix\SRV.5\* fix\.'
	call execute '@xcopy 'fpk.per.dir'\fix\SRV.6\* fix\.'
	call execute '@xcopy 'fpk.per.dir'\fix\SRV.7\* fix\.'

	/* then prepare it */
	'@del result.out >nul'
	'@call prpfp fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) ver log
	res = linein('result.out')
	rc = lineout('result.out')
	parse var res n.errors n.warnings 

	/* finally run update */
	'@del result.out >nul'
	'@copy peerfpk.wsb peerfpk.pin >nul'
	'@call updcd 'burn' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
	res = linein('result.out')
	rc = lineout('result.out')
	parse var res n.errors n.warnings 

	/* and delete temp stuff from fix */
	rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
	do i = 1 to ini.0
		call execute '@del 'ini.i
	end

	if expert = 0 then do
		say '1B'x || '[19;2HPress any key to continue or CTRL-C to abort'
		'@pause >nul'
		say '1B'x || '[19;2H                                            '
	end
end

/*****************************/
/* incorporate Java run-time */
/*****************************/

if upd.jav.dir <> '' then do

	/* create Java dir and copy the files needed */
	say '1B'x || '[7;26H'substr('Copying Java', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	call execute '@mkdir 'burn'\cid\server\java'

	/* copy java cid.rsp to tabledir */
	call execute '@copy 'upd.jav.dir'\cid.rsp 'burn'\ibminst\tables\javacid.rsp'

	/* copy the rest to image */
	call execute '@xcopy 'upd.jav.dir'\* 'burn'\cid\server\java /H/O/T/R/V/E'
	call execute '@mkdir 'burn'\cid\server\java\package'
	call execute '@xcopy 'upd.jav.dir'\package\* 'burn'\cid\server\java\package /H/O/T/S/R/V/E'
	call execute '@mkdir 'burn'\cid\server\java\en'
	if lang = 'DK' | lang = 'FI' | lang = 'NL' then lang = 'EN' /* there is no java for these languages, use English version */
	call execute '@xcopy 'upd.jav.dir'\'lang'\* 'burn'\cid\server\java\en /H/O/T/S/R/V/E'
	
	/* seems this file should be in the root */
	call execute '@copy 'upd.jav.dir'\'lang'\00000000.EAS 'burn'\cid\server\java'

	/* rename java response file */
	call execute '@copy 'burn'\cid\server\java\en\java*.rsp 'burn'\cid\server\java\en\rspjava.rsp'
	call execute '@del 'burn'\cid\server\java\en\java*.rsp'

/*
	/* remove java 1.0.2 from FI response file */
	if stream('fibase.loc', 'c', 'query exists') <> '' then do

		/* unpack fibase.rsp */
		location.fibase = linein('fibase.loc')
		call lineout 'fibase.loc'
		call execute '@unpack 'location.fibase' . /N:FIBASE.RSP'

		/* set some variables */
		found_java = 0
		create_object = 0
		copy_file = 0
		in  = 'fibase.rsp'
		out = 'fibase.out'
		'@del 'out' >nul 2>>&1'

		/* read fibase */
		do while lines(in)
			l=linein(in)

			/* where are we now? */
			select
				when l='JAVA=(' | l='JAVARUN=(' | l='JAVASMPLS=(' | l='JAVATLKT=(' then found_java = 1
				when found_java = 1 & l='	ObjectCreation=(' then do
					create_object = 1
					iterate
				end
				when found_java = 1 & l='	File=(' then do
					copy_file = 1
					iterate
				end
				when l='	)' & found_java = 1 & (create_object = 1 | copy_file = 1) then do
					create_object = 0
				 	copy_file = 0
					iterate
				end
				when l=')' & found_java = 1 then found_java = 0
				otherwise nop;
			end
		
			/* write out if it is not JAVA 1.0 create object or copy file */
			if found_java = 1 & (create_object = 1 | copy_file = 1) then iterate
			else call lineout out, l
		
		end
		call lineout in
		call lineout out

		/* pack new rsp file */
		call execute '@copy 'out in
		'@pack2 \OS2\INSTALL\FIBASE.RSP 'location.fibase' /R >nul 2>>&1'
		call execute '@pack2 'in location.fibase' /H:\OS2\INSTALL\ /A'

		/* clean up */
		'@del 'in'  >nul 2>>&1'
		'@del 'out' >nul 2>>&1'
		'@del fibase.loc >nul 2>>&1'

	end
*/
end

/************************************/
/* incorporate Java run-time fixpak */
/************************************/

if upd.jav.dir <> '' & fpk.jav.dir <> '' then do

	/* copy fix */
	say '1B'x || '[7;26H'substr('Copying JAVA fixpak', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	call execute '@xcopy 'fpk.jav.dir'\lib\* 					fix\.'
	call execute '@xcopy 'fpk.jav.dir'\lib\security\* fix\.'
	call execute '@xcopy 'fpk.jav.dir'\dll\* 					fix\.'
	call execute '@xcopy 'fpk.jav.dir'\bin\* 					fix\.' 
	call execute '@xcopy 'fpk.jav.dir'\*     					fix\.'

	/* delete some files */
	call execute '@del fix\FIXES.LST'

	/* finally run update */
	'@del result.out >nul'
	'@call updcd 'burn' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
	res = linein('result.out')
	rc = lineout('result.out')
	parse var res n.errors n.warnings 

	/* and delete temp stuff from fix */
	rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
	do i = 1 to ini.0
		call execute '@del 'ini.i
	end

	if expert = 0 then do
		say '1B'x || '[19;2HPress any key to continue or CTRL-C to abort'
		'@pause >nul'
		say '1B'x || '[19;2H                                            '
	end
	
end

/*****************************/
/* incorporate Netscape 4.61 */
/*****************************/

if upd.nsc.dir <> '' then do
	say '1B'x || '[7;26H'substr('Copying Netscape', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	/* delete old netscape but preserve fi plug-in */
	call execute '@copy 'burn'\cid\server\netscape\npfi.dll fix\.'
	rc = SysFileTree(burn'\cid\server\netscape\*', ini., "FSO",,'**---')  
	do i = 1 to ini.0
		call execute '@del 'ini.i
	end
	call execute '@copy fix\npfi.dll 'burn'\cid\server\netscape\.'
	call execute '@del fix\npfi.dll'

	/* copy files we need */
	call execute '@copy newinst\netscape.rsp 'burn'\ibminst\tables'
	call execute '@xcopy 'upd.nsc.dir'\* 'burn'\cid\server\netscape /H/O/T/S/R/V/E'
end


/******************************/
/* incorporate 32-bits TCP/IP */
/******************************/

if upd.tcp.dir <> '' then do
	/* delete old TCP/IP */
	rc = SysFileTree(burn'\cid\server\tcpapps\*', ini., "FSO",,'**---')  
	do i = 1 to ini.0
		call execute '@del 'ini.i
	end

	/* copy new one */
	say '1B'x || '[7;26H'substr('Copying TCP/IP', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	call execute '@xcopy 'upd.tcp.dir'\* 'burn'\cid\server\tcpapps /H/O/T/S/R/V/E'

	/* add new response file */
	call execute '@copy newinst\tcpip.rsp 'burn'\ibminst\tables'
end

/******************************/
/* copy updated CID procedure */
/******************************/
rc = SysFileTree(burn'\ibminst\*', ini., "FSO",,'**---')  
call execute '@copy newinst\addons.cfg   'burn'\ibminst\tables'
call execute '@copy newinst\addon.fil    'burn'\ibminst\tables'
call execute '@copy newinst\lcudrvr.wsb  'burn'\ibminst\tables\lcudrvr.fil'
call execute '@copy newinst\StTimeV.Cmd  'burn'\ibminst'
call execute '@copy unzip.exe            'burn'\ibminst'
call execute '@copy newinst\mkrsp.wsb    'burn'\ibminst\mkrsp.cmd'
call execute '@copy 'burn'\ibminst\npconfig.exe 'burn'\ibminst\npcfg2.exe'
call execute '@copy newinst\npconfig.exe 'burn'\ibminst'
call execute '@copy vrobj.dll            'burn'\ibminst'
call execute '@copy newinst\tunecfg.cmd  'burn'\ibminst'
call execute '@copy newinst\tunecfg.cfg  'burn'\ibminst'
'@echo do not remove this file > 'burn'\ibminst\npconfig.wsb'

/************************/
/* Add fixed getcfg.exe */
/************************/
call execute '@copy 'burn'\os2image\disk_3\getcfg.exe 'burn'\os2image\disk_3\getcfg2.exe'
call execute '@copy newinst\getcfg.exe 'burn'\os2image\disk_3\.'

/* add fixed cdinst.cmd */
call execute '@copy newinst\cdinst.wsb 'burn'\cdinst.cmd'

/***********************************/
/* add Warp 4 FI products to updcd */
/***********************************/
if stream('fi\fibase.rsp', 'c', 'query exists') <> '' then do
	call execute '@mkdir 'burn'\fi'
	call execute '@xcopy fi\* 'burn'\fi\. /H/O/T/S/R/V/E'
end

/************************/
/* add UPDCD info to CD */
/************************/

call execute '@mkdir 'burn'\updcd\bin'
call execute '@copy *.cm? 'burn'\updcd\bin\.'
call execute '@copy *.exe 'burn'\updcd\bin\.'
call execute '@copy *.dll 'burn'\updcd\bin\.'
call execute '@copy *.msg 'burn'\updcd\bin\.'
call execute '@copy *.cfg 'burn'\updcd\bin\.'
call execute '@copy cd2boot   'burn'\updcd\bin\.'
call execute '@copy pmfaxlt.* 'burn'\updcd\bin\.'
call execute '@copy basefpk.* 'burn'\updcd\bin\.'
call execute '@copy mptsfpk.* 'burn'\updcd\bin\.'
call execute '@copy tcppfpk.* 'burn'\updcd\bin\.'
call execute '@copy peerfpk.* 'burn'\updcd\bin\.'
call execute '@mkdir 'burn'\updcd\doc'
call execute '@copy *.txt 'burn'\updcd\doc\.'
call execute '@copy readme.* 'burn'\updcd\doc\.'
call execute '@mkdir 'burn'\updcd\addons'
call execute '@xcopy addons\* 'burn'\updcd\addons\. /S/O/T/R/E/H'
call execute '@mkdir 'burn'\updcd\log'
rc = lineout(log, 'Info: Total number of errors  : 'n.errors)
rc = lineout(log, 'Info: Total number of warnings: 'n.warnings)
rc = lineout(log)
'@copy *.log 'burn'\updcd\log\. >nul 2>>&1'

/***********/
/* burn CD */
/***********/

if stream(cdrprg, 'c', 'query exists') <> '' then do
	say '1B'x || '[7;26H'substr('Calling script 'cdrprg' to burn CD.', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	say '1B'x || '[19;2H'
	'@call 'cdrprg n.errors n.warnings
end

/***********************/
/* clean up and report */
/***********************/
'@del result.out >nul'

/* signal fatal errors */
if n.errors > 0 then 	say '1B'x || '[19;2HThere were one or more errors detected, Check 'log'!'
else say '1B'x || '[19;2HUpdate is completed succesfully!'

'@del go4it.bsy >nul 2>>&1'
exit


/* delete directory */
DelDir: procedure expose n. log

	parse arg Directory
	DirSpec = Directory || '\*'

	/* delete subdirectories */
	rc = SysFileTree(DirSpec, Subdirs, 'DO', '*****', '-*---')
	do i = 1 to Subdirs.0
   		call DelDir Subdirs.i
	end

	/* delete files */
	rc = SysFileTree(DirSpec, Files, 'FO', '*****', '-*---')
	do i = 1 to Files.0
      call execute '@del 'Files.i
  end

	/* delete directory */
	cdir = directory()
	d = directory(Directory)
	cdir = directory(cdir)
	if d <> '' then call execute '@rmdir 'Directory

return

/* execute command, display it and write to log */ 
execute: procedure expose log n. iddir

	parse arg comm 
	rcode = 0

	parse upper var comm comm1 comm2 comm3 comm4 rest
	/* do not copy or pack if file does not exist */
	rc = SysFileTree(comm2, tmp., "FSO") 
	if (comm1 <> '@COPY' & comm1 <> '@PACK2' & comm1 <> '@DEL' & comm1 <> '@XCOPY') | (stream(comm2, 'c', 'query exists') <> '') | (tmp.0 > 0) then do
		comm' >nul 2>>&1'
		if rc <> 0 then rcode = rc
	end
	else do /* log warning */
		rc = lineout(log, 'Warning: 'comm2' does not exist!')
		n.warnings = n.warnings + 1
		call report_status
		return
	end
	comm = comm ||' rc='rcode

	if comm1 = '@..\ZIP.EXE' then do	
		say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(comm3), 1, 50))), 1, 50)
		say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(comm4), 1, 50))), 1, 50)
		say '1B'x || '[11;26HZip         '
	end
	else if comm1 = '@MKDIR' | comm1 = '@RMDIR' | comm1 = '@CD' then do	
		nop;
	end
	else if comm1 = '@UNZIP' then do	
		say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(rest), 1, 50))), 1, 50)
		say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(comm3), 1, 50))), 1, 50)
		say '1B'x || '[11;26HUnzip         '
	end
	else do 
		say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(comm3), 1, 50))), 1, 50)
		say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(comm2), 1, 50))), 1, 50)
		say '1B'x || '[11;26H'substr(comm1, 2, 50)
	end
	say '1B'x || '[12;26H'rcode' '

	if rcode <> 0 then do
		rc = lineout(log, 'Error: 'comm)
		rc = lineout(log)
		n.errors = n.errors + 1
	end
	else do
		rc = lineout(log, 'Info: 'comm)
		rc = lineout(log)
	end

	call report_status

return rcode

/* display status */
report_status: procedure expose n. 

	say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
	say '1B'x || '[15;2HNumber of errors      : 'n.errors
	say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
	say '1B'x || '[19;2H'

return

