/* Install.cmd - Installation Utility for Bamba for OS/2 */
/* place all files of BOS2a in this directory,           */
/* Last modified on 01.16.2001                           */

parse arg target source

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")
NS_DIR            = value("NS_DIR"           , ,"OS2ENVIRONMENT")

/* check product */
/* if stream(???, 'c', 'query exists') = '' then exit 9 */

call load /* Load Rexx System Functions if necessary */
backup=0 /* Flag to tell us if we need to back up. */
/* call init */
/* NS_DIR=findNS_DIR() /* Exits if directory isn't found */ */
NS_DIR=NS_DIR'\Program'
/* netscapeplugindir=findnetscapeplugindir(NS_DIR) */
netscapeplugindir=NS_DIR"\PlugIns"
osdir=value('OS2_SHELL', ,'OS2ENVIRONMENT')
osdrive=left(osdir,3)
call testcurrentdir
/* call searcholdversions /* May or may not change the value of 'backup' */ */
if backup=1 then do
        call backupnpb
        call backupbmb /* Check if there are any bmb*.dll's */
end
/* Everything is backed up, now we can copy our stuff */
call copystuff /* copies the dll's into their destination and deletes them in the current temporary directory */
say ''
say 'The OS/2 Bamba plug-in has been installed.'
say '------------------------------------------'
say ''
/* say 'Do you want to test your sound system now? [Y]/N'
pull answer
if answer\='N' then do
        'daudio'
end */

exit

/* ***************************************** */
/* Load: loads the rexx system functions if necessary */
/* **************************************** */
load:
if \RxFuncQuery("SysLoadFuncs") then return /* Loaded already */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadfuncs'
call SysLoadFuncs
return

/* ************************************** */
/* init: asks the user if he/she wants to continue */
/* ************************************* */
init:
call SysCls
say ''
say 'This will install OS/2 Bamba plug-in Version 1.1 and backup any'
say 'previous installation. The plug-in requires Netscape 2.02 for OS/2.'
say ''
say 'Netscape should not be running for this install to be successful'
say '(exit Netscape, if it is running, before continuing)'
say ''
say 'Once the files have been copied and the plug-in installed you will'
say 'be given options to view the readme and test your audio system.'
say ''
/* say 'Do you want to continue? Y/[N]'
pull answer
if answer\='Y' then call quitting('Installation canceled by user.') */
return

quitting:
parse arg msg
say msg
say 'Bamba plug-in was not installed.'
exit

/* ******************************************************************************* */
/* FindNS_DIR: Returns the directory of Netscape. Returns the string 'Error' if nothing was found. */
/* ******************************************************************************* */
findNS_DIR:
ret=''
netdir4=SysIni('USER', 'WPURLDEFAULTSETTINGS', 'DefaultWorkingDir')
netdir3=SysIni('USER', 'Netscape', '2.02')
if left(netdir4,6)='ERROR:' & netdir3='ERROR:' then ret='Error'
else do
        if left(netdir4,6)\='ERROR:' then ret=left(netdir4,length(netdir4)-1)
        else ret=netdir3
end
if ret='Error' then call quitting('Could not find Netscape directory.')
return ret

/* ********************************************************************** */
/* FindNetscapePluginDir: returns the 'plugin' directory of Netscape, quits if doesn't find it */
/* ********************************************************************** */
findnetscapeplugindir:
parse arg ndir
pdir=ndir'\plugins'
call SysFileTree pdir, 'dir', 'D'
if dir.0=0 then call quitting('Could not find Netscape Plug-In directory')
return pdir

/* ****************************************************** */
/* SearchOldVersions:  changes 'backup' into 1 if npbamba.dll is found */
/* ****************************************************** */
searcholdversions: procedure expose netscapeplugindir backup
plug=netscapeplugindir'\npbamba.dll'
call SysFileTree plug, 'file', 'F'
if file.0=1 then backup=1
return

/* ************************** */
/* Backupnpb: backs up old plug-in */
/* ************************* */
backupnpb: procedure expose netscapeplugindir
say ''
say 'Found previous Bamba version.'
bdir=netscapeplugindir'\bbbackup'
call SysFileTree bdir, 'dir', 'D'
if dir.0=0 then do              /* backup directory doesn't exist, so create it */
        say 'Creating backup directory 'bdir
        rc=SysMkDir(bdir)
        if rc=5 then do
                say 'Error. Access denied while trying to create backup directory.'
                say 'Ending program. Bamba was NOT installed.'
                exit
        end
        else if rc\=0 then do
                say 'An unknown error has occured while trying to create backup directory.'
                say 'Program is ending. Bamba was NOT installed.'
                say 'Return code is ' rc
                exit
        end
end
backnpbdll=bdir'\npbamba.'
i=0
ext='000'
call SysFileTree backnpbdll'000', 'npb', 'F'
do while npb.0\=0
        i=i+1
        ext=addzeros(i)
        file=backnpbdll||ext
        call SysFileTree file, 'npb', 'F'
end /* do while */
/* now we have an 'i' which is the extention of the backup file */
'@echo off'
'copy ' netscapeplugindir'\npbamba.dll' bdir'\npbamba.'ext '>nul'
'del 'netscapeplugindir'\npbamba.dll'
say 'Backup directory: 'bdir
say 'NPBAMBA.DLL backed up as NPBAMBA.'ext
return

/* ************************************************ */
/* AddZeros: turns a 1 or 2 digit number into a 3 digit number */
/* ************************************************ */
addzeros: procedure
parse arg getal
zeros='000'
ret=left(zeros,3-length(getal))||getal
return ret

/* ***************************************************** */
/* backupbmb: looks for bmb*.dll files and backs them up if necessary */
/* ***************************************************** */
backupbmb: procedure expose osdrive netscapeplugindir
bmb1='bmblbra.dll'
bmb2='bmblbrv.dll'
bmb3='bmbom30.dll'

bmbdir=osdrive'MMOS2\DLL'
orbmb.1=bmbdir'\'bmb1
orbmb.2=bmbdir'\'bmb2
orbmb.3=bmbdir'\'bmb3
do i=1 to 3
        temp=orbmb.i
        call SysFileTree temp, 'file', 'F'
        if file.0=1 then call backbmb(orbmb.i)
end /* do */
/* Check for c:\os2\dll as well */
orbmb.1=osdrive'OS2\DLL\'bmb1
orbmb.2=osdrive'OS2\DLL\'bmb2
orbmb.3=osdrive'OS2\DLL\'bmb3
do i=1 to 3
        temp=orbmb.i
        call SysFileTree temp, 'file', 'F'
        if file.0=1 then call backbmb(temp)
end /* do */
/* This install program assumes that the dll's haven't been put into another directory */
return

/* *********************************** */
/* backbmb: moves the bmb* files to bbbackup */
/* *********************************** */
backbmb: procedure expose orbmb. netscapeplugindir backup
parse arg bestand
best=left(bestand,length(bestand)-3)
best=right(best,8)
bdir=netscapeplugindir'\bbbackup'
bfile=bdir'\'best
i=0
ext='000'
bkfile=bfile||ext
call SysFileTree bkfile, 'file', 'F'
do while file.0\=0
        i=i+1
        ext=addzeros(i)
        bkfile=bfile||ext
        call SysFileTree bkfile, 'file', 'F'
end
'@echo off'
fbest=best||ext
'copy' bestand bdir'\'fbest ' > nul'
'del' bestand
say bestand 'backed up as' fbest
return

/* ***************************************** */
/* CopyStuff: copies all the files into their destination */
/* ***************************************** */
copystuff:
'@echo off'
'copy 'inst_dir'\npbamba.dll 'netscapeplugindir'\npbamba.dll > nul'
'copy 'inst_dir'\bmblbra.dll' osdrive'os2\dll\bmblbra.dll > nul'
'copy 'inst_dir'\bmblbrv.dll' osdrive'os2\dll\bmblbrv.dll > nul'
'copy 'inst_dir'\bmbom30.dll' osdrive'os2\dll\bmbom30.dll > nul'
say ''
say 'Copied NPBAMBA.DLL to' netscapeplugindir
say 'Copied BMBLBRA.DLL, BMBLBRV.DLL and BMBOM30.DLL to' osdrive'OS2\DLL'
/*
'del npbamba.dll'
'del bmblbra.dll'
'del bmblbrv.dll'
'del bmbom30.dll'
*/
return

/* ****************************************************** */
/* TestCurrentDir: if this command is executed in the plug-in directory */
/* there will be problems                                                     */
/* ****************************************************** */
testcurrentdir: procedure expose netscapeplugindir osdrive
temp=directory()
if translate(temp)=translate(netscapeplugindir) | translate(temp)=translate(osdrive'os2\dll') then do
        say 'Please install the Bamba plug-in from another directory'
        say '(do not use the Netscape plug-in directory or \OS2\DLL).'
        say 'Delete the extracted files that are here, then move bos2a.exe'
        say 'to an empty directory and execute it again. Re-run the install'
        say 'from that directory.'
        say ' '
        say 'These are the extracted files here that should be deleted:'
        say '   bmblbra.dll'
        say '   bmblbrv.dll'
        say '   bmbom30.dll'
        say '   daudio.exe'
        say '   daudio.wav'
        say '   license.txt'
        say '   npbamba.dll'
        say '   readme.txt'
        say '   install.cmd'
call quitting('')
end /* if */
return
