/* XWP installation file                             */
/* Place the XWP package here under the name xwp.wpi */
/* Last modified on 03.03.2001                       */

parse arg target source

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")
product_drv       = value("PRODUCT_DRV"      , ,"OS2ENVIRONMENT")
product_path      = value("PRODUCT_PATH"     , ,"OS2ENVIRONMENT")

/* exit if package does not exist */
if stream(inst_dir'\xwp.wpi', 'c', 'query exists') = '' then exit 9

/* set installation environment */
rc = value("WARPIN_DISPLAYPAGES"     , "NO"       , "OS2ENVIRONMENT")
rc = value("WARPIN_INSTALLACTION"    , "ADDREMOVE", "OS2ENVIRONMENT")
rc = value("WARPIN_SELECTPACKAGE1"   , "INSTALL"  , "OS2ENVIRONMENT")
rc = value("WARPIN_TARGETPATH1"      , product_drv"\"product_path, "OS2ENVIRONMENT")
rc = value("WARPIN_SELECTPACKAGE2"   , "INSTALL"  , "OS2ENVIRONMENT")
rc = value("WARPIN_TARGETPATH2"      , product_drv"\"product_path, "OS2ENVIRONMENT")
rc = value("WARPIN_UPDATECONFIGSYS"  , "NO"       , "OS2ENVIRONMENT")
rc = value("WARPIN_INSTALLWPSCLASSES", "YES"      , "OS2ENVIRONMENT")
rc = value("WARPIN_CREATEWPSOBJECTS" , "YES"      , "OS2ENVIRONMENT")
rc = value("WARPIN_IFSAMEDATE"       , "OVERWRITE", "OS2ENVIRONMENT")
rc = value("WARPIN_IFEXISTINGOLDER"  , "OVERWRITE", "OS2ENVIRONMENT")
rc = value("WARPIN_IFEXISTINGNEWER"  , "OVERWRITE", "OS2ENVIRONMENT")

/* run warpin */
cdir = directory()
rc   = directory(get_ini_key(warpin path))
'WarpIN.Exe 'inst_dir'\xwp.wpi'
rc = directory(cdir)

exit


/* get apps key value from OS2.INI */
get_ini_key: procedure

	parse upper arg apps key

	call rxfuncadd sysini, rexxutil, sysini
	call SysIni 'USER', 'All:', 'Apps.'
	do i = 1 to Apps.0	
		if translate(apps.i) = apps then do
			call SysIni 'USER', Apps.i, 'All:', 'Keys'
 	   	do j=1 to Keys.0
 	   		if translate(Keys.j) = key then do
					val = SysIni('USER', Apps.i, Keys.j)
					return val
				end
    	end
  	end
	end

return ''


