/* WarpIN installation, registration and create icons    */
/* Unpack the WarpIn distribution file in this directory */
/* Last modified on 01.23.2001                           */

parse arg target source

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
product_drv       = value("PRODUCT_DRV"      , ,"OS2ENVIRONMENT")
product_path      = value("PRODUCT_PATH"     , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* exit if package does not exist */
if stream(inst_dir'\warpin.exe', 'c', 'query exists') = '' then exit 9

/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* WarpIN kopieren und registrieren */
dest_dir = product_drv'\'product_path
'xcopy 'inst_dir' 'dest_dir'\. /s/e >> 'product_log
'del 'dest_dir'\addonins.cmd >> 'product_log

CreateCollision = 'Replace' 
CreateObjects:
rc = CreateObject( 'WPFolder',,
    'WarpIN',,
    '<WP_DESKTOP>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=NONGRID,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'OBJECTID=<WARPIN_FOLDER>',,
    CreateCollision )
rc = CreateObject( 'WPProgram',,
    'WarpIN',,
    '<WARPIN_FOLDER>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=RUNNING;'||,
        'ASSOCFILTER=*.WPI;'||,
        'ASSOCTYPE=WarpIN Archive;'||,
        'EXENAME='dest_dir'\WARPIN.EXE;'||,
        'STARTUPDIR='dest_dir';'||,
        'PROGTYPE=PM;'||,
        'OBJECTID=<WARPIN_EXE>',,
    CreateCollision )
rc = CreateObject( 'WPProgram',,
    'WarpIN User''s Guide',,
    '<WARPIN_FOLDER>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=RUNNING;'||,
        'EXENAME=VIEW.EXE;'||,
        'STARTUPDIR='dest_dir';'||,
        'PARAMETERS=WPI_USER.INF;'||,
        'PROGTYPE=PM;'||,
        'OBJECTID=<WARPIN_PROGGUIDE>',,
    CreateCollision )
rc = CreateObject( 'WPProgram',,
    'WarpIN Programmer''s Guide and Reference',,
    '<WARPIN_FOLDER>',,
    'NOPRINT=YES;'||,
        'DEFAULTVIEW=RUNNING;'||,
        'EXENAME=VIEW.EXE;'||,
        'STARTUPDIR='dest_dir';'||,
        'PARAMETERS=WPI_PROG.INF;'||,
        'PROGTYPE=PM;'||,
        'OBJECTID=<WARPIN_USERGUIDE>',,
    CreateCollision )
rc = CreateObject( 'WPShadow',,
    'readme.txt',,
    '<WARPIN_FOLDER>',,
    'SHADOWID='dest_dir'\readme.txt',,
    CreateCollision )

/* WarpIN in OS2.Ini eintragen */
rc = SysIni( 'USER', 'WarpIN', 'Path', dest_dir''d2c(0) )
if rc ='' then
  'echo WarpIN has been added to the OS2.INI. >> 'product_log
else
  'echo WarpIN was not added to the OS2.INI. >> 'product_log

exit

CreateObject: procedure expose product_log
    Parse Arg Class, Title, Location, Setup, Collision
    'echo Object ['Title'] erzeugt >> 'product_log
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        'echo Object ['Title' | 'Class'] in ['Location'] nicht erstellt >> 'product_log
return rc
