/* VFAT/EXT2/NTFS IFS installation script                           */
/* Unzip vfat_005.zip to this directory                             */
/* Add ext2flt.flt from ext2_240.zip if you want Linux FS support   */
/* Warning: This driver does not work with LVM installed            */
/* Installing LVM will automatically disable this driver to avoid   */
/* the hang during boot. If you want this limitation removed please */
/* email the author of the driver: daniel.steiner@cch.cerberus.ch   */
/* Last modified on 04.22.2001                                      */

parse arg target source

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* exit if package does not exist */
if stream(inst_dir'\VFAT-OS2.EXE', 'c', 'query exists') = '' then exit 9

/* check if LVM active */
q = 1
partfilt_active = 0
cfgfile = target'\config.sys'
do while lines(cfgfile)
	l.q = linein(cfgfile)
	if translate(l.q) = 'BASEDEV=OS2LVM.DMD' then do
		'echo LVM is active, exiting... >> 'product_log
		exit 8
	end
	if translate(l.q) = 'BASEDEV=PARTFILT.FLT /P 0B,0C /W' then do
		l.q = 'BASEDEV=PARTFILT.FLT /P 0B,0C,83 /W'
		partfilt_active = 1
	end
	if translate(l.q) = 'BASEDEV=PARTFILT.FLT /P 0B,0C'    then do
		l.q = 'BASEDEV=PARTFILT.FLT /P 0B,0C,83'
		partfilt_active = 1
	end
	q=q+1
end
l.0 = q-1
call lineout cfgfile

/* copy files */
'copy 'inst_dir'\MWDD32.SYS   'target'\os2\boot\. >> 'product_log' 2>>&1'
'copy 'inst_dir'\VFAT-OS2.IFS 'target'\os2\.      >> 'product_log' 2>>&1'
'copy 'inst_dir'\remount.exe  'target'\os2\.      >> 'product_log' 2>>&1'
'copy 'inst_dir'\umount.exe   'target'\os2\.      >> 'product_log' 2>>&1'
'copy 'inst_dir'\VFAT_LW.EXE  'target'\os2\.      >> 'product_log' 2>>&1'
'copy 'inst_dir'\VFAT-OS2.EXE 'target'\os2\.      >> 'product_log' 2>>&1'
if stream(inst_dir'\ext2flt.flt', 'c', 'query exists') <> '' then 
	'copy 'inst_dir'\ext2flt.flt  'target'\os2\.    >> 'product_log' 2>>&1'

/* update config.sys */
'copy 'cfgfile target'\os2\install\config.vft >> 'product_log 
'del 'cfgfile' >> 'product_log 
do q=1 to l.0
	rc = lineout(cfgfile, l.q)
end
call lineout cfgfile, ' '
call lineout cfgfile, 'REM UpdCD'
call lineout cfgfile, 'BASEDEV=MWDD32.SYS -q'
if partfilt_active = 0 then call lineout cfgfile, 'BASEDEV=EXT2FLT.FLT'
call lineout cfgfile, 'REM IFS='target'\os2\vfat-os2.ifs -q -cache:256 -errors=continue -VFAT:*'
call lineout cfgfile, 'IFS='target'\os2\vfat-os2.ifs -q -cache:256 -errors=continue -NTFS'
call lineout cfgfile, 'RUN='target'\os2\vfat_lw.exe'
call lineout cfgfile

exit
