/* Installation of LVM and JFS support on Warp 4                     */
/*                                                                   */
/* For LVM support place the following files in this directory:      */
/* vcu.exe, vcu.msg, lvm.msg, lvmh.msg, lvm.exe, lvm.dll, os2lvm.dmd */
/* lvmalert.exe, os2dasd.dmd (from WSeB, ECS or MCP)                 */
/*                                                                   */
/* For JFS support place the following files in this directory       */
/* ujfs.dll, jfs.msg, jfsh.msg, jfs.ifs, jfschk32.exe                */
/*                                                                   */
/* These files can be found in Wseb, eCS, CP, Wseb fixpak 1/2        */
/* You must have a Wseb/eCS/CP license to use these files!           */
/*                                                                   */
/* You must have fixpak 13 or higher installed/incorporated          */
/*                                                                   */
/* 04.21.2001: added code to disable VFAT driver                     */

parse arg target source

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* check */
if stream(inst_dir'\vcu.exe', 'c', 'query exists') = '' then exit 9

/* create temporary command file to run VCU */
tmpcmd = target'\temp.cmd'
'@del 'tmpcmd' >nul 2>>&1'
call lineout tmpcmd, '/* rexx */'
call lineout tmpcmd, 'say ""'
call lineout tmpcmd, 'say "This procedure will call VCU and create the compatibility volumes."'
call lineout tmpcmd, 'say "Caution: do not reboot the system until the Add-On installation finishes!"'
call lineout tmpcmd, 'say ""'
call lineout tmpcmd, '"@'source'\updcd\addons\25_lvmjs\vcu.exe"'
call lineout tmpcmd, 'say "Return code VCU: "rc'
call lineout tmpcmd, 'if rc = 0 then do'
call lineout tmpcmd, '	say "VCU completed"'
call lineout tmpcmd, '	"@echo VCU completed > 'target'\vcuflag.flg"'
call lineout tmpcmd, 'end'
call lineout tmpcmd

/* run cmd file */
'@del 'target'\vcuflag.flg'
call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'
'start "Create Compatibility Volumes" /f /c 'tmpcmd 

/* wait for result or time out */
i = 0
do while i < 60 & stream(target'\vcuflag.flg', 'c', 'query exists') = ''
	'@echo Waiting 60s for VCU to complete. Current wait: 'i's >> 'product_log
	call syssleep 1
	i = i + 1
end

/* log what happened */
if i = 60 then do
	'@echo VCU timed out, installation will be aborted. >> 'product_log
	exit 8
end
else do
	'@echo VCU completed, installation will continoue.  >> 'product_log
end

/* clean up the mess */
'@del 'tmpcmd' >nul 2>>&1'
'@del 'target'\vcuflag.flg >nul 2>>&1'

/* copy LVM files */
dest_dir = target'\OS2'
'copy 'inst_dir'\vcu.exe      'dest_dir'\.        >> 'product_log
'copy 'inst_dir'\vcu.msg      'dest_dir'\.        >> 'product_log
'copy 'inst_dir'\lvm.exe      'dest_dir'\.        >> 'product_log
'copy 'inst_dir'\lvm.msg      'dest_dir'\system\. >> 'product_log
'copy 'inst_dir'\lvmh.msg     'dest_dir'\system\. >> 'product_log
'copy 'inst_dir'\lvmalert.exe 'dest_dir'\system\. >> 'product_log
'copy 'inst_dir'\lvm.dll      'dest_dir'\DLL\.    >> 'product_log
'copy 'inst_dir'\os2lvm.dmd   'dest_dir'\BOOT\.   >> 'product_log
'copy 'inst_dir'\os2dasd.dmd  'dest_dir'\BOOT\.   >> 'product_log

/* load config.sys */
lvm_found = 0
jfs_found = 0
cfgfile = target'\config.sys'
q = 1
do while lines(cfgfile)
	l.q = linein(cfgfile)
	if pos('BASEDEV=OS2LVM.DMD', translate(l.q)) > 0 then lvm_found = 1
	if pos('\OS2\JFS.IFS',       translate(l.q)) > 0 then jfs_found = 1
	/* remove VFAT */
	if pos('BASEDEV=MWDD32.SYS', translate(l.q)) > 0 then iterate
	if pos('VFAT-OS2.IFS',       translate(l.q)) > 0 then iterate
	if pos('VFAT_LW.EXE',        translate(l.q)) > 0 then iterate
	if pos('BASEDEV=EXT2FLT.FLT',translate(l.q)) > 0 then iterate
	q = q+1
end
rc = lineout(cfgfile)
l.0 = q-1

/* backup config.sys */
'copy 'cfgfile target'\os2\install\config.lvm' 
'del 'cfgfile

/* write new config.sys */
do q=1 to l.0
	if pos('BASEDEV=OS2DASD.DMD', translate(l.q)) > 0 & lvm_found = 0 then do
		/* add driver */
		rc = lineout(cfgfile, l.q)
		rc = lineout(cfgfile, ' ')
		rc = lineout(cfgfile, 'REM UpdCD')
		rc = lineout(cfgfile, 'BASEDEV=OS2LVM.DMD')
		lvm_found = 1
	end
	else if pos('BASEDEV=DANIDASD.DMD', translate(l.q)) > 0 & lvm_found = 0 then do
		/* add drivers */
		rc = lineout(cfgfile, ' ')
		rc = lineout(cfgfile, 'REM UpdCD')
		rc = lineout(cfgfile, 'BASEDEV=OS2DASD.DMD')
		rc = lineout(cfgfile, 'BASEDEV=OS2LVM.DMD')
		lvm_found = 1
	end
	/* remove partfilter */
	else if pos('PARTFILT.FLT', translate(l.q)) = 0 then rc = lineout(cfgfile, l.q)

end
rc = lineout(cfgfile)

/* check */
if stream(inst_dir'\jfs.ifs', 'c', 'query exists') = '' then exit

/* copy JFS files */
'copy 'inst_dir'\ujfs.dll     'dest_dir'\DLL\.  >> 'product_log
'copy 'inst_dir'\jfs.msg      'dest_dir'\.      >> 'product_log
'copy 'inst_dir'\jfsh.msg     'dest_dir'\.      >> 'product_log
'copy 'inst_dir'\jfs.ifs      'dest_dir'\.      >> 'product_log
'copy 'inst_dir'\jfschk32.exe 'dest_dir'\.      >> 'product_log

/* load config.sys */
cfgfile = target'\config.sys'
q = 1
do while lines(cfgfile)
	l.q = linein(cfgfile)
	q = q+1
end
rc = lineout(cfgfile)
l.0 = q-1

/* backup config.sys */
'copy 'cfgfile target'\os2\install\config.jfs' 
'del 'cfgfile

/* write new config.sys */
do q=1 to l.0
	if pos('BASEDEV=OS2LVM.DMD', translate(l.q)) > 0 & jfs_found = 0 then do
		/* add driver */
		rc = lineout(cfgfile, 'IFS='target'\OS2\JFS.IFS /AUTOCHECK:* /CACHE:2048')
		jfs_found = 1
	end
	rc = lineout(cfgfile, l.q)
end
rc = lineout(cfgfile)

exit
