/* Install script for the FAT32.IFS driver                                */
/*                                                                        */
/* Place the following files in this directory from the OS2FAT32 package: */
/* FAT32.IFS, CACHEF32.EXE, F32STAT.EXE, MONITOR.EXE, UFAT32.DLL,         */
/* PARTFILT.FLT, fat32.txt, partfilt.txt, partfilt.doc and DISKINFO.EXE.  */
/*                                                                        */
/* Instead of PARTFILT.FLT you might place here DANIDASD.DMD too.         */
/* PARTFILT.FLT (or DANIDASD.DMD) will not be installed if LVM is         */
/* active!!! The LVM enabled version of OS2DASD.DMD is FAT32 aware, so    */
/* you will not need those files.                                         */
/*                                                                        */
/* 05.05.2001: FAT32.IFS will be added before the PROTSHELL line, and not */
/*             after HPFS.IFS. HPFS.IFS is not always in the config.sys.  */ 

parse arg target source

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* exit if package does not exist */
if stream(inst_dir'\fat32.ifs', 'c', 'query exists') = '' then exit 9

/* copy files but do not overwrite them if they are already there */
if stream(target'\os2\FAT32.IFS', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\FAT32.IFS 'target'\os2\. >> 'product_log
end
if stream(target'\os2\CACHEF32.EXE', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\CACHEF32.EXE 'target'\os2\. >> 'product_log
end
if stream(target'\os2\F32STAT.EXE', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\F32STAT.EXE 'target'\os2\. >> 'product_log
end
if stream(target'\os2\MONITOR.EXE', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\MONITOR.EXE 'target'\os2\. >> 'product_log
end
if stream(target'\os2\DISKINFO.EXE', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\DISKINFO.EXE 'target'\os2\. >> 'product_log
end
if stream(target'\os2\DLL\UFAT32.DLL', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\UFAT32.DLL 'target'\os2\dll\. >> 'product_log
end
if stream(target'\os2\boot\PARTFILT.FLT', 'c', 'query exists') = '' then do
  if stream(inst_dir'\PARTFILT.FLT', 'c', 'query exists') <> '' then 'copy 'inst_dir'\PARTFILT.FLT 'target'\os2\boot\. >> 'product_log
end
if stream(target'\os2\boot\DANIDASD.DMD', 'c', 'query exists') = '' then do
	if stream(inst_dir'\DANIDASD.DMD', 'c', 'query exists') <> '' then 'copy 'inst_dir'\DANIDASD.DMD 'target'\os2\boot\. >> 'product_log
end
if stream(target'\os2\help\fat32.txt', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\fat32.txt 'target'\os2\help\. >> 'product_log
end
if stream(target'\os2\help\partfilt.txt', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\partfilt.txt 'target'\os2\help\. >> 'product_log
end
if stream(target'\os2\help\partfilt.doc', 'c', 'query exists') = '' then do
	'copy 'inst_dir'\partfilt.doc 'target'\os2\help\. >> 'product_log
end

/* change config.sys if needed */
cfgfile = target'\config.sys'
q = 1
lvm_active = 0
do while lines(cfgfile)
	l.q = linein(cfgfile)
	if pos('FAT32.IFS',  translate(l.q)) > 0 then exit /* the driver is already added, leave the config.sys alone */
	if pos('OS2LVM.DMD', translate(l.q)) > 0 then lvm_active = 1
	q = q+1
end
rc = lineout(cfgfile)
l.0 = q-1

/* backup config.sys */
'copy 'cfgfile target'\os2\install\config.f32' 
'del 'cfgfile
gevonden = 0
do q=1 to l.0
	if pos('PROTSHELL=', translate(l.q)) > 0 then do
		/* add FAT32 driver after PROTSHELL= */
		gevonden = 1
	end
	if (pos('OS2DASD.DMD', translate(l.q)) = 0 | stream(inst_dir'\DANIDASD.DMD', 'c', 'query exists') = '') then rc = lineout(cfgfile, l.q)
	if gevonden = 1 then do
		rc = lineout(cfgfile, ' ')
		rc = lineout(cfgfile, 'REM UpdCD')
		rc = lineout(cfgfile, 'IFS='target'\OS2\FAT32.IFS /CACHE:2048')
		rc = lineout(cfgfile, 'CALL='target'\OS2\CACHEF32.EXE')
		if lvm_active = 0 then do
			if stream(inst_dir'\DANIDASD.DMD', 'c', 'query exists') <> '' then rc = lineout(cfgfile, 'BASEDEV=DANIDASD.DMD') 
			else rc = lineout(cfgfile, 'BASEDEV=PARTFILT.FLT /P 0B,0C /W') 
		end
		else do
			if stream(inst_dir'\DANIDASD.DMD', 'c', 'query exists') <> '' then rc = lineout(cfgfile, 'BASEDEV=OS2DASD.DMD') 
		end
		gevonden = 0
	end
end
rc = lineout(cfgfile)

exit
