/* Scrollmouse installation script                                  */
/* Run scrollms.exe in this directory to get the installation files */
/* Last modified on 04.21.2001                                      */

parse arg target source

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* exit if package does not exist */
if stream(inst_dir'\mouinst.exe', 'c', 'query exists') = '' then exit 9

/* installation */
inst_dir'\mouinst.exe >> 'product_log' 2>>&1'

/* check if it is installed */
if stream(target'\os2\dll\WPSTKMRI.dll', 'c', 'query exists') = '' then do
	/* install manually */
	'copy 'target'\os2\boot\mouse.sys 'target'\os2\boot\mouse.bak >>  'product_log' 2>>&1'
	'copy 'inst_dir'\mouse.sys 'target'\os2\boot\. >>  'product_log' 2>>&1'
	lang = translate(value("LANG", ,"OS2ENVIRONMENT"))
	select
		when lang = 'FR_BE' | lang = 'FR_CA' | lang = 'FR_CH' | lang = 'FR_FR' then lang = 'FR'
		when lang = 'EN_US' | lang = 'EN_GB' | lang = 'EN_JP' then lang = 'EN'
		when lang = 'DE_DE' | lang = 'DE_CH' then lang = 'DE'
		when lang = 'NL_BE' | lang = 'NL_NL' then lang = 'NL'
		when lang = 'PT_BR' | lang = 'PT_PT' then lang = 'BR'
		when lang = 'ZH_SC' | lang = 'ZH_CN' then lang = 'SC'
		when lang = 'DA_DK' then lang = 'DK'
		when lang = 'ES_ES' then lang = 'ES'
		when lang = 'FI_FI' then lang = 'FI'
		when lang = 'IT_IT' then lang = 'IT'
		when lang = 'JP_JP' then lang = 'JP'
		when lang = 'NO_NO' then lang = 'NO'
		when lang = 'SV_SE' then lang = 'SV'
		when lang = 'ZH_TW' then lang = 'TW'
		otherwise lang = 'EN'
	end
	'copy 'inst_dir'\WPSTKMRI.'lang target'\os2\dll\wpstkmri.dll >>  'product_log' 2>>&1'
	call RxFuncAdd 'SysRegisterObjectClass', 'RexxUtil', 'SysRegisterObjectClass';
	call SysRegisterObjectClass "WPStickMouse", "WPSTKMOU"
	call RxFuncAdd 'SysCreateObject', 'RexxUtil', 'SysCreateObject';
	call SysCreateObject "WPStickMouse", "ScrollPoint Mouse", "<WP_APPSFOLDER>", "OBJECTID=<SCROLL_MOUSE>"
end

exit
