/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/* PROGRAM NAME   : Sample BIDI Protocol Converter                          */
/* AUTHOR         : Pat D                                                   */
/* FILENAME       : protcnv.h                                               */
/* DATE WRITTEN   : 12-17-93                                                */
/* DESCRIPTION    : Header file for the sample protocol converter that      */
/*                  defines the structures needed                           */
/*                                                                          */
/****************************************************************************/


#define NO_ERROR                     0
#define ERROR_MORE_DATA              234
#define ERROR_INSUFFICIENT_BUFFER    122

/*
 * Base of all query commands ( will be > )
 */
#define  BIDI_Q_BASE               0x00008000

typedef struct _CONVERTERDATA
{
   HMTX     semPMSPL;
   HMODULE hModule;
   ULONG lfModified;
   PSZ pszPortName;
   USHORT usSaveTimeOut;
   USHORT usOrgTimeOut;
   BOOL   fOrgShareAccess ;
   BOOL   fShareAccess ;
} CONVERTERDATA, *PCONVERTERDATA;

/*
** Per-request instance structure for cached information.
** Only one process gets access to this memory.
*/
typedef struct _REQINST
{
  USHORT signature;                    /* signature word for validating
                                          REQINST                             */
  USHORT usDummy;
  ULONG  cb;                           /* number of bytes allocated          */
  struct _REQINST    *pNext;           /* pointer to next struct in list     */
  PSZ    pszPortName;                  /* Port name for this instance data   */
  ULONG  ulType;                       /* type of query and options          */
  ULONG  ulCmdCode;                    /* generic command code               */
  PVOID  pInData;                      /* pointer to input data              */
  ULONG  cbInData;                     /* length of input data               */
  PVOID  pOutData;                     /* pointer to output buffer           */
  PULONG pcbOutData;                   /* pointer to output buffer length    */
  ULONG  rc;                           /* return code from xlatecmd          */
  BOOL   fRespRecv;                    /* flag indicating responses left
                                          0 means all received               */
  ULONG  cCmdsNeeded;                  /* number of commands to send         */
  ULONG  cCmdsSent;                    /* number of commands sent            */
  ULONG  cRespRecv;                    /* number of responses received       */
  ULONG  TimeSent;
} REQINST, *PREQINST;

#define  RQ_SIGNATURE  0x5152       /* 'RQ' is the signature value        */

typedef struct _PASSRESPINST {
  USHORT signature;                    /* signature word for validating
                                          PASSRESPINST                        */
  USHORT usDummy;
  ULONG  cb;                           /* number of bytes allocated          */
  struct _PASSRESPINST *pNext;         /* pointer to next struct in list     */
  ULONG  cbInData;                     /* length of input data               */
  PVOID  pInData;                      /* pointer to input data              */
  ULONG  ulAlertId;
  ULONG  cAlertSes;
  ULONG  cAlertSesRet;
} PASSRESPINST;
typedef PASSRESPINST *PPASSRESPINST;

#define  PR_SIGNATURE  0x5250       /* 'PR' is the signature value        */

#define  MAX_PASSTHRU_RESP   5
#define  MAX_ALERT_RESP      5

typedef struct _ALERTSESINST {
  USHORT signature;                    /* signature word for validating
                                          ALERTSESINST                       */
  USHORT usDummy;
  ULONG  cb;                           /* number of bytes allocated          */
  struct _ALERTSESINST *pNext;         /* pointer to next struct in list     */
  struct _ALERTSESINST *pNextAlert;    /* pointer to next struct in list     */
  PVOID  pPortInst;                    /* pointer to the port instance       */
                                       /* containing this alert session      */
  ULONG  ulNextAlertId;                /* Next Alert Id to read for session  */
  ULONG  ulLastRead;                   /* Time of last read alert session    */
  ULONG  ulReadCount;                  /* Count of read alerts for session   */
} ALERTSESINST;
typedef ALERTSESINST *PALERTSESINST;

#define  AS_SIGNATURE  0x5341       /* 'AS' is the signature value        */

/*
** Per-port instance structure for cached information.
** Only one process gets access to this memory.
*/
typedef struct _PORTINST
{
  USHORT signature;                    /* signature word for validating
                                          PORTINST                           */
  USHORT usDummy;
  ULONG  cb;                           /* number of bytes allocated          */
  struct _PORTINST    *pNext;          /* pointer to next struct in list     */
  PSZ    pszPort;                      /* Port name for this instance data   */
  PID    uPid;                         /* Process that created this instance */
                                       /*    structure and owns this memory  */
  ULONG  fsStatus;                     /* Status bits (see PI_ below)        */
  ULONG  ulJobSending;                 /* Printer Job ID sending to printer  */
                                       /*  (ie: inside PdOpen/PdClose)       */
  ULONG  ulJobInterpreter;             /* Printing Job's interpreter ID      */
  ULONG  ulJobPrinting;                /* Spooler Job ID being printed       */
  ULONG  ulBidiFlags;                  /* Flags from PRTPORT structure       */
  HMTX   semPortSem;                   /* Semaphore to control access to port*/
  HEV    semQueries;                   /* Event semaphore for queries        */
  PREQINST pReqList;                   /* Head of list of requests for the   */
                                       /* port                               */
  PREQINST pReqLast;                   /* Last element of the request list   */
  BOOL   fPassthruSes;                 /* Flag indicating whether passthru
                                          session has been started           */
  ULONG  cPassRespInst;                /* Count of passthru response in cache*/
  PPASSRESPINST pPassRespList;         /* Head of list of passthru responses */
  PPASSRESPINST pPassRespLast;         /* Last passthru response in list     */
  ULONG  cAlertRespInst;               /* Count of Alert responses in cache  */
  ULONG  ulNextAlertId;                /* Next alert id to use for the port  */
  PPASSRESPINST pAlertRespList;        /* Head of list of alert responses    */
  PPASSRESPINST pAlertRespLast;        /* Last alert response in list        */
  ULONG  cAlertSes;                    /* Count of alert sessions            */
  ULONG  cAlertRead;
  PALERTSESINST pAlertSesList;         /* Head of list of alert sessions     */
  PALERTSESINST pAlertSesLast;         /* Last alert sesssion in list        */
  ULONG  fAlertLevel;
  ULONG  cbAlertLevel;
  PBYTE  pAlertLevel;
  ULONG  fSW;
  ULONG  cbSW;
  PBYTE  pSW;
  ULONG  fDevice;
  ULONG  cbDevice;
  PBYTE  pDevice;
  ULONG  fInterpreter;
  ULONG  cbInterpreter;
  PBYTE  pInterpreter;
  ULONG  fInputbins;
  ULONG  cbInputbins;
  PBYTE  pInputbins;
  ULONG  fOutputbins;
  ULONG  cbOutputbins;
  PBYTE  pOutputbins;
  ULONG  fOptions;
  ULONG  cbOptions;
  PBYTE  pOptions;
  ULONG  fFonts;
  ULONG  cbFonts;
  PBYTE  pFonts;
  ULONG  fJobscomp;
  ULONG  cbJobscomp;
  PBYTE  pJobscomp;
  ULONG  fJobsqueued;
  ULONG  cbJobsqueued;
  PBYTE  pJobsqueued;
  ULONG  fStatus;
  ULONG  cbStatus;
  PBYTE  pStatus;
} PORTINST, *PPORTINST;

#define  CN_SIGNATURE  0x4E43       /* 'CN' is the signature value        */

#define  CN_PORT_FREED  0x00000001

typedef struct _FREEMEM {
    USHORT      signature;      /* signature word for validating memory */
    USHORT usDummy;
    ULONG  cb;                           /* number of bytes allocated          */
    struct _FREEMEM *pNext;
} FREEMEM;
typedef FREEMEM *PFREEMEM;

#define FR_SIGNATURE    0x5246  /* "FR" is the signature value */

#ifdef MAINPROTCNV

PPORTINST pPortList = NULL;             /* List of port instanace structures  */
PPORTINST pPortLast = NULL;             /* Last port in the list              */
HMTX      semProtCnv = NULLHANDLE;      /* Semaphore to control access        */
PVOID     pHeapBase = NULL;             /* Pointer to start of memory heap    */
HMODULE   hCnvMod = NULLHANDLE;         /* Module which loaded protocol conv  */
BOOL      fInitialized = FALSE;         /* Is protocol converter initialized  */
PALERTSESINST pAlertSesList = NULL;     /* Head of list of alert sessions     */
PALERTSESINST pAlertSesLast = NULL;     /* Last alert sesssion in list        */

#else

extern
PPORTINST pPortList;                    /* List of port instanace structures  */
extern
PPORTINST pPortLast;                    /* Last port in the list              */
extern
HMTX      semProtCnv;                   /* Semaphore to control access        */
extern
PVOID     pHeapBase;                    /* Pointer to start of memory heap    */
extern
HMODULE   hCnvMod;                      /* Module which loaded protocol conv  */
extern
BOOL      fInitialized;                 /* Is protocol converter initialized  */
extern
PALERTSESINST pAlertSesList;            /* Head of list of alert sessions     */
extern
PALERTSESINST pAlertSesLast;            /* Last alert sesssion in list        */

#endif

#define  CNV_TIMEOUT    300000          // 5 Minutes

