/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/* PROGRAM NAME   : Sample BIDI protocol Converter                          */
/* AUTHOR         : Pat D                                                   */
/* FILENAME       : init.c                                                  */
/* DATE WRITTEN   : 12-17-93                                                */
/* DESCRIPTION    : DLL Initialization/Termination routines                 */
/*                                                                          */
/****************************************************************************/

#define INCL_BASE
#define INCL_DOS
#define INCL_SPL
#define INCL_SPLBIDI
#include <os2.h>
#define MAINPROTCNV
#include "protcnv.h"
#include "protcnv1.h"
#include "cnvproto.h"

/*
 * Local function prototypes
 */
BOOL ProtLoadProc( HMODULE hModule );
BOOL ProtTermProc ( VOID );

/****************************************************************************
 *
 * FUNCTION NAME = _DLL_InitTerm
 *
 * DESCRIPTION   = DLL initialization/termination routine
 *
 * INPUT         = hModule     - Module handle for this DLL(PMPRINT.QPR)
 *               = ulFlag      - Reason for call
 *                                         0 - DLL firstime load for process
 *                                         1 - DLL being removed from process
 *
 *
 * OUTPUT        = Calls ProtLoadProc to initialize per process data
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

ULONG _System _DLL_InitTerm(HMODULE hModule, ULONG ulFlag)
{

   switch (ulFlag)
   {
     case 0:
       if (ProtLoadProc ( hModule ) == 0) return 0;
       break;
    case 1:
       if (ProtTermProc () == 0) {
          return(0);
       }
       break;

     default:
       return 0;
   }
   /* Return success */
   return( 1 );
}

/****************************************************************************
 *
 * FUNCTION NAME = ProtLoadProc
 *
 * DESCRIPTION   = Initialization to be done when loading the protocol
 *                 converter.
 *
 * INPUT         = hModule     - Module handle for this DLL(PROTCNV.CNV)
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

BOOL ProtLoadProc( HMODULE hModule ) {

    ULONG rc = 0;

    hCnvMod = hModule;
    /*
     * Setup Memory heap, will be process memory not shared.
     * Allocate memory sparse, will be committed by DosSubAllocMem as
     * needed.  Size of heap is 1 Meg.
     */
    rc = DosAllocMem (&pHeapBase, 0x100000, PAG_READ | PAG_WRITE );
    if (rc) {
        return(0);
    }
    rc = DosSubSetMem ( pHeapBase, DOSSUB_INIT | DOSSUB_SPARSE_OBJ,
                        0x100000 );
    if (rc) {
        return(0);
    }
    /*
     * Setup Protocol Converter semaphore
     */
    rc = DosCreateMutexSem ( 0,
                             &semProtCnv,
                             0,
                             FALSE );       // Create Unowned
    if (rc) {
        return(0);
    }

    return(1);

}

/****************************************************************************
 *
 * FUNCTION NAME = ProtTermProc
 *
 * DESCRIPTION   = Cleanup to be done when unloading the protocol
 *                 converter.
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 * NOTE: This routine expects to have exclusive access to the protocol
 *       converter since the spooler is the only process which will call it.
 *
 ****************************************************************************/

BOOL ProtTermProc ( VOID ) {

    ULONG rc = 0;

    /*
     * Check for existence of Memory Heap
     */
    if (pHeapBase) {
        /*
         * Clean up port structures
         */
        FreeAllPorts ();
        /*
         * Clean up Memory Heap
         */
        rc = DosSubUnsetMem ( pHeapBase );
        if (rc) {
            return(0);
        }
        rc = DosFreeMem ( pHeapBase );
        if (rc) {
            return(0);
        }
        /*
         * Close Protocol Converter Semaphore, will be created after heap
         */
        rc = DosCloseMutexSem ( semProtCnv );
        if (rc) {
            return(0);
        }
    }

    return(1);

}

