/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/* PROGRAM NAME   : Sample BIDI Protocol Converter                          */
/* AUTHOR         : Pat D                                                   */
/* FILENAME       : getcmd.c                                                */
/* DATE WRITTEN   : 02-03-94                                                */
/* DESCRIPTION    : Routines to get response from cache if possible         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                           Routines In File                               */
/*                      GetQAlertlevelCmd()                                 */
/*                      GetQDeviceCmd()                                     */
/*                      GetQInterpreterCmd()                                */
/*                      GetQInputbinsCmd()                                  */
/*                      GetQOutputbinsCmd()                                 */
/*                      GetQOptionsCmd()                                    */
/*                      GetQFontsCmd()                                      */
/*                      GetQJobscompCmd()                                   */
/*                      GetQJobsqueuedCmd()                                 */
/*                      GetQStatusCmd()                                     */
/****************************************************************************/

#define INCL_BASE
#define INCL_DOS
#define INCL_SPL
#define INCL_SPLBIDI
#define INCL_SPLERRORS
#include <os2.h>
#include <string.h>
#include "protcnv.h"
#include "protcnv1.h"
#include "cnvproto.h"

/****************************************************************************
 *
 * FUNCTION NAME = GetQAlertlevelCmd
 *
 * DESCRIPTION   = Determine if there is any data in the Passthru buffer
 *                 that has not already been read.  If so, return the data
 *                 to the caller.  [No commands will be sent to the port
 *                 driver.]
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pOutData    - Return buffer
 *               = pcbOutData  - Points to length of output buffer
 *                               On entry this is set to length of output
 *                                 buffer passed in.
 *                               On exit this is updated with length of data
 *                                 returned.
 *               = pfGotResp   - Pointer to boolean value indicating whether
 *                               response was obtained
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

ULONG GetQAlertlevelCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                          PBOOL pfGotResp) {

    PPORTINST pPortInst = NULL;
    ULONG rc = 0;

  EnterCnvSem();
    /*
     * Find port instance data
     */
    if (!(pPortInst = FindPort( pszPortName ))) {
      LeaveCnvSem();
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Check for cached data
     */
    if (pPortInst->pAlertLevel) {
        /*
         * If enough room in output buffer, copy data to it
         */
        if (pPortInst->cbAlertLevel <= *pcbOutData) {
            memcpy ( pOutData, pPortInst->pAlertLevel,
                     pPortInst->cbAlertLevel );
            *pcbOutData = pPortInst->cbAlertLevel;
        } else {
            rc = NERR_BufTooSmall;
        }
        *pfGotResp = TRUE;
    }

  LeaveCnvSem();

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = GetQDeviceCmd
 *
 * DESCRIPTION   = Determine if there is any data in the Passthru buffer
 *                 that has not already been read.  If so, return the data
 *                 to the caller.  [No commands will be sent to the port
 *                 driver.]
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pOutData    - Return buffer
 *               = pcbOutData  - Points to length of output buffer
 *                               On entry this is set to length of output
 *                                 buffer passed in.
 *                               On exit this is updated with length of data
 *                                 returned.
 *               = pfGotResp   - Pointer to boolean value indicating whether
 *                               response was obtained
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

ULONG GetQDeviceCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                      PBOOL pfGotResp) {

    PPORTINST pPortInst = NULL;
    ULONG rc = 0;

  EnterCnvSem();
    /*
     * Find port instance data
     */
    if (!(pPortInst = FindPort( pszPortName ))) {
      LeaveCnvSem();
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Check for cached data
     */
    if ( pPortInst->pDevice ) {
        /*
         * If enough room in output buffer, copy data to it
         */
        if (pPortInst->cbDevice <= *pcbOutData) {
            memcpy ( pOutData, pPortInst->pDevice, pPortInst->cbDevice );
            *pcbOutData = pPortInst->cbDevice;
        } else {
            rc = NERR_BufTooSmall;
        }
        *pfGotResp = TRUE;
    }

  LeaveCnvSem();

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = GetQInterpreterCmd
 *
 * DESCRIPTION   = Determine if there is any data in the Passthru buffer
 *                 that has not already been read.  If so, return the data
 *                 to the caller.  [No commands will be sent to the port
 *                 driver.]
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pOutData    - Return buffer
 *               = pcbOutData  - Points to length of output buffer
 *                               On entry this is set to length of output
 *                                 buffer passed in.
 *                               On exit this is updated with length of data
 *                                 returned.
 *               = pfGotResp   - Pointer to boolean value indicating whether
 *                               response was obtained
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

ULONG GetQInterpreterCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                           PBOOL pfGotResp) {

    PPORTINST pPortInst = NULL;
    ULONG rc = 0;

  EnterCnvSem();
    /*
     * Find port instance data
     */
    if (!(pPortInst = FindPort( pszPortName ))) {
      LeaveCnvSem();
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Check for cached data
     */
    if ( pPortInst->pInterpreter ) {
        /*
         * If enough room in output buffer, copy data to it
         */
        if (pPortInst->cbInterpreter <= *pcbOutData) {
            memcpy ( pOutData, pPortInst->pInterpreter,
                      pPortInst->cbInterpreter );
            *pcbOutData = pPortInst->cbInterpreter;
        } else {
            rc = NERR_BufTooSmall;
        }
        *pfGotResp = TRUE;
    }

  LeaveCnvSem();

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = GetQInputbinsCmd
 *
 * DESCRIPTION   = Determine if there is any data in the Passthru buffer
 *                 that has not already been read.  If so, return the data
 *                 to the caller.  [No commands will be sent to the port
 *                 driver.]
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pOutData    - Return buffer
 *               = pcbOutData  - Points to length of output buffer
 *                               On entry this is set to length of output
 *                                 buffer passed in.
 *                               On exit this is updated with length of data
 *                                 returned.
 *               = pfGotResp   - Pointer to boolean value indicating whether
 *                               response was obtained
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

ULONG GetQInputbinsCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                         PBOOL pfGotResp) {

    PPORTINST pPortInst = NULL;
    ULONG rc = 0;

  EnterCnvSem();
    /*
     * Find port instance data
     */
    if (!(pPortInst = FindPort( pszPortName ))) {
      LeaveCnvSem();
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Check for cached data
     */
    if ( pPortInst->pInputbins ) {
        /*
         * If enough room in output buffer, copy data to it
         */
        if (pPortInst->cbInputbins <= *pcbOutData) {
            memcpy ( pOutData, pPortInst->pInputbins,
                      pPortInst->cbInputbins );
            *pcbOutData = pPortInst->cbInputbins;
        } else {
            rc = NERR_BufTooSmall;
        }
        *pfGotResp = TRUE;
    }

  LeaveCnvSem();

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = GetQOutputbinsCmd
 *
 * DESCRIPTION   = Determine if there is any data in the Passthru buffer
 *                 that has not already been read.  If so, return the data
 *                 to the caller.  [No commands will be sent to the port
 *                 driver.]
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pOutData    - Return buffer
 *               = pcbOutData  - Points to length of output buffer
 *                               On entry this is set to length of output
 *                                 buffer passed in.
 *                               On exit this is updated with length of data
 *                                 returned.
 *               = pfGotResp   - Pointer to boolean value indicating whether
 *                               response was obtained
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

ULONG GetQOutputbinsCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                          PBOOL pfGotResp) {

    PPORTINST pPortInst = NULL;
    ULONG rc = 0;

  EnterCnvSem();
    /*
     * Find port instance data
     */
    if (!(pPortInst = FindPort( pszPortName ))) {
      LeaveCnvSem();
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Check for cached data
     */
    if ( pPortInst->pOutputbins ) {
        /*
         * If enough room in output buffer, copy data to it
         */
        if (pPortInst->cbOutputbins <= *pcbOutData) {
            memcpy ( pOutData, pPortInst->pOutputbins,
                      pPortInst->cbOutputbins );
            *pcbOutData = pPortInst->cbOutputbins;
        } else {
            rc = NERR_BufTooSmall;
        }
        *pfGotResp = TRUE;
    }

  LeaveCnvSem();

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = GetQOptionsCmd
 *
 * DESCRIPTION   = Determine if there is any data in the Passthru buffer
 *                 that has not already been read.  If so, return the data
 *                 to the caller.  [No commands will be sent to the port
 *                 driver.]
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pOutData    - Return buffer
 *               = pcbOutData  - Points to length of output buffer
 *                               On entry this is set to length of output
 *                                 buffer passed in.
 *                               On exit this is updated with length of data
 *                                 returned.
 *               = pfGotResp   - Pointer to boolean value indicating whether
 *                               response was obtained
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

ULONG GetQOptionsCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                       PBOOL pfGotResp) {

    PPORTINST pPortInst = NULL;
    ULONG rc = 0;

  EnterCnvSem();
    /*
     * Find port instance data
     */
    if (!(pPortInst = FindPort( pszPortName ))) {
      LeaveCnvSem();
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Check for cached data
     */
    if ( pPortInst->pOptions ) {
        /*
         * If enough room in output buffer, copy data to it
         */
        if (pPortInst->cbOptions <= *pcbOutData) {
            memcpy ( pOutData, pPortInst->pOptions,
                      pPortInst->cbOptions );
            *pcbOutData = pPortInst->cbOptions;
        } else {
            rc = NERR_BufTooSmall;
        }
        *pfGotResp = TRUE;
    }

  LeaveCnvSem();

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = GetQFontsCmd
 *
 * DESCRIPTION   = Determine if there is any data in the Passthru buffer
 *                 that has not already been read.  If so, return the data
 *                 to the caller.  [No commands will be sent to the port
 *                 driver.]
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pOutData    - Return buffer
 *               = pcbOutData  - Points to length of output buffer
 *                               On entry this is set to length of output
 *                                 buffer passed in.
 *                               On exit this is updated with length of data
 *                                 returned.
 *               = pfGotResp   - Pointer to boolean value indicating whether
 *                               response was obtained
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

ULONG GetQFontsCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                     PBOOL pfGotResp) {

    PPORTINST pPortInst = NULL;
    ULONG rc = 0;

  EnterCnvSem();
    /*
     * Find port instance data
     */
    if (!(pPortInst = FindPort( pszPortName ))) {
      LeaveCnvSem();
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Check for cached data
     */
    if ( pPortInst->pFonts ) {
        /*
         * If enough room in output buffer, copy data to it
         */
        if (pPortInst->cbFonts <= *pcbOutData) {
            memcpy ( pOutData, pPortInst->pFonts,
                      pPortInst->cbFonts );
            *pcbOutData = pPortInst->cbFonts;
        } else {
            rc = NERR_BufTooSmall;
        }
        *pfGotResp = TRUE;
    }

  LeaveCnvSem();

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = GetQJobscompCmd
 *
 * DESCRIPTION   = Determine if there is any data in the Passthru buffer
 *                 that has not already been read.  If so, return the data
 *                 to the caller.  [No commands will be sent to the port
 *                 driver.]
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pOutData    - Return buffer
 *               = pcbOutData  - Points to length of output buffer
 *                               On entry this is set to length of output
 *                                 buffer passed in.
 *                               On exit this is updated with length of data
 *                                 returned.
 *               = pfGotResp   - Pointer to boolean value indicating whether
 *                               response was obtained
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

ULONG GetQJobscompCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                        PBOOL pfGotResp) {

    PPORTINST pPortInst = NULL;
    ULONG rc = 0;

  EnterCnvSem();
    /*
     * Find port instance data
     */
    if (!(pPortInst = FindPort( pszPortName ))) {
      LeaveCnvSem();
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Check for cached data
     */
    if ( pPortInst->pJobscomp ) {
        /*
         * If enough room in output buffer, copy data to it
         */
        if (pPortInst->cbJobscomp <= *pcbOutData) {
            memcpy ( pOutData, pPortInst->pJobscomp,
                      pPortInst->cbJobscomp );
            *pcbOutData = pPortInst->cbJobscomp;
        } else {
            rc = NERR_BufTooSmall;
        }
        *pfGotResp = TRUE;
    }

  LeaveCnvSem();

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = GetQJobsqueuedCmd
 *
 * DESCRIPTION   = Determine if there is any data in the Passthru buffer
 *                 that has not already been read.  If so, return the data
 *                 to the caller.  [No commands will be sent to the port
 *                 driver.]
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pOutData    - Return buffer
 *               = pcbOutData  - Points to length of output buffer
 *                               On entry this is set to length of output
 *                                 buffer passed in.
 *                               On exit this is updated with length of data
 *                                 returned.
 *               = pfGotResp   - Pointer to boolean value indicating whether
 *                               response was obtained
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

ULONG GetQJobsqueuedCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                          PBOOL pfGotResp) {

    PPORTINST pPortInst = NULL;
    ULONG rc = 0;

  EnterCnvSem();
    /*
     * Find port instance data
     */
    if (!(pPortInst = FindPort( pszPortName ))) {
      LeaveCnvSem();
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Check for cached data
     */
    if ( pPortInst->pJobsqueued ) {
        /*
         * If enough room in output buffer, copy data to it
         */
        if (pPortInst->cbJobsqueued <= *pcbOutData) {
            memcpy ( pOutData, pPortInst->pJobsqueued,
                      pPortInst->cbJobsqueued );
            *pcbOutData = pPortInst->cbJobsqueued;
        } else {
            rc = NERR_BufTooSmall;
        }
        *pfGotResp = TRUE;
    }

  LeaveCnvSem();

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = GetQStatusCmd
 *
 * DESCRIPTION   = Determine if there is any data in the Passthru buffer
 *                 that has not already been read.  If so, return the data
 *                 to the caller.  [No commands will be sent to the port
 *                 driver.]
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pOutData    - Return buffer
 *               = pcbOutData  - Points to length of output buffer
 *                               On entry this is set to length of output
 *                                 buffer passed in.
 *                               On exit this is updated with length of data
 *                                 returned.
 *               = pfGotResp   - Pointer to boolean value indicating whether
 *                               response was obtained
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

ULONG GetQStatusCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                          PBOOL pfGotResp) {

    PPORTINST pPortInst = NULL;
    ULONG rc = 0;

  EnterCnvSem();
    /*
     * Find port instance data
     */
    if (!(pPortInst = FindPort( pszPortName ))) {
      LeaveCnvSem();
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Check for cached data
     */
    if ( pPortInst->pStatus ) {
        /*
         * If enough room in output buffer, copy data to it
         */
        if (pPortInst->cbStatus <= *pcbOutData) {
            memcpy ( pOutData, pPortInst->pStatus,
                      pPortInst->cbStatus );
            *pcbOutData = pPortInst->cbStatus;
        } else {
            rc = NERR_BufTooSmall;
        }
        *pfGotResp = TRUE;
    }

  LeaveCnvSem();

    return(rc);

}

