/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/* PROGRAM NAME   : Sample BIDI protocol Converter                          */
/* AUTHOR         : Pat D                                                   */
/* FILENAME       : cnvproto.h                                              */
/* DATE WRITTEN   : 11-03-93                                                */
/* DESCRIPTION    : Function prototypes for the skeleton protocol converter */
/*                                                                          */
/****************************************************************************/

/*
 * In util.c
 */
PVOID AllocCnvMem ( ULONG cb );
ULONG FreeCnvMem ( PVOID pMem, ULONG cb );
ULONG EnterCnvSem ( VOID );
ULONG LeaveCnvSem ( VOID );
VOID CnvError ( ULONG ulCode, ULONG ulType );
VOID CnvPanic ( ULONG ulCode, ULONG ulType );
VOID CnvWarning ( ULONG ulCode, ULONG ulType );
PPORTINST AllocatePort ( PSZ pszName );
BOOL FreePort ( PPORTINST pPortInst );
ULONG FreeAllPorts ( VOID );
BOOL AddPort ( PSZ pszName, PPORTINST pPortInst );
PPORTINST FindPort ( PSZ pszName );
BOOL CheckPort ( PSZ pszName );
PPORTINST RemovePort ( PSZ pszName );
PREQINST NewRequest ( PSZ pszPortName,
                      ULONG ulCommand,
                      PVOID pInData,
                      ULONG cbInData,
                      PVOID pOutData,
                      PULONG pcbOutData,
                      ULONG cCmds );
ULONG AddReq ( PPORTINST pPortInst, PREQINST pReqInst );
ULONG RemoveReq ( PSZ pszPortName, PREQINST pReqInst );
ULONG GetWrapperSize ( VOID );
PVOID AddWrapper ( PVOID pBuf, PVOID pData, ULONG cbData );
PVOID RemoveWrapper ( PVOID pData, PULONG pcbData );

/*
 * In buildcmd.c
 */
ULONG BuildQAlertlevelCmd ( PSZ pszPortName, PMULTICMD *ppMultiCmd );

ULONG BuildQDeviceCmd ( PSZ pszPortName, PMULTICMD *ppMultiCmd );

ULONG BuildQInterpreterCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                             PMULTICMD *ppMultiCmd );

ULONG BuildQInputbinsCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                           PMULTICMD *ppMultiCmd );

ULONG BuildQOutputbinsCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                            PMULTICMD *ppMultiCmd );

ULONG BuildQOptionsCmd ( PSZ pszPortName, PMULTICMD *ppMultiCmd );

ULONG BuildQFontsCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                       PMULTICMD *ppMultiCmd );

ULONG BuildQJobscompCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                          PMULTICMD *ppMultiCmd );

ULONG BuildQJobsqueuedCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                            PMULTICMD *ppMultiCmd );

ULONG BuildQStatusCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                        PMULTICMD *ppMultiCmd );

ULONG BuildQJobidCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                       PMULTICMD *ppMultiCmd );

ULONG BuildQRespfmtCmd ( PVOID pOutData, PULONG pcbOutData );

ULONG BuildSetStartjobCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                            PMULTICMD *ppMultiCmd );

ULONG BuildSetEndjobCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                          PMULTICMD *ppMultiCmd );

ULONG BuildSetHoldjobCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                           PMULTICMD *ppMultiCmd );

ULONG BuildSetReleasejobCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                              PMULTICMD *ppMultiCmd );

ULONG BuildSetCanceljobCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                             PMULTICMD *ppMultiCmd );

ULONG BuildSetAlertlevelCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                              PMULTICMD *ppMultiCmd );

ULONG BuildSetResetCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                         PMULTICMD *ppMultiCmd );

ULONG BuildSetTermCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                        PMULTICMD *ppMultiCmd );

ULONG BuildSetPacketsizeCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                              PMULTICMD *ppMultiCmd );
/*
 * In getcmd.c
 */
ULONG GetQAlertlevelCmd ( PSZ pszPortName, PVOID pOutData,
                          PULONG pcbOutData, PBOOL pfGotResp );
ULONG GetQDeviceCmd ( PSZ pszPortName, PVOID pOutData,
                      PULONG pcbOutData, PBOOL pfGotResp );
ULONG GetQInterpreterCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                           PBOOL pfGotResp);
ULONG GetQInputbinsCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                         PBOOL pfGotResp);
ULONG GetQOutputbinsCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                          PBOOL pfGotResp);
ULONG GetQOptionsCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                       PBOOL pfGotResp);
ULONG GetQFontsCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                     PBOOL pfGotResp);
ULONG GetQJobscompCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                        PBOOL pfGotResp);
ULONG GetQJobsqueuedCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                          PBOOL pfGotResp);
ULONG GetQStatusCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                      PBOOL pfGotResp);

/*
 * In cache.c
 */
ULONG CacheQAlertlevel ( PPORTINST pPortInst, PRESPPKT pRespPkt );
ULONG CacheQSW ( PPORTINST pPortInst, PRESPPKT pRespPkt );
ULONG CacheQDevice ( PPORTINST pPortInst, PRESPPKT pRespPkt );
ULONG CacheQInterpreter ( PPORTINST pPortInst, PRESPPKT pRespPkt );
ULONG CacheQInputbins ( PPORTINST pPortInst, PRESPPKT pRespPkt );
ULONG CacheQOutputbins ( PPORTINST pPortInst, PRESPPKT pRespPkt );
ULONG CacheQOptions ( PPORTINST pPortInst, PRESPPKT pRespPkt );
ULONG CacheQFonts ( PPORTINST pPortInst, PRESPPKT pRespPkt );
ULONG CacheQJobscomp ( PPORTINST pPortInst, PRESPPKT pRespPkt );
ULONG CacheQJobsqueued ( PPORTINST pPortInst, PRESPPKT pRespPkt );
ULONG CacheQStatus ( PPORTINST pPortInst, PRESPPKT pRespPkt );

/*
 * In passthru.c
 */
PPASSRESPINST AllocPassRespInst ( PVOID pInData, ULONG cbInData );
BOOL AddPassRespInst ( PVOID pInData, ULONG cbInData, PPORTINST pPortInst );
BOOL FreePassRespInst ( PPASSRESPINST pPassRespInst );
ULONG FreePassRespList ( PPASSRESPINST pPassRespList );
ULONG GetReadPassthruCmd ( PSZ pszPortName, ULONG ulType, PVOID pOutData,
                           PULONG pcbOutData, PBOOL pfGotResp );
ULONG BuildSendPassthruCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                             ULONG ulType, PMULTICMD *ppMultiCmd );
ULONG BuildStartPassthruCmd ( PSZ pszPortName );
ULONG BuildEndPassthruCmd ( PSZ pszPortName );

/*
 * In alertses.c
 */
PALERTSESINST AllocAlertSesInst ( PPORTINST pPortInst );
PALERTSESINST AddAlertSesInst ( PPORTINST pPortInst );
ULONG RemoveAlertSesInst ( PPORTINST pPortInst, PALERTSESINST pAlertInst,
                           BOOL fRemoveAlert );
PALERTSESINST CheckAlertSesInst ( PALERTSESINST pAlertSesInst,
                                  PALERTSESINST pAlertSesList );
BOOL FreeAlertSesList ( PALERTSESINST pAlertSesList );
BOOL SetAlertRespRead ( PALERTSESINST pAlertSesInst,
                        PPORTINST pPortInst );
BOOL GetNextAlert ( PPORTINST pPortInst, PALERTSESINST pAlertSesInst,
                    ULONG ulType, PVOID pOutData, PULONG pcbOutData,
                    PBOOL pfGotResp );
ULONG GetReadAlertsessionCmd ( PSZ pszPortName, ULONG ulType, PVOID pInData,
                               ULONG cbInData, PVOID pOutData,
                               PULONG pcbOutData, PBOOL pfGotResp );
ULONG BuildStartAlertSessionCmd ( PSZ pszPortName, PVOID pOutData,
                                  PULONG pcbOutData );
ULONG BuildEndAlertSessionCmd ( PSZ pszPortName, PVOID pInData,
                                ULONG cbInData );
BOOL CheckAlertTimeouts ( VOID );
ULONG RemoveAlertSession ( PALERTSESINST pAlertSesInst );
ULONG SetReadTime ( PALERTSESINST pAlertSesInst );
/*
 * In proctype.c
 */
ULONG APIENTRY ProcTypeQAlertlevel ( PSZ pszPortName, ULONG ulType,
                                     PVOID pOutData, PULONG pcbOutData,
                                     PBOOL pfGotResp, PBOOL pfNeedResp,
                                     PULONG prc, PMULTICMD *ppMultiCmd );
ULONG APIENTRY ProcTypeQSW ( PSZ pszPortName, ULONG ulType, PVOID pOutData,
                             PULONG pcbOutData, PBOOL pfGotResp,
                             PBOOL pfNeedResp, PULONG prc,
                             PMULTICMD *ppMultiCmd );
ULONG APIENTRY ProcTypeQDevice ( PSZ pszPortName, ULONG ulType, PVOID pOutData,
                                 PULONG pcbOutData, PBOOL pfGotResp,
                                 PBOOL pfNeedResp, PULONG prc,
                                 PMULTICMD *ppMultiCmd );
ULONG APIENTRY ProcTypeQInterpreter ( PSZ pszPortName, ULONG ulType,
                                      PVOID pInData, ULONG cbInData,
                                      PVOID pOutData, PULONG pcbOutData,
                                      PBOOL pfGotResp, PBOOL pfNeedResp,
                                      PULONG prc, PMULTICMD *ppMultiCmd );
ULONG APIENTRY ProcTypeQInputbins ( PSZ pszPortName, ULONG ulType,
                                    PVOID pInData, ULONG cbInData,
                                    PVOID pOutData, PULONG pcbOutData,
                                    PBOOL pfGotResp, PBOOL pfNeedResp,
                                    PULONG prc, PMULTICMD *ppMultiCmd );
ULONG APIENTRY ProcTypeQOutputbins ( PSZ pszPortName, ULONG ulType,
                                     PVOID pInData, ULONG cbInData,
                                     PVOID pOutData, PULONG pcbOutData,
                                     PBOOL pfGotResp, PBOOL pfNeedResp,
                                     PULONG prc, PMULTICMD *ppMultiCmd );
ULONG APIENTRY ProcTypeQOptionss ( PSZ pszPortName, ULONG ulType,
                                   PVOID pOutData, PULONG pcbOutData,
                                   PBOOL pfGotResp, PBOOL pfNeedResp,
                                   PULONG prc, PMULTICMD *ppMultiCmd );
ULONG APIENTRY ProcTypeQFonts ( PSZ pszPortName, ULONG ulType,
                                PVOID pInData, ULONG cbInData,
                                PVOID pOutData, PULONG pcbOutData,
                                PBOOL pfGotResp, PBOOL pfNeedResp,
                                PULONG prc, PMULTICMD *ppMultiCmd );
ULONG APIENTRY ProcTypeQJobscomp ( PSZ pszPortName, ULONG ulType,
                                   PVOID pInData, ULONG cbInData,
                                   PVOID pOutData, PULONG pcbOutData,
                                   PBOOL pfGotResp, PBOOL pfNeedResp,
                                   PULONG prc, PMULTICMD *ppMultiCmd ) ;
ULONG APIENTRY ProcTypeQJobsqueued ( PSZ pszPortName, ULONG ulType,
                                     PVOID pInData, ULONG cbInData,
                                     PVOID pOutData, PULONG pcbOutData,
                                     PBOOL pfGotResp, PBOOL pfNeedResp,
                                     PULONG prc, PMULTICMD *ppMultiCmd );
ULONG APIENTRY ProcTypeQStatus ( PSZ pszPortName, ULONG ulType,
                                 PVOID pInData, ULONG cbInData,
                                 PVOID pOutData, PULONG pcbOutData,
                                 PBOOL pfGotResp, PBOOL pfNeedResp,
                                 PULONG prc, PMULTICMD *ppMultiCmd );
