/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/* PROGRAM NAME   : Sample BIDI Protocol Converter                          */
/* AUTHOR         : Pat D                                                   */
/* FILENAME       : cache.c                                                 */
/* DATE WRITTEN   : 02-03-94                                                */
/* DESCRIPTION    : Routines to cache data received from the printer        */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                           Routines In File                               */
/*                      CacheQAlertlevel()                                  */
/*                      CacheQDevice()                                      */
/*                      CacheQInterpreter()                                 */
/*                      CacheQInputbins()                                   */
/*                      CacheQOutputbins()                                  */
/*                      CacheQOptions()                                     */
/*                      CacheQFonts()                                       */
/*                      CacheQJobscomp()                                    */
/*                      CacheQJobsqueued()                                  */
/*                      CacheQStatus()                                      */
/****************************************************************************/

#define INCL_BASE
#define INCL_DOS
#define INCL_SPL
#define INCL_SPLBIDI
#define INCL_SPLERRORS
#include <os2.h>
#include <string.h>
#include "protcnv.h"
#include "protcnv1.h"
#include "cnvproto.h"

/****************************************************************************
 *
 * FUNCTION NAME = CacheQAlertLevel
 *
 * DESCRIPTION   = Store Alert Level response in the protocol converter
 *
 * INPUT         = pPortInst   - Pointer to the port instance
 *               = pRespPkt    - Pointer to the response packet from ParseData
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Data could not be stored)
 *
 * NOTE: Caller must be in the protocol converter semaphore
 *
 ****************************************************************************/

ULONG CacheQAlertlevel ( PPORTINST pPortInst, PRESPPKT pRespPkt ) {

    ULONG cbTemp;
    PBYTE pTemp = NULL;

    /*
     * Check for previously cached data
     */
    if (pPortInst->pAlertLevel) {
        FreeCnvMem ( pPortInst->pAlertLevel, pPortInst->cbAlertLevel );
    }
    /*
     * Set up cache information
     */
    pPortInst->fAlertLevel = 0;
    cbTemp = pRespPkt->cbData;
    pTemp = AllocCnvMem ( cbTemp );
    if (pTemp) {
        memcpy ( pTemp , pRespPkt->Data, cbTemp );
        pPortInst->cbAlertLevel = cbTemp;
        pPortInst->pAlertLevel = pTemp;
    } else {
        return(ERROR_NOT_ENOUGH_MEMORY);
    }

    return(0);

}

/****************************************************************************
 *
 * FUNCTION NAME = CacheQDevice
 *
 * DESCRIPTION   = Store Device response in the protocol converter
 *
 * INPUT         = pPortInst   - Pointer to the port instance
 *               = pRespPkt    - Pointer to the response packet from ParseData
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Data could not be stored)
 *
 * NOTE: Caller must be in the protocol converter semaphore
 *
 ****************************************************************************/

ULONG CacheQDevice ( PPORTINST pPortInst, PRESPPKT pRespPkt ) {

    ULONG cbTemp;
    PBYTE pTemp = NULL;

    /*
     * Check for previously cached data
     */
    if ( pPortInst->pDevice ) {
        FreeCnvMem ( pPortInst->pDevice, pPortInst->cbDevice );
    }
    /*
     * Set up cache information
     */
    pPortInst->fDevice = 0;
    cbTemp = pRespPkt->cbData;
    pTemp = AllocCnvMem ( cbTemp );
    if (pTemp) {
        memcpy ( pTemp , pRespPkt->Data, cbTemp );
        pPortInst->cbDevice = cbTemp;
        pPortInst->pDevice = pTemp;
    } else {
        return(ERROR_NOT_ENOUGH_MEMORY);
    }

    return(0);

}

/****************************************************************************
 *
 * FUNCTION NAME = CacheQInterpreter
 *
 * DESCRIPTION   = Store Device response in the protocol converter
 *
 * INPUT         = pPortInst   - Pointer to the port instance
 *               = pRespPkt    - Pointer to the response packet from ParseData
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Data could not be stored)
 *
 * NOTE: Caller must be in the protocol converter semaphore
 *
 ****************************************************************************/

ULONG CacheQInterpreter ( PPORTINST pPortInst, PRESPPKT pRespPkt ) {

    ULONG cbTemp;
    PBYTE pTemp = NULL;

    /*
     * Check for previously cached data
     */
    if ( pPortInst->pInterpreter ) {
        FreeCnvMem ( pPortInst->pInterpreter, pPortInst->cbInterpreter );
    }
    /*
     * Set up cache information
     */
    pPortInst->fInterpreter = 0;
    cbTemp = pRespPkt->cbData;
    pTemp = AllocCnvMem ( cbTemp );
    if (pTemp) {
        memcpy ( pTemp , pRespPkt->Data, cbTemp );
        pPortInst->cbInterpreter = cbTemp;
        pPortInst->pInterpreter = pTemp;
    } else {
        return(ERROR_NOT_ENOUGH_MEMORY);
    }

    return(0);

}

/****************************************************************************
 *
 * FUNCTION NAME = CacheQInputbins
 *
 * DESCRIPTION   = Store Input bins response in the protocol converter
 *
 * INPUT         = pPortInst   - Pointer to the port instance
 *               = pRespPkt    - Pointer to the response packet from ParseData
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Data could not be stored)
 *
 * NOTE: Caller must be in the protocol converter semaphore
 *
 ****************************************************************************/

ULONG CacheQInputbins ( PPORTINST pPortInst, PRESPPKT pRespPkt ) {

    ULONG cbTemp;
    PBYTE pTemp = NULL;

    /*
     * Check for previously cached data
     */
    if ( pPortInst->pInputbins ) {
        FreeCnvMem ( pPortInst->pInputbins, pPortInst->cbInputbins );
    }
    /*
     * Set up cache information
     */
    pPortInst->fInputbins = 0;
    cbTemp = pRespPkt->cbData;
    pTemp = AllocCnvMem ( cbTemp );
    if (pTemp) {
        memcpy ( pTemp , pRespPkt->Data, cbTemp );
        pPortInst->cbInputbins = cbTemp;
        pPortInst->pInputbins = pTemp;
    } else {
        return(ERROR_NOT_ENOUGH_MEMORY);
    }

    return(0);

}

/****************************************************************************
 *
 * FUNCTION NAME = CacheQOutputbins
 *
 * DESCRIPTION   = Store Output bins response in the protocol converter
 *
 * INPUT         = pPortInst   - Pointer to the port instance
 *               = pRespPkt    - Pointer to the response packet from ParseData
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Data could not be stored)
 *
 * NOTE: Caller must be in the protocol converter semaphore
 *
 ****************************************************************************/

ULONG CacheQOutputbins ( PPORTINST pPortInst, PRESPPKT pRespPkt ) {

    ULONG cbTemp;
    PBYTE pTemp = NULL;

    /*
     * Check for previously cached data
     */
    if ( pPortInst->pOutputbins ) {
        FreeCnvMem ( pPortInst->pOutputbins, pPortInst->cbOutputbins );
    }
    /*
     * Set up cache information
     */
    pPortInst->fOutputbins = 0;
    cbTemp = pRespPkt->cbData;
    pTemp = AllocCnvMem ( cbTemp );
    if (pTemp) {
        memcpy ( pTemp , pRespPkt->Data, cbTemp );
        pPortInst->cbOutputbins = cbTemp;
        pPortInst->pOutputbins = pTemp;
    } else {
        return(ERROR_NOT_ENOUGH_MEMORY);
    }

    return(0);

}

/****************************************************************************
 *
 * FUNCTION NAME = CacheQOptions
 *
 * DESCRIPTION   = Store Options response in the protocol converter
 *
 * INPUT         = pPortInst   - Pointer to the port instance
 *               = pRespPkt    - Pointer to the response packet from ParseData
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Data could not be stored)
 *
 * NOTE: Caller must be in the protocol converter semaphore
 *
 ****************************************************************************/

ULONG CacheQOptions ( PPORTINST pPortInst, PRESPPKT pRespPkt ) {

    ULONG cbTemp;
    PBYTE pTemp = NULL;

    /*
     * Check for previously cached data
     */
    if ( pPortInst->pOptions ) {
        FreeCnvMem ( pPortInst->pOptions, pPortInst->cbOptions );
    }
    /*
     * Set up cache information
     */
    pPortInst->fOptions = 0;
    cbTemp = pRespPkt->cbData;
    pTemp = AllocCnvMem ( cbTemp );
    if (pTemp) {
        memcpy ( pTemp , pRespPkt->Data, cbTemp );
        pPortInst->cbOptions = cbTemp;
        pPortInst->pOptions = pTemp;
    } else {
        return(ERROR_NOT_ENOUGH_MEMORY);
    }

    return(0);

}

/****************************************************************************
 *
 * FUNCTION NAME = CacheQFonts
 *
 * DESCRIPTION   = Store Fonts response in the protocol converter
 *
 * INPUT         = pPortInst   - Pointer to the port instance
 *               = pRespPkt    - Pointer to the response packet from ParseData
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Data could not be stored)
 *
 * NOTE: Caller must be in the protocol converter semaphore
 *
 ****************************************************************************/

ULONG CacheQFonts ( PPORTINST pPortInst, PRESPPKT pRespPkt ) {

    ULONG cbTemp;
    PBYTE pTemp = NULL;

    /*
     * Check for previously cached data
     */
    if ( pPortInst->pFonts ) {
        FreeCnvMem ( pPortInst->pFonts, pPortInst->cbFonts );
    }
    /*
     * Set up cache information
     */
    pPortInst->fFonts = 0;
    cbTemp = pRespPkt->cbData;
    pTemp = AllocCnvMem ( cbTemp );
    if (pTemp) {
        memcpy ( pTemp , pRespPkt->Data, cbTemp );
        pPortInst->cbFonts = cbTemp;
        pPortInst->pFonts = pTemp;
    } else {
        return(ERROR_NOT_ENOUGH_MEMORY);
    }

    return(0);

}

/****************************************************************************
 *
 * FUNCTION NAME = CacheQJobscomp
 *
 * DESCRIPTION   = Store Jobs Complete response in the protocol converter
 *
 * INPUT         = pPortInst   - Pointer to the port instance
 *               = pRespPkt    - Pointer to the response packet from ParseData
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Data could not be stored)
 *
 * NOTE: Caller must be in the protocol converter semaphore
 *
 ****************************************************************************/

ULONG CacheQJobscomp ( PPORTINST pPortInst, PRESPPKT pRespPkt ) {

    ULONG cbTemp;
    PBYTE pTemp = NULL;

    /*
     * Check for previously cached data
     */
    if ( pPortInst->pJobscomp ) {
        FreeCnvMem ( pPortInst->pJobscomp, pPortInst->cbJobscomp );
    }
    /*
     * Set up cache information
     */
    pPortInst->fJobscomp = 0;
    cbTemp = pRespPkt->cbData;
    pTemp = AllocCnvMem ( cbTemp );
    if (pTemp) {
        memcpy ( pTemp , pRespPkt->Data, cbTemp );
        pPortInst->cbJobscomp = cbTemp;
        pPortInst->pJobscomp = pTemp;
    } else {
        return(ERROR_NOT_ENOUGH_MEMORY);
    }

    return(0);

}

/****************************************************************************
 *
 * FUNCTION NAME = CacheQJobsqueued
 *
 * DESCRIPTION   = Store Jobs Queued response in the protocol converter
 *
 * INPUT         = pPortInst   - Pointer to the port instance
 *               = pRespPkt    - Pointer to the response packet from ParseData
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Data could not be stored)
 *
 * NOTE: Caller must be in the protocol converter semaphore
 *
 ****************************************************************************/

ULONG CacheQJobsqueued ( PPORTINST pPortInst, PRESPPKT pRespPkt ) {

    ULONG cbTemp;
    PBYTE pTemp = NULL;

    /*
     * Check for previously cached data
     */
    if ( pPortInst->pJobsqueued ) {
        FreeCnvMem ( pPortInst->pJobsqueued, pPortInst->cbJobsqueued );
    }
    /*
     * Set up cache information
     */
    pPortInst->fJobsqueued = 0;
    cbTemp = pRespPkt->cbData;
    pTemp = AllocCnvMem ( cbTemp );
    if (pTemp) {
        memcpy ( pTemp , pRespPkt->Data, cbTemp );
        pPortInst->cbJobsqueued = cbTemp;
        pPortInst->pJobsqueued = pTemp;
    } else {
        return(ERROR_NOT_ENOUGH_MEMORY);
    }

    return(0);

}

/****************************************************************************
 *
 * FUNCTION NAME = CacheQStatus
 *
 * DESCRIPTION   = Store Status response in the protocol converter
 *
 * INPUT         = pPortInst   - Pointer to the port instance
 *               = pRespPkt    - Pointer to the response packet from ParseData
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Data could not be stored)
 *
 * NOTE: Caller must be in the protocol converter semaphore
 *
 ****************************************************************************/

ULONG CacheQStatus ( PPORTINST pPortInst, PRESPPKT pRespPkt ) {

    ULONG cbTemp;
    PBYTE pTemp = NULL;

    /*
     * Check for previously cached data
     */
    if ( pPortInst->pStatus ) {
        FreeCnvMem ( pPortInst->pStatus, pPortInst->cbStatus );
    }
    /*
     * Set up cache information
     */
    pPortInst->fStatus = 0;
    cbTemp = pRespPkt->cbData;
    pTemp = AllocCnvMem ( cbTemp );
    if (pTemp) {
        memcpy ( pTemp , pRespPkt->Data, cbTemp );
        pPortInst->cbStatus = cbTemp;
        pPortInst->pStatus = pTemp;
    } else {
        return(ERROR_NOT_ENOUGH_MEMORY);
    }

    return(0);

}

