/**************************************************************************
 *
 * SOURCE FILE NAME = QPINIT.C
 *
 * DESCRIPTIVE NAME = PM Spooler Queue Processor
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             Copyright Microsoft Corporation, 1990
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * This file contains the initialization and termination code for the 32-bit
 * PM Spooler Queue Processor(PMPRINT.QPR).
 *
 * FUNCTIONS   :   ExitListProc       - called by OS/2 during process exit
 *                 InitResources      - called to setup per-process data
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 ****************************************************************************/

#define INCL_DOSNLS
#define INCL_DOSPFS
#define INCL_WINP_MISC
#define INCL_WINWINDOWMGR

#include "pmprint.h"

/*
** internal function prototypes
*/
VOID FreeQProcInstResources(PID uPid);

/****************************************************************************
 *
 * FUNCTION NAME = _DLL_InitTerm
 *
 * DESCRIPTION   = DLL initialization/termination routine
 *
 * INPUT         = hModule     - Module handle for this DLL(PMPRINT.QPR)
 *               = ulFlag      - Reason for call
 *                                   0 - DLL firstime load for process
 *                                   1 - DLL termination for this process
 *
 *
 * OUTPUT        = sets up per process data on first load of PMPRINT
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

ULONG _System _DLL_InitTerm(HMODULE hModule, ULONG ulFlag)
{

   switch (ulFlag)
   {
     case 0:
       /*
       ** First time load of PMPRINT for this process
       **
       ** if multiple threads from same process attempting to print
       **    must make second calling thread wait in
       **    SplQpOpen until resources initiailized
       */
       fQprDoingInit = TRUE ;

       if (!hModPMPrint)
       {
           /*
           ** Remember our module handle for resources
           */
           hModPMPrint = hModule;

           /*
           ** Create per process instance of PMPRINT Mutex semaphore
           **   as non-shared, non-named.
           ** This is used to serialize access to list of QPROCINST
           **   structures pointed at by pQprocInstHead
           */
           DosCreateMutexSem( NULL, &semPMPRINT, 0, 0);

           pQprocInstHead = NULL;

           DosGetInfoBlocks(&pTIB, &pPIB);

           fInitDone = TRUE ;

       }

       fQprDoingInit = FALSE ;
       break;
     case 1:

       /*
       ** Process termination, free QPROC Instances
       */
       EnterSem();
         FreeQProcInstResources(pPIB->pib_ulpid);
       ExitSem();
       break;

     default:
       return 0;
   }
   /*
   ** Return success
   */
   return( 1 );
}


/****************************************************************************
 *
 * FUNCTION NAME = FreeQProcInstResources
 *
 * DESCRIPTION   = Free QPROCINST structures allocated for calling process
 *
 * INPUT         = uPid        - process ID to free resources for
 *               = uExitReason - Reason for process termination
 *                      TC_EXIT            0 - Normal exit
 *                      TC_HARDERROR       1 - Hard-error halt
 *                      TC_TRAP            2 - Trap for 16-bit child process
 *                      TC_KILLPROCESS     3 - Unintercepted DosKillProcess
 *                      TC_EXCEPTION       4 - Exception for 32-bit child
 *
 *
 * OUTPUT        = frees any memory allocated for this process by PMPRINT
 *
 * RETURN-NORMAL = VOID
 *
 * RETURN-ERROR  = same as NORMAL
 *
 ****************************************************************************/

VOID FreeQProcInstResources(PID uPid)
{
    PQPROCINST pQProc = pQprocInstHead;

    /*
    ** Go thru per process list of QPROCINST structures and free all memory
    **
    ** Note: uPid should always match since this is per-process list
    */
    while (pQProc)
        if (pQProc->uPid == uPid)
        {
            Warning( "SplExitList: HPROC: %0x not freed by PMPRINT",
                        pQProc, 0);
            pQProc = DestroyQProcInst( pQProc );
        } else {

            pQProc = pQProc->pNext;
        }


    return;

}
