/**************************************************************************
 *
 * SOURCE FILE NAME = QPDJP.C
 *
 * DESCRIPTIVE NAME = PM Print Queue Processor
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Dynamic Job Properties function for PM Print Queue Processor
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 ****************************************************************************/

#define INCL_DEV
#define INCL_DEVDJP
#include "pmprint.h"

/* Dynamic Job Properties typedefs
*/
/* DevPostEscape is a new API.  The easiest way to call it is to
** rely on OS2386.LIB and just use DevPostEscape (...).
** However, on previous releases of OS/2, the loader will refuse to
** load your program since that API is not in the GPI.
** Therefore, check to see if the API exists ourselves.
*/
#ifndef ORD_DEV32POSTESCAPE
   #define ORD_DEV32POSTESCAPE                729
#endif

/*
 * Per-process flag and DJP function pointer
 */

BOOL                fDevPostEscapeChecked = FALSE;
PDEVPOSTESCAPE_FUNC pDevPostEscape        = NULL;

PSZ   INI_QUEUE_SEPTRAY      = "PM_SPOOLER_QUEUE_SEPTRAY";

/*
** Local functions
*/
ULONG UseDJP( PDRIVDATA pSepDriverData, PSZ pszSepTray,
              PDEVPOSTESCAPEBLOCK pDPEB );
BOOL DoesDevPostEscapeExist (VOID);


/****************************************************************************
 *
 * FUNCTION NAME = UpdateDrivdata
 *
 * DESCRIPTION   = Update given Drivdata with the following overrides:
 *                 Portrait
 *                 Simplex
 *                 InputTray=trayname selected by user
 *
 *                 If no separator input tray was specified by the user
 *                 then reset the drivdata to be minimal(change size)
 *
 *                 This assumes caller knows original length of drivdata
 *                 since the length field in it can be decreased.
 *
 * INPUT         = pSepDriverData -> copy of original drivdata for print job
 *
 * OUTPUT        = pSepDriverData is updated
 *
 * RETURN-NORMAL = None
 *
 *
 * RETURN-ERROR  = None
 *
 *
 ****************************************************************************/
ULONG UpdateSepDrivdata( PDRIVDATA pSepDriverData,
                         PDEVPOSTESCAPEBLOCK pDPEB )
{
  BOOL     fSuccess;
  CHAR     szSepTray[32]; // Max DJPTRAYNAME length
  ULONG    rc;


  if (!fDevPostEscapeChecked) {
     DoesDevPostEscapeExist();
     fDevPostEscapeChecked = TRUE;
  }

  szSepTray[0] = '\0';
  rc           = 0;
  fSuccess = PrfQueryProfileString( HINI_SYSTEMPROFILE,
                                    INI_QUEUE_SEPTRAY,
                                    pDPEB->pszQueueName,
                                    (PSZ)NULL,       /* default string */
                                    szSepTray,
                                    sizeof(szSepTray) - 1);
  if (pDevPostEscape && fSuccess && szSepTray[0]) {
     /*
      * We must override the job properties using DJP
      */
     rc = UseDJP( pSepDriverData, szSepTray, pDPEB );
  } else {
     /*
     ** Use minimal drivdata to force the print driver to
     ** use printer properties device defaults to print the
     ** separator page(like the spooler used to do).
     */
     pSepDriverData->cb = sizeof(DRIVDATA) - 1;

  }
  return(rc);
}

/****************************************************************************
 *
 * FUNCTION NAME = UseDJP
 *
 * DESCRIPTION   = Update given Drivdata with the following overrides:
 *                 Portrait
 *                 Simplex
 *                 InputTray=trayname selected by user
 *
 * INPUT         = pSepDriverData -> copy of original drivdata for print job
 *                 pszSepTray  -> name of input tray to use for separator page
 *
 *
 * OUTPUT        = pSepDriverData is updated
 *
 * RETURN-NORMAL = None
 *
 *
 * RETURN-ERROR  = None
 *
 *
 ****************************************************************************/
ULONG UseDJP( PDRIVDATA pSepDriverData, PSZ pszSepTray,
              PDEVPOSTESCAPEBLOCK pDPEB )
{
   CHAR             chJobProps[260];
   PDJP_ITEM        pDJP;
   PDJPT_TRAYNAME   pTrayName;
   PBYTE            pbBuffer;
   ULONG            cbSizeItems;
   ULONG            rc;


   // Set up the pointers
   pbBuffer = chJobProps;
   memset( pbBuffer, 0, sizeof( chJobProps ) );

   pDJP    = (PDJP_ITEM)pbBuffer;

   // Set the orientation to Portrait
   pDJP->cb            = sizeof (DJP_ITEM);
   pDJP->ulProperty    = DJP_SJ_ORIENTATION;
   pDJP->lType         = DJP_CURRENT;
   pDJP->ulNumReturned = 1;
   pDJP->ulValue       = DJP_ORI_PORTRAIT;
   pDJP++;                            // Move to the next DJP_ITEM

   // Set Duplex off
   pDJP->cb            = sizeof (DJP_ITEM);
   pDJP->ulProperty    = DJP_SJ_DUPLEX;
   pDJP->lType         = DJP_CURRENT;
   pDJP->ulNumReturned = 1;
   pDJP->ulValue       = DJP_DUP_OFF;
   pDJP++;                            // Move to the next DJP_ITEM

   // Set the trayname into the ulValue field
   pDJP->cb            = DJP_HEADER_SIZE + sizeof (DJPT_TRAYNAME);
   pDJP->ulProperty    = DJP_CJ_TRAYNAME;
   pDJP->lType         = DJP_CURRENT;
   pDJP->ulNumReturned = 1;
   pTrayName           = (PDJPT_TRAYNAME)&pDJP->ulValue;
   strcpy( pTrayName->szTrayname, pszSepTray );
   pTrayName->szDisplayTrayname[0] = '\0';
   pTrayName->djpttTrayID = 0;

   pDJP = DJP_NEXT_STRUCTP (pDJP);    // Move to the next DJP_ITEM

   // Signify the end of the list
   pDJP->cb         = sizeof (DJP_ITEM);
   pDJP->ulProperty = DJP_NONE;
   pDJP->ulValue    = DJP_NONE;
   pDJP->lType      = DJP_NONE;
   pDJP++;                            // Move to the next DJP_ITEM

   // Change the drivdata with these overrides

   cbSizeItems = sizeof(DJP_ITEM) + sizeof(DJP_ITEM) +
                 DJP_HEADER_SIZE + sizeof (DJPT_TRAYNAME);

   rc = pDevPostEscape (pDPEB->pszDriverName,
                        pDPEB->pszDeviceName,
                        pDPEB->pszQueueName,
                        pDPEB->pszSplPrinterName,
                        DEVPE_SETJOBPROPERTIES,
                        cbSizeItems,              // I   - max size
                        pbBuffer,                 // I/O - start of DJP_ITEMs
                        pSepDriverData->cb,       // I   - size of drivdata
                        (PBYTE)pSepDriverData);   // I/O - drivdata

   if ( (DEV_OK == rc) || (DEV_WARNING == rc) ) {

      rc = 0;
   } else {
      rc = ERROR_NOT_SUPPORTED;
   }

   return(rc);
}

/****************************************************************************
 *
 * FUNCTION NAME = DoesDevPostEscapeExist - INTERNAL API
 *
 * DESCRIPTION   = Get procedure address of Dev32PostEscape from PMGPI
 *
 * INPUT         = None
 *
 * OUTPUT        = TRUE  - Dev32PostEscape is exported by PMGPI.DLL
 *
 * NOTE            Not in spooler semaphore on entry/exit
 *
 ****************************************************************************/


BOOL DoesDevPostEscapeExist (VOID)
{
   CHAR        achBuf[100];
   HMODULE     hmodPMGPI = 0;
   APIRET      rc;

   pDevPostEscape = NULL;

   strcpy (achBuf, "PMGPI");

   rc = DosLoadModule (achBuf,
                       sizeof (achBuf),
                       achBuf,
                       &hmodPMGPI);

   if ( (rc == 0) && hmodPMGPI ) {
      rc = DosQueryProcAddr (hmodPMGPI,              // module handle
                             ORD_DEV32POSTESCAPE,    // ordinal #
                             (PSZ)NULL,              // or proc name
                             (PFN*)&pDevPostEscape);
      #ifdef DEBUG
       {
        char logbuf[260];
        sprintf( logbuf,
                 "DoesDevPostEscapeExist rc=%d pfn=%lX\r\n",
                 rc, (ULONG)pDevPostEscape);
        LogCall( logbuf );
       }
      #endif /* DEBUG */

      if (rc) {
         DosFreeModule (hmodPMGPI);
      }
   }

   fDevPostEscapeChecked = TRUE;

   return pDevPostEscape ? TRUE : FALSE;
}

