/**************************************************************************
 *
 * SOURCE FILE NAME = PDCCONST.H
 *
 * DESCRIPTIVE NAME = Constant defines for port driver sample
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 *
 ****************************************************************************/

#define PDR_HELPFILE_NAME       "PAR1284.HLP"
#define PDR_HELPFILE_EXT        ".HLP"

#define DEFAULT_STACKSIZE            24*1024
#define DEFAULT_BUFSIZE              4096
#define DEF_WAITALERTBUF_SIZE        60*1024
#define MAX_CONNECTNAME_SZ           64

#define ID_NUMBER_OF_DESC_LINES 8000
#define ID_FIRST_DESC_LINES     8001
#define ID_IR_INIT_ERROR        8002
#define ID_IR_BIND_ERROR        8003
#define ID_IR_DISCOVER_ERROR    8004
#define ID_IR_CONNECT_ERROR     8005
#define ID_IR_DLLLOAD_ERROR     8006
#define ID_IR_CONFIG_ERROR      8007
#define ID_IR_BUSY_ERROR        8008
#define ID_IR_SETTINGS_ERROR    8009

#define PORT_ID_1               5001
#define PORT_DESC_1             5002
#define PORT_ID_2               5003
#define PORT_DESC_2             5004
#define PORT_ID_3               5005
#define PORT_DESC_3             5006
#define PORT_HELP_TITLE         5007
#define PORT_ERR_TITLE          5008
#define ID_MODE_AUTODETECT      5009
#define ID_MODE_COMPATIBLE      5010
#define ID_MODE_NIBBLE          5011
#define ID_MODE_BYTE            5012
#define ID_MODE_ECP             5013
#define ID_MODE_ECP_RLE         5014
#define ID_MODE_UNKNOWN         5015
#define PDR_ID_PROPERTIES       5016
#define PDR_ID_ADV_PROPERTIES   5017

#define PORT_ID_FIRST           PORT_ID_1
#define PORT_ID_LAST            PORT_ID_3


#define PAR1284_ICON           7001

#define STR_LEN_PORTNAME        64
#define STR_LEN_PORTDESC        256
#define STR_LEN_DESC            81
#define STR_LEN_TITLE           256

   /*
   ** port defaults
   */
#define DEF_INITIALIZATION      ";"
#define DEF_OLD_INITIALIZATION  ";"
#define DEF_TERMINATION         ";"
#define DEF_CONNECTION          ";"
#define DEF_TIMEOUT_PRINT       "45;"
#define DEF_TIMEOUT_QUERY       "180;"
#define DEF_TIMEOUT_JOB         "300;"
//#define DEF_PORTDRIVER          "PAR1284;"
#define DEF_PORTDRIVER          "PARALLEL;"
#define DEF_PORTNAME            "LPT"

#define TIMEOUT_LOWER_LIMIT          0
#define TIMEOUT_UPPER_LIMIT          9999
#define TIMEOUT_UPPER_LIMIT_MS     999999
#define DEF_TIMEOUT_PRINT_VALUE      45
#define DEF_TIMEOUT_QUERY_VALUE      180
#define DEF_TIMEOUT_JOB_VALUE        300
#define DEF_TIMEOUT_READ_INTER        64
#define DEF_TIMEOUT_READ_ELAPSED    1000
#define DEF_TIMEOUT_WRITE_INTER    15000
#define DEF_TIMEOUT_WRITE_ELAPSED  15000

#define APPNAME_LEAD_STR           "PM_"

#define KEY_DESCRIPTION            "DESCRIPTION"
#define KEY_INITIALIZATION         "INITIALIZATION"
#define KEY_TERMINATION            "TERMINATION"
#define KEY_PORTDRIVER             "PORTDRIVER"
#define KEY_TIMEOUT_PRINT          "TIMEOUT"
#define KEY_TIMEOUT_QUERY          "TIMEOUT_QUERY"
#define KEY_TIMEOUT_JOB            "TIMEOUT_JOB"
#define KEY_TIMEOUT_READ_INTER     "TIMEOUT_READ_INTER"
#define KEY_TIMEOUT_READ_ELAPSED   "TIMEOUT_READ_ELAPSED"
#define KEY_TIMEOUT_WRITE_INTER    "TIMEOUT_WRITE_INTER"
#define KEY_TIMEOUT_WRITE_ELAPSED  "TIMEOUT_WRITE_ELAPSED"
#define KEY_MODE_SELECTED          "MODE_SELECTED"

#define APPNAME_PM_SPOOLER_PORT    "PM_SPOOLER_PORT"

#define NumPorts() (((PORT_ID_LAST - PORT_ID_FIRST) >> 1) + 1)

   /*
   ** ChkMem defines
   */
#define CHK_READ        0
#define CHK_WRITE       1

   /*
   ** Port Settings - Par1284 Port
   */
#define IDD_PORTPAR1284      21500
#define IDC_PPA_PRINTTIMEOUT 21501                   /* Print Timeout      */
#define IDC_PPA_QUERYTIMEOUT 21502                   /* Query Timeout      */
#define IDC_PPA_JOBTIMEOUT   21503                   /* Job Timeout        */
#define IDC_PPA_PORTNAME     21504                   /* Port name(LPT1)    */
#define IDC_PPA_SHAREHW      21505                   /* share access       */
#define IDC_PPA_CONNECTIONS  21506                   /* Connections        */
#define IDC_OK                1100                   /* OK push button     */
#define IDC_CANCEL            1101                   /* Cancel push button */
#define IDC_HELP              1102                   /* Help push button   */
#define IDC_RESET             1103                   /* Help push button   */
#define IDC_DEFAULT           1104                   /* Help push button   */
#define IDC_ADVANCED          1105                   /* AdvancedOpts button*/
#define IDC_REFRESH           1107                   /* Refresh pushbutton */

#define IDC_SETTINGS_UPDATED  WM_USER+1      /* Msg posted when query done */

#define IDH_DLG_EXTENDED      15483
#define IDH_PPA_TIMEOUT_PRINT 15484
#define IDH_PPA_TIMEOUT_QUERY 15485
#define IDH_PPA_TIMEOUT_JOB   15486
#define IDH_PPA_SHAREHW       15822
#define IDH_PPA_DESC          15715
#define IDH_OK                1090
#define IDH_CANCEL            1091
#define IDH_RESET             1092
#define IDH_DEFAULT           1093
#define IDH_HELP              15483


#define IDD_ADVANCEDOPTS      21600              /* Advanced options dialog */
#define IDC_PPE_READ_INTCHAR  21601                   /* Read inter-char TO */
#define IDC_PPE_READ_ELAPSED  21602                   /* Read elapsed TO    */
#define IDC_PPE_WRITE_INTCHAR 21603                   /* Write inter-char TO*/
#define IDC_PPE_WRITE_ELAPSED 21604                   /* Write elapsed TO   */
#define IDC_PPE_MODE_SELECTED 21605                   /* User-selected Mode */
#define IDC_PPE_MODE_CURRENT  21606                   /* Current bidi Mode  */
#define IDC_MLE_DEVICEID      21607                   /* Device ID string   */

