/****************************************************************************/
/*  Copyright (C) 1993 IBM Corporation                                      */
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/* PROGRAM NAME   : Sample BIDI Port Driver                                 */
/* FILENAME       : init.c                                                  */
/* DATE WRITTEN   : 02-08-95                                                */
/* DESCRIPTION    : DLL Initialization/Termination routines                 */
/*                                                                          */
/****************************************************************************/

#define MAINPORTDRV
#include    "pdrconst.h"
#include    "pdrtypes.h"
#include    "pdrproto.h"

/*
 * Local function prototypes
 */
BOOL PortLoadProc( HMODULE hModule );
BOOL PortTermProc ( VOID );

/****************************************************************************
 *
 * FUNCTION NAME = _DLL_InitTerm
 *
 * DESCRIPTION   = DLL initialization/termination routine
 *
 * INPUT         = hModule     - Module handle for this DLL(PMPRINT.QPR)
 *               = ulFlag      - Reason for call
 *                                         0 - DLL firstime load for process
 *                                         1 - DLL being removed from process
 *
 *
 * OUTPUT        = Calls ProtLoadProc to initialize per process data
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

ULONG _System _DLL_InitTerm(HMODULE hModule, ULONG ulFlag)
{
    #ifdef DEBUG_ALERT
      char logbuf[360];
    #endif

    #ifdef DEBUG_ALERT
     {
      sprintf( logbuf,
               "PAR1284 DLL_InitTerm hModule=%d ulFlag=%d\r\n",
               hModule, ulFlag );
      LogCall( logbuf );
     }
    #endif /* DEBUG */

   switch (ulFlag)
   {
     case 0:
       if (PortLoadProc ( hModule ) == 0) return 0;
       break;
    case 1:
       if (PortTermProc () == 0) {
          return(0);
       }
       break;

     default:
       return 0;
   }
   /* Return success */
   return( 1 );
}

/****************************************************************************
 *
 * FUNCTION NAME = PortLoadProc
 *
 * DESCRIPTION   = Initialization to be done when loading the port
 *                 driver.
 *
 * INPUT         = hModule     - Module handle for this DLL(driver.PDR)
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 ****************************************************************************/

BOOL PortLoadProc( HMODULE hModule ) {

    ULONG rc = 0;

    hPdrMod = hModule;
    /*
     * Setup Memory heap, will be process memory not shared.
     * Allocate memory sparse, will be committed by DosSubAllocMem as
     * needed.  Size of heap is 1 Meg.
     */
    rc = DosAllocMem (&pHeapBase, 0x100000,
                      PAG_READ | PAG_WRITE );
    if (rc) {
        return(0);
    }
    rc = DosSubSetMem ( pHeapBase, DOSSUB_INIT | DOSSUB_SPARSE_OBJ,
                        0x100000 );
    if (rc) {
        return(0);
    }
    /*
     * Setup Port Driver Mutex semaphore
     */
    rc = DosCreateMutexSem ( 0,
                             &semPortDrv,
                             0,
                             FALSE );       // Create Unowned
    if (rc) {
        return(0);
    }
    /*
     * Setup Port Driver WaitAlert Event semaphore
     */
    rc = DosCreateEventSem ( 0,
                             &(PdrWaitAlert.hevWaitAlert),
                             0,
                             FALSE );   // Create in Reset state

    return(1);

}

/****************************************************************************
 *
 * FUNCTION NAME = PortTermProc
 *
 * DESCRIPTION   = Cleanup to be done when unloading the port driver.
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = 0(Failure, DLL should not be loaded)
 *
 * NOTE: This routine expects to have exclusive access to the port driver
 *       since the spooler is the only process which will call it.
 *
 ****************************************************************************/

BOOL PortTermProc ( VOID ) {

    ULONG rc = 0;

    /*
     * Free all port instances
     */
    rc = FreeAllPortInst ();
    if (rc) {
        return(0);
    }
    /*
     * Check for existence of Memory Heap
     */
    if (pHeapBase) {
        /*
         * Clean up Memory Heap
         */
        rc = DosSubUnsetMem ( pHeapBase );
        if (rc) {
            return(0);
        }
        rc = DosFreeMem ( pHeapBase );
        if (rc) {
            return(0);
        }
        /*
         * Close Port Driver Semaphore, will be created after heap
         */
        rc = DosCloseMutexSem ( semPortDrv );
        if (rc) {
            return(0);
        }
    }

    return(1);

}

/***************************************************************************
 * FUNCTION NAME = LoadInfraredDll
 *
 * DESCRIPTION   = load LMDLL.DLL
 *
 * INPUT         =
 *
 * OUTPUT        = *phModule = LMDLL module handle
 *                  plmpfns  = set to LMDLL entry points
 *
 * RETURN-NORMAL = 0 - Success
 *
 * RETURN-ERROR  = error
 *
 **************************************************************************/
#ifdef IR_BUILD   // Not used by PAR1284  @BUGBUG

ULONG APIENTRY LoadInfraredDLL( PHMODULE phModule, PLMPFNS plmpfns)
{
  ULONG ulRC;

  ulRC = DosLoadModule(NULL, 0, "LMDLL", phModule);
  if (ulRC == 0 )
  {
    HMODULE hmod = *phModule;

    if (DosQueryProcAddr(hmod,(ULONG)NULL,"LM_OpenDriver",
                         (PFN *)&plmpfns->pfnLM_OpenDriver       ) ||
        DosQueryProcAddr(hmod,(ULONG)NULL,"LM_CloseDriver",
                         (PFN *)&plmpfns->pfnLM_CloseDriver      ) ||
        DosQueryProcAddr(hmod,(ULONG)NULL,"LM_Initialize",
                         (PFN *)&plmpfns->pfnLM_Initialize       ) ||
        DosQueryProcAddr(hmod,(ULONG)NULL,"LM_DiscoverDevices",
                         (PFN *)&plmpfns->pfnLM_DiscoverDevices  ) ||
        DosQueryProcAddr(hmod,(ULONG)NULL,"LM_ConnectRequest",
                         (PFN *)&plmpfns->pfnLM_ConnectRequest   ) ||
        DosQueryProcAddr(hmod,(ULONG)NULL,"LM_Shutdown",
                         (PFN *)&plmpfns->pfnLM_Shutdown         ) ||
        DosQueryProcAddr(hmod,(ULONG)NULL,"LM_BindLSAP",
                         (PFN *)&plmpfns->pfnLM_BindLSAP         ) ||
        DosQueryProcAddr(hmod,(ULONG)NULL,"LM_DisconnectRequest",
                         (PFN *)&plmpfns->pfnLM_DisconnectRequest) ||
        DosQueryProcAddr(hmod,(ULONG)NULL,"LM_DataRequest",
                         (PFN *)&plmpfns->pfnLM_DataRequest      ) ||
        DosQueryProcAddr(hmod,(ULONG)NULL,"LM_DataRequest2",
                         (PFN *)&plmpfns->pfnLM_DataRequest2     ) ||
        DosQueryProcAddr(hmod,(ULONG)NULL,"LM_UnBindLSAP",
                         (PFN *)&plmpfns->pfnLM_UnBindLSAP       ) ||
        DosQueryProcAddr(hmod,(ULONG)NULL,"LM_Statistics",
                         (PFN *)&plmpfns->pfnLM_Statistics       ) ||
        DosQueryProcAddr(hmod,(ULONG)NULL,"LM_ReceiveData2",
                         (PFN *)&plmpfns->pfnLM_ReceiveData2     ) ||
        DosQueryProcAddr(hmod,(ULONG)NULL,"LM_ConnectResponse",
                         (PFN *)&plmpfns->pfnLM_ConnectResponse  ))
    {
      DosFreeModule(*phModule);
      *phModule = (HMODULE)NULL;
      ulRC = ERROR_PROC_NOT_FOUND;
    }
  }
  /*
  ** if we received an error loading LMDLL.DLL - tell the user
  */
  if (ulRC)
  {
    DisplayError (HWND_DESKTOP, ID_IR_DLLLOAD_ERROR,
                  MB_OK | MB_APPLMODAL | MB_MOVEABLE);
  }

  return(ulRC);

} /* end function LoadInfaredDLL */

#endif // IR_BUILD  Not used by PAR1284  @BUGBUG
