/**************************************************************************
 *
 * SOURCE FILE NAME = PDRTYPES.H
 *
 * DESCRIPTIVE NAME = Type definitions for port driver
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 *
 ****************************************************************************/

#define LINT_ARGS                      /* argument checking enabled         */

#define  INCL_DOS
#define  INCL_DEV
#define  INCL_ERRORS
#define  INCL_DOSMEMMGR                /* Include standard OS/2 support     */
#define  INCL_DOSMODULEMGR             /* For DosLoadModule                 */
#define  INCL_DOSPROCESS
#define  INCL_GPILCIDS
#define  INCL_WINCOMMON                /* Include Window Management support */
#define  INCL_WINDOWMGR
#define  INCL_WINSWITCHLIST
#define  INCL_WINPROGRAMLIST
#define  INCL_WINMENUS
#define  INCL_WINWINDOWMGR
#define  INCL_WINMESSAGEMGR
#define  INCL_WINDIALOGS
#define  INCL_WINSTATICS
#define  INCL_WINLISTBOXES
#define  INCL_WINMENUS
#define  INCL_WINSYS
#define  INCL_WINFRAMEMGR
#define  INCL_INCLWINACCELERATORS
#define  INCL_WINPOINTERS
#define  INCL_WINERRORS
#define  INCL_WINSHELLDATA

#define  INCL_WINTYPES
#define  INCL_WINACCELERATORS
#define  INCL_WINBUTTONS
#define  INCL_WINENTRYFIELDS
#define  INCL_WINRECTANGLES
#define  INCL_WINTIMER
#define  INCL_WINSCROLLBARS
#define  INCL_WINHEAP
#define  INCL_SHLERRORS
#define  INCL_WININPUT
#define  INCL_WINHELP
#define  INCL_WINSTDSPIN

#define  INCL_SPL
#define  INCL_SPLP
#define  INCL_SPLDOSPRINT
#define  INCL_SPLBIDI
#define  INCL_SPLERRORS
#define  INCL_SHLERRORS
#define  INCL_DOSERRORS
#define  INCL_WINHOOKS

#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#define OS2DLL  /* for LMAPI.H  */
#include "lmapi.h"
#include "irstatus.h"
#include "cbdefs.h"

//
// Include this private version of the public header pmsplb.h
//   only if pmsplb.h is not in the current headers
//
#ifndef PMSPLB_INCLUDED
 #include "pmsplnew.h"
#endif

/*
** MACROS
*/
#define  ABS(Value)    ((Value) > 0 ? (Value) : (-(Value)))
#define  WITHIN(value,lower,upper) ((value) >= (lower) && (value) <= (upper))
#define  MIN(a,b)      ((a) > (b) ? (b) : (a))
#define  MAX(a,b)      ((a) > (b) ? (a) : (b))

#ifndef OFFSETOFLONG
#define OFFSETOFLONG(p)         (((PULONG)&(p))[0])
#endif

/* change the pointer to an offset to the beginning of the structure */
#ifndef PTRTOOFFSET
#define PTRTOOFFSET(p, pbase) OFFSETOFLONG(pbase->p) -= (ULONG)pbase
#endif

/* change the offset from the beginning of the structure to a pointer */

#ifndef OFFSETTOPTR
#define OFFSETTOPTR(p, pbase) pbase->p = (PVOID)(OFFSETOFLONG(pbase->p) ? \
                             ((PBYTE)pbase + OFFSETOFLONG(pbase->p)) : (PBYTE)NULL)
#endif


/* Generate a pointer from a structure/offset pair */

#ifndef GETPTRFROMOFFSET
#define GETPTRFROMOFFSET(p, pbase) pbase->p ? ((PSZ)pbase + pbase->p) : NULL
#endif

/*
** Function list structure for LMDLL callbacks
*/
typedef struct _LMPFNS
{
  LMFNC_OpenDriver          pfnLM_OpenDriver;
  LMFNC_CloseDriver         pfnLM_CloseDriver;
  LMFNC_Initialize          pfnLM_Initialize;
  LMFNC_DiscoverDevices     pfnLM_DiscoverDevices;
  LMFNC_ConnectRequest      pfnLM_ConnectRequest;
  LMFNC_Shutdown            pfnLM_Shutdown;
  LMFNC_BindLSAP            pfnLM_BindLSAP;
  LMFNC_DisconnectRequest   pfnLM_DisconnectRequest;
  LMFNC_DataRequest         pfnLM_DataRequest;
  LMFNC_DataRequest2        pfnLM_DataRequest2;
  LMFNC_UnBindLSAP          pfnLM_UnBindLSAP;
  LMFNC_Statistics          pfnLM_Statistics;
  LMFNC_ReceiveData2        pfnLM_ReceiveData2;
  LMFNC_ConnectResponse     pfnLM_ConnectResponse;
} LMPFNS, *PLMPFNS;


/*
** Parameters to handle communication with LMDLL for a single IR port
*/
typedef struct _LMPARMS
{
  HMODULE hmodLMDLL;                   /* LMDLL.DLL mod handle               */
  HEV     hevConnect;                  /* IR Connect event semaphore         */
  HEV     hevDisconnect;               /* IR Connect event semaphore         */
  HEV     hevWriteComplete;            /* IR Write Complete semaphore        */
  ULONG   ulBuffersSent;               /* IR # of buffs Sent(1 transaction)  */
  ULONG   ulBuffersConfirmed;          /* IR # of buffs Confirmed(1 trans)   */
  ULONG   ulBytesConfirmed;            /* IR # Bytes confirmed(1 Transaction)*/
  ULONG   ulTotalBytesConfirmed;       /* IR # Bytes confirmed(all transacts)*/
  BOOL    fDisconnected;               /* IR True when disconnected          */
  struct _PORTINST    *pPortInst;      /* pointer to PORTINST for this port  */
  struct   _DATAINFO *pWaitingConfirmBufs; /* ->pdWrite buffers waiting to   */
                                       /*  get transmission confirmed by     */
                                       /*  printer.                          */
  struct   _DATAINFO *pConfirmedBufs;  /* ->pdWrite buffers confirmed by     */
                                       /*  printer waiting to be freed by    */
                                       /*  the InfraredWrite() routine.      */
  USHORT  ushConnection;               /* IR connection ID/Handle            */
  USHORT  usFill;                      /* Keep structure DWORD aligned       */
  LMPFNS  lmpfns;                      /* Structure of pointers to LM_ functs*/
  CONNECT_PARMS ConnectParms;          /* IR connection params               */
} LMPARMS, *PLMPARMS;

/*
** Structure whose pointer is returned by SplPdOpen.
** Stores all information relative to job being printed.
*/
typedef struct _PDOPENINST
{
  USHORT signature;                    /* signature word for validation      */
  USHORT usDummy;                      /* DWORD aligns this structure        */
  ULONG  cb;                           /* number of bytes allocated          */
  struct _PDOPENINST    *pNext;        /* pointer to next struct in list     */
  PID uPid;                            /* Process that created this          */
                                       /*   PdOpenInstance                   */
  struct _PORTINST *pPortInst;         /* ->port instance for handle         */
  ULONG   uJobId;                      /* Job ID being printed               */
  /*
  ** NOTE: following fields are pointers to variable length data
  **       Each field points to memory allocated inside the
  **        PDOPENINST memory block.
  **       These fields are freed when the PDOPENINST memory
  **        is freed(ie: their length is included in cb above)
  */
  PSZ pszPortName;                     /* Port Name i.e. "LPT1"              */
} PDOPENINST, *PPDOPENINST;

#define  PD_SIGNATURE  0x4450          /* 'PD' is the signature value        */

/*
** Structure which stores all information about a supported port
*/
typedef struct _PORTINST
{
  USHORT signature;                    /* signature word for validation      */
  USHORT usDummy;                      /* DWORD align structure              */
  ULONG  cb;                           /* number of bytes allocated          */
  struct _PORTINST    *pNext;          /* pointer to next struct in list     */
  PSZ    pszPortName;                  /* ->name of port at end of PORTINST  */
  ULONG  flStatus;                     /* status flags - see PF_ below       */
  ULONG  flJob;                        /* PRTSW.flJob flags                  */
  ULONG  flDevice;                     /* PRTSW.flDevice flags               */
  ULONG  ulJobPrinting;                /* see PDR_ values below              */
  BOOL   fMoreCmds;                    /* Set when Job should wait due to    */
                                       /*    more query cmds coming          */
  HFILE  hFile;                        /* Dos FileHandle to port(IRDD.SYS)   */
  HMTX   hPortSem;                     /* serialize access to this port      */
  ULONG  rc;                           /* asynch error code from port        */
  ULONG  ulTimeLastCmd;                /* Time(seconds) of last cmd for port */
  ULONG  ulTimeLastJob;                /* Time(seconds) of last PdClose      */
  ULONG  ulPrintTimeOut;               /* Seconds to continue to retry job   */
                                       /*  write request in SplPdWrite().    */
                                       /*  Default: 45 seconds               */
  ULONG  ulNoQueryTimeOut;             /* Seconds from last query until      */
                                       /*  port drops printer connection     */
                                       /*  Default: 180 seconds              */
  ULONG  ulNoJobTimeOut;               /* Seconds from last job sent until   */
                                       /*  port drops printer connection     */
                                       /*  NOTE: Connection can be dropped   */
                                       /*        sooner if PDR receives      */
                                       /*        BIDI_NOTIFY_ENDJOBCONNECT   */
                                       /*        This is used if we lose     */
                                       /*        a job acknowledgement so    */
                                       /*        that other Apps can use the */
                                       /*        infrared port.              */
                                       /*  Default: 300 seconds              */
  LMPARMS LMParms;                     /* LMDLL - infrared vars              */

  CHAR    szNickName[MAX_CONNECTNAME_SZ]; /* Device ID string from printer   */

} PORTINST, *PPORTINST;

#define  PT_SIGNATURE  0x5450       /* 'PT' is the signature value        */

         // PORTINST->flStatus flags

#define  PF_Q_PORT_CALLED      0x00000001  /* BIDI_Q_PORT issued for port   */
#define  PF_UNI_DIRECTIONAL    0x00000002  /* Printer not in bidi mode      */
#define  PF_CONNECTED_QUEUE    0x00000004  /* Port connected to print queue */
#define  PF_PORT_OPEN          0x00000008  /* IR Port already open          */
#define  PF_OPEN_IN_PROGRESS   0x00000010  /* IR Port open in progress      */
#define  PF_PROCESS_PDOPEN     0x00000020  /* SplPdOpen being processed     */
#define  PF_PROCESS_PDCLOSE    0x00000040  /* SplPdClose being processed    */
#define  PF_PD_MOREALERTS      0x00000080  /* XlateCmd has more alerts left */
#define  PF_DISCONNECT_POSTED  0x00000100  /* Set when COMM_STATUS_CHANGED  */
                                           /*   alert already posted due to */
                                           /*   a disconnection             */

         // PORTINST->ulJobPrinting values

#define  PDR_NOT_PRINTING    0
#define  PDR_PRINTING        1
#define  PDR_ABORTED         2

/*
** Structure that holds data sent by the printer.
**   An array of these structures is stored in the WAITALERTBUF.
*/
typedef struct _ALERTBUF
{
  PSZ    pszAlertPortName;             /* ->name of port alert received on   */
  ULONG  cbData;                       /* length, in bytes, of data sent by  */
                                       /*   the printer that follows this    */
                                       /*   cbData field.                    */
                                       /* NOTE: if this field is 0, the      */
                                       /*   WaitAlertThread should check     */
                                       /*   the PortInst structure to see if */
                                       /*   a communications alert should    */
                                       /*   be sent to the spooler.          */
                                       /*                                    */
} ALERTBUF, *PALERTBUF;

/*
** Buffer that holds multiple data packets sent by the printer.
**   This is used by the thread processing BIDI_WAIT_ALERT command.
*/
typedef struct _WAITALERTBUF
{
  ULONG  cbBufSize;                    /* total length of this structure     */
  ULONG  cbBufUsed;                    /* bytes used in buffer so far        */
  ULONG  cAlertsRemaining;             /* number of unprocessed alerts left  */
  BOOL   fPdMoreAlerts;                /* TRUE if ProtXlateCmd must be called*/
                                       /*   again with a NULL buffer because */
                                       /*   the last buffer had multiple     */
                                       /*   alerts in it                     */
  PALERTBUF pLastStored;               /* ->last ALERTBUF stored in this buf.*/
                                       /*   This is NULL if no alerts have   */
                                       /*   been stored in this buffer.      */
  PALERTBUF pLastProcessed;            /* ->last ALERTBUF sent to ProtXlate  */
                                       /*   This is NULL if no alerts from   */
                                       /*   this buffer have been sent to    */
                                       /*   ProtXlateCmd yet                 */
  ALERTBUF  FirstAlertBuf;             /* First ALERTBUF stored, followed    */
                                       /*   by its variable length data.     */
                                       /*                                    */
} WAITALERTBUF, *PWAITALERTBUF;

/*
** Structure which stores information needed to handle data
**   coming from multiple printers.
** This is used to handle BIDI_WAIT_ALERT command by keeping a
**   single list of alerts from any port.
** There is only 1 of these structures, and it is allocated as a
**   variable, not dynamically allocated.  The variable is PdrWaitAlert.
*/
typedef struct _PDRWAITALERT
{
  PWAITALERTBUF pCurrBuf;              /* Current WAITALERTBUF we are using  */
                                       /*   to store alert data received     */
                                       /*   from printers                    */
  PWAITALERTBUF pXlateBuf;             /* WAITALERTBUF being processed by    */
                                       /*   the BIDI_WAIT_ALERT thread       */
  HEV    hevWaitAlert;                 /* EventSem for thread processing     */
                                       /*   the BIDI_WAIT_ALERT command.     */
} PDRWAITALERT, *PPDRWAITALERT;

/*
** Structure to get/set configuration of a port.
** Used when a Bidi spooler is installed that
**   exports PrtQuery and PrtSet.
** The port driver gets these using
**   PrtQuery( BIDI_Q_PORTDRV)
** and changes the port's settings using
**   PrtSet( BIDI_SET_PORTDRV
*/

typedef struct _PORTSETTINGS
{
   ULONG   signature;           /* Must be INFR_SIGNATURE                */
   ULONG   ulVersion;           /* Version of structure is 1             */
   ULONG   flStatus;            /* status flags - see PF_ above          */
                                /*  If PF_Q_PORT_CALLED set then the     */
                                /*   Bidi spooler is enabled.            */
   ULONG   ulPrintTimeOut;      /* Seconds to continue to retry job      */
                                /*  write request in SplPdWrite().       */
                                /*  Default: 45 seconds                  */
   ULONG   ulNoQueryTimeOut;    /* Seconds from last query until         */
                                /*  port drops printer connection        */
                                /*  Default: 180 seconds                 */
   ULONG   ulNoJobTimeOut;      /* Seconds from last job sent until      */
                                /*  port drops printer connection        */
                                /*  NOTE: Connection can be dropped      */
                                /*        sooner if PDR receives         */
                                /*        BIDI_NOTIFY_ENDJOBCONNECT      */
                                /*        This is used if we lose        */
                                /*        a job acknowledgement so       */
                                /*        that other Apps can use the    */
                                /*        infrared port.                 */
                                /*  Default: 300 seconds                 */
                                /*                                       */
                                /*                                       */
                                /* The following ulpsz fields are        */
                                /*  offsets from the beginning of        */
                                /*  this PORTSETTINGS structure to       */
                                /*  the variable length strings.         */
                                /* This allows us to pass the buffer     */
                                /*  intact to PrtQuery and PrtSet,       */
                                /*  even across the network.             */
                                /* All strings are packed immediately    */
                                /*  after the fixed-length PORTSETTINGS  */
                                /*  structure.                           */
                                /*                                       */
                                /* An offset of 0 means no string        */
                                /*                                       */
   ULONG   ulpszPortName;       /* -> name of port info is for           */
   ULONG   ulpszDescription;    /* -> description of port                */
   ULONG   ulpszConnectName;    /* -> IR nickname for printer on port    */
   ULONG   ulcDeviceNames;      /* Number of IR printer names found      */
                                /* This field determines how many null   */
                                /*  terminated strings are pointed to    */
                                /*  by ulpszDeviceList.                  */
   ULONG   ulpszDeviceList;     /* -> list of nicknames for IR printers  */
                                /*  Each string is null terminated       */
                                /*  ulcDevice is the number of names     */
                                /*  in this list                         */
} PORTSETTINGS, *PPORTSETTINGS;
#define INFR_SIGNATURE 0x52464E49       /* Signature is 'INFR' */

/*
** Structure used by SplPdSetPort and SplPdRemoteSetPort for displaying
**  and changing the InfraRed port's connection parameters
*/
typedef struct _PORTDLGSTRUCT
{
   ULONG   signature;           /* Must be PDLG_SIGNATURE                */
   struct _PORTDLGSTRUCT *pNext;/* Next port dlg struct                  */
   HAB     hAB;                 /* Anchor block                          */
   HWND    hwndDlg;             /* hwnd InfraredDlg dialog box           */
   HMODULE hModule;             /* hMod INFRARED.PDR                     */
   HMODULE hModLMDLL;           /* hMod LMDLL.DLL                        */
   ULONG   flModified;          /* TRUE if settings modified             */
   ULONG   cbPortSettings;      /* Size of pPortSettings in bytes        */
   PPORTSETTINGS pPortSettings; /* ->separately allocated PORTSETTINGS   */
                                /*   buffer.  This must be freed when    */
                                /*   the dialog is dismissed             */
                                /*   by using DosFreeMem()               */
   PSZ     pszComputerName;     /* ->computer settings dialog is for     */
                                /*   NULL for local settings             */
   PSZ     pszPortName;         /* ->port name on pszComputer that the   */
                                /*   settings are being displayed        */
                                /*                                       */
                                /* The original values for the following */
                                /*  fields are in pPortSettings:         */
                                /*                                       */
   ULONG   ulPrintTimeOut;      /* Updated seconds to continue to retry  */
                                /*  job write request in SplPdWrite().   */
                                /*  Default: 45 seconds                  */
   ULONG   ulNoQueryTimeOut;    /* Updated seconds from last query until */
                                /*  port drops printer connection        */
                                /*  Default: 60 seconds                  */
   ULONG   ulNoJobTimeOut;      /* Updated seconds from last job sent    */
                                /*  until port drops printer connection  */
                                /*  NOTE: Connection can be dropped      */
                                /*        sooner if PDR receives         */
                                /*        BIDI_NOTIFY_ENDJOBCONNECT      */
                                /*        This is used if we lose        */
                                /*        a job acknowledgement so       */
                                /*        that other Apps can use the    */
                                /*        infrared port.                 */
                                /*  Default: 300 seconds                 */
                                /*                                       */
                                /* The next field is the new IR nickname */
                                /*  of the printer to use for this       */
                                /*  IR port:                             */
   CHAR    szDescription[CCHMAXPATH];
   CHAR    szConnectName[MAX_CONNECTNAME_SZ];
} PORTDLGSTRUCT, *PPORTDLGSTRUCT;
#define PDLG_SIGNATURE 0x474C4450       /* Signature is 'PDLG' */

typedef struct _FREEMEM {
    USHORT      signature;      /* signature word for validating memory */
    USHORT usDummy;
    ULONG  cb;                           /* number of bytes allocated   */
    struct _FREEMEM *pNext;
} FREEMEM;
typedef FREEMEM *PFREEMEM;

#define FR_SIGNATURE    0x5246  /* "FR" is the signature value */


/*
** Structure used in front of the data passed to the IR device driver
**   to help identify the data on the callback.
*/

typedef struct _DATAINFO {
  USHORT   signature;              /* signature word for validating memory    */
  USHORT   usDummy;                /* fill word for DWORD alignment           */
  ULONG    cb;                     /* total bytes for this structure          */
  struct   _DATAINFO *pNext;       /* ->next buffer waiting confirmation from */
                                   /*   the printer                           */
  PLMPARMS pLMParms;               /* pointer to port driver LM instance data */
                                   /*  sem in this struct is used to block    */
                                   /*  the pdWrite until the writes complete  */
  ULONG   ulDataType;              /* ulDataType - bits defining the data     */
                                   /*  sent( see IRDATATYPE_ in pdrconst.h )  */
  ULONG   ulDataSize;              /* size of data in buffer                  */
} DATAINFO;
typedef DATAINFO  *PDATAINFO;

#define DI_SIGNATURE    0x4944  /* "DI" is the signature value */


/*
** Assert routine macro defines
*/
#ifdef DEBUG_ALERT
  #define ASSERTT(exp)  {if (exp)  { char logbuf[260]; sprintf( logbuf, "AssertFailed rc=%d in %s line %d\r\n", exp,__FILE__,__LINE__); LogCall(logbuf);}}
  #define ASSERTF(exp)  {if (!(exp))  { char logbuf[260]; sprintf( logbuf, "AssertFailed %s in %s line %d\r\n", (PSZ)#exp,__FILE__,__LINE__); LogCall(logbuf);}}
  #define DBPRINTF(list) {char logbuf[260]; sprintf list ; strcat( logbuf, "\r\n"); LogCall(logbuf); }
#else
  #define ASSERTT(x)
  #define ASSERTF(x)
  #define DBPRINTF(str)
#endif /* DEBUG_ALERT */

/*
** The following typedefs are for functions only exported by
**   the bidi spooler(PMSPL.DLL) available in a fixpak.
** These functions are not exported by the original Warp spooler,
**   so we try DosQueryProcAddr() to determine if the bidi spooler
**   is installed.  This way our port driver runs on the
**   original Warp system without requiring a fixpak.
**
** Typedefs for PrtQuery and PrtSet exported by PMSPL.DLL:
*/
typedef ULONG (APIENTRY FNPRTQUERY) ( PSZ, PSZ, ULONG, ULONG, PVOID,
                                      ULONG, PVOID, PULONG );
typedef FNPRTQUERY *PFNPRTQUERY;

typedef ULONG (APIENTRY FNPRTSET) ( PSZ, PSZ, ULONG, ULONG, PVOID,
                                    ULONG );
typedef FNPRTSET *PFNPRTSET;


/*
** Typedefs for protocol converter APIs SplProtSendCmd and SplProtXlateCmd
** A port driver actually calls PMSPL.DLL at these entry points
**  and the spooler calls the correct protocol conveter for the port.
*/

typedef ULONG (APIENTRY FNPROTSEND) ( PSZ, ULONG, ULONG, PFN, PFN, PVOID,
                                      ULONG, PVOID, PULONG );
typedef FNPROTSEND *PFNPROTSEND;

typedef ULONG (APIENTRY FNPROTXLAT) ( PSZ, PFN, PVOID, ULONG, PVOID,
                                      PVOID, PULONG );
typedef FNPROTXLAT *PFNPROTXLAT;


#ifdef MAINPORTDRV
 HWND hwndHelp = NULLHANDLE;
 BOOL HelpStubHookIsSet = FALSE;
 BOOL HelpAlreadyInitialized = FALSE;
 PVOID pHeapBase = NULL;
 HMTX semPortDrv = NULLHANDLE;
 HEV  hevControl = NULLHANDLE;
 PDRWAITALERT PdrWaitAlert;
 TID   tidControlThread = 0;
 BOOL  fShutdownInProgress   = FALSE;
 BOOL  fControlWakeupPending = FALSE;
 HMODULE hPdrMod = NULLHANDLE;
 PPDOPENINST pPdOpenInstList = NULL;
 PPORTINST pPortInstList = NULL;
 BOOL         fLoadedPMSPL    = FALSE;
 PFNPROTSEND  pfnProtSendCmd  = NULL;
 PFNPROTXLAT  pfnProtXlateCmd = NULL;
 PFNPRTQUERY  pfnPrtQuery     = NULL;
 PFNPRTSET    pfnPrtSet       = NULL;
 PPORTDLGSTRUCT pOpenDlgList  = NULL;
#else
 extern
 HWND hwndHelp ;
 extern
 BOOL HelpStubHookIsSet;
 extern
 BOOL HelpAlreadyInitialized;
 extern
 PVOID pHeapBase;
 extern
 HMTX semPortDrv;
 extern
 HEV  hevControl;
 extern
 PDRWAITALERT PdrWaitAlert;
 extern
 TID   tidControlThread;
 extern
 BOOL  fShutdownInProgress;
 extern
 BOOL  fControlWakeupPending;
 extern
 HMODULE hPdrMod;
 extern
 PPDOPENINST pPdOpenInstList;
 extern
 PPORTINST pPortInstList;
 extern
 BOOL         fLoadedPMSPL;
 extern
 PFNPROTSEND  pfnProtSendCmd;
 extern
 PFNPROTXLAT  pfnProtXlateCmd;
 extern
 PFNPRTQUERY  pfnPrtQuery;
 extern
 PFNPRTSET    pfnPrtSet;
 extern
 PPORTDLGSTRUCT pOpenDlgList;

#endif
