/**************************************************************************
 *
 * SOURCE FILE NAME = PDRPROTO.H
 *
 * DESCRIPTIVE NAME = Function prototypes for port driver
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 *
 ****************************************************************************/
/*
 * In util.c
 */
PVOID       AllocPdrMem ( ULONG cb );
ULONG       FreePdrMem ( PVOID pMem, ULONG cb );
ULONG       EnterPdrSem ( VOID );
ULONG       LeavePdrSem ( VOID );
VOID        PdrError ( ULONG ulCode, ULONG ulFile );
VOID        PdrPanic ( ULONG ulCode, ULONG ulFile );
VOID        PdrWarning ( ULONG ulCode, ULONG ulFile );
ULONG       AddPdOpenInst ( PPDOPENINST pPdOpenInst );
ULONG       RemovePdOpenInst ( PPDOPENINST pPdOpenInst );
PPDOPENINST ValidatePdOpenInst ( PPDOPENINST pPdOpenInst );
PPORTINST   AddPortInst ( PSZ pszPortName );
PPORTINST   NewPortInst ( PSZ pszPortName );
PPORTINST   FindPortInst ( PSZ pszPortName );
ULONG       RemovePortInst ( PSZ pszPortName );
ULONG       FreePortInst ( PPORTINST pPortInst );
ULONG       FreeAllPortInst ( VOID );
BOOL        GetConnectionName( PSZ pszPort,  PSZ pszBuf );
BOOL        GetTimeOuts( PSZ pszPort, PPORTINST pPortInst );
VOID        DumpHex ( PBYTE pbHexChars, ULONG cb );
VOID        LogCall( PSZ pszMsg );
ULONG       time ( VOID );
BOOL        GenerateUniquePortName( PSZ pszPortName );
ULONG       MyPrtQuery ( PSZ    pszComputerName,
                         PSZ    pszDeviceName,
                         ULONG  ulType,
                         ULONG  ulCommand,
                         PVOID  pInData,
                         ULONG  cbInData,
                         PVOID  pOutData,
                         PULONG pcbOutData );

ULONG       MyPrtSet   ( PSZ    pszComputerName,
                         PSZ    pszDeviceName,
                         ULONG  ulType,
                         ULONG  ulCommand,
                         PVOID  pInData,
                         ULONG  cbInData );

ULONG       MySplProtSendCmd( PSZ    pszPortName,
                              ULONG  ulType,
                              ULONG  ulCommand,
                              PFN    pfnPdSendCmd,
                              PFN    pfnBaseProtSendCmd,
                              PVOID  pInData,
                              ULONG  cbInData,
                              PVOID  pOutData,
                              PULONG pcbOutData );

ULONG       MySplProtXlateCmd( PSZ    pszPortName,
                               PFN    pfnBaseProtXlateCmd,
                               PVOID  pInData,
                               ULONG  cbInData,
                               PVOID  pAlertInfo,
                               PVOID  pOutData,
                               PULONG pcbOutData );
VOID        LoadPMSPL( VOID );
VOID AddDataInfoBuf ( PDATAINFO *ppHead, PDATAINFO pNewItem );
BOOL RemoveDataInfoBuf ( PDATAINFO *ppHead, PDATAINFO pOldItem );
ULONG FreeConfirmedBufs ( PDATAINFO *ppHead );
BOOL AddPortDlgStruct ( PPORTDLGSTRUCT pPortDlgStruct );
BOOL RemovePortDlgStruct ( PPORTDLGSTRUCT pPortDlgStruct );
PPORTDLGSTRUCT FindPortDlgStruct ( PPORTDLGSTRUCT pPortDlgStruct );


/*
 * In help.c
 */
BOOL APIENTRY CALLAssociateHelpInstance (HWND hwndHelpInstance, HWND hwndApp);
BOOL APIENTRY CALLDestroyHelpInstance(HWND hwndHelpInstance);
HWND APIENTRY CALLCreateHelpInstance(HAB hab,PHELPINIT phinitHMInitStructure);
HWND APIENTRY CALLQueryHelpInstance(HWND hwndApp);
VOID EXPENTRY InitializeHelp(VOID);
BOOL EXPENTRY SetHelpStubHook(VOID);
VOID EXPENTRY ReleaseHelpStubHook(VOID);
INT  EXPENTRY HelpStubHook( HAB AppHAB, USHORT Context, USHORT IdTopic,
                            USHORT IdSubTopic, PRECTL RectLPtr );

/*
 * In infrared.c
 */
ULONG   APIENTRY InfraredWrite( PPORTINST  pPortInst, PVOID pchData,
                                ULONG cbData, PULONG pcbWritten);
LONG    APIENTRY InfraredOpen( PPORTINST pPortInst );
LONG    APIENTRY InfraredDisconnect(PLMPARMS pLMParms);
LONG    APIENTRY InfraredClose(PLMPARMS pLMParms, LSAPSEL lsap,
                               PHFILE phFile);
LONG    APIENTRY InfraredDisplayDevices( PLMPARMS pLMParms,
                                         PSZ pszConnection,
                                         HWND hwnd);
MRESULT EXPENTRY InfraredDlg( HWND hDlg, USHORT msg, MPARAM mp1, MPARAM mp2 );
ULONG   APIENTRY WriteWithRetry( PPORTINST  pPortInst, PVOID pchData,
                                 ULONG cbData, PULONG pcbWritten);
ULONG   HandleWaitAlert( PSZ    pszDeviceName,
                         ULONG  ulFlags,
                         ULONG  ulCommand,
                         PVOID  pInData,
                         ULONG  cbInData,
                         PVOID  pOutData,
                         PULONG pcbOutData );
ULONG   HandleQPort( PSZ    pszDeviceName,
                     ULONG  ulFlags,
                     PVOID  pOutData,
                     PULONG pcbOutData );
ULONG   OpenInfraredPortDlg ( HAB hab, PPORTDLGSTRUCT pPortDlgStruct );
ULONG   CalcBufLength ( HAB hab );
ULONG   NumPortsCanFit ( HAB hab, ULONG cbBuf );
VOID    CopyNPorts ( HAB hab, PCH pBuf, ULONG ulReturned ) ;
BOOL    GetPortDescription ( HAB hab, PSZ pszPortName, PSZ pszPortDesc );
ULONG   HandleQPortDRV( PSZ pszPortName, PPORTSETTINGS pPortSettings,
                        PULONG pcbPortSettings );
ULONG   HandleSetPortDRV ( PSZ           pszPortName,
                           PPORTSETTINGS pPortSettings,
                           ULONG         cbPortSettings );
BOOL    GetPortSettings( PPORTSETTINGS pPortSettings );
BOOL    SavePortSettings( PPORTDLGSTRUCT pPortDlgStruct );
BOOL    CheckPortSettings( PPORTSETTINGS pPortSettings );
ULONG   PdInitPort ( HFILE hFile, PSZ pszPortName );
USHORT  DisplayError ( HWND hwndOwner, USHORT usStringID, USHORT usWinStyle );
TID     CreateControlThread( VOID );

/*
 * In init.c
 */
ULONG APIENTRY LoadInfraredDLL( PHMODULE phModule, PLMPFNS plmpfns);
