/**************************************************************************
 *
 * SOURCE FILE NAME = PDCCONST.H
 *
 * DESCRIPTIVE NAME = Constant defines for port driver sample
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 *
 ****************************************************************************/

#define PDR_HELPFILE_NAME       "INFRARED.HLP"
#define PDR_HELPFILE_EXT        ".HLP"
//#define PDR_HELPFILE_NAME       "WPHELP.HLP"

#define NO_ERROR                     0
#define ERROR_MORE_DATA              234
#define ERROR_INSUFFICIENT_BUFFER    122

/*
** Return values for internal routine FindConnectName()
*/
#define PDR_CONNECTNAME_FOUND        0
#define PDR_OTHER_PRINTER_FOUND      1
#define PDR_NO_PRINTERS_FOUND        2

#define MAX_CONNECTNAME_SZ           64
#define DEFAULT_BUFSIZE              4096
#define DEF_WAITALERTBUF_SIZE        60*1024

#define ID_NUMBER_OF_DESC_LINES 8000
#define ID_FIRST_DESC_LINES     8001
#define ID_IR_INIT_ERROR        8002
#define ID_IR_BIND_ERROR        8003
#define ID_IR_DISCOVER_ERROR    8004
#define ID_IR_CONNECT_ERROR     8005
#define ID_IR_DLLLOAD_ERROR     8006
#define ID_IR_CONFIG_ERROR      8007
#define ID_IR_BUSY_ERROR        8008
#define ID_IR_SETTINGS_ERROR    8009

#define PORT_ID_1               5001
#define PORT_DESC_1             5002
#define PORT_ID_2               5003
#define PORT_DESC_2             5004
#define PORT_ID_3               5005
#define PORT_DESC_3             5006
#define PORT_HELP_TITLE         5100
#define PORT_ERR_TITLE          7000

#define PDR_ID_PROPERTIES       6001

#define PORT_ID_FIRST           PORT_ID_1
#define PORT_ID_LAST            PORT_ID_1

#define INFRARED_ICON           7001

#define STR_LEN_PORTNAME        64
#define STR_LEN_PORTDESC        256
#define STR_LEN_DESC            81
#define STR_LEN_TITLE           256

   /*
   ** port defaults
   */
#define DEF_INITIALIZATION      ";"
#define DEF_OLD_INITIALIZATION  ";"
#define DEF_TERMINATION         ";"
#define DEF_CONNECTION          ";"
#define DEF_TIMEOUT_PRINT       "45;"
#define DEF_TIMEOUT_QUERY       "180;"
#define DEF_TIMEOUT_JOB         "300;"
#define DEF_PORTDRIVER          "INFRARED;"
#define DEF_PORTNAME            "INFRARED"

#define TIMEOUT_LOWER_LIMIT      0
#define TIMEOUT_UPPER_LIMIT      9999
#define DEF_TIMEOUT_PRINT_VALUE  45
#define DEF_TIMEOUT_QUERY_VALUE  180
#define DEF_TIMEOUT_JOB_VALUE    300

#define APPNAME_LEAD_STR           "PM_"

#define KEY_DESCRIPTION            "DESCRIPTION"
#define KEY_INITIALIZATION         "INITIALIZATION"
#define KEY_TERMINATION            "TERMINATION"
#define KEY_PORTDRIVER             "PORTDRIVER"
#define KEY_TIMEOUT_PRINT          "TIMEOUT"
#define KEY_TIMEOUT_QUERY          "TIMEOUT_QUERY"
#define KEY_TIMEOUT_JOB            "TIMEOUT_JOB"
#define KEY_CONNECTION             "CONNECTION"

#define APPNAME_PM_SPOOLER_PORT    "PM_SPOOLER_PORT"

#define NumPorts() (((PORT_ID_LAST - PORT_ID_FIRST) >> 1) + 1)

   /*
   ** Port Settings - Infrared Port
   */
#define IDD_PORTINFRARED      21400
#define IDC_PPA_PRINTTIMEOUT  (IDD_PORTINFRARED + 1)  /* Print Timeout      */
#define IDC_PPA_QUERYTIMEOUT  (IDD_PORTINFRARED + 2)  /* Query Timeout      */
#define IDC_PPA_JOBTIMEOUT    (IDD_PORTINFRARED + 3)  /* Job Timeout        */
#define IDC_PPA_DESC          (IDD_PORTINFRARED + 4)  /* description        */
#define IDC_PPA_SHAREHW       (IDD_PORTINFRARED + 5)  /* share access       */
#define IDC_PPA_CONNECTIONS   (IDD_PORTINFRARED + 6)  /* Connections        */
#define IDC_OK                1100                    /* OK push button     */
#define IDC_CANCEL            1101                    /* Cancel push button */
#define IDC_HELP              1102                    /* Help push button   */
#define IDC_RESET             1103                    /* Help push button   */
#define IDC_DEFAULT           1104                    /* Help push button   */

#define IDH_DLG_EXTENDED      15483
#define IDH_PPA_TIMEOUT_PRINT 15484
#define IDH_PPA_TIMEOUT_QUERY 15485
#define IDH_PPA_TIMEOUT_JOB   15486
#define IDH_PPA_SHAREHW       15822
#define IDH_PPA_DESC          15715
#define IDH_OK                1090
#define IDH_CANCEL            1091
#define IDH_RESET             1092
#define IDH_DEFAULT           1093
#define IDH_HELP              15483


  /*
  ** Infrared driver specific defines
  */
#define  STSOK stsOK               /* 1 GOOD LM return                       */
#define  STSFAILED  stsFailed      /* Bad  LM return                         */

#define IRDATATYPE_LASTBUFFER      0x01  /* bit 1 identifies the last buffer */
                                         /* of multiple writes               */
                                         /* The callback will unblock the    */
                                         /* the pdWrite function when this   */
                                         /* buffer is received               */

#define IR_HINT1_PNP               0x01
#define IR_HINT1_PDA               0x02
#define IR_HINT1_COMPUTER          0x04
#define IR_HINT1_PRINTER           0x08
#define IR_HINT1_MODEM             0x10
#define IR_HINT1_FAX               0x20
#define IR_HINT1_LAN               0x40

#define IR_HINT_EXTENSION          0x80

#define IR_HINT2_TELEPHONY         0x01
#define IR_HINT2_FILESERVER        0x02
#define IR_HINT2_IRCOMM            0x04
#define IR_HINT2_RES2              0x08
#define IR_HINT2_RES3              0x10
#define IR_HINT2_RES4              0x20
#define IR_HINT2_RES5              0x40

