/* @(#)70       1.1  api/LMAPI.H, api, irda_1.00, irlevel_0.22 9/27/95 19:38:15 */
/*
   *********************************************************************
   *     Copyright 1994,1995 IBM Corporation,   All Rights Reserved    *
   *                                                                   *
   * $Workfile:   lmapi.h  $                                           *
   *                                                                   *
   * Description  :                                                    *
   *                                                                   *
   * $Revision:   2.0  $                                               *
   *   $Author:   FNOVAK  $                                            *
   *     $Date:   $                                                    *
   *      $Log:   $                                                    *
   *                                                                   *
   *********************************************************************
*/

#ifndef  lmapi_h
#define  lmapi_h

#ifndef  cmntypes_h
#include "cmntypes.h"
#endif

#ifdef __cplusplus
   extern "C" {
#endif


typedef  U16      HCONNECTION, *P_HCONNECTION, LMPTR * LP_HCONNECTION;
typedef  U16      HDEVICE, *P_HDEVICE, LMPTR *LP_HDEVICE;
typedef  U32      DEVADDR;
typedef  U32      HUSERDATA, *P_HUSERDATA, LMPTR * LP_HUSERDATA;


#define IR_HINT1_PNP               0x01
#define IR_HINT1_PDA               0x02
#define IR_HINT1_COMPUTER          0x04
#define IR_HINT1_PRINTER           0x08
#define IR_HINT1_MODEM             0x10
#define IR_HINT1_FAX               0x20
#define IR_HINT1_LAN               0x40

#define IR_HINT_EXTENSION          0x80

#define IR_HINT2_TELEPHONY         0x01
#define IR_HINT2_FILESERVER        0x02
#define IR_HINT2_IRCOMM            0x04
#define IR_HINT2_RES2              0x08
#define IR_HINT2_RES3              0x10
#define IR_HINT2_RES4              0x20
#define IR_HINT2_RES5              0x40


#pragma pack(1)
typedef  struct   _USER_STRING
{
   U8    characterSet;
   U8    length;
   U8    string[1];

} USER_STRING, *P_USER_STRING, LMPTR * LP_USER_STRING;
#pragma pack()

typedef  U16   XID_METHOD;

#define  unknown     0
#define  active      1
#define  passive     2
#define  sniff       3

#define  XID_MAXLEN_NICKNAME     20
#define  XID_MAXLEN  24

#define  MAX_HINTS   2              // max bytes of hints

#pragma pack(1)
typedef  struct   _XID_INFO
{
   U8    xidInfo[XID_MAXLEN];
   struct
   {
      LP_U8 hints;
      LP_U8 nickName;
      U8    lenHints;
      U8    characterSet;
      U8    lenName;
      U8    length;
   } stdInfo;

} XID_INFO, *P_XID_INFO, LMPTR * LP_XID_INFO;
#pragma pack()

#pragma pack(1)
typedef  struct   _DEVICE_DISCOVERY_INFO
{
   HDEVICE     hDevice;
   XID_INFO    xid;
   XID_METHOD  method;

} DEVICE_DISCOVERY_INFO , * P_DEVICE_DISCOVERY_INFO
  , LMPTR * LP_DEVICE_DISCOVERY_INFO;

typedef  struct   _DEVICE_DISCOVERY_LIST
{
   BOOLEAN                 cached;
   U16                     nrItems;
   DEVICE_DISCOVERY_INFO   device[1];

} DEVICE_DISCOVERY_LIST, * P_DEVICE_DISCOVERY_LIST
   , LMPTR * LP_DEVICE_DISCOVERY_LIST;
#pragma pack()

#define  LM_MAX_NAME_LENGTH   60

typedef  struct   _NAME
{
   U8    length;
   U8    name[1];

} NAME;

typedef  NAME  CLASS_NAME, *P_CLASS_NAME, LMPTR * LP_CLASS_NAME;

typedef  NAME  ATTRIBUTE_NAME, *P_ATTRIBUTE_NAME, LMPTR * LP_ATTRIBUTE_NAME;

typedef  U16   OBJECTID, *_P_OBJECTID, LMPTR * LP_OBJECTID;

#pragma  pack(1)
typedef  struct   _OBJECT_ITEM
{
   OBJECTID    idObject;
   CLASS_NAME  className;

} OBJECT_ITEM, * P_OBJECT_ITEM, LMPTR * LP_OBJECT_ITEM;
#pragma  pack()

#pragma  pack(1)
typedef  struct   _OBJECT_LIST
{
   U16         nrItems;
   OBJECT_ITEM object[1];

} OBJECT_LIST, * P_OBJECT_LIST, LMPTR * LP_OBJECT_LIST;
#pragma  pack()

typedef  U16   ATTRIBUTEID, *P_ATTRIBUTEID, LMPTR * LP_ATTRIBUTEID;

#define  missing     0x00
#define  integer     0x01
#define  octetSeq    0x02
#define  userString  0x03

typedef  U8 ATTRIBUTE_TYPE;

#pragma  pack(1)
typedef  struct   _ATTRIBUTE_VALUE
{
   ATTRIBUTE_TYPE attributeType;
   union
   {
      U32   anInteger;
      struct
      {
         U16   length;
         U8    info[1];
      } octet;
      USER_STRING string;

   } value;

} ATTRIBUTE_VALUE, * P_ATTRIBUTE_VALUE, LMPTR * LP_ATTRIBUTE_VALUE;
#pragma pack()


#pragma  pack(1)
typedef  struct   _ATTRIBUTE_VALUE_LIST
{
   U16               nrItems;
   ATTRIBUTE_VALUE   attribValue[1];

} ATTRIBUTE_VALUE_LIST , * P_ATTRIBUTE_VALUE_LIST
   ,LMPTR * LP_ATTRIBUTE_VALUE_LIST;
#pragma  pack()


#pragma  pack(1)
typedef  struct   _ATTRIBUTE_NAME_LIST
{
   U16               nrItems;
   ATTRIBUTE_NAME    attribName[1];

} ATTRIBUTE_NAME_LIST , * P_ATTRIBUTE_NAME_LIST
   , LMPTR * LP_ATTRIBUTE_NAME_LIST;
#pragma  pack()

#pragma  pack(1)
typedef  struct   _ATTR_OWNER
{
   OBJECTID          idObject;
   ATTRIBUTE_VALUE   attributeValue;

} ATTR_OWNER, *P_ATTR_OWNER , LMPTR *LP_ATTR_OWNER ;
#pragma  pack()

#pragma  pack(1)
typedef  struct   _ATTR_OWNER_LIST
{
   U16         nrItems;
   ATTR_OWNER  attributeOwner;

} ATTR_OWNER_LIST, *P_ATTR_OWNER_LIST, LMPTR * LP_ATTR_OWNER_LIST;
#pragma  pack()

typedef  U8    LSAPSEL, * P_LSAPSEL, LMPTR * LP_LSAPSEL;

#define  INVALID_LSAP         0xfe
#define  INVALID_CONNECTION   0xffff
#define  INVALID_LINK         0xffff

typedef  struct   _LSAPID
{
   HDEVICE  hDevice;
   LSAPSEL  lsap;

} LSAPID, *P_LSAPID, LMPTR * LP_LSAPID;

typedef  U16   HDATA, *P_HDATA, LMPTR * LP_HDATA;

#define  physicalPtr    0
#define  gdtPtr         2
#define  virtualPtr     3

typedef  struct   _DATA_BLOCK
{
   U8    ptrType;
   U8    rsvdByte;
   U16   dataLength;
   LP_U8 pData;

} DATA_BLOCK, * P_DATA_BLOCK, LMPTR * LP_DATA_BLOCK;

#define  lmMaxTxDataBlk   7
#define  lmMaxRxDataBlk   7

typedef  struct   _TX_BUFFER_DESC
{
   U16         txImmedLen;
   LP_U8       pTxImmed;
   U16         txDataCount;
   DATA_BLOCK  txDataBlk[lmMaxTxDataBlk];

} TX_BUFFER_DESC, * P_TX_BUFFER_DESC, LMPTR * LP_TX_BUFFER_DESC;

typedef  LP_TX_BUFFER_DESC LMPTR * LPLP_TX_BUFFER_DESC;

typedef  struct   _RX_BUFFER_DESC
{
   U16         rxDataCount;
   DATA_BLOCK  rxDataBlk[lmMaxRxDataBlk];

} RX_BUFFER_DESC, * P_RX_BUFFER_DESC, LMPTR * LP_RX_BUFFER_DESC;

#ifdef  __IBMC__
#define  LMAPI    _System  LOADDS
#else
#define  LMAPI    LMPTR EXPORT PASCAL LOADDS
#endif

#define  LOADDS   _loadds

// This is really a CSET/2 compiler issues!!

#ifdef  __IBMC__
#define  LMAPIFNC * LMAPI
#else
#define  LMAPIFNC LMAPI *
#endif

#define  LMINDIC     LMAPI
#define  LMCONF      LMAPI
#define  LMINDICFNC  LMAPIFNC
#define  LMCONFFNC   LMAPIFNC

typedef  S16      LMSTATUS;
typedef  S16      LMERROR, *P_ERROR, LMPTR * LP_ERROR;

// This is a native int size problem but for now we're special casing!
#if  defined(OS2DLL) || defined(OS2VDD)
typedef S32       IRSTATUS;
#else
typedef  S16      IRSTATUS;
#endif

typedef  LMSTATUS ( LMAPIFNC  LP_BaudRoutine) (U32 baudRate);

typedef  enum  _IRPORT_CLASS
{
        com      = 0
      , dongle   = 1
      , fir1     = 2
} IRPORT_CLASS , * P_IRPORT_CLASS, LMPTR * LP_IRPORT_CLASS;

typedef  enum  _IRPORT_TYPE
{
        irda      = 0
      , variable  = 1
      , fixed     = 2
} IRPORT_TYPE , * P_IRPORT_TYPE, LMPTR * LP_IRPORT_TYPE;

typedef  struct   _IRPORT_DESIGNATION
{
   U16      portId;
   U16      baseAddress;
   U16      irqLevel;

} IRPORT_DESIGNATION, * P_IRPORT_DESIGNATION, LMPTR * LP_IRPORT_DESIGNATION;

typedef  union  _IRPORT_BAUDINFO
{

   // Baud Info for the IrDA type
   struct
   {
      U32   operatingBaudMask;
      LP_BaudRoutine lpBaudRoutine;
   } irdaBaudInfo;

   // Baud Info for the variable type  port
   struct
   {
      U32   operatingBaudMask;
      U32   negotiatingBaudRate;
      LP_BaudRoutine lpBaudRoutine;
   }  variableBaudInfo;

   // Baud Info for the fixed type port
   struct
   {
      U32   operatingBaudRate;
      LP_BaudRoutine lpBaudRoutine;
   }  fixedBaudInfo;

}  IRPORT_BAUDINFO , * P_IRPORT_BAUDINFO  , LMPTR * LP_IRPORT_BAUDINFO;

typedef  struct _IRPORT_PARMS
{
   IRPORT_DESIGNATION   designation;
   IRPORT_CLASS         classPort;
   IRPORT_TYPE          type;
//   IRPORT_DESIGNATION   designation;
   IRPORT_BAUDINFO      baudSupport;

} IRPORT_PARMS, * P_IRPORT_PARMS, LMPTR * LP_IRPORT_PARMS;



#pragma pack (1)

typedef struct  _CONNECT_PARMS
{
   U32 baudRate;
   U8  windowSize;
   U16 maxTurnTime;
   U16 maxDataSize;
   U8  bofCount;
   U16 minTurnTime;
   U8  pollTimeout;
   U16 discThreshold;

}  CONNECT_PARMS , * P_CONNECT_PARMS, LMPTR * LP_CONNECT_PARMS;

#pragma pack ()

#define  maxLsapStates  9

typedef  enum  _LSAP_CONN_STATE
{
     lsapDisconnected   = 0
   , lsapLockedOut      = 1
   , lsapSetupPending   = 2
   , lsapSetup          = 3
   , lsapConnect        = 4
   , lsapDtr            = 5
   , lsapDtrIdle        = 6
   , lsapDtrLocked      = 7
   , lsapDisconnecting  = 8

} LSAP_CONN_STATE, * P_LSAP_CONN_STATE, LMPTR * LP_LSAP_CONN_STATE;



typedef  struct   _STATISTICS
{
     U32  rxFramesOk;             /* total frames received OK */
     U32  rxFramesCrcErr;         /* total frames with CRC error */
     U32  rxTotalBytes;           /* Total Bytes received OK */
     U32  rxFramesDiscardBuf;     /* frames discarded - no buffer space */
     U32  rxBroadcastFrames;      /* broadcast frames received */
     U32  rxFramesDiscardHwErr;   /* frames discarded hardware error */
     U32  txFramesOk;             /* total frames transmitted OK */
     U32  txTotalBytes;           /* total bytes transmitted  */
     U32  txBroadcastFrames;     /* total broadcast frames transmitted */
     U32  txFramesNotTxTimeout;   /* total frames not transmitted, time out*/
     U32  txFramesNotTxHwErr;     /* total frames not transmitted, Hw error*/

} STATISTICS, * P_STATISTICS, LMPTR * LP_STATISTICS;


typedef  BOOLEAN  (LMINDICFNC  LMCB_CONN_INDIC) (HCONNECTION
                     , LP_CONNECT_PARMS, LP_VOID, U16
// #if (OS2PDD || OS2DLL)      /* 1/25/96 */
                     , LSAPSEL
// #endif
                     );

typedef  BOOLEAN  (LMINDICFNC  LMCB_DISC_INDIC) (HCONNECTION, LP_VOID
                     , U16 , LMSTATUS, U32);

typedef  BOOLEAN  (LMINDICFNC  LMCB_DATA_INDIC) (HCONNECTION, LP_VOID
                     , U16, U16, HUSERDATA, U32);

typedef  BOOLEAN  (LMINDICFNC  LMCB_EXPD_INDIC) (HCONNECTION, LP_VOID
                     , U16, U16, HUSERDATA, U32);

typedef  BOOLEAN  (LMINDICFNC  LMCB_QOS_INDIC) (HCONNECTION, LP_VOID, U32);

typedef  BOOLEAN  (LMINDICFNC  LMCB_DSCVR_INDIC) ( LP_DEVICE_DISCOVERY_LIST);

typedef  VOID     (LMCONFFNC  LMCB_CONN_CONF) (HCONNECTION
                     , LP_CONNECT_PARMS, LP_VOID, U16, U32);

typedef  VOID     (LMCONFFNC  LMCB_TX_CONF) (HCONNECTION, HUSERDATA, LMSTATUS, U32);

typedef  VOID     (LMCONFFNC  LMCB_QOS_CONF) (HCONNECTION, LP_VOID , U32);

typedef  VOID     (LMCONFFNC  LMCB_DSCVR_CONF) ( LP_DEVICE_DISCOVERY_LIST);


typedef  struct   _LM_CALLBACKS
{
   LMCB_CONN_INDIC   lmConnectIndic;
   LMCB_DISC_INDIC   lmDisconnectIndic;
   LMCB_DATA_INDIC   lmDataIndic;
   LMCB_EXPD_INDIC   lmExpDataIndic;
   LMCB_QOS_INDIC    lmQosIndic;
   LMCB_CONN_CONF    lmConnectConf;
   LMCB_TX_CONF      lmTransmitConf;
   LMCB_QOS_CONF     lmQosConf;
   LMCB_DSCVR_CONF   lmDiscoverConf;
   LMCB_DSCVR_INDIC  lmDiscoverIndic;

} LM_CALLBACKS, * P_LM_CALLBACKS, LMPTR * LP_LM_CALLBACKS;


typedef  struct   _VERSION_INFO
{
   U16   major;
   U16   minor;
   U8    revision;

} VERSION_INFO , * P_VERSION_INFO , LMPTR * LP_VERSION_INFO;

typedef  VERSION_INFO   API_VERSION_INFO
          , * P_API_VERSION_INFO, LMPTR * LP_API_VERSION_INFO;

/*
 ************************************************************
 *    Initialization
 ************************************************************
*/

#define  VERINFO_API             0
#define  VERINFO_RELEASE_LEVEL   1

IRSTATUS LMAPI LM_AttachIrDD( U32 devhlp );

typedef  IRSTATUS (LMAPIFNC LMFNC_GetApiVersion)            (LP_API_VERSION_INFO);
typedef  IRSTATUS (LMAPIFNC LMFNC_QueryVersionInfo)         (U16, LP_VERSION_INFO);
typedef  IRSTATUS (LMAPIFNC LMFNC_Initialize)               (U32);
typedef  IRSTATUS (LMAPIFNC LMFNC_Shutdown)                 (void);
typedef  IRSTATUS (LMAPIFNC LMFNC_GetOptions)               (void);
typedef  IRSTATUS (LMAPIFNC LMFNC_SetOptions)               (void);
typedef  IRSTATUS (LMAPIFNC LMFNC_SetPortCfg)               (U16, U32);
typedef  IRSTATUS (LMAPIFNC LMFNC_GetPortCfg)               (U16, LP_VOID, LP_VOID, U16);
typedef  IRSTATUS (LMAPIFNC LMFNC_DiscoverDevices)          (U16, LP_DEVICE_DISCOVERY_LIST, LP_U16);
typedef  IRSTATUS (LMAPIFNC LMFNC_GetAttributeValueByClass) (HDEVICE, LP_CLASS_NAME, LP_ATTRIBUTE_NAME, LP_ATTR_OWNER_LIST, LP_U16 );
typedef  IRSTATUS (LMAPIFNC LMFNC_GetInfoBaseDetails)       (HDEVICE, LP_U16, LP_U16);
typedef  IRSTATUS (LMAPIFNC LMFNC_GetObjectList)            (HDEVICE, OBJECTID, U16, LP_OBJECT_LIST, LP_U16, LP_U16);
typedef  IRSTATUS (LMAPIFNC LMFNC_GetObjectInfo)            (HDEVICE, OBJECTID, LP_U16, LP_U16, LP_U16);
typedef  IRSTATUS (LMAPIFNC LMFNC_GetAttributeValues)       (HDEVICE, OBJECTID, LP_ATTRIBUTE_NAME_LIST, LP_ATTRIBUTE_VALUE_LIST, LP_U16);
typedef  IRSTATUS (LMAPIFNC LMFNC_GetAttributeNames)        (HDEVICE, OBJECTID, U16, U16, LP_ATTRIBUTE_NAME_LIST, LP_U16, LP_U16);
typedef  IRSTATUS (LMAPIFNC LMFNC_GetDeviceName)            (HDEVICE, LP_USER_STRING, LP_U16);
typedef  IRSTATUS (LMAPIFNC LMFNC_AddObject)                (LP_CLASS_NAME, LP_OBJECTID);
typedef  IRSTATUS (LMAPIFNC LMFNC_AddAttribute)             (OBJECTID, LP_ATTRIBUTE_NAME, LP_ATTRIBUTE_VALUE, LP_ATTRIBUTEID);
typedef  IRSTATUS (LMAPIFNC LMFNC_AssociateHints)           (OBJECTID, LP_U8, U16);
typedef  IRSTATUS (LMAPIFNC LMFNC_DeleteAttribute)          (OBJECTID, ATTRIBUTEID);
typedef  IRSTATUS (LMAPIFNC LMFNC_DeleteObject)             (OBJECTID);
typedef  IRSTATUS (LMAPIFNC LMFNC_RequestLSAP)              (LP_LSAPSEL);
typedef  IRSTATUS (LMAPIFNC LMFNC_BindLSAP)                 (LSAPSEL, LP_LM_CALLBACKS);
typedef  IRSTATUS (LMAPIFNC LMFNC_UnBindLSAP)               (LSAPSEL);
typedef  IRSTATUS (LMAPIFNC LMFNC_ReleaseLSAP)              (LSAPSEL);
typedef  IRSTATUS (LMAPIFNC LMFNC_IndicationsOn)            (LSAPSEL);
typedef  IRSTATUS (LMAPIFNC LMFNC_IndicationsOff)           (LSAPSEL);
typedef  IRSTATUS (LMAPIFNC LMFNC_ConnectRequest)           (HDEVICE, LSAPSEL, LSAPSEL, LP_CONNECT_PARMS, LP_VOID, U16, U32, LP_HCONNECTION);
typedef  IRSTATUS (LMAPIFNC LMFNC_ConnectResponse)          (HCONNECTION, LP_VOID, U16, BOOLEAN, U32);
typedef  IRSTATUS (LMAPIFNC LMFNC_DisconnectRequest)        (HCONNECTION, LP_VOID, U16, LP_VOID);
typedef  IRSTATUS (LMAPIFNC LMFNC_DataRequest)              (HCONNECTION, LP_TX_BUFFER_DESC, HUSERDATA);
typedef  IRSTATUS (LMAPIFNC LMFNC_DataRequest2)             (HCONNECTION, LP_VOID, U16, LP_VOID, U16, HUSERDATA);
typedef  IRSTATUS (LMAPIFNC LMFNC_ExpeditedDataRequest)     (HCONNECTION, LP_TX_BUFFER_DESC, HUSERDATA);
typedef  IRSTATUS (LMAPIFNC LMFNC_ExpeditedDataRequest2)    (HCONNECTION, LP_VOID, U16, LP_VOID, U16, HUSERDATA);
typedef  IRSTATUS (LMAPIFNC LMFNC_ReceiveData)              (HCONNECTION, HUSERDATA, LP_RX_BUFFER_DESC, U16, U16);
typedef  IRSTATUS (LMAPIFNC LMFNC_ReceiveData2)             (HCONNECTION, HUSERDATA, LP_VOID, U16, U16);
typedef  IRSTATUS (LMAPIFNC LMFNC_QosRequest)               (HCONNECTION, LP_VOID);
typedef  IRSTATUS (LMAPIFNC LMFNC_Status)                   (HCONNECTION, LP_BOOLEAN, LP_LSAP_CONN_STATE);
typedef  IRSTATUS (LMAPIFNC LMFNC_Statistics)               (LP_STATISTICS);
typedef  IRSTATUS (LMAPIFNC LMFNC_GetBIOSData)              (LP_VOID);
typedef  IRSTATUS (LMAPIFNC LMFNC_OpenDriver)               (LP_U32);
typedef  IRSTATUS (LMAPIFNC LMFNC_CloseDriver)              (LP_U32);



IRSTATUS LMAPI LM_GetApiVersion
                  (
                    LP_API_VERSION_INFO   lpVersionInfo
                  );

IRSTATUS LMAPI LM_QueryVersionInfo
                  (
                    U16             infoType
                  , LP_VERSION_INFO lpVersionInfo
                  );

IRSTATUS LMAPI LM_Initialize
                  (
                    U32    rsvd
                  );

IRSTATUS LMAPI LM_Shutdown
                  (
                    VOID
                  );



// ==> FPN: these are not implemented nor defined yet.

IRSTATUS LMAPI LM_GetOptions(void);
IRSTATUS LMAPI LM_SetOptions(void);


typedef  struct _IRPORT_DESIGNATION_LIST
{
   U16                  nrPorts;
   IRPORT_PARMS         PortParms;
//   IRPORT_DESIGNATION   ports[1];

} IRPORT_DESIGNATION_LIST , *P_IRPORT_DESIGNATION_LIST
    , LMPTR * LP_IRPORT_DESIGNATION_LIST;




IRSTATUS LMAPI LM_SetPortCfg
                  (
                    U16 reqPort
                  , U32 reqBaud
                  );

IRSTATUS LMAPI LM_GetPortCfg
                  (
                    U16       level
                  , LP_VOID   pParms
                  , LP_VOID   pInfo
                  , U16       size
                  );

// level = 0  ;  Query port designation
//       input    : LP_PORT_CLASS
//       output   : LP_IRPORT_DESIGNATION_LIST;
// ......



/*
 ************************************************************
 *    Device Discovery
 ************************************************************
*/


IRSTATUS LMAPI LM_DiscoverDevices
                  (
                    U16                      nrSlots
                  , LP_DEVICE_DISCOVERY_LIST pDiscoveryList
                  , LP_U16                   maxSize
                  );

IRSTATUS LMAPI LM_DiscoverRequest
                  (
                    U16                      nrSlots        // in: nr Slots
                  , LP_DEVICE_DISCOVERY_LIST pDiscoveryList
                  , LP_U16                   pMaxSize
                  , LSAPSEL                  lsap           // in: lsap; needed to assoc callBack
                  , LP_U32                   pHDiscovery    // out: discovery handle
                  );


/*
 ************************************************************
 *    Information Access Services (IAS)
 ************************************************************
*/

// This is the only function required by IrLMP, as well as the most useful one.

IRSTATUS LMAPI LM_GetAttributeValueByClass
                  (
                    HDEVICE            hDevice
                  , LP_CLASS_NAME      pClass
                  , LP_ATTRIBUTE_NAME  pAttrName
                  , LP_ATTR_OWNER_LIST pAttrList
                  , LP_U16             pSize
                  );

// These are optional functions.
// ==> FPN: Currently not supported.

IRSTATUS LMAPI LM_GetInfoBaseDetails
                  (
                    HDEVICE   hDevice
                  , LP_U16    pNrObjects
                  , LP_U16    pMaxIdObject
                  );

IRSTATUS LMAPI LM_GetObjectList
                  (
                    HDEVICE         hDevice
                  , OBJECTID        idFirstObject
                  , U16             maxObjects
                  , LP_OBJECT_LIST  pObjectList
                  , LP_U16          pSize
                  , LP_U16          pNextId
                  );

IRSTATUS LMAPI LM_GetObjectInfo
                  (
                    HDEVICE   hDevice
                  , OBJECTID  idObject
                  , LP_U16    pMinId
                  , LP_U16    pMaxId
                  , LP_U16    pNrAttributes
                  );

IRSTATUS LMAPI LM_GetAttributeValues
                  (
                    HDEVICE                  hDevice
                  , OBJECTID                 idObject
                  , LP_ATTRIBUTE_NAME_LIST   pNameList
                  , LP_ATTRIBUTE_VALUE_LIST  pValueList
                  , LP_U16                   pSize
                  );

IRSTATUS LMAPI LM_GetAttributeNames
                  (
                    HDEVICE                  hDevice
                  , OBJECTID                 idObject
                  , U16                      idFirst
                  , U16                      nrNames
                  , LP_ATTRIBUTE_NAME_LIST   pNameList
                  , LP_U16                   pSize
                  , LP_U16                   pNextId
                  );

// The following is a non-IrLMP function that simply overloads a more
// general function.

IRSTATUS LMAPI LM_GetDeviceName
                  (
                    HDEVICE         hDevice
                  , LP_USER_STRING  pDeviceName
                  , LP_U16          pSize
                  );

/*
 ************************************************************
 *    Registration
 ************************************************************
*/

IRSTATUS LMAPI LM_AddObject
                  (
                    LP_CLASS_NAME   pClass
                  , LP_OBJECTID     pObjectId
                  );

IRSTATUS LMAPI LM_AddAttribute
                  (
                    OBJECTID           idObject
                  , LP_ATTRIBUTE_NAME  pAttrName
                  , LP_ATTRIBUTE_VALUE pAttrValue
                  , LP_ATTRIBUTEID     pAttributeId
                  );

IRSTATUS LMAPI LM_AssociateHints
                  (
                    OBJECTID  idObject    // in: object to assoc hints
                  , LP_U8     pHints      // in: ptr to hints
                  , U16       sizeHints   // in: sizo of hints in bytes
                  );

IRSTATUS LMAPI LM_DeleteAttribute
                  (
                    OBJECTID     idObject
                  , ATTRIBUTEID  idAttribute
                  );

IRSTATUS LMAPI LM_DeleteObject
                  (
                    OBJECTID idObject
                  );

/*
 ************************************************************
 *    LSAP Control
 ************************************************************
*/

IRSTATUS LMAPI LM_RequestLSAP
                  (
                    LP_LSAPSEL pSel
                  );

IRSTATUS LMAPI LM_BindLSAP
                  (
                    LSAPSEL         lsap
                  , LP_LM_CALLBACKS pCallBacks
                  );

IRSTATUS LMAPI LM_UnBindLSAP
                  (
                    LSAPSEL lsap
                  );

IRSTATUS LMAPI LM_ReleaseLSAP
                  (
                    LSAPSEL lsap
                  );

IRSTATUS LMAPI LM_IndicationsOn
                  (
                    LSAPSEL lsap
                  );

IRSTATUS LMAPI LM_IndicationsOff
                  (
                    LSAPSEL lsap
                  );



/*
 ************************************************************
 *    LSAP Connection
 ************************************************************
*/


IRSTATUS LMAPI LM_ConnectRequest
                  (
                    HDEVICE            hDevice
                  , LSAPSEL            dst
                  , LSAPSEL            src
                  , LP_CONNECT_PARMS   pReqParms
                  , LP_VOID            pUserData
                  , U16                size
                  , U32                userContext
                  , LP_HCONNECTION     lphConnect
                  );


IRSTATUS LMAPI LM_ConnectResponse
                  (
                    HCONNECTION  hConnection
                  , LP_VOID      pUserData
                  , U16          size
                  , BOOLEAN      accept
                  , U32          userContext
                  );

IRSTATUS LMAPI LM_DisconnectRequest
                  (
                    HCONNECTION  hConnection
                  , LP_VOID      pUserData
                  , U16          size
                  , LP_VOID      lpFlags
                  );

/*
 ************************************************************
 *    Data Transfer
 ************************************************************
*/

IRSTATUS LMAPI LM_DataRequest
                  (
                    HCONNECTION        hConnection
                  , LP_TX_BUFFER_DESC  pTxBuf
                  , HUSERDATA          hData
                  );

IRSTATUS LMAPI LM_DataRequest2
                  (
                    HCONNECTION  hConnection
                  , LP_VOID      lpHeaderData
                  , U16          sizeHeader           // max 60 bytes
                  , LP_VOID      lpData
                  , U16          sizeData
                  , HUSERDATA    hData
                  );

IRSTATUS LMAPI LM_ExpeditedDataRequest
                  (
                    HCONNECTION        hConnection
                  , LP_TX_BUFFER_DESC  pTxBuf
                  , HUSERDATA          hData
                  );

IRSTATUS LMAPI LM_ExpeditedDataRequest2
                  (
                    HCONNECTION  hConnection
                  , LP_VOID      lpHeaderData
                  , U16          sizeHeader           // max 60 bytes
                  , LP_VOID      lpData
                  , U16          sizeData
                  , HUSERDATA    hData
                  );


IRSTATUS LMAPI LM_ReceiveData
                  (
                    HCONNECTION        hConnection
                  , HUSERDATA          hData
                  , LP_RX_BUFFER_DESC  pUserRxBuf
                  , U16                offset
                  , U16                nrBytes
                  );

IRSTATUS LMAPI LM_ReceiveData2
                  (
                    HCONNECTION  hConnection
                  , HUSERDATA    hData
                  , LP_VOID      pUserRxBuf
                  , U16          offset
                  , U16          nrBytes
                  );



/*
 ************************************************************
 *    Quality of Service
 ************************************************************
*/
// ==> FPN: The QoS functions are optional by IrLMP and are currently
// not implemented.  stsNotImplemented is returned as well as
// ERROR_NOT_IMPLEMENTED

IRSTATUS LMAPI LM_QosRequest(
                    HCONNECTION  hConnection
                  , LP_VOID      pQosParam
                  );


/*
 ************************************************************
 *    Special SAP services
 ************************************************************
*/

// The following services are offered at special SAPs.

// Notification of Discovery indications and status indications are by
// chaining to this special SAP.  This is currently not implemented.

// BOOLEAN  LMINDIC  LM_DiscoverDevicesIndication();
// BOOLEAN  LMINDIC  LM_StatusIndic();

// Connectionless data is sent over a reserved LSAPSEL.  This service
// is currently NOT available.

// IRSTATUS LMAPI LM_ConnectionlessDataRequest(
//                     LP_VOID pData
//                   , U16 size
//                   );

// BOOLEAN  LMINDIC  LM_ConnectionlessDataIndication(
//                     LP_VOID pData
//                   , U16 size
//                   );


/*
 ************************************************************
 *    Special services
 ************************************************************
*/


IRSTATUS LMAPI LM_Status
                  (
                    HCONNECTION        hConnection
                  , LP_BOOLEAN         lpfUnackedData
                  , LP_LSAP_CONN_STATE lpLsapConnState
                  );


IRSTATUS LMAPI LM_Statistics
                  (
                    LP_STATISTICS   lpStatistics
                  );


IRSTATUS LMAPI LM_GetBIOSData
                  (
                    LP_VOID   lpBiosData
                  );

IRSTATUS LMAPI LM_OpenDriver
                  (
                    LP_U32    pHandle
                  );

IRSTATUS LMAPI LM_CloseDriver
                  (
                    LP_U32 pHandle
                  );


#ifdef __cplusplus
   }
#endif


#endif

