/* @(#)69       1.1  api/IRSTATUS.H, api, irda_1.00 9/27/95 19:38:12 */
/*
   *********************************************************************
   *     Copyright 1994,1995, IBM Corporation,   All Rights Reserved   *
   *                                                                   *
   * $Workfile:   irstatus.h  $                                        *
   *                                                                   *
   * Description  :                                                    *
   *                                                                   *
   * $Revision:   2.0  $                                               *
   *   $Author:   FNOVAK $                                             *
   *     $Date:   $                                                    *
   *      $Log:   $                                                    *
   *                                                                   *
   *********************************************************************
*/

#ifndef  lmstatus_h
#define  lmstatus_h

#ifdef __cplusplus
   extern "C" {
#endif

#define  ERROR_GENERIC     -1

#define  stsNotImplemented          ((STATUS)stsOK +  9)
#define  stsResourceNotFound        ((STATUS)stsOK +  8)
#define  stsWarningQueueEmpty       ((STATUS)stsOK +  7)
#define  stsWarningIndicationsOff   ((STATUS)stsOK +  6)
#define  stsWait                    ((STATUS)stsOK +  3)

#define  stsOK                      ((STATUS)  1)
#define  stsFailed                  ((STATUS) -1)

#define  stsErrorQueueFull          ((STATUS)stsFailed -  2)
#define  stsErrorNodeActive         ((STATUS)stsFailed -  3)
#define  stsErrorBadConHandle       ((STATUS)stsFailed -  4)
#define  stsMediaBusy               ((STATUS)stsFailed -  5)
#define  stsErrorLinkSequence       ((STATUS)stsFailed -  6)
#define  stsErrorMaxResends         ((STATUS)stsFailed -  7)
#define  stsErrorLinkFailed         ((STATUS)stsFailed -  8)
#define  stsErrorLinkAborted        ((STATUS)stsFailed -  9)

#define  stsErrorBadHandle          ((STATUS)stsFailed - 10)
#define  stsErrorEventAlloc         ((STATUS)stsFailed - 11)
#define  stsErrorUnknownCmd         ((STATUS)stsFailed - 12)
#define  stsErrorBufferAlloc        ((STATUS)stsFailed - 13)
#define  stsErrorInvalidReq         ((STATUS)stsFailed - 14)
#define  stsErrorNoLsapSel          ((STATUS)stsFailed - 15)
#define  stsErrorInvalidLsap        ((STATUS)stsFailed - 16)
#define  stsErrorLockedOut          ((STATUS)stsFailed - 17)
#define  stsErrorAlreadyInUse       ((STATUS)stsFailed - 18)
#define  stsErrorUnexpected         ((STATUS)stsFailed - 19)
#define  stsErrorMediaBusy          ((STATUS)stsFailed - 20)
#define  stsErrorFailure            ((STATUS)stsFailed - 21)
#define  stsErrorStationExclusive   ((STATUS)stsFailed - 22)
#define  stsErrorLsapMemory         ((STATUS)stsFailed - 23)
#define  stsErrorInvalidDescriptor  ((STATUS)stsFailed - 24)
#define  stsErrorNotConfigured      ((STATUS)stsFailed - 25)
#define  stsErrorInvalidParameter   ((STATUS)stsFailed - 26)
#define  stsErrorConnectRace        ((STATUS)stsFailed - 27)
#define  stsErrorInvalidConnection  ((STATUS)stsFailed - 28)
#define  stsErrorInvalidEventHandle ((STATUS)stsFailed - 29)

#define  stsErrorTooMuchData        ((STATUS)stsFailed - 30)
#define  stsErrorResourceInUse      ((STATUS)stsFailed - 31)
#define  stsErrorNoIrResource       ((STATUS)stsFailed - 32)
#define  stsErrorLinkActive         ((STATUS)stsFailed - 33)
#define  stsErrorNoSuchDevice       ((STATUS)stsFailed - 34)
#define  stsErrorBufferTooSmall     ((STATUS)stsFailed - 39)

#define  stsErrorConnectTimeout     ((STATUS)stsFailed - 40)
#define  stsErrorNotConnected       ((STATUS)stsFailed - 41)

/* LM changes for LM_OpenDriver, LM_CloseDriver */

#define  stsErrorDeviceInUse        ((STATUS)stsFailed - 50)
#define  stsErrorAccessDenied       ((STATUS)stsFailed - 52)
#define  stsErrorFileNotFound       ((STATUS)stsFailed - 53)

#define  stsErrorLoadingLibrary     ((STATUS)stsFailed - 58)
#define  stsErrorLoadingModule      ((STATUS)stsFailed - 59)

#define  stsErrorNoSuchObject       ((STATUS)stsFailed - 70)
#define  stsErrorNoSuchAttribute    ((STATUS)stsFailed - 71)
#define  stsErrorNameListTooLong    ((STATUS)stsFailed - 72)
#define  stsErrorNoSuchClass        ((STATUS)stsFailed - 73)
#define  stsErrorOpCodeNotSupported ((STATUS)stsFailed - 74)
#define  stsErrorIasOverflow        ((STATUS)stsFailed - 75)
#define  stsErrorNoFreeIasSrvr      ((STATUS)stsFailed - 76)
#define  stsErrorIasNoWorkSpace     ((STATUS)stsFailed - 77)
#define  stsErrorIasAlloc           ((STATUS)stsFailed - 78)
#define  stsErrorObjectFull         ((STATUS)stsFailed - 79)
#define  stsErrorDuplicateAttribute ((STATUS)stsFailed - 80)
#define  stsErrorIasInvalidReq      ((STATUS)stsFailed - 81)
#define  stsErrorIasRequestFailed   ((STATUS)stsFailed - 82)

#define  stsErrorAnchorAlloc        ((STATUS)stsFailed - 100)
#define  stsErrorGDTAlloc           ((STATUS)stsFailed - 101)
#define  stsErrorMemAlloc           ((STATUS)stsFailed - 102)
#define  stsErrorNoMemToFree        ((STATUS)stsFailed - 103)


#define  stsErrorMacTxDescAlloc     ((STATUS)stsFailed - 200)
#define  stsErrorMacRxDescAlloc     ((STATUS)stsFailed - 201)
#define  stsErrorInvalidTxDescH     ((STATUS)stsFailed - 202)
#define  stsErrorInvalidRxDescH     ((STATUS)stsFailed - 203)
#define  stsErrorMacBufferAlloc     ((STATUS)stsFailed - 204)
#define  stsErrorInvalidBufH        ((STATUS)stsFailed - 205)
#define  stsErrorMacRxDescFull      ((STATUS)stsFailed - 206)

#define  stsErrorSeqNr              ((STATUS)stsFailed - 1000)
#define  stsErrorPktSize            ((STATUS)stsFailed - 1001)
#define  stsErrorDataValidation     ((STATUS)stsFailed - 1002)


#define StsOK(se, s) ((s = se) >= stsOK ? true : false)
#define StsFailed(se, s) ((s = se) != stsOK ? true : false)

#ifdef __cplusplus
   }
#endif

#endif
