/* @(#)67       1.1  api/CMNTYPES.H, api, irda_1.00 9/27/95 19:38:06 */
/*
   *********************************************************************
   *     Copyright 1994, IBM Corporation,   All Rights Reserved        *
   *                                                                   *
   * $Workfile:   cmntypes.h  $                                                        *
   *                                                                   *
   * Description  :                                                    *
   *                                                                   *
   * $Revision:   1.3  $                                                        *
   *   $Author:   TFW  $                                                        *
   *     $Date:   06 Aug 1994 21:31:12  $                                                        *
   *      $Log:   V:\irlap\archive\cmntypes.h_v  $                                                        *
 *
 *    Rev 1.3   06 Aug 1994 21:31:12   TFW
 *
 *    Rev 1.0   22 Jun 1994 14:01:50   FNOVAK
 * Initial revision.
   *                                                                   *
   *                      IBM Confidential                             *
   *********************************************************************
*/

#ifndef  cmntypes_h
#define  cmntypes_h

#ifdef __cplusplus
   extern "C" {
#endif

/*
   *********************************************************************
   *  The basic types                                                  *
   *********************************************************************
*/

#if defined(_VXD_)
   #define LMPTR
#elif   defined(__DOS__) || defined(OS2PDD)

//#if   defined(__DOS__) || defined(OS2PDD)
   #ifndef __WINDOWS_H
         #define  LMPTR            far
   #endif
#elif defined(__NETWARE__)
   #define  LMPTR
#else
   #if    defined(OS2DLL) || defined(OS2VDD) || defined(_VXD_)
      #define LMPTR
   #else
      #define  LMPTR         far
   #endif
#endif

#ifndef  FAR
   #if defined(__NETWARE__)
      #define  FAR
   #else
      #define  FAR   far
   #endif
#endif

#define  PUBLIC
#define  PRIVATE  static
#define  LOCAL    static


#define  PASCAL   _pascal
#define  EXPORT   _export

#if defined(_VXD_)
   #define  LOADDS
#else
   #define  LOADDS   _loadds
#endif

#define  IFPROC   PASCAL LMPTR LOADDS

// This is really a CSET/2 compiler issues!!

#ifdef  __IBMC__
   #define  STDAPI    _System  LOADDS
   #define  EXPAPI    _System  LOADDS
   #define  STDAPIFNC * STDAPI
   #define  EXPAPIFNC * STDAPI
#else
   #define  STDAPI    LMPTR PASCAL LOADDS
   #define  STDAPIFNC STDAPI *
   #define  EXPAPI    LMPTR EXPORT PASCAL LOADDS
   #define  EXPAPIFNC STDAPI *
#endif


typedef unsigned char U8, *P_U8, LMPTR *LP_U8, **PP_U8;
typedef LP_U8 LMPTR *LPP_U8;
typedef signed char   S8, *P_S8, LMPTR *LP_S8;
typedef unsigned short int  U16, *P_U16, LMPTR *LP_U16;
typedef short int     S16, *P_S16, LMPTR *LP_S16;
typedef unsigned long U32, *P_U32, LMPTR *LP_U32;
typedef long          S32, *P_S32, LMPTR *LP_S32;

#ifndef TRUE
   #define TRUE 1
#endif

#ifndef FALSE
   #define FALSE 0
#endif

typedef U16 BOOLEAN, LMPTR * LP_BOOLEAN;
#define  false FALSE
#define  true  TRUE

typedef void (LMPTR *LP_PROC)();

#ifndef  VOID
   typedef  void               VOID, *P_VOID, *P_UNKNOWN;
#else
   typedef  void               *P_VOID, *P_UNKNOWN;
#endif
typedef  VOID  LMPTR *       LP_VOID;
typedef  LP_VOID LMPTR       *LPP_VOID;

#if    !defined(OS2DLL)
   typedef  unsigned char     BYTE;
#endif
typedef BYTE  * P_BYTE, LMPTR * LP_BYTE;


#ifndef  NULL
   #define  NULL  (0)
#endif

#ifdef NULL
   #define null NULL
#endif

#define  pNull    ((LP_VOID)null)
#define  lpNull   ((LP_VOID)null)

#ifdef TRUE
  #define true TRUE
#endif

#ifdef FALSE
   #define false FALSE
#endif

#if !defined(OS2DLL) && !defined(OS2PDD)
   typedef  U32   LHANDLE, LMPTR * PLHANDLE;
#endif

/*
   *********************************************************************
   *  Bit manipulation constants and macros                            *
   *********************************************************************
*/

#define  bit0              (0x01)
#define  bit1              (0x02)
#define  bit2              (0x04)
#define  bit3              (0x08)
#define  bit4              (0x10)
#define  bit5              (0x20)
#define  bit6              (0x40)
#define  bit7              (0x80)



#define  flag0             (0x0001)
#define  flag1             (0x0002)
#define  flag2             (0x0004)
#define  flag3             (0x0008)
#define  flag4             (0x0010)
#define  flag5             (0x0020)
#define  flag6             (0x0040)
#define  flag7             (0x0080)
#define  flag8             (0x0100)
#define  flag9             (0x0200)
#define  flag10            (0x0400)
#define  flag11            (0x0800)
#define  flag12            (0x1000)
#define  flag13            (0x2000)
#define  flag14            (0x4000)
#define  flag15            (0x8000)
#define  flag16            (0x00010000L)
#define  flag17            (0x00020000L)
#define  flag18            (0x00040000L)
#define  flag19            (0x00080000L)
#define  flag20            (0x00100000L)
#define  flag21            (0x00200000L)
#define  flag22            (0x00400000L)
#define  flag23            (0x00800000L)
#define  flag24            (0x01000000L)
#define  flag25            (0x02000000L)
#define  flag26            (0x04000000L)
#define  flag27            (0x08000000L)
#define  flag28            (0x10000000L)
#define  flag29            (0x20000000L)
#define  flag30            (0x40000000L)
#define  flag31            (0x80000000L)


/*
   *********************************************************************
   *  Limits                                                           *
   *********************************************************************
*/

#define  minU8             ((U8)0x00)
#define  maxU8             ((U8)0xFF)
#define  minS8             ((S8)0x80)
#define  maxS8             ((S8)0x7F)
#define  minU16            ((U16)0x0000)
#define  maxU16            ((U16)0xFFFF)
#define  minS16            ((S16)0x8000)
#define  maxS16            ((S16)0x7FFF)
#define  minU32            ((U32)0x00000000L)
#define  maxU32            ((U32)0xFFFFFFFFL)
#define  minS32            ((S32)0x80000000L)
#define  maxS32            ((S32)0x7FFFFFFFL)

/*
   *********************************************************************
   *  Data conversion/Checking                                         *
   *********************************************************************
*/


#define  Max(a,b)          (a>b?a:b)
#define  Min(a,b)          (a<b?a:b)
#define  Abs(v)            ((v)<0?(-(v)):(v))
#define  Odd(a)            ((a & 0x01) ? TRUE : FALSE)
#define  Even(a)           ((a & 0x01) ? FALSE: TRUE )

#define  FlagOn(f,v)       (!FlagOff(f,v))
#define  FlagOff(f,v)      (!((v)&(f)))
#define  FlagSet(f,v)      ((v)|(f))
#define  FlagClear(f,v)    ((v)&(~(f)))

#define  OutRange(v,l,h)   ((v)<(l)||(v)>(h))
#define  InRange(v,l,h)    ((v)>=(l)&&(v)<=(h))


#define  LoByte(w)         ((U8)w)
#define  HiByte(w)         ((U8)((U16)(w) >> 8) )
#define  LoU8(w)           ((U8)w)
#define  HiU8(w)           ((U8)((U16)(w) >> 8) )
#define  LoU16(dw)         ((U16)dw)
#define  HiU16(dw)         ((U16)((U32)(dw) >> 16) )

#define  MakeU16(bl,bh)    ( (U16)( ((U16)bh << 8)   | ((U16)bl) ) )
#define  MakeU32(wl,wh)    ( (U32)( ((U32)wh << 16)  | ((U32)wl) ) )
#define  MakeFP(sel,off)   ( (LP_VOID)( ((U32)sel << 16)  | ((U32)off) ) )

#define  FieldOffset(t,f)     ((unsigned int)&((t *)0)->f)

/*
   *********************************************************************
   *  Macros for ease of reading, etc                                  *
   *********************************************************************
*/

#define or ||
#define and &&
#define not !


#define NoCompilerWarning(p) (p) = (p);

#define  UnUsed(p)  (void)(p)


#ifdef __cplusplus
   }
#endif

#ifndef  common_h
   #include "common.h"
#endif



#endif
