#----------------------------------------------------------------------------
# SUBSYS.MAK
#
# SCCSID: src/wpsh/common/subsys.mak, wpsh.common, wp.wpsh10, 940609.1 94/06/15
#
# FUNCTIONS:
#
# CALLED FROM: Component makefile
#
# ORIGINS:
#
# (C) COPYRIGHT International Business Machines Corp. 1994
# All Rights Reserved
# Licensed Materials - Property of IBM
#
# US Government Users Restricted Rights - Use, duplication or
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
#----------------------------------------------------------------------------
# Change History:
# ---------------
# Defect  # Date    By  Description
# ------  --------  -----------------------------------------------------------
#         05/01/94  EEO Created.
# 104419  11/09/94  EEO Added PDL macros
# 110613  1/26/95   TG  Added support to export .xh files
# 124902  06/09/95  EEO Added ETC for dsom IR and Impl Repos files.
#         01/10/95  AR  Integrated in PPC changes
# 151478  04/10/96  SAH Added macros for TCP toolkit tools
#------------------------------------------------------------------------------
#
# This is to be used for WPOS Common Macros/Definitions etc
#
# The following is a list of the order in which subsys.mak is designed.
#
#     Define Primiary options
#                    - Host OS, Host Proc, Target PROC, Target Exe,
#                      BLD_TYPE
#                    - Please note that Host OS, Host Proc will be defined
#                      by the build lab
#
#     Set up dot directives
#        Dot Directives - ie.
#          .SUFFIXES:
#          .SILENT:
#          .IGNORE:
#          .PRECIOUS:
#
#    Inference Rules Setup
#        .c.obj
#        .asm.obj
#        .exe.com
#
#    Common target information "common.mak" for dependency generation
#        Creation of dependencies using includes.
#
#    Make sure the base paths are created.
#
#      User Target Information
#         all
#         debug
#         retail
#         perf
#         private
#
# ******  NOTE  ******
#
#==================================================================
# First figure out what our host processor
# and operating system is so that we use the
# right tools. Host_Proc and Host_Os will be set by build lab
#==================================================================

!if "$(HOST_PROC)" == "" || "$(HOST_OS)" == ""
!error Environment variables "HOST_PROC" and/or "HOST_OS not set!  Please set\
"HOST_PROC" to the type of processor on which $(MAKE) was invoked \
(one of 386, PPC, RISC) and "HOST_OS" to the operating system in which \
$(MAKE) was invoked (one of OS2, WPOS2, AIX, OSF)!
!endif

!if "$(TARGET_PROC)"=="ppc"
CSET_VER=9
!endif

#==================================================================
# Specify subsystem specific options here.
#==================================================================

!if "$(TARGET_PROC)"=="ppc"
SOM_HDR         = $(TOOLS2)\som2\include
!else
SOM_HDR         = $(TOOLS2)\$(SOM_DIR)\include
!endif
SOM_LIB         = $(TOOLS2)\$(SOM_DIR)\lib
TCP_HDR         = $(TOOLS2)\tcp\$(TCP_VER)\include
TCP_LIB         = $(TOOLS2)\tcp\$(TCP_VER)\lib
PDL             = pdl
SUBSYS_ICONS    = $(O)\icons
ICON_PATH       = $(ROOT)\$(SRC_NL_RELATIVE)\icons
SOM2_IDLS       = $(SOM_HDR)
PMWP_IDLS       = $(ROOT)\src\$(SUBSYS)\pmwp
COMMON_IDLS     = $(ROOT)\src\$(SUBSYS)\common\include
ETC             = $(OS2)\etc

#
#  If the som headers have not yet been generated by running SOMSTARS,
#  then do it now...
#
$(SOM_HDR)\somobj.h: $(SOM_HDR)\somobj.idl
   -set SOMBASE=$(TOOLS2)\$(SOM_DIR)
   $(TOOLS2)\$(SOM_DIR)\bin\somstars.cmd

IDLCNVRT = $(ROOT)\src\wpsh\common\idlcnvrt.cmd
SOMCPLUS = $(ROOT)\src\wpsh\common\somcplus.cmd


!if "$(TARGET_PROD)"=="os2c"
SOM_SCFLAGS   = -maddstar -S128000 -C128000 -mnoint -v -a comment="--"
!endif

#-----------------------------------------------------------------------------
# Now we actually set our environment
#-----------------------------------------------------------------------------
!if [set SMINCLUDE=.;$(SOM2_IDLS);$(PMWP_IDLS);$(COMMON_IDLS);$(SOM_INCL_LIST)]
!endif

