:userdoc.
.** General help for Parallel Port Driver
:h1 id=15483 res=15483.Parallel Port Properties
:p.Use this window to display or configure the properties of the parallel
port.  It will allow the user to adjust the timeouts for errors or
terminating the connection to the printer.
:p. :hp2.Port name:ehp2. : This field shows the name that identifies this port.
:p. :link reftype=hd res=15490.Advanced:elink. : Display advanced parallel
port settings dialog.
:p. :hp2.OK:ehp2. : Save any changed information and close the window.
:p. :hp2.Undo:ehp2. : Reset all values to their state when the window was opened.
:p. :hp2.Default:ehp2. : Reset all values to their state when the system was installed.
:p. :hp2.Cancel:ehp2. : Do not save changes and close the window.
:p.For a detailed explanation of other fields, select from the list below:
:ul compact.
:li.:link reftype=hd res=15484.Timeouts:elink.
:li.:link reftype=hd res=15485.Share access:elink.
:li.:link reftype=hd res=15490.Advanced Properties:elink.
:eul.
.** Field helps
:h2 global hide nosearch id=15484 res=15484.Timeouts
:p.These fields set the timeouts that the parallel port driver uses to
recognize errors or terminate the printer connection.
:p.:hp2.Print:ehp2. : The amount of time elapsed before the parallel port
driver decides that an error should be returned when communicating with the
printer.  Default is :hp1.45:ehp1. seconds.
:p.:hp2.Job:ehp2.   : The amount of time to wait after a job has finished
before terminating the connection to the printer.  Default is :hp1.180:ehp1.
seconds.  Only works with bi-directional printers.
:p.:hp2.Query:ehp2. : The amount of time to wait after a query has been sent
before terminating the connection to the printer.  Set this to :hp1.0:ehp1. to
disable closing the port between jobs.
Default is :hp1.300:ehp1. seconds.  Only works with bi-directional printers.
:p.Select the up or down arrow to adjust the number of seconds.
.*
:h2 global hide id=15485 res=15485.Share Access
:p.This check box allows multiple DOS programs to share a parallel
port.  This might be required for DOS programs that try to access a
port during initialization.
:p.If the port is already in use, an error appears on the
screen.  Checking the :hp2.Share access:ehp2. check box prevents the
error from occurring.
:p.:hp2.Share access:ehp2. is disabled (unchecked) as the
default.  If this choice is checked and you get intermixed output from
DOS programs, return it to the unchecked state.
.*
.** Help for Advanced Properties of Parallel Port Driver
.*
:h1 id=15490 res=15490.Parallel Port Advanced Properties
:p.Use this window to display or configure advanced bidirectional
properties of the parallel port.
It will allow the user to view the device ID of the connected printer
and the bidirectional current mode,
and to select the bidi mode and
adjust the timeouts for the printer.
:p. :hp2.Refresh:ehp2. : Update this dialog with current settings of connected printer.
:p. :hp2.OK:ehp2. : Save any changed information and close the window.
:p. :hp2.Undo:ehp2. : Reset all values to their state when the window was opened.
:p. :hp2.Default:ehp2. : Reset all values to their state when the system was installed.
:p. :hp2.Cancel:ehp2. : Do not save changes and close the window.
:p.For a detailed explanation of other fields, select from the list below:
:ul compact.
:li.:link reftype=hd res=15491.Bidirectional Mode:elink.
:li.:link reftype=hd res=15492.Read Timeouts:elink.
:li.:link reftype=hd res=15493.Write Timeouts:elink.
:li.:link reftype=hd res=15494.Device ID:elink.
:eul.
.** Field helps
:h2 global hide nosearch id=15491 res=15491.Bidirectional Mode
:p.This field displays and allows setting the low-level protocol
used to communicate with the parallel-attached printer.
:p.:hp2.Current:ehp2. : Displays the current bidirection state
of the attached printer.
:hp1.Compatible:ehp1. is unidirectional.  This will also be displayed if
a printer capable of bidirectional communications is powered off.
:p.:hp2.Selected:ehp2. : The user can select the bidirectional mode
to use for the attached printer.
:p.:hp1.AutoDetect:ehp1. is the default and will try to put the printer
into the best mode available;  first ECP, then Byte,
then Nibble mode will be attempted.
Any other selected mode will try only that mode;  if unable to use
the mode selected then the printer will be set to unidirectional mode.
:p.:hp1.Compatible:ehp1. is unidirectional.  This will disable bidirectional
communications with the printer and can be selected if problems occur
using the printer in bidirectional mode.
:p.:hp1.Nibble:ehp1. is the minimum mode that can be selected and still
have bidirectional communications with the printer.
:p.:hp1.Byte:ehp1. is a mode that can be used with certain bidirectional printers
for better performance.
:p.:hp1.ECP:ehp1. is the fastest mode for bidirectional printers, but is only
available on certain PCs and printers.
The parallel port must be enabled for ECP mode on the host PC.
:p.:hp1.ECP RunLengthEncoding:ehp1. is ECP mode with an additional performance boost
for some bidirectional printers, but is only
available on certain PCs and printers.
The parallel port must be enabled for ECP mode on the host PC.
.*
:h2 global hide nosearch id=15492 res=15492.Read Timeouts
:p.These fields set the timeouts that the parallel port driver uses for
reading information from the printer.  The timeouts are in milliseconds.
:p.:hp2.Inter-character:ehp2. : The max amount of time to wait for an
interrupt indicating that data has been transferred from
the peripheral to the host.  This timer starts when the
channel is reversed, and is reset after each transfer
from the peripheral.
Default is :hp1.64:ehp1. milliseconds.
:p.:hp2.Elapsed:ehp2. : The max amount of time a read request
will wait before returning to the caller, even if there is
more data waiting to be read.  The timer starts when
the channel is reversed, and the timer runs as data is read.
Default is :hp1.1000:ehp1. milliseconds( 1 second ).
:p.:hp2.Note:ehp2.  the read elapsed timeout is the maximum amount of time
a read request can take;  the read inter-character timeout allows the read
request to return sooner.
:p.Select the up or down arrow to adjust the number of milliseconds.
.*
.*
:h2 global hide nosearch id=15493 res=15493.Write Timeouts
:p.These fields set the timeouts that the parallel port driver uses for
sending information to the printer.  The timeouts are in milliseconds.
:p.:hp2.Inter-character:ehp2. : The max amount of time to wait for an
interrupt indicating that data has been transferred from
the host to the peripheral.  This timer starts when the
first byte is strobed, and is reset after each successful transfer
to the peripheral.
Default is :hp1.15000:ehp1. milliseconds(15 seconds).
:p.:hp2.Elapsed:ehp2. : The max amount of time a write request
will wait before returning to the caller, even if there is
more data waiting to be written.  The timer starts when
the first byte is strobed, and the timer runs as data is sent to
the peripheral.
Default is :hp1.15000:ehp1. milliseconds(15 seconds).
:p.:hp2.Note:ehp2.  these write timeouts are only used internally by the port
driver when in bidirectional mode.  The parallel port properties
settings dialog's :hp1.Print Timeout:ehp1. is the timeout used when
returning write failures to applications.
:p.Select the up or down arrow to adjust the number of milliseconds.
.*
.*
:h2 global hide nosearch id=15494 res=15494.Device ID
:p.This scrollable field displays the IEEE 1284 device ID string
returned by the printer.
.*
.*
:euserdoc.
