/************************************************************
* .FILE:        progdial.hpp                                *
*                                                           *
* .DESCRIPTION: MandelBrot Sample Program:                  *
*                 - Class Header                            *
*                                                           *
* .CLASSES:     ProgressDialog                              *
*                                                           *
* .COPYRIGHT:                                               *
*   IBM Open Class Library                                  *
*   Licensed Material - Property of IBM                     *
*   (C) Copyright IBM Corp. 1998, 2000. All Rights Reserved *
*                                                           *
* .DISCLAIMER:                                              *
*   The following [enclosed] code is sample code created by *
*   IBM Corporation.  This sample code is not part of any   *
*   standard IBM product and is provided to you solely for  *
*   the purpose of assisting you in the development of your *
*   applications.  The code is provided 'AS IS', without    *
*   warranty of any kind.  IBM shall not be liable for any  *
*   damages arising out of your use of the sample code,     *
*   even if they have been advised of the possibility of    *
*   such damages.                                           *
*                                                           *
* .NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT   *
*        THE SOURCE                                         *
*                                                           *
************************************************************/
#ifndef PROGDIAL_HPP
#define PROGDIAL_HPP

#include <iframe.hpp>
#include <imcelcv.hpp>
#include <ipushbut.hpp>
#include <islider.hpp>

/************************************************************
* Class ProgressDialog                                      *
*  - Dialog containing a progress indicator and a cancel    *
*    button.                                                *
************************************************************/
class ProgressDialog : public IFrameWindow {
public:
  // Constructor
  //   - Construct a progress dialog with the given window
  //     as owner.
  ProgressDialog ( IWindow*    owner,
                   const char* title );

  // Set the percentage for the progress indicator.
ProgressDialog
 &setPercentage ( unsigned long percent );

private:
  // Hidden members.
  ProgressDialog ( const ProgressDialog& );
ProgressDialog
 &operator=      ( const ProgressDialog& );

  // Private data members.
IMultiCellCanvas
  fCanvas;
IProgressIndicator
  fIndicator;
IPushButton
  fCancelButton;
}; // ProgressDialog

#endif // PROGDIAL_HPP
