#pragma strings( readonly )
/******************************************************************************/
/*                                                                            */
/* MAIN05.C                                                                   */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/* ----------                                                                 */
/* Copyright (C) International Business Machines Corp., 1991, 1993.           */
/*                                                                            */
/* DISCLAIMER OF WARRANTIES:                                                  */
/* -------------------------                                                  */
/* The following [enclosed] code is sample code created by IBM                */
/* Corporation.  This sample code is not part of any standard IBM product     */
/* and is provided to you solely for the purpose of assisting you in the      */
/* development of your applications.  The code is provided "AS IS",           */
/* without warranty of any kind.  IBM shall not be liable for any damages     */
/* arising out of your use of the sample code, even if they have been         */
/* advised of the possibility of such damages.                                */
/*                                                                            */
/* This example asks the user which entrypoints to invoke and will invoke     */
/* one of the following:                                                      */
/*                                                                            */
/* 1 -  DLLINCREMENT- Accepts a count from its client and adds                */
/*                    this value to the process and system totals             */
/*                                                                            */
/* 2 -  DLLSTATS    - Dumps process and system totals on behalf               */
/*                    of its client                                           */
/*                                                                            */
/******************************************************************************/

#include <stdio.h>
#include "sample05.h"

int main( void )
   {
   int  loop_cont = 1;
   int  rc;
   char inchar;

   while ( loop_cont )
      {
      printf( "Enter 1 - to Increment\n" );
      printf( "Enter 2 - for Statistics\n" );
      printf( "Enter x to terminate\n" );

      /* Get a character from stdin.                                          */

      while ( ( inchar = getchar() ) < 0x20 )
         ;

      /* Process the character entered.                                       */

      switch ( inchar )
         {
         case '1':
            if ( ( rc = DLLINCREMENT( 17 ) ) != 0 )
               loop_cont = 0;
            break;

         case '2':
            if ( ( rc = DLLSTATS() ) != 0 )
               loop_cont = 0;
            break;

         case 'x':
            loop_cont = 0;
            break;

         default:
            printf( "Invalid Option.. retry\n" );
            break;
         }

      /* Read the carriage return character and throw it away.                */

      getchar();
      }

   return 0;
   }
