//
// class definitions 
// provided by the library vendor 
//

class employee {
  char* Name; 
protected:
  int hourRate;
public:
  employee(char* n, int hr); 
  ~employee();

  char* name() { return Name; }
  virtual int salary()=0;
};

class manager : public employee {
  int Experience;
public:
  manager(char* n, int hr, int ex) : employee(n, hr), Experience(ex) { }
  int salary();
};

// 
// The user modified the class 'programmer' provided 
// by the library vendor to add the data members Overtime 
// and OvertimeRate, and the member functions setOvertimeRate, 
// addOvertime, resetOvertime and overtimePay.
//
// Because the library vendor didn't provide the source
// code for impl.C, users cannot recompile impl.C and 
// therefore cannot add any virtual member functions
// (i.e. modify the virtual function table) of the base class 
// 'employee'.
//

class programmer : public employee {
  int OvertimeRate;
  int Overtime;
public:
  programmer(char* n, int hr) : employee(n, hr) { }
  void setOvertimeRate(int or) { Overtime = 0; OvertimeRate = or; }

  void addOvertime(int ov) { Overtime += ov; }
  void resetOvertime() { Overtime = 0; }
  int overtimePay() { return Overtime*OvertimeRate; }

  int salary() ;
};
