//+----------------------------------------------------------------------------+
//| TREENODE.HPP                                                               |
//|                                                                            |
//| COPYRIGHT:                                                                 |
//| ----------                                                                 |
//|  Copyright (C) International Business Machines Corp., 1992,1993.           |
//|                                                                            |
//| DISCLAIMER OF WARRANTIES:                                                  |
//| -------------------------                                                  |
//|  The following [enclosed] code is sample code created by IBM Corporation.  |
//|  This sample code is not part of any standard IBM product and is provided  |
//|  to you solely for the purpose of assisting you in the development of      |
//|  your applications.  The code is provided "AS IS", without warranty of     |
//|  any kind.  IBM shall not be liable for any damages arising out of your    |
//|  use of the sample code, even if they have been advised of the             |
//|  possibility of such damages.                                              |
//|                                                                            |
//| REVISION LEVEL: 1.0                                                        |
//| ---------------                                                            |
//|                                                                            |
//+----------------------------------------------------------------------------+
//| Class Name  : TREENODE                                                     |
//| Purpose     : This class encapulates the behaviour of a data structure     |
//|               known as an n-ary tree.                                      |
//| Author      : njC Sales                                                    |
//| Date        : 27 October 1992                                              |
//+----------------------------------------------------------------------------+

#ifndef TREENODE_HPP_INCLUDED
#define TREENODE_HPP_INCLUDED

#define NULL 0
typedef unsigned long BOOL;
#include "treelink.hpp"

class TreeNode : public TreeLink
{
public:
   enum TreeNodeLoc {Undefined, Leaf =Undefined, Internal, Top};
   //+-------------------------------------------------------------------------+
   //| Constructors                                                            |
   //+-------------------------------------------------------------------------+
   TreeNode() :
          myState(Undefined),
          TreeLink() {}

   TreeNode(TreeNode *pNode) :
          myState(pNode->myState),
          TreeLink(pNode){}

   TreeNode(const TreeNode&);

   virtual ~TreeNode() {}         // use default destructor

   //+-------------------------------------------------------------------------+
   //| Assignment                                                              |
   //+-------------------------------------------------------------------------+
   TreeNode &operator= (const TreeNode &node);

   //+-------------------------------------------------------------------------+
   //| Accessors                                                               |
   //+-------------------------------------------------------------------------+
   virtual TreeNodeLoc  getState() const  {return myState; }
   virtual void setState(TreeNodeLoc newLoc)
                        {myState= newLoc; }

   //+-------------------------------------------------------------------------+
   //| Define state predicates.                                                |
   //+-------------------------------------------------------------------------+
   BOOL isUndefined() const {return myState == Undefined;}
   BOOL isLeaf()      const {return myState == Leaf;}
   BOOL isInternal()  const {return myState == Internal;}
   BOOL isTop()       const {return myState == Top;}

   //+-------------------------------------------------------------------------+
   //| Tree Navigation functions                                               |
   //+-------------------------------------------------------------------------+
   TreeNode *GetParent() {return (TreeNode *)getParent();}
   TreeNode *GetChild()  {return (TreeNode *)getChild(); }
   TreeNode *GetLeft()   {return (TreeNode *)getLeft();  }
   TreeNode *GetRight()  {return (TreeNode *)getRight(); }

   //+-------------------------------------------------------------------------+
   //| Tree Alteration functions                                               |
   //+-------------------------------------------------------------------------+
   TreeNode *addChild (TreeNode *node);
   TreeNode *addChild (TreeNode &node);
   TreeNode *addSister(TreeNode *node);
   TreeNode *addSister(TreeNode &node);
   TreeNode *remove();

protected:

   TreeNodeLoc    myState;

   //+-------------------------------------------------------------------------+
   //| Tree Alteration Helper Functions                                        |
   //|    Due to the fact that these functions have to operate on various      |
   //|    other instances and not only 'this', they are declared as friends.   |
   //+-------------------------------------------------------------------------+

   friend TreeNode *adopt   (TreeNode *parent,       TreeNode *child);
   friend TreeNode *insert  (TreeNode *currentChild, TreeNode *newChild);
   friend TreeNode *addfirst(TreeNode *parent,       TreeNode *newChild);
   friend TreeNode *add     (TreeNode *currentChild, TreeNode *newChild);
   friend TreeNode *delink  (TreeNode *currentNode);
};
#endif
