//+----------------------------------------------------------------------------+
//| TREELINK.CPP                                                               |
//|                                                                            |
//| COPYRIGHT:                                                                 |
//| ----------                                                                 |
//|  Copyright (C) International Business Machines Corp., 1992,1993.           |
//|                                                                            |
//| DISCLAIMER OF WARRANTIES:                                                  |
//| -------------------------                                                  |
//|  The following [enclosed] code is sample code created by IBM Corporation.  |
//|  This sample code is not part of any standard IBM product and is provided  |
//|  to you solely for the purpose of assisting you in the development of      |
//|  your applications.  The code is provided "AS IS", without warranty of     |
//|  any kind.  IBM shall not be liable for any damages arising out of your    |
//|  use of the sample code, even if they have been advised of the             |
//|  possibility of such damages.                                              |
//|                                                                            |
//| REVISION LEVEL: 1.0                                                        |
//| ---------------                                                            |
//|                                                                            |
//+----------------------------------------------------------------------------+
//| Class Name  : TREELINK                                                     |
//| Purpose     : This class encapsulates the links to the immediate neighbours|
//|               in the n-ary tree.                                           |
//| Author      : njC Sales                                                    |
//| Date        : 27 October 1992                                              |
//+----------------------------------------------------------------------------+

#include "treelink.hpp"

TreeLink &TreeLink::operator= (const TreeLink &tLink)
{
   if (this != &tLink)
   {
      parentLink= tLink.parentLink;
      childLink=  tLink.childLink;
      leftLink=   tLink.leftLink;
      rightLink=  tLink.rightLink;
   }
   return *this;
}
