//+----------------------------------------------------------------------------+
//|                                                                            |
//| GENTREE.HPP                                                                |
//|                                                                            |
//| COPYRIGHT:                                                                 |
//| ----------                                                                 |
//|  Copyright (C) International Business Machines Corp., 1992,1993.           |
//|                                                                            |
//| DISCLAIMER OF WARRANTIES:                                                  |
//| -------------------------                                                  |
//|  The following [enclosed] code is sample code created by IBM Corporation.  |
//|  This sample code is not part of any standard IBM product and is provided  |
//|  to you solely for the purpose of assisting you in the development of      |
//|  your applications.  The code is provided "AS IS", without warranty of     |
//|  any kind.  IBM shall not be liable for any damages arising out of your    |
//|  use of the sample code, even if they have been advised of the             |
//|  possibility of such damages.                                              |
//|                                                                            |
//| REVISION LEVEL: 1.0                                                        |
//| ---------------                                                            |
//|                                                                            |
//+----------------------------------------------------------------------------+
//| Class Name : GenTree<T>                                                    |
//|                                                                            |
//| Purpose    : Create a Template Class to encapsulate TreeNode members.      |
//|              This class uses the TreeData class, and is still quite        |
//|              dependent on its functions.  We are slowly evolving into the  |
//|              full use of templates.                                        |
//|                                                                            |
//| Author     : njC Sales                                                     |
//| Date       : 27 October 1992                                               |
//+----------------------------------------------------------------------------+
#ifndef GENTREE_HPP_INCLUDED
#define GENTREE_HPP_INCLUDED
#include "treenode.hpp"

template <class T> class GenTree : public TreeNode
{

public:
   GenTree(): TreeNode(), MyData() {}
   virtual ~GenTree() {}

   virtual void display()
   {
      printf("Data  = %s\n",(char *)MyData.getData());
      printf("State = %d\n",(short)getState());
   }

   GenTree(const T   &pType) :
      TreeNode(), MyData(pType){}
   GenTree(GenTree<T>   *pDataInTree);
   GenTree(const GenTree<T>   &rDataInTree);
   GenTree<T> &operator= (const GenTree<T>   &rDataInTree);

//+----------------------------------------------------------------------------+
//| The following functions are not general enough, and are suitable only for  |
//| the purpose of template testing.                                           |
//| They assume that the datatype passed as template parm has the setData and  |
//| getData methods. In general, this is not a wise assumption.                |
//+----------------------------------------------------------------------------+

   virtual void SetData(void *pString) {MyData.setData(pString); }
   virtual void *GetData() const       {return MyData.getData(); }

protected:
   T       MyData;
};
#endif
