//+----------------------------------------------------------------------------+
//| DATNTREE.HPP                                                               |
//|                                                                            |
//| COPYRIGHT:                                                                 |
//| ----------                                                                 |
//|  Copyright (C) International Business Machines Corp., 1992,1993.           |
//|                                                                            |
//| DISCLAIMER OF WARRANTIES:                                                  |
//| -------------------------                                                  |
//|  The following [enclosed] code is sample code created by IBM Corporation.  |
//|  This sample code is not part of any standard IBM product and is provided  |
//|  to you solely for the purpose of assisting you in the development of      |
//|  your applications.  The code is provided "AS IS", without warranty of     |
//|  any kind.  IBM shall not be liable for any damages arising out of your    |
//|  use of the sample code, even if they have been advised of the             |
//|  possibility of such damages.                                              |
//|                                                                            |
//| REVISION LEVEL: 1.0                                                        |
//| ---------------                                                            |
//|                                                                            |
//+----------------------------------------------------------------------------+
//| Purpose     : This class encapsulates the links to the immediate neighbours|
//|               in the n-ary tree.                                           |
//| Author      : njC Sales                                                    |
//| Date        : 27 October 1992                                              |
//+----------------------------------------------------------------------------+

#ifndef DATNTREE_HPP_INCLUDED
#define DATNTREE_HPP_INCLUDED

#include "treenode.hpp"
#include "treedata.hpp"

class DataInTree : public TreeNode
{
public:
   DataInTree(): TreeNode(), MyData() {}
   DataInTree(void *pString);
   DataInTree(DataInTree *pDataInTree);
   DataInTree(const DataInTree &rDataInTree);

   virtual ~DataInTree() {}

   DataInTree &operator= (const DataInTree &rDataInTree);

   virtual void display();
   virtual void SetData(void *pString) { MyData.setData(pString); }
   virtual void *GetData() const       { return MyData.getData(); }

protected:
   TreeData   MyData;
};
#endif
