#ifndef _CNR_
#define _CNR_

/* Revision: 20 1.9.2.1 source/ui/widgets/cnr.h, cuawidgets, ioc.v400, 001006  */
/*******************************************************************************
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1997, 1997                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
/*
 * (c) Copyright 1989, 1990, 1991, 1992, 1993 OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * Motif top of 2.0 tree as of Tue Jun  1 05:18:29 EDT 1993
 */
#ifndef _XmContainer_h
#define _XmContainer_h

#include <Xm/Xm.h>

#ifdef __cplusplus
extern "C" {
#endif

#define DETECT_OVERFLOW 1
#define EMPTY_CNR_REGION 1

/************************************************************************
 * Container Widget defines                                             *
 ************************************************************************/
#define         XmUNSPECIFIED_POSITION          -1

#define         XmRDirection                    "Direction"

        /* XmRAutomaticSelection */
enum {  XmAUTO_SELECT,
        XmNO_AUTO_SELECT
        };
        /* XmRLineStyle */
enum {  /* XmNO_LINE */
        XmSINGLE = 1
        };
        /* XmREntryViewType */
enum {  /* XmLARGE_ICON */
        /* XmSMALL_ICON */
        XmDETAIL = 2
        };
        /* XmRIncludeModel */
enum {  XmAPPEND,
        XmCLOSEST,
        XmFIRST_FIT
        };
        /* XmRLayoutType */
enum {  XmOUTLINE,
        XmSPATIAL
        };
        /* XmRPlaceStyle */
enum {  /* XmNONE */
        XmGRID = 1,
        XmCELLS
        };
        /* XmRSelectionTechnique */
enum {  XmMARQUEE,
        XmMARQUEE_EXTEND_START,
        XmMARQUEE_EXTEND_BOTH,
        XmTOUCH_ONLY,
        XmTOUCH_OVER
        };
        /* XmRExpandState */
enum {  XmCOLLAPSED,
        XmEXPANDED
        };
        /* XmRDirection */
enum {  XmLEFT_TO_RIGHT,
        XmRIGHT_TO_LEFT
        };
#if DETECT_OVERFLOW
typedef struct
{
  int     reason;
  XEvent *event;
  Widget  item;
  int     overflowCount;
} XmContainerOverflowCallbackStruct;

typedef void (* XmContainerOverflowCallbackType)
                     ( Widget cnrwid, XtPointer client_data,
                       XtPointer call_data );


enum {  XmCR_CMEVENT,
        XmCR_KBEVENT
        };
#endif /* DETECT_OVERFLOW */

typedef struct
{
  int     reason;
  XEvent *event;
  Widget  item;
} XmContainerOutlineCallbackStruct;

typedef struct
{
  int             reason;
  XEvent         *event;
  WidgetList      selected_items;
  int             selected_item_count;
  unsigned char   auto_selection_type;
  unsigned char   select_operation;
} XmContainerSelectCallbackStruct;


typedef struct
{
  int             reason;
  XEvent         *event;
  Widget          cursored_item;
  unsigned char   cursored_operation;
} XmContainerCursoredCallbackStruct;

typedef struct
{
  int     reason;
  XEvent *event;
  Widget  item;
  Widget  traversal_destination;
} XmContainerTraversalCallbackStruct;

enum{   XmAUTO_UNSET,                   XmAUTO_BEGIN,
        XmAUTO_MOTION,                  XmAUTO_CANCEL,
        XmAUTO_NO_CHANGE,               XmAUTO_CHANGE
        };
enum{   XmSELECT_CHANGE,                XmSELECT_ADD,
        XmSELECT_REMOVE
        };
enum{   XmCR_COLLAPSED       = 3,
        XmCR_EXPANDED        = 4,
        XmCR_CNRTRAVERSE     = 5,
        XmCR_CURSORED_CHANGE = 6
        };
enum{   XmICON_EXTENT = 1,                                /* bit field */
        XmTEXT_EXTENT = 2
        };
enum{   XmCURSORED_ADD,
        XmCURSORED_REMOVE
        };


/* Class record constants */
extern  WidgetClass     xmContainerWidgetClass;

typedef struct  _XmContainerClassRec  *XmContainerWidgetClass;
typedef struct  _XmContainerRec       *XmContainerWidget;

#ifndef XmIsContainer
#define XmIsContainer(w) XtIsSubclass(w, xmContainerWidgetClass)
#endif /* XmIsContainer */

#define XmNcollapsedStatePixmap "collapsedStatePixmap"
#define XmNdetailColumnHeading  "detailColumnHeading"
#define XmNdetailCount          "detailCount"
#define XmNdetailMask           "detailMask"
#define XmNdetailSeparatorStyle "detailSeparatorStyle"
#define XmNdetailTabList        "detailTabList"
#define XmNentryViewType        "entryViewType"
#define XmNexpandedStatePixmap  "expandedStatePixmap"
#define XmNincludeModel         "includeModel"
#define XmNlargeCellHeight      "largeCellHeight"
#define XmNlargeCellWidth       "largeCellWidth"
#define XmNlayoutDirection      "layoutDirection"
#define XmNlayoutType           "layoutType"
#define XmNoutlineIndentation   "outlineIndentation"
#define XmNoutlineLineStyle     "outlineLineStyle"
#define XmNplaceStyle           "placeStyle"
#define XmNprimaryOwnership     "primaryOwnership"
#define XmNselectedObjects      "selectedObjects"
#define XmNselectedObjectCount  "selectedObjectCount"
#define XmNselectionCallback    "selectionCallback"
#define XmNselectionTechnique   "selectionTechnique"
#define XmNsmallCellHeight      "smallCellHeight"
#define XmNsmallCellWidth       "smallCellWidth"

/* added for ICLUI */
#define XmNshowIconInDetail     "showIconInDetail"
#define XmNshowTextView         "showTextView"
#define XmNrefreshCnr           "refreshCnr"

#define XmNentryDetail          "entryDetail"
#define XmNentryParent          "entryParent"
#define XmNoutlineState         "outlineState"
#define XmNlargeIconX           "largeIconX"
#define XmNlargeIconY           "largeIconY"
#define XmNsmallIconX           "smallIconX"
#define XmNsmallIconY           "smallIconY"
#define XmNiconViewX            "iconViewX"        /* LJO */
#define XmNiconViewY            "iconViewY"        /* LJO */
#define XmNneedArrange          "needArrange"      /* LJO */
#define XmNcursoredCallback     "cursoredCallback"
#define XmNdetailsLineSpacing   "detailsLineSpacing"
#if DETECT_OVERFLOW
#define XmNoverflowCallback     "overflowCallback"
#define XmCOverflowCallback     "OverflowCallback"
#endif
#define XmNcnrTraversalCallback "cnrTraversalCallback"
#define XmCCnrTraversalCallback "CnrTraversalCallback"

/* Perspectives */
#define XmNlineSegments         "lineSegments"
#define XmCLineSegments         "LineSegments"
#define XmNlineSegmentCount     "lineSegmentCount"
#define XmCLineSegmentCount     "LineSegmentCount"
#define XmNrectangleCount       "rectangleCount"
#define XmCRectangleCount       "RectangleCount"
/* end Perspectives */

#define XmCCollapsedStatePixmap "CollapsedStatePixmap"
#define XmCDetailColumnHeading  "DetailColumnHeading"
#define XmCDetailCount          "DetailCount"
#define XmCDetailMask           "DetailMask"
#define XmCEntryViewType        "EntryViewType"
#define XmCLineStyle            "LineStyle"
#define XmCDetailTabList        "DetailTabList"
#define XmCExpandedStatePixmap  "ExpandedStatePixmap"
#define XmCIncludeModel         "IncludeModel"
#define XmCCellHeight           "CellHeight"
#define XmCCellWidth            "CellWidth"
#define XmCLayoutDirection      "LayoutDirection"
#define XmCLayoutType           "LayoutType"
#define XmCNeedArrange          "NeedArrange"             /* LJO */
#define XmCOutlineIndentation   "OutlineIndentation"
#define XmCPlaceStyle           "PlaceStyle"
#define XmCPrimaryOwnership     "PrimaryOwnership"
#define XmCSelectedObjects      "SelectedObjects"
#define XmCSelectedObjectCount  "SelectedObjectCount"
#define XmCSelectionTechnique   "SelectionTechnique"
#define XmCdetailsLineSpacing   "detailsLineSpacing"

#define XmCEntryDetail          "EntryDetail"
#define XmCOutlineState         "OutlineState"

/* ICLUI added */
#define XmCShowIconInDetail     "ShowIconInDetail"
#define XmCShowTextView         "ShowTextView"
#define XmCRefreshCnr           "RefreshCnr"

#define XmRAutomaticSelection   "AutomaticSelection"
#define XmRBitArray             "BitArray"
#define XmRLineStyle            "LineStyle"
#define XmREntryViewType        "EntryViewType"
#define XmRIncludeModel         "IncludeModel"
#define XmRDirection            "Direction"
#define XmRLayoutType           "LayoutType"
#define XmRPlaceStyle           "PlaceStyle"
#define XmRPrimaryOwnership     "PrimaryOwnership"
#define XmRSelectionTechnique   "SelectionTechnique"
#define XmRdetailsLineSpacing   "detailsLineSpacing"

#define XmROutlineState         "OutlineState"

/********    Public Function Declarations    ********/
extern  Widget  XmCreateContainer(
                        Widget          parent,
                        char           *name,
                        ArgList         arglist,
                        Cardinal        argcount);
extern  int     XmContainerGetItemChildren(
                        Widget          wid,
                        Widget          item,
                        WidgetList     *item_children);
extern  void    XmContainerRelayout(
                        Widget          wid);
extern  void    XmContainerReorder(
                        Widget          wid,
                        WidgetList      cwid_list,
                        int             cwid_count);
extern  Widget  XmContainerGetItemByCoordinates(
                        Widget          wid,
                        Position        x,
                        Position        y);


/* Functions added to support IBM Open Class Library */
/* UICL: mimics CM_QUERYRECORD message under PM */
extern Widget
  XuiclQueryRecord              ( Widget            wid,
                                  unsigned long     position,
                                  unsigned long     order);

/* typedef long (*CnrCompareFunction) (void *, void *, void *); */

extern int
  XuiclSort                     ( Widget            widget,
                                  long (*comp) (void*, void*, void*),
                                  void*             sortPckg );

extern void
  XuiclSeverNode                ( Widget            widget );

extern Widget
  XuiclPointerInfo              ( Widget            widget,
                                  int               x,
                                  int               y,
                                  int*              columnPos,
                                  Boolean*          headingText,
                                  Boolean*          titleText );

extern void
  XuiclExpandCollapseTree       ( Widget            widget,
                                  unsigned char     newstate,
                                  Boolean           children );

extern Boolean
  XuiclLocation                 ( Widget            cwidget,
                                  Widget            gid,
                                  int               columnPos,
                                  Position*         label_x,
                                  Position*         label_y,
                                  XRectangle*       cell_rect );

extern XRectangle
  XuiclRectangle                ( Widget            cwidget,
                                  Widget            gid,
                                  unsigned long     extent,
                                  int               columnPos );

extern unsigned long
  XuiclTabWidth                 ( Widget            cwidget,
                                  int               columnPos );

extern void
  XuiclRefresh                  ( Widget            widget );

extern XtGeometryResult
  XuiclReplyToQueryGeometry     ( Widget            widget,
                                  XtWidgetGeometry* intended,
                                  XtWidgetGeometry* desired );

#if EMPTY_CNR_REGION
extern void
  XuiclMouseAction              ( Widget            widget,
                                  XButtonEvent*     xbutton,
                                  String*           params,
                                  Cardinal*         numParams );
#endif /* EMPTY_CNR_REGION */

#if DETECT_OVERFLOW
extern int
  XuiclGetOverflowCount         ( Widget            widget );
#endif

#if 0
#ifdef IC_NOTYET
extern void
  XuiclRefresh                  ( Widget            widget );
#endif
#endif

/* extern void XuiclSetRefreshOn ( Widget widget,
                                   Boolean turnItOn ); */

extern void
  XuiclSetLocationCursor        ( Widget            cwidget );

extern void
  XuiclDetailsTitleRectangle    ( Widget            cwidget,
                                  XRectangle*       rect );

extern unsigned long
  XuiclGetLogicalDisplayHeight  ( Widget            widget );
extern unsigned long
  XuiclGetVerticalDisplayOffset ( Widget            widget );
extern unsigned long
  XuiclSetVerticalDisplayOffset ( Widget            widget,
                                  unsigned long     offset,
                                  Boolean           update );

/********    End Public Function Declarations    ********/

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration which encloses file. */
#endif

#endif /* _XmContainer_h */
/* DON'T ADD ANYTHING AFTER THIS #endif */

#endif // CNR header guard
