/* Revision: 19 1.10.3.1 source/ui/widgets/cnr.c, cuawidgets, ioc.v400, 001006  */
/******************************************************************************
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1997, 1997                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
/*
 * (c) Copyright 1989, 1990, 1991, 1992, 1993 OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * Container.c: The Container widget methods.
 */

#include <stdlib.h>

#ifdef  DEBUG
#include <stdio.h>
#endif  /* DEBUG */

#include "cnrp.h"
#include "icong.h"
#ifdef  COSEICON
#include <Dt/Icon.h>
#endif  /* COSEICON */
#include <Xm/GadgetP.h>
#include <Xm/DrawP.h>
#include <Xm/PrimitiveP.h>
#include <Xm/PushB.h>
/* #include <Xm/DragDrop.h> */
#include <Xm/RepType.h>
#include <Xm/XmP.h>

#ifndef MIN
#define MIN(x,y)  ((x) < (y) ? (x) : (y))
#endif /* MIN */
#ifndef MAX
#define MAX(x,y)  ((x) > (y) ? (x) : (y))
#endif /* MAX */

#ifndef __STDC__
#define const   /* nothing */
#define volatile /* nothing */
#endif

#define ZERO_CELL_DIM   0
#define UNSPECIFIED_POSITION_INDEX      -32767
#define NO_CELL -1
#define OBNAME  "_XM_CONTAINER_OUTLINE_BUTTON"

/* Useful macros */
#define _FIRST  "First"
#define _LAST   "Last"
#define _LEFT   "Left"
#define _RIGHT  "Right"
#define _CNR_UP "Up"
#define _DOWN   "Down"
#define _IN     "In"
#define _OUT    "Out"
#define _ENTER  "Enter"
#define _LEAVE  "Leave"
#define _COPY   "Copy"
#define _LINK   "Link"
#define _MOVE   "Move"

#define INTEGRITY_CHECK 0  /* set to 0 for production */
#define PERFORMANCE 0      /* performance tuned */
// Turned the following flag off - didn't seem to make any difference.  LJO
#define AUTOPOSITION 0     /* arrangeIconView support (f4125) */ /* LJO */

/* ICLUI: Support for logical scrolling of more than 32K pixels. */
#include <limits.h>
#define MIN_SHORT  SHRT_MIN   // -32768 from limits.h
#define MAX_SHORT  SHRT_MAX   // 32767 from limits.h
/* #define MAX_SHORT 512 */   /* for testing */

#include <assert.h>


/********    Static Function Declarations    ********/
        /* Core methods */
static  void                 ClassInitialize(void);
static  void                 Initialize(
                                     Widget          rw,
                                     Widget          nw,
                                     ArgList         args,
                                     Cardinal        *num_args);
static  void                 Destroy(
                                     Widget          wid);
static  void                 Resize(
                                     Widget          wid);
static  void                 Redisplay(
                                     Widget          wid,
                                     XEvent          *event,
                                     Region          region);
static  Boolean              SetValues(
                                     Widget          cw,
                                     Widget          rw,
                                     Widget          nw,
                                     ArgList         args,
                                     Cardinal        *num_args);
static  Boolean              SVNeedLayout(
                                     Widget          cw,
                                     Widget          nw);
static  XtGeometryResult     QueryGeometry(
                                     Widget          wid,
                                     XtWidgetGeometry *intended,
                                     XtWidgetGeometry *desired);
        /* Composite methods */
static  XtGeometryResult     GeometryManager(
                                     Widget          instigator,
                                     XtWidgetGeometry *desired,
                                     XtWidgetGeometry *allowed);
static  void                 ChangeManaged(
                                     Widget          wid);
        /* Constraint methods */
static  void                 ConstraintInitialize(
                                     Widget          rcwid,
                                     Widget          ncwid,
                                     ArgList         args,
                                     Cardinal        *num_args);
static  void                 ConstraintDestroy(
                                     Widget          cwid);
static  Boolean              ConstraintSetValues(
                                     Widget          ccwid,
                                     Widget          rcwid,
                                     Widget          ncwid,
                                     ArgList         args,
                                     Cardinal        *num_args);
        /* Manager methods (none) */
        /* Container methods */
static  Boolean              TestFitItem(
                                     Widget          wid,
                                     Widget          cwid,
                                     Position        x,
                                     Position        y);
static  Boolean              PlaceItem(
                                     Widget          wid,
                                     Widget          cwid);
static  Boolean              RemoveItem(
                                     Widget          wid,
                                     Widget          cwid);
static  XtGeometryResult     QuerySpatialGeometry(
                                     Widget          wid,
                                     XtWidgetGeometry *intended,
                                     XtWidgetGeometry *desired);
        /* Private functions call by Container Methods */
static  void                 PlaceItemNone(
                                     Widget          wid,
                                     Widget          cwid);
static  void                 PlaceItemGrid(
                                     Widget          wid,
                                     Widget          cwid);
static  int                  GetCellFromCoord(
                                     Widget          wid,
                                     Position        x,
                                     Position        y);
static  void                 GetCoordFromCell(
                                     Widget          wid,
                                     Widget          cwid,
                                     int             cell_idx,
                                     XPoint         *point);
static  void                 PlaceItemCells(
                                     Widget          wid,
                                     Widget          cwid);

static  void                 InvalidateAllCells(
                                     XmContainerWidget ncw);

static  void                 PlaceItemReset(
                                     Widget          wid);
static  void                 PlaceCwid(
                                     Widget          cwid,
                                     Position        x,
                                     Position        y);
static  Boolean              HideCwid(
                                     Widget          cwid);
static  void                 ChangeOutlineStatePixmaps(
                                     Widget          cwid); 
static   void                SetLocationCursor(
                                     Widget          cwid,
                                     Widget          wid) ;
        /* Action Procs */
/* ICLUI: added ContainerHelp */
static  void                 ContainerHelp(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerBeginSelect(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerButtonMotion(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerEndSelect(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerBeginToggle(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerEndToggle(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerBeginExtend(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerEndExtend(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerCancel(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerSelect(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerExtend(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerMoveCursor(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerExtendCursor(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerToggleMode(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerSelectAll(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerDeselectAll(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerActivate(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 ContainerFocus(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
        /* Internal Functions */
static  void                 Layout(
                                     Widget          wid);
static  void                 RequestNewSize(
                                     Widget          wid);
static  void                 LayoutOutlineDetail(
                                     Widget          wid);
static  void                 LayoutSpatial(
                                     Widget          wid);
static  void                 SetCellSize(
                                     Widget          wid);
static  void                 SizeOutlineButton(
                                     Widget          wid);
static  void                 UpdateGCs(
                                     Widget          wid);
static  Dimension            SizeOneSpace(
                                     XmFontList      fl);
static  void                 CreateDetailHeading(
                                     Widget          wid);
static  void                 CreateEntryDetail(
                                     Widget          cwid);
static  void                 ResetTabs(
                                     Widget          cwid);
static  Boolean              ShowColumn(
                                     Widget          wid,
                                     int             column);
static  void                 ExposeDetail(
                                     Widget          cwid);
static  void                 ChangeView(
                                     Widget          wid,
                                     unsigned char   view);
static  CwidNode             NewNode(
                                     Widget          cwid);
static  void                 InsertNode(
                                     CwidNode        node);

/* 3 ICLUI functions */
static void                  SortNodes(
                                     Widget          widget,
                                     CwidNode        head,
                                     long (*comp) (void*, void*, void*),
                                     void*           sortPckg);

static  void                 SwapNode(
                                     CwidNode        S1,
                                     CwidNode        S2);

static void                  ModifySelectedChange(
                                     Widget          wid,
                                     Widget          cwid,
                                     Boolean         add);

/* end ICLUI functions */

static  void                 SeverNode(
                                     CwidNode        node);
static  void                 DeleteNode(
                                     Widget          cwid);
static  CwidNode             GetNextNode(
                                     Widget          wid,
                                     CwidNode        start_item);
static  CwidNode             GetNextUpLevelNode(
                                     CwidNode        start_item);
static  CwidNode             GetPrevNode(
                                     Widget          wid,
                                     CwidNode        start_item);
static  void                 StartSelect(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  Boolean              ProcessButtonMotion(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  Widget               LocatePointer(
                                     Widget          wid,
                                     int             x,
                                     int             y);
static  Boolean              SelectAllCwids(
                                     Widget          wid);
static  Boolean              DeselectAllCwids(
                                     Widget          wid);
static  Boolean              MarkCwid(
                                     Widget          cwid,
                                     Boolean         visual_only);
static  Boolean              UnmarkCwidVisual(
                                     Widget          cwid);
static  void                 SetMarkedCwids(
                                     Widget          wid);
static  Boolean              ResetMarkedCwids(
                                     Widget          wid);
static  Boolean              MarkCwidsInRange(
                                     Widget          wid,
                                     Widget          cwid1,
                                     Widget          cwid2,
                                     Boolean         visual_only);
static  Boolean              MarkCwidsInMarquee(
                                     Widget          wid,
                                     Boolean         find_anchor,
                                     Boolean         visual_only);
static  Boolean              InMarquee(
                                     Widget          cwid);
static  void                 RecalcMarquee(
                                     Widget          wid,
                                     Widget          cwid,
                                     Position        x,
                                     Position        y);
static  void                 DrawMarquee(
                                     Widget          wid);
static  void                 KBSelect(
                                     Widget          wid,
                                     XEvent          *event,
                                     String          *params,
                                     Cardinal        *num_params);
static  void                 BorderHighlight(
                                     Widget          cwid);
static  void                 BorderUnhighlight(
                                     Widget          cwid);
static  Widget               CalcNextLocationCursor(
                                     Widget          wid,
                                     String          direction);
static  void                 MakeOutlineButton(
                                     Widget          cwid);
static  void                 ExpandCwid(
                                     Widget          cwid,
                                     Boolean         refresh);
static  Boolean              CollapseCwid(
                                     Widget          cwid,
                                     Boolean         refresh);
static  void                 CallActionCB(
                                     Widget          cwid,
                                     XEvent          *event);
static  void                 CallSelectCB(
                                     Widget          wid,
                                     XEvent          *event,
                                     unsigned char   auto_selection_type);
static  void                 CursoredCB(
                                     Widget          cwid,
                                     Widget          icong,
                                     XEvent          *event,
                                     unsigned char   cursored_change_type);
static  WidgetList           GetSelectedCwids(
                                     Widget          wid);
static  void                 GetSelectedItems(
                                     Widget          wid,
                                     int             offset,
                                     XtArgVal        *value);
static  void                 GetDetailHeading(
                                     Widget          wid,
                                     int             offset,
                                     XtArgVal        *value);
static  void                 GetEntryDetail(
                                     Widget          cwid,
                                     int             offset,
                                     XtArgVal        *value);
static  int                  CompareInts(
                                     const void      *p1,
                                     const void      *p2);
static  int                  Isqrt(
                                     int             n);
        /* Internal Callback Functions */
static  void                 OutlineButtonCallback(
                                     Widget          pbwid,
                                     XtPointer       client_data,
                                     XtPointer       call_data,
                                     Boolean         bMouseClick);
static  void                 OutlineButtonCallbackMouse(
                                     Widget          pbwid,
                                     XtPointer       client_data,
                                     XtPointer       call_data);
static  void                 OutlineButtonCallbackProgram(
                                     Widget          pbwid,
                                     XtPointer       client_data,
                                     XtPointer       call_data);
        /* External Function declarations are in Container.h */

/********    End Static Function Declarations    ********/

/* ICLUI: added translation for ContainerHelp()
 *        and space & Return for ContainerActivate()
 *           (NOTE: Return not working due to IFrameWindow
 *                  default button processing.
 */
static  char    defaultTranslations[] = "\
<Key>osfHelp:                   ContainerHelp()\n\
~c ~s ~m ~a <Btn1Down>:         ContainerBeginSelect()\n\
~m ~a <Btn1Motion>:             ContainerButtonMotion()\n\
~c ~s ~m ~a <Btn1Up>:           ContainerEndSelect()\n\
 c ~s ~m ~a <Btn1Down>:         ContainerBeginToggle()\n\
 c ~s ~m ~a <Btn1Up>:           ContainerEndToggle()\n\
~c  s ~m ~a <Btn1Down>:         ContainerBeginExtend()\n\
~c  s ~m ~a <Btn1Up>:           ContainerEndExtend()\n\
 c  s ~m ~a <Btn1Down>:         ContainerBeginExtend()\n\
 c  s ~m ~a <Btn1Up>:           ContainerEndExtend()\n\
<Key>osfCancel:                 ContainerCancel()\n\
~c ~s <Key>osfSelect:           ContainerSelect()\n\
~c  s <Key>osfSelect:           ContainerExtend()\n\
<Key>osfAddMode:                ContainerToggleMode()\n\
~s  c ~m ~a <Key>slash:         ContainerSelectAll()\n\
~s  c ~m ~a <Key>backslash:     ContainerDeselectAll()\n\
<Key>osfActivate:               ContainerActivate()\n\
<Key>space:                     ContainerActivate()\n\
<Key>Return:                    ContainerActivate()\n\
";

static  char    traversalTranslations[] = "\
 c ~s <Key>osfBeginLine:        ContainerMoveCursor(First)\n\
 c ~s <Key>osfEndLine:          ContainerMoveCursor(Last)\n\
 c  s <Key>osfBeginLine:        ContainerExtendCursor(First)\n\
 c  s <Key>osfEndLine:          ContainerExtendCursor(Last)\n\
~s <Key>osfUp:                  ContainerMoveCursor(Up)\n\
~s <Key>osfDown:                ContainerMoveCursor(Down)\n\
~s <Key>osfLeft:                ContainerMoveCursor(Left)\n\
~s <Key>osfRight:               ContainerMoveCursor(Right)\n\
 s <Key>osfUp:                  ContainerExtendCursor(Up)\n\
 s <Key>osfDown:                ContainerExtendCursor(Down)\n\
 s <Key>osfLeft:                ContainerExtendCursor(Left)\n\
 s <Key>osfRight:               ContainerExtendCursor(Right)\n\
<FocusIn>:                      ContainerFocus(In)\n\
<FocusOut>:                     ContainerFocus(Out)\n\
 s ~m ~a <Key>Tab:              ManagerGadgetPrevTabGroup()\n\
~s ~m ~a <Key>Tab:              ManagerGadgetNextTabGroup()\n\
";

static  XtActionsRec    actionsList[] = {
{"ContainerHelp",               (XtActionProc)  ContainerHelp},
{"ContainerBeginSelect",        (XtActionProc)  ContainerBeginSelect},
{"ContainerButtonMotion",       (XtActionProc)  ContainerButtonMotion},
{"ContainerEndSelect",          (XtActionProc)  ContainerEndSelect},
{"ContainerBeginToggle",        (XtActionProc)  ContainerBeginToggle},
{"ContainerEndToggle",          (XtActionProc)  ContainerEndToggle},
{"ContainerBeginExtend",        (XtActionProc)  ContainerBeginExtend},
{"ContainerEndExtend",          (XtActionProc)  ContainerEndExtend},
{"ContainerCancel",             (XtActionProc)  ContainerCancel},
{"ContainerSelect",             (XtActionProc)  ContainerSelect},
{"ContainerExtend",             (XtActionProc)  ContainerExtend},
{"ContainerMoveCursor",         (XtActionProc)  ContainerMoveCursor},
{"ContainerExtendCursor",       (XtActionProc)  ContainerExtendCursor},
{"ContainerToggleMode",         (XtActionProc)  ContainerToggleMode},
{"ContainerSelectAll",          (XtActionProc)  ContainerSelectAll},
{"ContainerDeselectAll",        (XtActionProc)  ContainerDeselectAll},
{"ContainerActivate",           (XtActionProc)  ContainerActivate},
{"ContainerFocus",              (XtActionProc)  ContainerFocus},
};

static  XtResource      resources[] =
    {
        {
        XmNautomaticSelection,XmCAutomaticSelection,
                XmRAutomaticSelection,sizeof(unsigned char),
        XtOffset(XmContainerWidget,container.automatic),
                XmRImmediate,(XtPointer)XmAUTO_SELECT},
        {
        XmNcollapsedStatePixmap,XmCCollapsedStatePixmap,XmRPixmap,
                sizeof(Pixmap),
        XtOffset(XmContainerWidget,container.collapsed_state_pixmap),
                XmRImmediate,(XtPointer)XmUNSPECIFIED_PIXMAP},
        {
        XmNdefaultActionCallback,XmCCallback,XmRCallback,
                sizeof(XtCallbackList),
        XtOffset(XmContainerWidget,container.default_action_cb),
                XmRImmediate,(XtPointer)NULL},
        {
        XmNdetailColumnHeading,XmCDetailColumnHeading,XmRXmStringTable,
                sizeof(XmStringTable),
        XtOffset(XmContainerWidget,container.detail_heading),
                XmRImmediate,(XtPointer)NULL},
        {
        XmNdetailCount,XmCDetailCount,XmRCardinal,sizeof(Cardinal),
        XtOffset(XmContainerWidget,container.detail_count),
                XmRImmediate,(XtPointer)0},
        {
        XmNdetailSeparatorStyle,XmCLineStyle,XmRLineStyle,
                sizeof(unsigned char),
        XtOffset(XmContainerWidget,container.detail_sep_style),
                XmRImmediate,(XtPointer)XmSINGLE},
        {
        XmNentryViewType,XmCEntryViewType,XmREntryViewType,
                sizeof(unsigned char),
        XtOffset(XmContainerWidget,container.entry_viewtype),
                XmRImmediate,(XtPointer)XmLARGE_ICON},
        {
        XmNexpandedStatePixmap,XmCExpandedStatePixmap,XmRPixmap,
                sizeof(Pixmap),
        XtOffset(XmContainerWidget,container.expanded_state_pixmap),
                XmRImmediate,(XtPointer)XmUNSPECIFIED_PIXMAP},
        {
        XmNfontList,XmCFontList,XmRFontList,
                sizeof(XmFontList),
        XtOffset(XmContainerWidget,container.render_table),
                XmRImmediate,(XtPointer)NULL},
        {
        XmNincludeModel,XmCIncludeModel,XmRIncludeModel,
                sizeof(unsigned char),
        XtOffset(XmContainerWidget,container.include_model),
                XmRImmediate,(XtPointer)XmAPPEND},
        {
        XmNlargeCellHeight,XmCCellHeight,XmRDimension,
                sizeof(Dimension),
        XtOffset(XmContainerWidget,container.large_cell_height),
                XmRImmediate,(XtPointer)ZERO_CELL_DIM},
        {
        XmNlargeCellWidth,XmCCellWidth,XmRDimension,
                sizeof(Dimension),
        XtOffset(XmContainerWidget,container.large_cell_width),
                XmRImmediate,(XtPointer)ZERO_CELL_DIM},
        {
        XmNlayoutDirection,XmCLayoutDirection,XmRDirection,
                sizeof(unsigned char),
        XtOffset(XmContainerWidget,container.layout_direction),
                XmRImmediate,(XtPointer)XmLEFT_TO_RIGHT},
        {
        XmNlayoutType,XmCLayoutType,XmRLayoutType,
                sizeof(unsigned char),
        XtOffset(XmContainerWidget,container.layout_type),
                XmRImmediate,(XtPointer)XmSPATIAL},
        {
        XmNmarginHeight,XmCMarginHeight,XmRDimension,
                sizeof(Dimension),
        XtOffset(XmContainerWidget,container.margin_h),
                XmRImmediate,(XtPointer)0},
        {
        XmNmarginWidth,XmCMarginWidth,XmRDimension,
                sizeof(Dimension),
        XtOffset(XmContainerWidget,container.margin_w),
                XmRImmediate,(XtPointer)0},
        {
        XmNorientation,XmCOrientation,XmROrientation,
                sizeof(unsigned char),
        XtOffset(XmContainerWidget,container.orientation),
                XmRImmediate,(XtPointer)XmHORIZONTAL},
        {
        XmNoutlineIndentation,XmCOutlineIndentation,XmRDimension,
                sizeof(Dimension),
        XtOffset(XmContainerWidget,container.outline_indent),
                XmRImmediate,(XtPointer)100},
        {
        XmNoutlineLineStyle,XmCLineStyle,XmRLineStyle,
                sizeof(unsigned char),
        XtOffset(XmContainerWidget,container.outline_sep_style),
                XmRImmediate,(XtPointer)XmSINGLE},
        {
        XmNplaceStyle,XmCPlaceStyle,XmRPlaceStyle,
                sizeof(unsigned char),
        XtOffset(XmContainerWidget,container.place_style),
                XmRImmediate,(XtPointer)XmNONE},
        {
        XmNresizeHeight,XmCResizeHeight,XmRBoolean,sizeof(Boolean),
        XtOffset(XmContainerWidget,container.resize_height),
                XmRImmediate,(XtPointer)True},
        {
        XmNresizeWidth,XmCResizeWidth,XmRBoolean,sizeof(Boolean),
        XtOffset(XmContainerWidget,container.resize_width),
                XmRImmediate,(XtPointer)True},
        {                                                          /* LJO */
        XmNneedArrange,XmCNeedArrange,XmRBoolean,sizeof(Boolean),  /* LJO */
        XtOffset(XmContainerWidget,container.needArrange),         /* LJO */
                XmRImmediate,(XtPointer)False},                    /* LJO */
        {                                                          /* LJO */
        XmNselectedObjects,XmCSelectedObjects,XmRWidgetList,
                sizeof(WidgetList),
        XtOffset(XmContainerWidget,container.selected_items),
                XmRImmediate,(XtPointer)NULL},
        {
        XmNselectedObjectCount,XmCSelectedObjectCount,XmRInt,
                sizeof(int),
        XtOffset(XmContainerWidget,container.selected_item_count),
                XmRImmediate,(XtPointer)0},
        {
        XmNselectionCallback,XmCCallback,XmRCallback,
                sizeof(XtCallbackList),
        XtOffset(XmContainerWidget,container.selection_cb),
                XmRImmediate,(XtPointer)NULL},
        {
        XmNselectionPolicy,XmCSelectionPolicy,XmRSelectionPolicy,
                sizeof(unsigned char),
        XtOffset(XmContainerWidget,container.selection_policy),
                XmRImmediate,(XtPointer)XmEXTENDED_SELECT},
        {
        XmNselectionTechnique,XmCSelectionTechnique,
                XmRSelectionTechnique,sizeof(unsigned char),
        XtOffset(XmContainerWidget,container.selection_technique),
                XmRImmediate,(XtPointer)XmTOUCH_OVER},
        {
        XmNcursoredCallback,XmCCallback,XmRCallback,
                sizeof(XtCallbackList),
        XtOffset(XmContainerWidget,container.cursored_cb),
                XmRImmediate,(XtPointer)NULL},
        {
        XmNdetailsLineSpacing,XmCdetailsLineSpacing,XmRdetailsLineSpacing,
                sizeof(long),
        XtOffset(XmContainerWidget,container.detailsViewLineSpacing),
                XmRImmediate, (XtPointer)0},
        {
        XmNsmallCellHeight,XmCCellHeight,XmRDimension,
                sizeof(Dimension),
        XtOffset(XmContainerWidget,container.small_cell_height),
                XmRImmediate,(XtPointer)ZERO_CELL_DIM},
        {
        XmNsmallCellWidth,XmCCellWidth,XmRDimension,
                sizeof(Dimension),
        XtOffset(XmContainerWidget,container.small_cell_width),
                XmRImmediate,(XtPointer)ZERO_CELL_DIM},
        {
        XmNvalueChangedCallback,XmCCallback,XmRCallback,
                sizeof(XtCallbackList),
        XtOffset(XmContainerWidget,container.value_changed_cb),
                XmRImmediate,(XtPointer)NULL},
        {
        XmNshowIconInDetail,XmCShowIconInDetail,XmRBoolean,sizeof(Boolean),
        XtOffset(XmContainerWidget,container.showIconInDetail),
                XmRImmediate,(XtPointer)False},
        {
        XmNrefreshCnr,XmCRefreshCnr,XmRBoolean,sizeof(Boolean),
        XtOffset(XmContainerWidget,container.refreshOn),
	             XmRImmediate,(XtPointer)False},
        {
        XmNshowTextView,XmCShowTextView,XmRBoolean,sizeof(Boolean),
        XtOffset(XmContainerWidget,container.showTextView),
                XmRImmediate,(XtPointer)False},
#if DETECT_OVERFLOW
        {
        XmNoverflowCallback,XmCOverflowCallback,XmRCallback,
                sizeof(XtCallbackList),
        XtOffset(XmContainerWidget,container.overflow_callbacks),
                XmRImmediate,(XtPointer)NULL},
#endif
        {
        XmNcnrTraversalCallback,XmCCnrTraversalCallback,XmRCallback,
                sizeof(XtCallbackList),
        XtOffset(XmContainerWidget,container.traversal_callbacks),
                XmRImmediate,(XtPointer)NULL},

        /* Perspectives  f7731 */
        {
        XmNlineSegments,XmCLineSegments,XmRPointer,
                sizeof(XtPointer),
        XtOffset(XmContainerWidget,container.free_hand_segs),
                XmRImmediate, (XtPointer)NULL},
        {
        XmNlineSegmentCount,XmCLineSegmentCount,XmRInt,
                sizeof(int),
        XtOffset(XmContainerWidget, container.free_hand_seg_count),
                XmRImmediate, (XtPointer)0},
        {
        XmNrectangles,XmCRectangles,XmRPointer,
                sizeof(XtPointer),
        XtOffset(XmContainerWidget,container.free_hand_rects),
                XmRImmediate, (XtPointer)NULL},
        {
        XmNrectangleCount,XmCRectangleCount,XmRInt,
                sizeof(int),
        XtOffset(XmContainerWidget,container.free_hand_rect_count),
                XmRImmediate, (XtPointer)NULL},
        /* end Perspectives */
    };

static  XmSyntheticResource     syn_resources[] =
    {
        {
        XmNdetailColumnHeading,sizeof(XmStringTable),
        XtOffset(XmContainerWidget,container.detail_heading),
        GetDetailHeading,NULL},
        {
        XmNlargeCellHeight,sizeof(Dimension),
        XtOffset(XmContainerWidget,container.large_cell_height),
        _XmFromVerticalPixels,_XmToVerticalPixels},
        {
        XmNlargeCellWidth,sizeof(Dimension),
        XtOffset(XmContainerWidget,container.large_cell_width),
        _XmFromHorizontalPixels,_XmToHorizontalPixels},
        {
        XmNmarginHeight,sizeof(Dimension),
        XtOffset(XmContainerWidget,container.margin_h),
        _XmFromVerticalPixels,_XmToVerticalPixels},
        {
        XmNmarginWidth,sizeof(Dimension),
        XtOffset(XmContainerWidget,container.margin_w),
        _XmFromHorizontalPixels,_XmToHorizontalPixels},
        {
        XmNoutlineIndentation,sizeof(Dimension),
        XtOffset(XmContainerWidget,container.outline_indent),
        _XmFromHorizontalPixels,_XmToHorizontalPixels},
        {
        XmNselectedObjects,sizeof(WidgetList),
        XtOffset(XmContainerWidget,container.selected_items),
        GetSelectedItems,NULL},
        {
        XmNsmallCellHeight,sizeof(Dimension),
        XtOffset(XmContainerWidget,container.small_cell_height),
        _XmFromVerticalPixels,_XmToVerticalPixels},
        {
        XmNsmallCellWidth,sizeof(Dimension),
        XtOffset(XmContainerWidget,container.small_cell_width),
        _XmFromHorizontalPixels,_XmToHorizontalPixels},
    };

/*  The constraint resource list  */

static  XtResource      constraints[] =
    {
        {
        XmNentryDetail,XmCEntryDetail,XmRXmStringTable,
                sizeof(XmStringTable),
        XtOffset(XmContainerConstraintPtr,container.entry_detail),
                XmRImmediate,(XtPointer)NULL},
        {
        XmNentryParent,XmCWidget,XmRWidget,sizeof(Widget),
        XtOffset(XmContainerConstraintPtr,container.entry_parent),
                XmRImmediate,(XtPointer)NULL},
        {
        XmNoutlineState,XmCOutlineState,XmROutlineState,
                sizeof(unsigned char),
        XtOffset(XmContainerConstraintPtr,container.outline_state),
                XmRImmediate,(XtPointer)XmCOLLAPSED},
        {
        XmNlargeIconX,XmCIconX,XmRPosition,sizeof(Position),
        XtOffset(XmContainerConstraintPtr,container.large_icon_x),
                XmRImmediate,(XtPointer)XmUNSPECIFIED_POSITION},
        {
        XmNlargeIconY,XmCIconY,XmRPosition,sizeof(Position),
        XtOffset(XmContainerConstraintPtr,container.large_icon_y),
                XmRImmediate,(XtPointer)XmUNSPECIFIED_POSITION},
        {
        XmNpositionIndex,XmCPositionIndex,XmRInt,sizeof(int),
        XtOffset(XmContainerConstraintPtr,container.position_index),
                XmRImmediate,(XtPointer)UNSPECIFIED_POSITION_INDEX},
        {
        XmNsmallIconX,XmCIconX,XmRPosition,sizeof(Position),
        XtOffset(XmContainerConstraintPtr,container.small_icon_x),
                XmRImmediate,(XtPointer)XmUNSPECIFIED_POSITION},
        {
        XmNsmallIconY,XmCIconY,XmRPosition,sizeof(Position),
        XtOffset(XmContainerConstraintPtr,container.small_icon_y),
                XmRImmediate,(XtPointer)XmUNSPECIFIED_POSITION},
        {                                                         /* LJO */
        XmNiconViewX,XmCIconX,XmRPosition,sizeof(Position),       /* LJO */
        XtOffset(XmContainerConstraintPtr,container.icon_view_x), /* LJO */
                XmRImmediate,(XtPointer)XmUNSPECIFIED_POSITION},  /* LJO */
        {                                                         /* LJO */
        XmNiconViewY,XmCIconY,XmRPosition,sizeof(Position),       /* LJO */
        XtOffset(XmContainerConstraintPtr,container.icon_view_y), /* LJO */
                XmRImmediate,(XtPointer)XmUNSPECIFIED_POSITION},  /* LJO */
    };

static  XmSyntheticResource     syn_constraint_resources[] =
    {
        {
        XmNentryDetail,sizeof(XmStringTable),
        XtOffset(XmContainerConstraintPtr,container.entry_detail),
        GetEntryDetail,NULL},
        {
        XmNlargeIconX,sizeof(Position),
        XtOffset(XmContainerConstraintPtr,container.large_icon_x),
        _XmFromHorizontalPixels,_XmToHorizontalPixels},
        {
        XmNlargeIconY,sizeof(Position),
        XtOffset(XmContainerConstraintPtr,container.large_icon_y),
        _XmFromVerticalPixels,_XmToVerticalPixels},
        {
        XmNsmallIconX,sizeof(Position),
        XtOffset(XmContainerConstraintPtr,container.small_icon_x),
        _XmFromHorizontalPixels,_XmToHorizontalPixels},
        {
        XmNsmallIconY,sizeof(Position),
        XtOffset(XmContainerConstraintPtr,container.small_icon_y),
        _XmFromVerticalPixels,_XmToVerticalPixels},
        {                                                         /* LJO */
        XmNiconViewX,sizeof(Position),                            /* LJO */
        XtOffset(XmContainerConstraintPtr,container.icon_view_x), /* LJO */
        _XmFromHorizontalPixels,_XmToHorizontalPixels},           /* LJO */
        {                                                         /* LJO */
        XmNiconViewY,sizeof(Position),                            /* LJO */
        XtOffset(XmContainerConstraintPtr,container.icon_view_y), /* LJO */
        _XmFromVerticalPixels,_XmToVerticalPixels},               /* LJO */
    };

static  String  AutomaticSelectionNames[] =
{       "auto_select", "no_auto_select"
        };
XmRepTypeId     XmRID_AUTOMATIC_SELECTION;

static  String  LineStyleNames[] =
{       "no_line", "single"
        };
XmRepTypeId     XmRID_LINE_STYLE;

static  String  EntryViewTypeNames[] =
{       "large_icon", "small_icon", "detail"
        };
XmRepTypeId     XmRID_ENTRY_VIEW_TYPE;

static  String  IncludeModelNames[] =
{       "append", "closest", "first_fit"
        };
XmRepTypeId     XmRID_INCLUDE_MODEL;

static  String  DirectionNames[] =
{       "left_to_right_top_to_bottom", "right_to_left_top_to_bottom"
        };
XmRepTypeId     XmRID_DIRECTION;

static  String  LayoutTypeNames[] =
{       "outline", "spatial"
        };
XmRepTypeId     XmRID_LAYOUT_TYPE;

static  String  OutlineStateNames[] =
{       "collapsed", "expanded"
        };
XmRepTypeId     XmRID_OUTLINE_STATE;

static  String  PlaceStyleNames[] =
{       "none", "grid"
        };
XmRepTypeId     XmRID_PLACE_STYLE;

static  String  SelectionTechniqueNames[] =
{       "marquee", "marquee_extend_start", "marquee_extend_both",
        "touch_only", "touch_over"
        };
XmRepTypeId     XmRID_SELECTION_TECHNIQUE;

/***************************/
/* Default collapsedPixmap */
/***************************/

#define xm_collapsed16_width 16
#define xm_collapsed16_height 16
static char xm_collapsed16_bits[] = {
   0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xfe, 0x7f, 0xfc, 0x3f, 0xfc, 0x3f,
   0xf8, 0x1f, 0xf8, 0x1f, 0xf0, 0x0f, 0xf0, 0x0f, 0xe0, 0x07, 0xe0, 0x07,
   0xc0, 0x03, 0xc0, 0x03, 0x80, 0x01, 0x80, 0x01};

/**************************/
/* Default expandedPixmap */
/**************************/

#define xm_expanded16_width 16
#define xm_expanded16_height 16
static char xm_expanded16_bits[] = {
   0x80, 0x01, 0x80, 0x01, 0xc0, 0x03, 0xc0, 0x03, 0xe0, 0x07, 0xe0, 0x07,
   0xf0, 0x0f, 0xf0, 0x0f, 0xf8, 0x1f, 0xf8, 0x1f, 0xfc, 0x3f, 0xfc, 0x3f,
   0xfe, 0x7f, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0xff};


externaldef( xmcontainerclassrec) XmContainerClassRec  xmContainerClassRec =
{       /* CoreClassPart */
    {
    (WidgetClass) &xmManagerClassRec, /* superclass */
    "XmContainer",                  /* class_name           */
    sizeof(XmContainerRec),         /* widget_size          */
    ClassInitialize,                /* class_initialize     */
    NULL,                           /* class_initialize     */
    FALSE,                          /* class_inited         */
    Initialize,                     /* initialize           */
    NULL,                           /* initialize_hook      */
    XtInheritRealize,               /* realize              */
    actionsList,                    /* actions              */
    XtNumber(actionsList),          /* num_actions          */
    resources,                      /* resources            */
    XtNumber(resources),            /* num_resources        */
    NULLQUARK,                      /* xrm_class            */
    TRUE,                           /* compress_motion      */
    XtExposeCompressMultiple,       /* compress_exposure    */
    TRUE,                           /* compress_enterleave  */
    TRUE,                           /* visible_interest     */
    Destroy,                        /* destroy              */
    Resize,                         /* resize               */
    Redisplay,                      /* expose               */
    SetValues,                      /* set_values           */
    NULL,                           /* set_values_hook      */
    XtInheritSetValuesAlmost,       /* set_values_almost    */
    NULL,                           /* get_values_hook      */
    NULL,                           /* accept_focus         */
    XtVersion,                      /* version              */
    NULL,                           /* callback private     */
    defaultTranslations,            /* tm_table             */
    QueryGeometry,                  /* query_geometry       */
    NULL,                           /* display_accelerator  */
    NULL,                           /* extension            */
    },
    /* Composite class fields                               */
    {
    GeometryManager,                /* geometry_manager     */
    ChangeManaged,                  /* change_managed       */
    XtInheritInsertChild,           /* insert_child         */
    XtInheritDeleteChild,           /* delete_child         */
    NULL,                           /* extension            */
    },
    /* Constraint class fields                              */
    {
    constraints,                    /* resource list        */
    XtNumber(constraints),          /* num resources        */
    sizeof(XmContainerConstraintRec), /* constraint size    */
    ConstraintInitialize,           /* init proc            */
    ConstraintDestroy,              /* destroy proc         */
    ConstraintSetValues,            /* set values proc      */
    NULL,                           /* extension            */
    },
    /*  XmManager class fields                              */
    {
    traversalTranslations,          /* translations         */
    syn_resources,                  /* get resources        */
    XtNumber(syn_resources),        /* num get_resources    */
    syn_constraint_resources,       /* get_cont_resources   */
    XtNumber(syn_constraint_resources), /* num_get_cont_resources */
    XmInheritParentProcess,         /* parent_process       */
    NULL,                           /* extension            */
    },
    /* Container class fields */
    {
    (XmSpatialTestFitProc)TestFitItem,      /* test_fit_item        */
    (XmSpatialPlacementProc)PlaceItem,      /* place_item           */
    (XmSpatialRemoveProc)RemoveItem,        /* remove_item          */
    (XtGeometryHandler)QuerySpatialGeometry, /* query_spatial_geometry */
    }
};

externaldef( xmcontainerwidgetclass) WidgetClass xmContainerWidgetClass
                = (WidgetClass) &xmContainerClassRec;

/*-------------
| Core methods |
-------------*/
/************************************************************************
 * ClassInitialize
 ************************************************************************/
static void
ClassInitialize( void )
{
    XmRID_AUTOMATIC_SELECTION = XmRepTypeRegister(XmRAutomaticSelection,
            AutomaticSelectionNames,NULL,XtNumber(AutomaticSelectionNames));
    XmRID_LINE_STYLE  = XmRepTypeRegister(XmRLineStyle,
            LineStyleNames,NULL,XtNumber(LineStyleNames));
    XmRID_ENTRY_VIEW_TYPE = XmRepTypeRegister(XmREntryViewType,
            EntryViewTypeNames,NULL,XtNumber(EntryViewTypeNames));
    XmRID_INCLUDE_MODEL = XmRepTypeRegister(XmRIncludeModel,
            IncludeModelNames,NULL,XtNumber(IncludeModelNames));
    XmRID_DIRECTION = XmRepTypeRegister(XmRDirection,
            DirectionNames,NULL,XtNumber(DirectionNames));
    XmRID_LAYOUT_TYPE = XmRepTypeRegister(XmRLayoutType,
            LayoutTypeNames,NULL,XtNumber(LayoutTypeNames));
    XmRID_LINE_STYLE = XmRepTypeRegister(XmRLineStyle,
            LineStyleNames,NULL,XtNumber(LineStyleNames));
    XmRID_OUTLINE_STATE = XmRepTypeRegister(XmROutlineState,
            OutlineStateNames,NULL,XtNumber(OutlineStateNames));
    XmRID_PLACE_STYLE = XmRepTypeRegister(XmRPlaceStyle,
            PlaceStyleNames,NULL,XtNumber(PlaceStyleNames));
    XmRID_SELECTION_TECHNIQUE = XmRepTypeRegister(XmRSelectionTechnique,
            SelectionTechniqueNames,NULL,XtNumber(SelectionTechniqueNames));
}


/************************************************************************
 * Initialize
 ************************************************************************/
static  void
Initialize(
    Widget          rw,
    Widget          nw,
    ArgList         args,           /* unused */
    Cardinal       *num_args )      /* unused */
{
    XmContainerWidget       rcw = (XmContainerWidget) rw;
    XmContainerWidget       ncw = (XmContainerWidget) nw;

    /*
     * Verify enumerated resources.
     */
    if ( ! XmRepTypeValidValue( XmRID_AUTOMATIC_SELECTION,
                    ncw->container.automatic,nw ) )
        ncw->container.automatic = XmAUTO_SELECT;
    if ( ! XmRepTypeValidValue( XmRID_LINE_STYLE,
                    ncw->container.detail_sep_style, nw ) )
        ncw->container.detail_sep_style = XmSINGLE;
    if ( ! XmRepTypeValidValue( XmRID_ENTRY_VIEW_TYPE,
                    ncw->container.entry_viewtype, nw ) )
        ncw->container.entry_viewtype = XmLARGE_ICON;
    if ( ! XmRepTypeValidValue( XmRID_INCLUDE_MODEL,
                    ncw->container.include_model, nw ) )
        ncw->container.include_model = XmAPPEND;
    if ( ! XmRepTypeValidValue( XmRID_DIRECTION,
                    ncw->container.layout_direction, nw ) )
        ncw->container.layout_direction = XmLEFT_TO_RIGHT;
    if ( ! XmRepTypeValidValue( XmRID_LAYOUT_TYPE,
                    ncw->container.layout_type, nw ) )
        ncw->container.layout_type = XmSPATIAL;

/*  UICL: changed to use the safer define */
/*      if (!XmRepTypeValidValue(XmRepTypeGetId("Orientation"), */
    if ( ! XmRepTypeValidValue( XmRepTypeGetId( XmROrientation ),
                    ncw->container.orientation, nw ) )
        ncw->container.orientation = XmHORIZONTAL;
    if ( ! XmRepTypeValidValue( XmRID_LINE_STYLE,
                    ncw->container.outline_sep_style, nw ) )
        ncw->container.outline_sep_style = XmSINGLE;
    if ( ! XmRepTypeValidValue( XmRID_PLACE_STYLE,
                    ncw->container.place_style, nw ) )
        ncw->container.place_style = XmNONE;
    if ( ! XmRepTypeValidValue( XmRepTypeGetId( XmRSelectionPolicy ),
                    ncw->container.selection_policy, nw ) )
        ncw->container.selection_policy = XmEXTENDED_SELECT;
    if ( ! XmRepTypeValidValue( XmRID_SELECTION_TECHNIQUE,
                    ncw->container.selection_technique, nw ) )
        ncw->container.selection_technique = XmTOUCH_OVER;

    /*
     * Initialize internal variables.
     */
    ncw->container.detailsViewLineSpacing = 0L ;

    ncw->container.first_node = NULL;
    ncw->container.last_node = NULL;
    ncw->container.self = False;

    ncw->container.toggle_pressed = False;
    ncw->container.extend_pressed = False;
    ncw->container.cancel_pressed = False;
    ncw->container.kaddmode =
          ( CtrPolicyIsMULTIPLE( ncw )  ||  CtrPolicyIsSINGLE( ncw ) );
    ncw->container.marquee_mode = ! ( CtrTechIsTOUCH_ONLY( ncw ) );
    ncw->container.marquee_drawn = False;

    ncw->container.selection_state = XmSELECTED;
    ncw->container.anchor_cwid = NULL;
    ncw->container.loc_cursor_cwid = NULL;
    ncw->container.have_focus = False;
    ncw->container.have_primary = False;

    ncw->container.last_click_time = 0;
#if DETECT_OVERFLOW
    ncw->container.nodes_laidout = 0;
#endif
    ncw->container.severing_node = False;

    /*
     * Get default Font.
     */
    if ( ncw->container.render_table == NULL )
    {
        XmFontList  defaultFont = NULL;

        defaultFont = _XmGetDefaultFontList( nw, XmLABEL_FONTLIST );
        ncw->container.render_table = XmFontListCopy( defaultFont );
    }
    else
        ncw->container.render_table =
                       XmFontListCopy( ncw->container.render_table );

    /*
     * Initialize GCs
     */
    ncw->container.normalGC = NULL;
    ncw->container.inverseGC = NULL;
    ncw->container.marqueeGC = NULL;
    UpdateGCs( nw );

    /*
     * Get XmNexpandedStatePixmap & XmNcollapsedStatePixmap
     */
    if ( ncw->container.expanded_state_pixmap == XmUNSPECIFIED_PIXMAP )
    {
        Pixmap  bitmap;

        ncw->container.bDefaultOutlinePixmaps = True ;
        bitmap =
            XCreateBitmapFromData( XtDisplay( ncw ),
                                   RootWindowOfScreen( XtScreen( ncw ) ),
                                   (char*) xm_expanded16_bits,
                                   xm_expanded16_width,
                                   xm_expanded16_height );
        ncw->container.expanded_state_pixmap =
            XCreatePixmap( XtDisplay( ncw ),
                           RootWindowOfScreen( XtScreen( ncw ) ),
                           xm_expanded16_width, xm_expanded16_height,
                           DefaultDepthOfScreen( XtScreen( ncw ) ) );
        XCopyPlane( XtDisplay( ncw ), bitmap,
                    ncw->container.expanded_state_pixmap,
                    ncw->container.normalGC, 0, 0,
                    xm_expanded16_width, xm_expanded16_height,
                    0, 0, 1 );
        XFreePixmap( XtDisplay( ncw ), bitmap );
    }

    if ( ncw->container.collapsed_state_pixmap == XmUNSPECIFIED_PIXMAP )
    {
        Pixmap  bitmap;

        ncw->container.bDefaultOutlinePixmaps = True ;
        bitmap =
            XCreateBitmapFromData( XtDisplay( ncw ),
                                   RootWindowOfScreen( XtScreen( ncw ) ),
                                   (char*) xm_collapsed16_bits,
                                   xm_collapsed16_width,
                                   xm_collapsed16_height );
        ncw->container.collapsed_state_pixmap =
            XCreatePixmap( XtDisplay( ncw ),
                           RootWindowOfScreen( XtScreen( ncw ) ),
                           xm_collapsed16_width, xm_collapsed16_height,
                           DefaultDepthOfScreen( XtScreen( ncw ) ) );
        XCopyPlane( XtDisplay( ncw ), bitmap,
                    ncw->container.collapsed_state_pixmap,
                    ncw->container.normalGC, 0, 0,
                    xm_collapsed16_width,
                    xm_collapsed16_height, 0, 0, 1 );
        XFreePixmap( XtDisplay( ncw ), bitmap );
    }

    SizeOutlineButton( nw );

    ncw->container.hspacing = SizeOneSpace( ncw->container.render_table );

    ncw->container.heading_rect.x = ncw->container.margin_w;
    ncw->container.heading_rect.y = ncw->container.margin_h;
    ncw->container.heading_rect.width = 0;
    ncw->container.detail_count_at_create = ncw->container.detail_count;
    if ( ncw->container.detail_count != 0 )
    {
        ncw->container.tabs = (int*)
            XtCalloc( ncw->container.detail_count + 1, sizeof( int ) );
        ncw->container.tabs[0] = ncw->container.margin_w;
    }
    else
        ncw->container.tabs = NULL;

    /* ICLUI: CreateDetailHeading may create detail_segs for a detail
              heading that will be displayed even though no IconGadgets
              are in the Container. So we moved intialization of detail_segs
              before CreateDetailHeading.
     */
    ncw->container.detail_segs = NULL;
    ncw->container.detail_seg_count = 0;
    CreateDetailHeading( nw );

    ncw->container.max_depth = 0;
    ncw->container.outline_segs = NULL;

    /* ICLUI: Replaced XmContainerPart::outline_seg_count with
     *        outline_seg_count_allocated and outline_seg_count_used.
     */
    ncw->container.outline_seg_count_allocated = 0;
    ncw->container.outline_seg_count_used = 0;

    /* Perspectives  f7731 */
    ncw->container.free_hand_segs = NULL;
    ncw->container.free_hand_seg_count = 0;

    ncw->container.free_hand_rects = NULL;
    ncw->container.free_hand_rect_count = 0;
    /* end Perspectives */

    /*
     * Initialize GRID/CELLS
     */
    ncw->container.cells = NULL;
    ncw->container.cell_count = 0;

    // ICLUI: Replaced next_free_cell with first_free_cell and
    //        last_used_cell.
    ncw->container.first_free_cell = 0;
    ncw->container.last_used_cell = 0;

    ncw->container.current_width_in_cells = 0;
    ncw->container.current_height_in_cells = 0;
    ncw->container.firstChangeManaged = True;
    ncw->container.refreshOn = True;

    /*
     * Freeze width & height, if requested and if specified.
     */
    if ( rcw->core.width == 0 )
        ncw->container.width_frozen = False;
    else
        ncw->container.width_frozen =
                        (ncw->container.resize_width) ? False : True;
    if ( rcw->core.height == 0 )
        ncw->container.height_frozen = False;
    else
        ncw->container.height_frozen =
                        (ncw->container.resize_height) ? False : True;

    /* ICLUI: Support for logical scrolling of more than 32K pixels. */
    ncw->container.logicalDisplayHeight = 0;
    ncw->container.verticalDisplayOffset = 0;

    /* ICLUI: Performance flag for changing views. */
    ncw->container.viewChangeInProgress = False;
}

/************************************************************************
 * Destroy
 ************************************************************************/
static  void
Destroy( Widget  wid )
{
#ifdef DEBUG
    printf( "cnr::Destroy\n" );
    fflush( stdout );
#endif
    XmContainerWidget       cw = (XmContainerWidget) wid;
    int                     i;
    XmContainerConstraint   c;

    XmFontListFree( cw->container.render_table );
    XtReleaseGC( wid, cw->container.normalGC );
    XtReleaseGC( wid, cw->container.inverseGC );
    XtReleaseGC( wid, cw->container.marqueeGC );
    for ( i = 0; i < cw->composite.num_children; i++ )
    {
        /* Bypass XtDestroyWidget if no constraints for child  */
        if ( cw->composite.children[i]->core.constraints )
        {
            c = GetContainerConstraint( cw->composite.children[i] );
            if ( c->container_created )
                XtDestroyWidget( cw->composite.children[i] );
        }
    }
    if ( cw->container.detail_heading != NULL )
    {
        for ( i = 0; i < cw->container.detail_count; i++ )
            _XmStringFree( cw->container.detail_heading[i] );
        XtFree( (char*) cw->container.detail_heading );
    }
    if ( cw->container.outline_segs != NULL )
        XtFree( (char*) cw->container.outline_segs );
    if ( cw->container.detail_segs != NULL )
        XtFree( (char*) cw->container.detail_segs );

 /* Perspectives  f7731 */
    if ( cw->container.free_hand_segs != NULL )
    {
        XtFree( (char*) cw->container.free_hand_segs );
        cw->container.free_hand_segs = NULL;
    }
    if ( cw->container.free_hand_rects != NULL )
    {
        XtFree( (char*) cw->container.free_hand_rects );
        cw->container.free_hand_rects = NULL;
    }
 /* end Perspectives */

    if ( cw->container.tabs != NULL )
        XtFree( (char*) cw->container.tabs );
}

/************************************************************************
 * Resize
 ************************************************************************/
static void
Resize(
    Widget      wid )
{
    XmContainerWidget   cw = (XmContainerWidget)wid;

#ifdef  DEBUG
    printf( "cnr::Resize\n" );
    fflush( stdout );
#endif
    /*
     * The one-dimensional layouts are oblivious to size constraints
     * in the Left-to-Right layout direction.
     * So, just return. Otherwise, call Layout() to adjust to new size.
     */
    if ( ( CtrViewIsDETAIL( cw )  ||  CtrLayoutIsOUTLINE( cw ) )  &&
         ( CtrLayoutIsLtoR( cw ) ) )
        return;
    /*
     * One-dimensional Right-to_Left layouts are oblivious to
     * height changes; so, just return if the width hasn't changed.
     */
    if ( ( CtrViewIsDETAIL( cw )  ||  CtrLayoutIsOUTLINE( cw ) )  &&
         ( cw->core.width == cw->container.prev_width ) )
        return;
    /*
     * ICLUI: Height-only changes don't affect horizontal layouts.
     */
    if ( CtrIsHORIZONTAL( cw )  &&
         ( cw->core.width == cw->container.prev_width ) )
    {
        return;
    }

    cw->container.prev_width = cw->core.width;
    Layout( wid );
}

/************************************************************************
 * Redisplay
 * This function processes expose events.
 ************************************************************************/
static  void
Redisplay(
    Widget  wid,
    XEvent *event,
    Region  region)
{

#ifdef DEBUG
    printf( "cnr::Redisplay\n" );
    fflush( stdout );
#endif
    XmContainerWidget     cw = (XmContainerWidget)wid;
    int                   i;
    Dimension             check_width;
    Position              check_x = 0;
    Position              ltor_x;
    CwidNode              node;
    XmContainerConstraint c;
    GC                    rect_gc, string_gc;
    Dimension            *baselines;
    int                   baseline_count;
    Position              string_y;
    long                  workY;

#ifdef DEBUG
    printf( "cnr ideal width = %d\n", cw->container.ideal_width );
    printf( "cnr ideal height = %d\n", cw->container.ideal_height );
    fflush( stdout );
#endif

    if ( ! cw->container.refreshOn )
        return;

    if ( CtrViewIsDETAIL( cw ) )
    /*
     * If we're in detail view, we have to render all the XmStrings in
     * the heading and the entries.
     */
    {
        /*
         * Check for exposures in each detail-heading column and redraw.
         */
        if ( cw->container.detail_heading != NULL )
        {
            if ( cw->container.detail_count > 0 )
                check_x = cw->container.tabs[0] + cw->container.hspacing;
            for ( i = 0; i < cw->container.detail_count; i++ )
            {
                if ( ShowColumn( wid, i ) )
                {
                    /* ICLUI: Account for calls to XuiclSetVerticalDisplayOffset.
                     */
                    workY = cw->container.heading_rect.y -
                               cw->container.verticalDisplayOffset;
                    if ( workY + cw->container.heading_rect.height > 0 )
                    {   // Some part of the column heading is in the 32K
                        // visible vertical pixels of the container.
                        check_width = cw->container.tabs[i+1];
                        ltor_x = check_x;
                        if ( CtrLayoutIsRtoL( cw ) )
                            check_x = cw->core.width
                                           - check_x - check_width;
                        if ( XRectInRegion( region, check_x,
                                            (int) workY,
                                            check_width,
                                            cw->container.heading_rect.height )
                                                         != RectangleOut )
                        {
                            _XmStringDraw( XtDisplay( wid ), XtWindow( wid ),
                                    cw->container.render_table,
                                    cw->container.detail_heading[i],
                                    cw->container.normalGC,
                                    check_x,
                                    (int) workY,
                                    check_width,
                                    XmALIGNMENT_BEGINNING,
                                    cw->manager.string_direction, NULL );
                        }

                        if ( CtrLayoutIsRtoL( cw ) )
                            check_x = ltor_x;
                        check_x += cw->container.tabs[i+1]
                                        + cw->container.hspacing;
                    }
                }
            }
        } // end details heading

        /*
         * Check for exposures in each entry-detail column of each
         * node and redraw the exposed strings.
         */
        node = cw->container.first_node;
        while ( node != NULL )
        {
            c = GetContainerConstraint( node->widget_ptr );

            if ( c->entry_detail != NULL )
            {
                // ICLUI: Ignore this node if it does not appear within
                //        the expose region.
                if ( XRectInRegion( region, 0, c->row_y,
                                    SHRT_MAX, c->row_height) != RectangleOut )
                {
                    XmGadgetClassExt *gcePtr;

                    if ( c->selection_visual == XmSELECTED )
                    {
                        string_gc = cw->container.inverseGC;
                        rect_gc = cw->container.normalGC;
                    }
                    else
                    {
                        string_gc = cw->container.normalGC;
                        rect_gc = cw->container.inverseGC;
                    }
                    string_y = c->row_y;
                    /*
                     * If the first column is a Gadget, see if it has a
                     * widget_baseline method so we can line up the
                     * other columns with it.
                     * ICLUI: don't use the baseline adjustment if not
                     *        showing the Icon.
                     */
                    if ( cw->container.showIconInDetail )
                    {
                        gcePtr = _XmGetGadgetClassExtPtr(
                                    (XmGadgetClass)XtClass(node->widget_ptr),
                                    NULLQUARK );
                        if ( *gcePtr  &&  (*gcePtr)->widget_baseline )
                        {
                            if ( (*((*gcePtr)->widget_baseline))
                                    (node->widget_ptr,&baselines,
                                                    &baseline_count) )
                            {
                                string_y = MAX(c->row_y,
                                        baselines[baseline_count-1]
                                                - c->detail_height);
                                XtFree( (char*) baselines );
                            }
                        }
                    }

                    check_x = cw->container.tabs[0] + cw->container.hspacing;
                    /* if (cw->container.showIconInDetail)
                          check_x += cw->container.tabs[1]; */
                    for ( i = 0; i < cw->container.detail_count; i++ )
                    {
                        /*
                         * Check each column of the entry detail.
                         */
                        if ( ShowColumn( wid, i ) )
                        {
                            check_width = cw->container.tabs[i+1];
                            ltor_x = check_x;
                            if ( CtrLayoutIsRtoL( cw ) )
                                check_x = cw->core.width
                                                - check_x - check_width;
                            if ( XRectInRegion( region, check_x,
                                                c->row_y, check_width,
                                                c->row_height) != RectangleOut )
                            {
                                XFillRectangle( XtDisplay(wid),XtWindow(wid),
                                        rect_gc,check_x,c->row_y,
                                        check_width,c->row_height ); 
                                _XmStringDraw( XtDisplay(wid),XtWindow(wid),
                                        cw->container.render_table,
                                        c->entry_detail[i],string_gc,
                                        check_x,string_y,check_width,
                                        XmALIGNMENT_BEGINNING,
                                        cw->manager.string_direction,NULL );
                            }

                            if ( CtrLayoutIsRtoL( cw ) )
                                check_x = ltor_x;
                            check_x += cw->container.tabs[i+1]
                                            + cw->container.hspacing;
                        }
                    }
                }
            }
            /*
             * No sense checking for exposures if we've hit the bottom
             * of the Window.  Otherwise, get the next node.
             */
            if ( c->row_y + c->row_height > cw->core.height )
                break;
            node = GetNextNode( wid, node );
        } // end iterate all nodes
    } // end details view

    /*
     * If lines are present & we're in detail view, draw the lines.
     */
    if ( CtrDrawLinesDETAIL(cw) && (cw->container.detail_seg_count > 0) )
    {
        XDrawSegments( XtDisplay(wid), XtWindow(wid),
                       cw->container.normalGC,
                       cw->container.detail_segs,
                       cw->container.detail_seg_count );
    }

    /*
     * If lines are present & we're in outline layout, draw the lines.
     */
    if ( CtrDrawLinesOUTLINE( cw )  &&
         ( cw->container.outline_seg_count_used > 0 ) )
    {
        XDrawSegments( XtDisplay( wid ), XtWindow( wid ),
                       cw->container.normalGC,
                       cw->container.outline_segs,
                       cw->container.outline_seg_count_used );
    }

    /* Perspectives  f7731 */
    /*
     * If we have any free hand lines to draw and we're not in
     * details view - draw them now
     */
    if ( ( ! CtrDrawLinesDETAIL( cw ) )  &&
         ( cw->container.free_hand_seg_count > 0 ) )
    {
        XDrawSegments( XtDisplay(wid), XtWindow(wid),
                       cw->container.normalGC,
                       cw->container.free_hand_segs,
                       cw->container.free_hand_seg_count );
    }

    /*
     * if we have any rectangles to draw -- draw them too
     */
    if ( ( ! CtrDrawLinesDETAIL( cw ) )  &&
         ( cw->container.free_hand_rect_count > 0 ) )
    {
        XDrawRectangles( XtDisplay(wid), XtWindow(wid),
                         cw->container.normalGC,
                         cw->container.free_hand_rects,
                         cw->container.free_hand_rect_count );
    }
    /* end Perspectives */

    // This function is called when the widget is "exposed", i.e.,
    // made visible.  So we have to check to see if an arrangeIconView
    // was made while the widget was invisible and do it.
    if ( CtrPlaceStyleIsNONE( cw )  &&  CtrNeedArrange( cw ) )/* LJO */
    {                                                         /* LJO */
        XtVaSetValues( wid, XmNplaceStyle, XmGRID, NULL );    /* LJO */
        XmContainerRelayout( wid );                           /* LJO */
        XtVaSetValues( wid, XmNplaceStyle, XmNONE,            /* LJO */
                            XmNneedArrange, False,            /* LJO */
                            NULL );                           /* LJO */
    }                                                         /* LJO */
    /*
     * Redisplay all affected gadgets & Highlight the item at the
     *      location cursor.
     * ICLUI: IconGadget's Redisplay() will check the showIconInDetail
     *        and showTextView resources and do the right thing.
     */
    _XmRedisplayGadgets( wid,event,region );

#ifdef DEBUG
    printf( "at end of Redisplay\n" );
    printf( "cnr ideal width = %d\n", cw->container.ideal_width );
    printf( "cnr ideal height = %d\n", cw->container.ideal_height );
    fflush( stdout );
#endif

    BorderHighlight( cw->container.loc_cursor_cwid );
}

/************************************************************************
 * SetValues
 ************************************************************************/
static  Boolean
SetValues(
        Widget          cw,
        Widget          rw,             /* unused */
        Widget          nw,
        ArgList         args,           /* unused */
        Cardinal        *num_args)      /* unused */
{
    XmContainerWidget       ccw = (XmContainerWidget)cw;
    XmContainerWidget       ncw = (XmContainerWidget)nw;
    Boolean                 need_layout = False;
    Boolean                 need_expose = False;
    CwidNode                node;
    XmContainerConstraint   c;
    int                     i;

    /*
     * Verify enumerated resources.
     */
    if ( ! XmRepTypeValidValue( XmRID_AUTOMATIC_SELECTION,
                                ncw->container.automatic, nw ) )
        ncw->container.automatic = 
                          ccw->container.automatic;
    if ( ! XmRepTypeValidValue( XmRID_LINE_STYLE,
                                ncw->container.detail_sep_style, nw ) )
        ncw->container.detail_sep_style =
                          ccw->container.detail_sep_style;
    if ( ! XmRepTypeValidValue( XmRID_ENTRY_VIEW_TYPE,
                                ncw->container.entry_viewtype, nw ) )
        ncw->container.entry_viewtype =
                          ccw->container.entry_viewtype;
    if ( ! XmRepTypeValidValue( XmRID_INCLUDE_MODEL,
                                ncw->container.include_model, nw ) )
        ncw->container.include_model =
                          ccw->container.include_model;
    if ( ! XmRepTypeValidValue( XmRID_DIRECTION,
                                ncw->container.layout_direction, nw ) )
        ncw->container.layout_direction =
                          ccw->container.layout_direction;
    if ( ! XmRepTypeValidValue( XmRID_LAYOUT_TYPE,
                                ncw->container.layout_type, nw ) )
        ncw->container.layout_type =
                          ccw->container.layout_type;
/*  UICL: changed line below to avoid Illegal representation id warnings. */
/*  if (!XmRepTypeValidValue(XmRepTypeGetId("XmROrientation"), */
    if ( ! XmRepTypeValidValue( XmRepTypeGetId( XmROrientation ),
                                ncw->container.orientation, nw ) )
        ncw->container.orientation =
                          ccw->container.orientation;
    if ( ! XmRepTypeValidValue( XmRID_LINE_STYLE,
                                ncw->container.outline_sep_style, nw ) )
        ncw->container.outline_sep_style =
                          ccw->container.outline_sep_style;
    if ( ! XmRepTypeValidValue( XmRID_PLACE_STYLE,
                                ncw->container.place_style, nw ) )
        ncw->container.place_style =
                          ccw->container.place_style;
    if ( ! XmRepTypeValidValue( XmRepTypeGetId( XmRSelectionPolicy ),
                                ncw->container.selection_policy, nw ) )
        ncw->container.selection_policy =
                          ccw->container.selection_policy;
    if ( ! XmRepTypeValidValue( XmRID_SELECTION_TECHNIQUE,
                                ncw->container.selection_technique, nw ) )
        ncw->container.selection_technique =
                          ccw->container.selection_technique;

    /*
     * Check if we'll need a new layout.
     */
    need_layout = SVNeedLayout( cw, nw );

    /*
     * ICLUI: will call ChangeView if coming from XmDETAIL.
     * Code had been skipping this.
     * Change all IconGadget children's XmNentryType to match
     * XmNentryViewType, unless we're changing to XmDETAIL.
     */
    // This is a bug I found in the widget - changing from certain views to
    // others didn't work properly all the time.  The fix was to move this
    // call to ChangeView to BEFORE the loop below to relayout all the
    // gadgets.  LJO
    if ( ( ncw->container.entry_viewtype != ccw->container.entry_viewtype )  &&  /* LJO */
         ( ! CtrViewIsDETAIL( ncw ) ) )                                          /* LJO */
        ChangeView( nw, ncw->container.entry_viewtype );                         /* LJO */

    /* ICLUI: if Icon handling changes, then Layout. Following new resources
     *        were added to support PM behaviour:
     *
     *        showIconInDetail - tells the container to display the IconGadget's
     *                           Icon in detail view. This is not done unless
     *                           an IContainerColumn is added with DataSource
     *                           of "isIcon".
     *        showTextView     - for the PM Text View. Icons are not displayed.
     *
     *  When either of the new resources changes, or we switch to/from
     *  Details View, then we have to call the new function
     *  XuiclIconGadgetLayout (in IconG.c) to resize every IconGadget that
     *  is a child of the Container. Then when we call Container's Layout()
     *  at the bottom of this function, each IconGadget will return its
     *  proper size.
     */
    if ( ( ( ncw->container.showIconInDetail != ccw->container.showIconInDetail )  &&
           CtrViewIsDETAIL( ncw ) )  ||

         ( ( ncw->container.showTextView != ccw->container.showTextView )  &&
           ! CtrViewIsDETAIL( ncw ) )  ||

         ( CtrViewIsDETAIL( ncw ) != CtrViewIsDETAIL( ccw ) ) )
    {
        need_layout = True;
        /* Use the composite list to pick up all children. This makes Tree View
           work since unexpanded nodes are unmanaged.
         */
        for (i = 0; i < ncw->composite.num_children; i++)
        {
            if ( XtIsSubclass( ncw->composite.children[i], xmIconGadgetClass ) )
                XuiclIconGadgetLayout( ncw->composite.children[i] );
        }
    }

    /*
     * SetCellSizes if we need to.
     * ICLUI: call SetCellSize() if need_layout is true
     */
    if ( CtrPlaceStyleIsGRID( ncw )  ||  CtrPlaceStyleIsCELLS( ncw ) )
    {
        if ( CtrViewIsLARGEICON( ncw )  &&
             ( ( ncw->container.large_cell_width == ZERO_CELL_DIM )  ||
               ( ncw->container.large_cell_height == ZERO_CELL_DIM )  ||
               ( need_layout ) ) )
            SetCellSize( nw );
        if ( CtrViewIsSMALLICON( ncw )  &&
             ( ( ncw->container.small_cell_width == ZERO_CELL_DIM )  ||
               ( ncw->container.small_cell_height == ZERO_CELL_DIM )  ||
               ( need_layout ) ) )
            SetCellSize( nw );
    }

    /*
     * ICLUI: redo cells
     *     Added this code so we could go from Icon <-> Name/Text view.
     */
    else if ( CtrLayoutIsSPATIAL( ncw )  &&  need_layout )
    {
        PlaceItemReset( nw );
        InvalidateAllCells( ncw );
    }

    /*
     * Hide all non-level-0 children if we've switched from CtrLayoutIsOUTLINE
     */
    if ( ( ncw->container.layout_type != ccw->container.layout_type )  &&
         ( CtrLayoutIsOUTLINE( ccw ) ) )
    {
        node = ccw->container.first_node;
        while ( node != NULL )
        {
            c = GetContainerConstraint(node->widget_ptr);
            if ( ( ( c->depth == 0 )  &&  ( c->outline_button != NULL ) )  ||
                 ( c->depth != 0 ) )
                HideCwid( node->widget_ptr );
            node = GetNextNode( cw, node );
        }
    }

    if ( ( ncw->container.collapsed_state_pixmap !=
                             ccw->container.collapsed_state_pixmap )  ||
         ( ncw->container.expanded_state_pixmap !=
                             ccw->container.expanded_state_pixmap ) )
    {
        SizeOutlineButton( nw );
        /* update the existing expand/collapse buttons */
        ChangeOutlineStatePixmaps( (Widget) ncw );
        if ( CtrLayoutIsOUTLINE( ncw ) )
        {
            need_expose = True;
            if ( ( ncw->container.ob_width != ccw->container.ob_width )  ||
                 ( ncw->container.ob_height != ccw->container.ob_height ) )
                need_layout = True;
        }
    }

    /*
     * Invalidate "placed" constraints if Spatial Layout options
     *      have changed.
     */
    if ( CtrLayoutIsSPATIAL( ncw )  &&
         ( ncw->container.place_style != ccw->container.place_style ) )
    {
        PlaceItemReset( nw );                         // ICLUI
        InvalidateAllCells( ncw );
    }

    /*
     * Set selected items, if necessary.
     */
    if ( ncw->container.selected_items !=
                                    ccw->container.selected_items )
    {
       int     save_item_count;

       DeselectAllCwids( cw );
       if ( ncw->container.selected_items == NULL )
       {
           ncw->container.selected_item_count = 0;
       }
       else
       {
           save_item_count = ncw->container.selected_item_count;
           ncw->container.selected_item_count = 0;
           for ( i = 0; i < save_item_count; i++ )
           {
               MarkCwid( ncw->container.selected_items[i], False );
           }
       }
    }

    /*
     * Change GC's and Fontlist, if necessary.
     */
    if ( ncw->container.render_table != ccw->container.render_table )
    {
        XmFontListFree( ccw->container.render_table );
        ncw->container.render_table =
                        XmFontListCopy( ncw->container.render_table );
        ncw->container.hspacing = SizeOneSpace( ncw->container.render_table );
        UpdateGCs( nw );
    }

    if ( ( ncw->manager.foreground != ccw->manager.foreground )  ||
         ( ncw->core.background_pixel != ccw->core.background_pixel ) )
    {
        Pixmap     bitmap;

        /* when container background color changes, re-color the
         * expand-collapse push-buttons
         */
        if ( ncw->core.background_pixel != ccw->core.background_pixel )
        {
            Cardinal   numChildren = 0;
            WidgetList child = 0;

            XtVaGetValues( nw,
                           XmNnumChildren, &numChildren,
                           XmNchildren, &child,
                           NULL );
            for ( i = 0; i < numChildren; i++ )
            {
                if ( XmIsPushButton( child[i] ) )
                {
                    XmChangeColor( child[i], ncw->core.background_pixel );
                }
            }
        }

        UpdateGCs( nw );

        /* recolor bitmaps */
        if ( ncw->container.bDefaultOutlinePixmaps )
        {
           bitmap = XCreateBitmapFromData( XtDisplay( ncw ),
                       RootWindowOfScreen( XtScreen( ncw ) ),
                       (char*) xm_collapsed16_bits,
                       xm_collapsed16_width, xm_collapsed16_height );
           XCopyPlane( XtDisplay( ncw ), bitmap,
                       ncw->container.collapsed_state_pixmap,
                       ncw->container.normalGC, 0, 0,
                       xm_collapsed16_width, xm_collapsed16_height,
                       0, 0, 1 );
           XFreePixmap( XtDisplay( ncw ), bitmap );

           bitmap = XCreateBitmapFromData( XtDisplay( ncw ),
                       RootWindowOfScreen( XtScreen( ncw ) ),
                       (char*) xm_expanded16_bits,
                       xm_expanded16_width, xm_expanded16_height );
           XCopyPlane( XtDisplay( ncw ), bitmap,
                       ncw->container.expanded_state_pixmap,
                       ncw->container.normalGC, 0, 0,
                       xm_expanded16_width,xm_expanded16_height,
                       0, 0, 1);
           XFreePixmap( XtDisplay( ncw ), bitmap );
        }

        if ( CtrLayoutIsOUTLINE( ncw ) )
        {
            need_expose = True;
        }
    }

    /*
     * Build new tab array
     */
    if ( ncw->container.detail_count != ccw->container.detail_count )
    {
        if ( ncw->container.detail_count >
                               ccw->container.detail_count_at_create )
        {
           ncw->container.tabs =
               (int*) XtRealloc( (char*) ccw->container.tabs,
                                 sizeof( int ) *
                                   ( ncw->container.detail_count + 1 ) );
           for ( i = ccw->container.detail_count_at_create;
                 i < ncw->container.detail_count;
                 i++)
               ncw->container.tabs[i+1] = 0;
           if ( ccw->container.detail_count == 0 )
               ncw->container.tabs[0] = ncw->container.margin_w;
        }
    }

    /*
     * Rebuild heading, if necessary.
     */
    if ( ncw->container.detail_heading != ccw->container.detail_heading )
    {
        if ( ccw->container.detail_heading != NULL )
        {
            for ( i = 0; i < ccw->container.detail_count; i++ )
                _XmStringFree( ccw->container.detail_heading[i] );
            XtFree( (char*) ccw->container.detail_heading );
        }

        /* reset horizontal tabs array, to allow text to be
         * laid out correctly after heading change
         */
        for ( i = 0; i < ncw->container.detail_count; i++ )
        {
            ncw->container.tabs[i+1] = 0;
        }
        CreateDetailHeading( nw );
    }

    if ( ncw->container.selection_policy != ccw->container.selection_policy )
    {
        /* when we switch selection policy, if this results in a change
         * to border highlight style (solid/dashed), then unhighlight
         * and rehighlight the location cursor to show the new style.
         */
        Boolean kaddmode_change =
            ( ( CtrPolicyIsMULTIPLE( ncw )  ||
                CtrPolicyIsSINGLE( ncw ) )
              !=
              ( CtrPolicyIsMULTIPLE( ccw )  ||
                CtrPolicyIsSINGLE( ccw ) ) );

        if ( kaddmode_change )
        {
            /* unhighlight cursor using old kaddmode */
            if ( ncw->container.loc_cursor_cwid )
                BorderUnhighlight( nw );

            need_layout = True;    /* will highlight */
        }

        /* update kaddmode */
        ncw->container.kaddmode =
            ( CtrPolicyIsMULTIPLE( ncw )  ||  CtrPolicyIsSINGLE( ncw ) );
    }

    /*
     * Set internal variables that are based on resource values.
     */
    if ( ncw->container.margin_w != ccw->container.margin_w )
        ncw->container.heading_rect.x = ncw->container.margin_w;
    if ( ncw->container.margin_h != ccw->container.margin_h )
        ncw->container.heading_rect.y = ncw->container.margin_h;

#if AUTOPOSITION
    if ( ncw->container.resize_width != ccw->container.resize_width )
    {
        ncw->container.width_frozen = !ncw->container.resize_width;
        if ( ncw->container.resize_width == False )
            need_layout = True;
    }
#else
    if ( ncw->container.resize_width != ccw->container.resize_width )
        ncw->container.width_frozen = !ncw->container.resize_width;
#endif
    if ( ncw->container.resize_height != ccw->container.resize_height )
        ncw->container.height_frozen = !ncw->container.resize_height;

    if ( ncw->container.selection_technique !=
                                    ccw->container.selection_technique)
        ncw->container.marquee_mode =
                    ( CtrTechIsTOUCH_ONLY( ncw ) ? False : True );

    /* Perspectives  f7731
     *
     * Allocate or Free storage for lines and rectangles
     *  and copy storage for XmNlineSegents and XmNrectangles if needed.
     */
    if ( ncw->container.free_hand_seg_count !=
                                    ccw->container.free_hand_seg_count )
    {
        if ( ccw->container.free_hand_segs != NULL )
            XtFree( (char*) ccw->container.free_hand_segs );

        if ( ncw->container.free_hand_seg_count != 0 )
        {
            XSegment *from_segs = (XSegment*) ncw->container.free_hand_segs;
            XSegment *to_segs   = (XSegment*)
                XtMalloc( ncw->container.free_hand_seg_count * 
                            sizeof( XSegment ) );
            int n;
            for ( n = 0; n < ncw->container.free_hand_seg_count; n++ )
                to_segs[n] = from_segs[n];
            ncw->container.free_hand_segs = to_segs;
        }
        else /* ncw->container.free_hand_seg_count == 0 */
            ncw->container.free_hand_segs = NULL;

        need_layout = True;
    }

    if ( ncw->container.free_hand_rect_count !=
                                    ccw->container.free_hand_rect_count )
    {
        if ( ccw->container.free_hand_rects != NULL )
            XtFree( (char*) ccw->container.free_hand_rects );

        if ( ncw->container.free_hand_rect_count != 0 )
        {
            XRectangle *from_rects =
                          (XRectangle*) ncw->container.free_hand_rects;
            XRectangle *to_rects   = (XRectangle*)
                XtMalloc( ncw->container.free_hand_rect_count *
                            sizeof( XRectangle ) );
            int n;
            for ( n = 0; n < ncw->container.free_hand_rect_count; n++ )
                to_rects[n] = from_rects[n];
            ncw->container.free_hand_rects = to_rects;
        }
        else  /* ncw->container.free_hand_rect_count == 0 */
            ncw->container.free_hand_rects = NULL;

        need_layout = True;
    }
    /* end Perspectives */

    if ( need_layout )
    {
        Layout( nw );
        RequestNewSize( nw );
        need_expose = True;
    }
    return need_expose;
}

/************************************************************************
 * SVNeedLayout
 ************************************************************************/
static  Boolean
SVNeedLayout(
        Widget          cw,
        Widget          nw)
{
    XmContainerWidget       ccw = (XmContainerWidget) cw;
    XmContainerWidget       ncw = (XmContainerWidget) nw;

    if ( ncw->container.entry_viewtype != ccw->container.entry_viewtype )
        return True;

    if ( CtrViewIsDETAIL( ncw )  &&
         ( ( ncw->container.detail_heading != ccw->container.detail_heading )  ||
           ( ncw->container.detail_count != ccw->container.detail_count )  ||
           ( ncw->container.detail_sep_style != ccw->container.detail_sep_style )  ||
           ( ncw->container.render_table != ccw->container.render_table )  ||
           ( ncw->container.detailsViewLineSpacing != ccw->container.detailsViewLineSpacing )
         ) )
        return True;

    if ( ncw->container.layout_type != ccw->container.layout_type )
        return True;

    if ( CtrLayoutIsOUTLINE( ncw )  &&
         ( ( ncw->container.outline_indent != ccw->container.outline_indent )  ||
           ( ncw->container.outline_sep_style != ccw->container.outline_sep_style ) ) )
        return True;

    if ( ( ncw->container.margin_h != ccw->container.margin_h )  ||
         ( ncw->container.margin_w != ccw->container.margin_w )  ||
         ( ncw->container.layout_direction != ccw->container.layout_direction ) )
        return True;

    if ( CtrLayoutIsSPATIAL( ncw )  &&
         ( ( ncw->container.place_style != ccw->container.place_style )  ||
           ( ncw->container.orientation != ccw->container.orientation ) ) )
        return True;

    if ( ! CtrPlaceStyleIsNONE( ncw )  &&  CtrViewIsLARGEICON( ncw )  &&
         ( ( ncw->container.large_cell_height !=
                                  ccw->container.large_cell_height )  ||
           ( ncw->container.large_cell_width !=
                                  ccw->container.large_cell_width ) ) )
        return True;

    if ( ! CtrPlaceStyleIsNONE( ncw )  &&  CtrViewIsSMALLICON( ncw )  &&
         ( ( ncw->container.small_cell_height !=
                                  ccw->container.small_cell_height )  ||
           ( ncw->container.small_cell_width !=
                                  ccw->container.small_cell_width ) ) )
        return True;

    return False;
}

/************************************************************************
 * QueryGeometry
 ************************************************************************/
static  XtGeometryResult
QueryGeometry(
    Widget                  wid,
    XtWidgetGeometry        *intended,
    XtWidgetGeometry        *desired)
{
    XmContainerWidget       cw = (XmContainerWidget)wid;
    XtWidgetGeometry        geo_spatial;
    Dimension               parentWidth, parentHeight;

#ifdef  DEBUG
    printf( "cnr::QueryGeometry\n" );
    fflush( stdout );
#endif
    /*
     * Anything but Width & Height are fine.
     */
    if ( ! ( intended->request_mode & CWWidth )  &&
         ! ( intended->request_mode & CWHeight ) )
        return XtGeometryYes;
    /*
     * Are width & height frozen?  Then let's just return them and
     * avoid all the calculation.
     */
    if ( cw->container.width_frozen  &&  cw->container.height_frozen )
    {
        desired->width = cw->core.width;
        desired->height = cw->core.height;
        return XuiclReplyToQueryGeometry( wid, intended, desired );
    }
    if ( CtrViewIsDETAIL( cw )  ||  CtrLayoutIsOUTLINE( cw ) )
    {
        /*
         * Ideal width & height have already been calculated
         * by Layout().
         */
        desired->width = cw->container.ideal_width;
        desired->height = cw->container.ideal_height;
    }
    else
    {
        /*
         * Get width & height from class method.
         */

        /* ICLUI: fixed a real hummer of a bug here. Original code
         * was returning from QuerySpatialGeometry without setting
         * desired width and height. So you'd get whatever junk was
         * in the stack space for the passed in "desired" parameter.
         */
        ( *( xmContainerClassRec.container_class.query_spatial_geometry ) )
            ( wid, intended, &geo_spatial );
        desired->width = geo_spatial.width;
        desired->height = geo_spatial.height;
    }

#if !AUTOPOSITION
    if ( cw->container.width_frozen )
        desired->width = cw->core.width;
    if ( cw->container.height_frozen )
        desired->height = cw->core.height;
#endif
  return XuiclReplyToQueryGeometry( wid, intended, desired );
}


/*------------------
| Composite methods |
------------------*/
/************************************************************************
 * GeometryManager
 ************************************************************************/
static XtGeometryResult
GeometryManager(
    Widget                  instigator,
    XtWidgetGeometry       *desired,
    XtWidgetGeometry       *allowed)
{
    XmGadget          g  = (XmGadget)instigator;
    XmContainerWidget cw = (XmContainerWidget) XtParent( instigator );

#ifdef  DEBUG
    printf( "cnr::GeometryManager\n" );
    fflush( stdout );
#endif
    /*
     * pre-load x,y, width & height (same offsets for Widgets & Gadgets)
     */
    allowed->request_mode = 0;
    allowed->x = g->rectangle.x;
    allowed->y = g->rectangle.y;
    allowed->width = g->rectangle.width;
    allowed->height = g->rectangle.height;
    /* ICLUI: fix alert. In the following 2 tests the original widget code
            used && rather than &. Thus we got spurious True, and could
            set a value to garbage.
     */
    if ( desired->request_mode & CWWidth )
    {
        allowed->request_mode |= CWWidth;
        allowed->width = desired->width;
    }
    if ( desired->request_mode & CWHeight )
    {
        allowed->request_mode |= CWHeight;
        allowed->height = desired->height;
    }

    /* f7351
     * for Spatial layout with place_style XmNONE, allow x and/or y
     * to be modified.
     */
    if ( ( cw->container.place_style == XmNONE )  &&
         ( ! CtrViewIsDETAIL( cw ) )  ||  ( ! CtrLayoutIsOUTLINE( cw ) ) )
    {
        if ( desired->request_mode & CWX )
        {
            allowed->request_mode |= CWX;
            allowed->x = desired->x;
        }
        if ( desired->request_mode & CWY )
        {
            allowed->request_mode |= CWY;
            allowed->y = desired->y;
        }
    }

    if ( allowed->request_mode != 0 )
    {
        Widget cnr = XtParent( instigator );
        _XmConfigureObject( instigator, allowed->x, allowed->y,
                            allowed->width, allowed->height, 0 );

        /* ICLUI: As a performance improvement, skip updating the
         *        layout of the icon gadgets during a view switch
         *        until the switch is complete. The flag,
         *        XmContainerPart::viewChangeInProgress, is set
         *        in ChangeView.
         */
        if ( ! cw->container.viewChangeInProgress )
        {
            /* ICLUI: since we now support changing Icons or Icon text
             *        we need to Layout based on the new size of this
             *        IconGadget.
             *        In GRID spatial layout also need to recompute
             *        cell sizes.
             */
            if ( CtrPlaceStyleIsGRID( cnr ) )
            {
                PlaceItemReset( cnr );
                InvalidateAllCells( (XmContainerWidget) cnr );
            }

            Layout( cnr );
            RequestNewSize( cnr );
        }

        return XtGeometryDone;
    }
    else
        return XtGeometryNo;
}

/************************************************************************
 * ChangeManaged
 ************************************************************************/
static void
ChangeManaged(
    Widget  wid)
{
    XmContainerWidget     cw = (XmContainerWidget) wid;
    Boolean               changes = False;
    int                   i;
    Widget                cwid;
    XmContainerConstraint c;
    CwidNode              node;
    XtWidgetGeometry      geo_current;
    XtWidgetGeometry      geo_desired;
    XtGeometryResult      geo_response = XtGeometryYes;
    XtGeometryResult      pwid_geo_response = XtGeometryYes;
    Boolean               forceItemReset = False;

#ifdef  DEBUG
    printf( "cnr::ChangeManaged\n" );
    fflush( stdout );
#endif
    for ( i = 0; i < cw->composite.num_children; i++ )
    {
        cwid = cw->composite.children[i];
        c = GetContainerConstraint( cwid );
        if ( c->was_managed != XtIsManaged( cwid ) )
        {
            c->was_managed = XtIsManaged( cwid );
            /*
             * A cwid's been changed, does it affect Layout?
             */
            if ( c->container_created )
            {
                /* ICLUI:
                 * If an outline button is being Unmanaged it's probably
                 * because the IconGadget it was associated with was
                 * destroyed and called XtDestroyWidget for the outline
                 * button. In this case we then come in here with
                 * node->widget_ptr holding the address of the destroyed
                 * IconGadget. So avoid even looking at node->widget_ptr
                 * if the button is being unmanaged and just set changes true.
                 */
                if ( ! c->was_managed )
                    changes = True;
                else
                {
                    /*
                     * Is it a new OutlineButton attached to
                     * a visible item?
                     */
                    node = c->node_ptr;
                    if ( node  &&  node->widget_ptr )
                    {
                        c = GetContainerConstraint( node->widget_ptr );
                        if ( c  &&  c->visible_in_outline )
                            changes = True;
                    }
                }
            }
            else
            {
                /* not an OutlineButton, must be a cwid */
                if ( XtIsManaged( cwid )  &&
                     CtrLayoutIsOUTLINE( wid )  &&
                     ( ! c->visible_in_outline ) )
                    /*
                     * Don't let newly managed children
                     * pop up in Outline if they're
                     * supposed to be hidden.
                     */
                    HideCwid( cwid );

                if ( ( c->entry_parent == NULL )  ||
                     ( c->visible_in_outline  &&  CtrLayoutIsOUTLINE( wid ) ) )
                    /*
                     * It's a child that should be shown
                     * or removed; Layout is affected.
                     */
                    changes = True;

                if ( XtIsManaged( cwid ) )
                {
                    /*
                     * Put it into the linked
                     * list of nodes.
                     */
                    InsertNode( c->node_ptr );

                    /* Layout() will call the "place-item"
                     * method to position it later, but first check
                     * whether the cell size fits. If not set
                     * forceItemReset = True to force PlaceItemReset to
                     * occur when items are placed.
                     */
                    if ( CtrPlaceStyleIsGRID( cw )  ||
                         CtrPlaceStyleIsCELLS( cw ) )
                    {
                        int cell_width = ( CtrViewIsLARGEICON( cw ) ) ?
                             cw->container.large_cell_width :
                             cw->container.small_cell_width;
                        int cell_height = ( CtrViewIsLARGEICON( cw ) ) ?
                             cw->container.large_cell_height :
                             cw->container.small_cell_height;

                        if ( ( cwid->core.width  > cell_width )  ||
                             ( cwid->core.height > cell_height ) )
                            forceItemReset = True;
                    }

                    /* After node inserted, if its the first one,
                     * set loc_cursor_cwid if necessary
                     */
                    if ( cw->container.first_node->widget_ptr == cwid  &&
                         cw->container.loc_cursor_cwid == NULL )
                    {
                        /* cw->container.loc_cursor_cwid = cwid; */
                        SetLocationCursor( (Widget) cw, cwid );
                    }

                    if ( c->selection_visual == XmSELECTED )
                    {
                       /* Managing a selected object results from an object
                        * created already selected, or selecting an object
                        * before it is shown.
                        * Managing a selected object requires that
                        * we add this object to the list of selected
                        * items maintained by ICnrHandler.
                        * ICnrHandler does NOT invoke handleSelectedChange
                        * for this item as it is not a change of emphasis,
                        * but a new item that already has emphasis.
                        */
                       ModifySelectedChange( wid, cwid, True ); /* add == True */
                    }
                }
                else
                {
                    /*
                     * Remove it from the linked
                     * list of nodes.  And remove
                     * it from any Spatial layout
                     * representation.
                     */
                    SeverNode( c->node_ptr );
                    ( *( xmContainerClassRec.container_class.remove_item ) )
                           ( wid,cwid );

                    /* For items that are possibly being hidden,
                     * force recalculation of new cell width and height.
                     */
                    if ( CtrLayoutIsSPATIAL( wid ) )
                    {
                        cw->container.current_height_in_cells = 0;
                        cw->container.current_width_in_cells = 0;
                    }

                    /* Reset location cursor if necessary
                     */
                    if ( cwid == cw->container.loc_cursor_cwid )
                        /* cw->container.loc_cursor_cwid = NULL; */
                        SetLocationCursor( (Widget) cw, NULL ); 

                    /* d4706 unmanaging object in outline view with
                     * visible lines requires the window to be cleared to
                     * clear the lines.
                     */

                    if ( XtIsRealized( cwid )  &&  CtrDrawLinesOUTLINE( cw ) )
                        XClearArea( XtDisplay( cwid ),
                                    XtWindow( cwid ), 0, 0, 0, 0, True );
                }
            }
        }
    }

    if ( changes  &&
         ( CtrLayoutIsOUTLINE( cw )  ||  CtrViewIsDETAIL( cw ) ) )
    {
        /*
         * Call Layout() for one-dimensional
         * layout types so ideal_width/height are updated before
         * the call to QueryGeometry() routine.
         */
        Layout( wid );
        /* ICLUI: added XClearArea so details view heading refreshed
         *        to be wider if needed.
         */
        if ( CtrViewIsDETAIL( cw )  &&  XtIsRealized( wid ) )
        {
            XClearArea( XtDisplay( wid ),
                        XtWindow( wid ), 0, 0, 0, 0, True );
        }
     }

    /*
     * SetCellSizes if we need to.
     * ICLUI: defect 1156 had just been using !XtIsRealized() as
     * way of determining if this was the first ChangeManaged call.
     * Showing the parent IFrameWindow before adding the first object
     * would make us miss a much needed call to SetCellSize.
     */
    /* Also, defect 4271 resulted from cell_width, cell_height == 0 in
     * LayoutSpatial, when abjects are added to an empty container
     * with refresh turned off. Make sure SetCellSize if called.
     */

    if ( CtrPlaceStyleIsGRID( cw )  ||  CtrPlaceStyleIsCELLS( cw ) )
    {
        int cell_width = ( CtrViewIsLARGEICON( cw ) ) ?
              cw->container.large_cell_width : cw->container.small_cell_width;
        int cell_height = ( CtrViewIsLARGEICON( cw ) ) ?
              cw->container.large_cell_height : cw->container.small_cell_height;

        if ( cell_width == 0  ||  cell_height == 0 )
            SetCellSize( wid );

        /* Also, if larger size item is newly managed, it might not have
         * PlaceItemReset called if it does not extend a curret row or column.
         * Even if it does extend a row or column, SetCellSize needs to be
         * called BEFORE PlaceItemReset to calc width(height)_in_cells
         * correctly.
         */
        if ( forceItemReset == True )
        {
            cw->container.current_width_in_cells = 0; /* to force PlaceItemReset */
            cw->container.current_height_in_cells = 0;
            SetCellSize( wid );                       /* cell is larger */
        }
    }

    if ( changes )
    {
        geo_current.request_mode = CWWidth | CWHeight;
        geo_current.width = cw->core.width;
        geo_current.height = cw->core.height;
        geo_response = ( *( xmContainerClassRec.core_class.query_geometry ) )
                              ( wid, &geo_current, &geo_desired );
#ifdef  DEBUG
        printf( "returned width  = %d\n", geo_desired.width );
        printf( "returned height = %d\n", geo_desired.height );
        fflush( stdout );
#endif
        if ( geo_response != XtGeometryYes )
            pwid_geo_response = _XmMakeGeometryRequest( wid, &geo_desired );
#ifdef  DEBUG
        if ( geo_response != XtGeometryYes )
        {
            if ( pwid_geo_response == XtGeometryYes )
                printf( "_XmMakeGeometryRequest returned XtGeometryYes\n" );
            else
                printf( "_XmMakeGeometryRequest returned XtGeometryNo\n" );
            fflush( stdout );
        }
#endif
    }

    /*
     * If it's the first time through ChangeManaged,
     * and XmNresizeWidth/Height is set to False,
     * and the width/height wasn't specified and frozen
     *  at Initialize() time, then freeze it now.
     */
    if ( cw->container.firstChangeManaged )
    {
        if ( ( ! cw->container.width_frozen )  &&
             ( ! cw->container.resize_width ) )
            cw->container.width_frozen = True;
        if ( ( ! cw->container.height_frozen )  &&
             ( ! cw->container.resize_height ) )
            cw->container.height_frozen = True;

        /*
         * Set the first item as the "keyboard focus".
         */
        /* ICLUI: protect against bogus loc_cursor_cwid value */
        if ( cw->container.first_node )
            /* cw->container.loc_cursor_cwid = cw->container.first_node->widget_ptr; */
            SetLocationCursor( (Widget) cw,
                               cw->container.first_node->widget_ptr );
        else
            /* cw->container.loc_cursor_cwid = NULL; */
            SetLocationCursor( (Widget) cw, NULL ); 

        cw->container.firstChangeManaged = False;
    }

    /*
     * No changes, no new Layout() required.
     */
    if ( ! changes )
        return;

    /*
     * The one-dimensional layouts are oblivious to any size constraints
     * in the Left-to-Right layout direction.
     *  One-dimensional Right-to_Left layouts are sensitive to width changes.
     */
    if ( CtrViewIsDETAIL( cw )  ||  CtrLayoutIsOUTLINE( cw ) )
    {
        if ( CtrLayoutIsLtoR( cw )  ||
             ( cw->core.width == cw->container.prev_width ) )
        {
            return;
        }
        cw->container.prev_width = cw->core.width;
    }

    /*
     * There are changes that affect layout, so do it.  But, don't request
     * a resize - _XmMakeGeometryRequest said no above and we've been
     * synchronous since then, so it will just say no again.
     */
    Layout( wid );
}

/*-------------------
| Constraint methods |
-------------------*/
/************************************************************************
 * ConstraintInitialize
 ************************************************************************/
static void
ConstraintInitialize(
    Widget          rcwid,          /* unused */
    Widget          ncwid,
    ArgList         args,           /* unused */
    Cardinal       *num_args)       /* unused */
{
    XmContainerWidget      cw = (XmContainerWidget) XtParent( ncwid );
    XmContainerConstraint  nc = GetContainerConstraint( ncwid );
    XmContainerConstraint  pc;     /* parent's constraints */

    nc->container_created = cw->container.self;
    if ( nc->container_created )
        return;

    /*
     * validate resource values
     */
    if ( ! XmRepTypeValidValue( XmRID_OUTLINE_STATE,
                                nc->outline_state,ncwid ) )
        nc->outline_state = XmCOLLAPSED;
    if ( nc->position_index != UNSPECIFIED_POSITION_INDEX )
        nc->position_index = MAX( 0, nc->position_index );

    /*
     * Create new node for child - ChangeManaged will insert into list.
     */
    NewNode( ncwid );

#ifdef  COSEICON
    nc->selection_visual = ( DtIconGetState( ncwid ) ) ?
                               XmSELECTED : XmNOT_SELECTED;
#else
    nc->selection_visual = XmNOT_SELECTED;
    XtVaGetValues( ncwid, XmNvisualEmphasis, &nc->selection_visual, NULL );
#endif  /* COSEICON */
    if ( nc->selection_visual == XmSELECTED )
    {
        if ( cw->container.anchor_cwid == NULL )
            cw->container.anchor_cwid = ncwid;
        cw->container.selected_item_count++;
    }

    nc->selection_state = nc->selection_visual;
    nc->outline_button = NULL;
    if ( nc->entry_parent != NULL )
    {
        pc = GetContainerConstraint( nc->entry_parent );
        nc->depth = pc->depth + 1;
        cw->container.max_depth = MAX( cw->container.max_depth,
                                       nc->depth );
        if ( pc->outline_state == XmEXPANDED )
            nc->visible_in_outline = True;
        else
            nc->visible_in_outline = False;
        if ( ( CwidIsHidden( nc->entry_parent ) )  ||
             ( ! CtrLayoutIsOUTLINE( cw ) ) )
            HideCwid( ncwid );
        /*
         * Check to see if we've created a new parent
         */
        if ( pc->outline_button == NULL )
        {
            MakeOutlineButton(nc->entry_parent);
            if ( CwidIsHidden( ncwid )  ||
                 ( ! CtrLayoutIsOUTLINE( cw ) ) )
                HideCwid( pc->outline_button );
        }
    }
    else
    {
        nc->visible_in_outline = True;
        nc->depth = 0;
    }
    nc->outline_button = NULL;
    nc->was_managed = False;

    CreateEntryDetail( ncwid );

    /*
     * Initialize variables used by
     *      Container SpatialLayout methods.
     */
    nc->cell_idx = NO_CELL;
}

/************************************************************************
 * ConstraintDestroy
 ************************************************************************/
static  void
ConstraintDestroy(
    Widget  cwid)
{
    XmContainerWidget      cw = (XmContainerWidget) XtParent( cwid );
    XmContainerConstraint  c = GetContainerConstraint( cwid );

    if ( cwid == cw->container.loc_cursor_cwid )
        /* cw->container.loc_cursor_cwid = NULL; */
        SetLocationCursor( (Widget) cw, NULL ); 
    if ( cwid == cw->container.anchor_cwid )
        cw->container.anchor_cwid = NULL;
    if ( c->container_created )
        return;

    DeleteNode( cwid );
    if ( c->entry_detail != NULL )
    {
        int     i;

        for ( i = 0; i < c->entry_detail_count; i++ )
            _XmStringFree( c->entry_detail[i] );
        XtFree( (char*) c->entry_detail );
    }
    if ( c->selection_state == XmSELECTED )
    {
        unsigned char   save_state = cw->container.selection_state;

        cw->container.selection_state = XmNOT_SELECTED;
        MarkCwid( cwid, False );
        cw->container.selection_state = save_state;
    }

    /* d6246 (Tree Expand button NOT attached to a IContainerObject)
     * delete outline button if not already deleted.
     */
    if ( c->outline_button != NULL  &&
         ( ! c->outline_button->core.being_destroyed ) )
    {
        XtDestroyWidget( c->outline_button );
    }
}

/************************************************************************
 * ConstraintSetValues
 ************************************************************************/
static Boolean
ConstraintSetValues(
    Widget          ccwid,
    Widget          rcwid,          /* unused */
    Widget          ncwid,
    ArgList         args,           /* unused */
    Cardinal       *num_args)       /* unused */
{
    XmContainerWidget      cw = (XmContainerWidget) XtParent( ncwid );
    XmContainerConstraint  cc = GetContainerConstraint( ccwid );
    XmContainerConstraint  nc = GetContainerConstraint( ncwid );
    XmContainerConstraint  pc;     /* Parent's Contraints */
    Boolean                need_layout = False;
    Boolean                need_expose = False;

    if ( cw->container.self )
        return False;
    if ( nc->container_created )
        return False;

#ifdef  DEBUG
    printf( "cnr::ConstraintSetValues\n" );
    fflush( stdout );
#endif

    /*
     * Validate resource values
     */
    if ( ! XmRepTypeValidValue( XmRID_OUTLINE_STATE,
                                nc->outline_state,ncwid ) )
        nc->outline_state = cc->outline_state;
    if ( nc->position_index < 0 )
        nc->position_index = cc->position_index;

    /*
     * Check if layout required.
     * ICLUI: added check for managed. If setRefreshOff() was done
     *        we'll be doing XtVaSetValues for IconGadgets that were
     *        created Unmanaged. No need for Layout in this case, in fact
     *        found a strange problem where calling Layout and outputting
     *        its DEBUG traces would hang an X-Server!!!
     *        Not sure what that was all about.
     */
    if ( XtIsManaged( ncwid ) )
    {
        if ( nc->position_index != cc->position_index )
            need_layout = True;
        if ( CtrViewIsDETAIL( cw )  &&
             ( nc->entry_detail != cc->entry_detail ) )
            need_layout = True;
        if ( CtrLayoutIsOUTLINE( cw )  &&
             ( ( nc->entry_parent != cc->entry_parent )  ||
               ( nc->outline_state != cc->outline_state ) ) )
            need_layout = True;

        /* When updating entry_detail in outline view
         * under certain circumstances,
         * eg after font change or when entry_detail
         * nunber-of-lines change, the old tree lines
         * need to be erased before the new ones are
         * drawn, as the horizontal tree line positions
         * are different. There is no method to do this
         * so clear the widget area.
         */
        if ( CtrDrawLinesOUTLINE( cw )  &&
             ( nc->entry_detail != cc->entry_detail ) )
        {
            need_layout = True;
            if ( XtIsRealized( (Widget) cw ) )
            {
                XClearArea( XtDisplay( (Widget) cw ),
                            XtWindow( (Widget) cw ), 0, 0, 0, 0, True );
            }
        }
    }

    /*
     * Check for change in selection status
     */
#ifdef  COSEICON
    nc->selection_visual = ( DtIconGetState( ncwid ) ) ?
            XmSELECTED : XmNOT_SELECTED;
#else
    XtVaGetValues( ncwid, XmNvisualEmphasis, &nc->selection_visual, NULL );
#endif  /* COSEICON */
    if ( nc->selection_visual != cc->selection_visual )
    {
        if ( nc->selection_visual == XmSELECTED )
        {
            cw->container.selected_item_count++;
            if ( cw->container.anchor_cwid == NULL )
                cw->container.anchor_cwid = ncwid;

            if ( CtrPolicyIsSINGLE ( cw ) )
            {
                WidgetList wlist = GetSelectedCwids( (Widget) cw );
                if ( wlist )
                {  /*
                    * Deselect the previously selected container objects.
                    */
                   int selected_item_count =
                               cw->container.selected_item_count;
                   Widget lcw;
                   XmContainerConstraint lcc;
                   int i;
                   for ( i = 0; i < selected_item_count; i++ )
                   {
                       lcw = wlist[i];
                       lcc = GetContainerConstraint( lcw );
   
                       /* deselect all except yourself */
                       if ( lcw != ncwid )
                       {
                           XtVaSetValues( lcw, XmNvisualEmphasis,
                                          XmNOT_SELECTED, NULL );
                       }
                   }
                   XtFree( (char*) wlist );
                }

                /* set new loc_cursor */
                SetLocationCursor( (Widget) cw, ncwid );
                /* 
                if ( cw->container.loc_cursor_cwid )
                {
                    BorderUnhighlight(
                        cw->container.loc_cursor_cwid );
                }
                cw->container.loc_cursor_cwid = ncwid;
                */
            }
        }
        else     /* XmNOT_SELECTED */
        {
            cw->container.selected_item_count--;
        }
        nc->selection_state = nc->selection_visual;

        /* Perform handleSelected callback.
         * Synthesize a Selection event and call callbacks.
         */

        if ( cw->container.severing_node )
        {
            if ( cc->selection_visual == XmSELECTED )
            {
               /* If we are severing a previously selected object,
                * we need to remove it from the list of selected
                * items maintained by ICnrHandler.
                * ICnrHandler does NOT invoke handleSelectedChange
                * for this item as it is not a change of emphasis,
                * but an item that is being removed
                */
               ModifySelectedChange( XtParent( ncwid ), ncwid,
                                     False ); /* add == False */
            }
        }
        else  /* !cw->container.severing_node */
        {
            if ( XtIsRealized( XtParent( ncwid ) )  &&
                 XtIsManaged( ncwid ) )
            {
                XEvent event; /* dummy event for callback */
                CallSelectCB( (Widget) cw, &event, XmAUTO_UNSET );
            }
        }

        /* ICLUI: hack to get all detail columns in right
         *        selection state.
         */
        if ( CtrViewIsDETAIL( cw ) )
            ExposeDetail( ncwid );
    }

    /*
     * Changes in parentage or position.
     * If XmNpositionIndex has changed, but the "node" has no siblings,
     *      then there's no need to change the node's position in the
     *      linked list.
     */
    if ( ( nc->entry_parent != cc->entry_parent )  ||
         ( ( nc->position_index != cc->position_index )  &&
           ( ( nc->node_ptr->prev_ptr != NULL )  ||
             ( nc->node_ptr->next_ptr != NULL ) ) ) )
    {
        SeverNode( nc->node_ptr );
        InsertNode( nc->node_ptr );
    }
    if ( nc->entry_parent != cc->entry_parent )
    {
        if ( nc->entry_parent == NULL )
        {
            nc->depth = 0;
            nc->visible_in_outline = True;
        }
        else
        {
            pc = GetContainerConstraint( nc->entry_parent );
            nc->depth = pc->depth +1;
            cw->container.max_depth = MAX( cw->container.max_depth,
                                           nc->depth );
            if ( pc->outline_state == XmEXPANDED )
                nc->visible_in_outline = True;
            else
                nc->visible_in_outline = False;
            if ( ( CwidIsHidden( nc->entry_parent ) )  ||
                 ( ! CtrLayoutIsOUTLINE( cw ) ) )
                HideCwid( ncwid );
            /*
             * Check to see if we've created a new parent
             */
            if ( pc->outline_button == NULL )
            {
                MakeOutlineButton(nc->entry_parent);
                if ( ( CwidIsHidden( ncwid ) )  ||
                     ( ! CtrLayoutIsOUTLINE( cw ) ) )
                    HideCwid( pc->outline_button );
            }
        }
    }

    /*
     * Change in entry_detail
     */
    if ( nc->entry_detail != cc->entry_detail )
    {
        /* Note: we don't need to call ResetTabs here
         * since all we are doing is freeing storage.
         * CreateEntryDetail will set the tabs array
         */
        if ( cc->entry_detail != NULL )
        {
            int     i;

            for ( i = 0; i < cc->entry_detail_count; i++ )
                _XmStringFree( cc->entry_detail[i] );
            XtFree( (char*) cc->entry_detail );
        }
        CreateEntryDetail( ncwid );
    }

    /*
     * Change Spatial locations.  May need a new Layout if
     *      items can't be placed.
     */
    if ( ( CtrViewIsLARGEICON( cw )  &&
           ( ( nc->large_icon_x != cc->large_icon_x )  ||
             ( nc->large_icon_y != cc->large_icon_y ) ) )
            ||
         ( CtrViewIsSMALLICON( cw )  &&
           ( ( nc->small_icon_x != cc->small_icon_x ) ||
             ( nc->small_icon_y != cc->small_icon_y ) ) ) )
        ( *( xmContainerClassRec.container_class.remove_item ) )
                ( (Widget) cw, ncwid );

    /* ICLUI: added XtIsManaged check for same reason as above */
    if ( CtrLayoutIsSPATIAL( cw )  &&  XtIsManaged( ncwid )  &&
         ( ( nc->large_icon_x != cc->large_icon_x )  ||
           ( nc->large_icon_y != cc->large_icon_y )  ||
           ( nc->small_icon_x != cc->small_icon_x )  ||
           ( nc->small_icon_y != cc->small_icon_y ) ) )
    {
        need_layout &=
          ! ( *( xmContainerClassRec.container_class.place_item ) )
                    ( (Widget) cw, ncwid );
    }

    if ( need_layout )
    {
        Layout( (Widget) cw );
        RequestNewSize( (Widget) cw );
        need_expose = True;
    }
    return need_expose;
}

/*----------------
| Manager methods |
----------------*/
        /* None */
/*------------------
| Container methods |
------------------*/
/************************************************************************
 * TestFitItem
 ************************************************************************/
static  Boolean
TestFitItem(
    Widget      wid,
    Widget      cwid,
    Position    x,
    Position    y)
{
    XmContainerWidget   cw = (XmContainerWidget)wid;
    int trial_cell;

#ifdef  DEBUG
    printf( "cnr::TestFitItem\n" );
    fflush( stdout );
#endif  /* DEBUG */
    /*
     * Must be a 2-D layout.
     */
    if ( CtrViewIsDETAIL( cw )  ||  CtrLayoutIsOUTLINE( cw ) )
        return True;
    if ( ( x < (Position) cw->container.margin_w )  ||
         ( y < (Position) cw->container.margin_h )  ||
         ( x > (Position) ( cw->core.width - cw->container.margin_w ) )  ||
         ( y > (Position) ( cw->core.height - cw->container.margin_h ) ) )
        return False;

    if ( CtrPlaceStyleIsGRID( cw )  ||  CtrPlaceStyleIsCELLS( cw ) )
    {
        trial_cell = GetCellFromCoord( wid, x - cw->container.margin_w,
                                       y - cw->container.margin_h );
#ifdef  DEBUG
        printf( "trial_cell is %d\n", trial_cell );
        fflush( stdout );
#endif  /* DEBUG */

        if ( cw->container.cells[trial_cell] != NULL )
            return False;
    }
    return True;
}

/************************************************************************
 * PlaceItem
 ************************************************************************/
static  Boolean
PlaceItem(
    Widget      wid,
    Widget      cwid)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;

#ifdef DEBUG
    printf( "cnr::PlaceItem\n" );
    fflush( stdout );
#endif
    /*
     * No-op if not Spatial layout.
     */
    if ( CtrViewIsDETAIL( cw )  ||  CtrLayoutIsOUTLINE( cw ) )
        return True;

    if ( cwid == NULL )
    {
        PlaceItemReset( wid );
        InvalidateAllCells( cw );                        // ICLUI
        return True;
    }

    if ( CtrItemIsPlaced( cwid ) )
        return True;

    switch ( cw->container.place_style )
    {
        case XmNONE:
            PlaceItemNone( wid, cwid );
            break;
        case XmGRID:
            PlaceItemGrid( wid, cwid );
            break;
        case XmCELLS:
            PlaceItemCells( wid, cwid );
            break;
        default:
            break;
    }
    if ( ! CtrItemIsPlaced( cwid ) )
        HideCwid( cwid );
    return CtrItemIsPlaced( cwid );
}

/************************************************************************
 * RemoveItem
 ************************************************************************/
static  Boolean
RemoveItem(
    Widget          wid,
    Widget          cwid)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    XmContainerConstraint c = GetContainerConstraint( cwid );

    if ( ! CtrItemIsPlaced( cwid ) )
        return True;
    switch ( cw->container.place_style )
    {
        case XmCELLS:
        case XmGRID:
        {
            int cellIndex = c->cell_idx;
            cw->container.cells[ cellIndex ] = 0;

            // ICLUI: Update first_free_cell and last_used_cell to
            //        allow for performance short cuts in PlaceItemGrid
            //        and PlaceItemReset.
            if ( cellIndex < cw->container.first_free_cell )
            {
               cw->container.first_free_cell = cellIndex;
            }
            if ( cellIndex  &&  cellIndex == cw->container.last_used_cell )
            {
               cw->container.last_used_cell = cellIndex - 1;
            }
        }
           // Fall through to case below.
        case XmNONE:
            c->cell_idx = NO_CELL;
            break;
        default:
            break;
    }
    return True;
}

/************************************************************************
 * QuerySpatialGeometry
 ************************************************************************/
static  XtGeometryResult
QuerySpatialGeometry(
    Widget              wid,
    XtWidgetGeometry   *intended,      /* unused */
    XtWidgetGeometry   *desired)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    CwidNode            node;
    XmContainerConstraint c;
    XPoint              spot;
    Dimension           trial_width = 0,
                        trial_height = 0;
    Dimension           cell_width = 0,
                        cell_height = 0;
    int                 width_in_cells = 1,
                        height_in_cells = 1;
    int                 min_width_in_cells = 1,
                        min_height_in_cells = 1;
    int                 cwid_width_in_cells,
                        cwid_height_in_cells;
    int                 cell_count = 0;
    Dimension           marginless_width,
                        marginless_height;
    XtGeometryResult    answer;
#if DETECT_OVERFLOW
    Boolean             overflow_detection_enabled =
                            cw->container.overflow_callbacks ? True : False;
#endif

#ifdef  DEBUG
    printf( "cnr::QuerySpatialGeometry\n" );
    fflush( stdout );
#endif  /* DEBUG */

    desired->request_mode = CWWidth & CWHeight;
    desired->width = desired->height = 0;
    if ( CtrPlaceStyleIsGRID( cw )  ||  CtrPlaceStyleIsCELLS( cw ) )
    {
        if ( CtrViewIsLARGEICON( cw ) )
        {
            cell_width = cw->container.large_cell_width;
            cell_height = cw->container.large_cell_height;
        }
        else
        {
            cell_width = cw->container.small_cell_width;
            cell_height = cw->container.small_cell_height;
        }
    }

    /*
     * Go through the linked list of cwids ands let determine
     * their geometry needs.
     */
    node = cw->container.first_node;
    while ( node != NULL )
    {
        if ( CtrPlaceStyleIsNONE( cw )  ||  CtrIncludeIsCLOSEST( cw ) )
        {
            /*
             * In this case, we care about the desired x,y coordinates of
             * each child, so let's compute the smallest rectangle that
             * would contain all of them and still fulfill their desires:
             *     (trial_width X trial_height)
             */
            if ( CtrItemIsPlaced( node->widget_ptr ) )
            {
                spot.x = ( (Widget) node->widget_ptr )->core.x;
                spot.y = ( (Widget) node->widget_ptr )->core.y;
            }
            else
            {
                c = GetContainerConstraint( node->widget_ptr );
                if ( CtrViewIsLARGEICON( cw ) )
                {
                    // Both tree view and icon view use the large icon
                    // setting. They can't share coordinates, so we have
                    // to check for tree view (OUTLINE) and use
                    // large_icon_x,y or icon_view_x,y.  LJO
                    if ( CtrLayoutIsOUTLINE( cw ) )                            /* LJO */
                    {                                                          /* LJO */
                        spot.x = (c->large_icon_x == XmUNSPECIFIED_POSITION) ? /* LJO */
                                    0 : c->large_icon_x;                       /* LJO */
                        spot.y = (c->large_icon_y == XmUNSPECIFIED_POSITION) ? /* LJO */
                                    0 : c->large_icon_y;                       /* LJO */
                    }                                                          /* LJO */
                    else                                                       /* LJO */
                    {                                                          /* LJO */
                        spot.x = (c->icon_view_x == XmUNSPECIFIED_POSITION) ?  /* LJO */
                                    0 : c->icon_view_x;                        /* LJO */
                        spot.y = (c->icon_view_y == XmUNSPECIFIED_POSITION) ?  /* LJO */
                                    0 : c->icon_view_y;                        /* LJO */
                    }                                                          /* LJO */
                }
                else
                {
                    spot.x = ( c->small_icon_x == XmUNSPECIFIED_POSITION ) ?
                                  0 : c->small_icon_x;
                    spot.y = ( c->small_icon_y == XmUNSPECIFIED_POSITION ) ?
                                  0 : c->small_icon_y;
                }
                spot.x += cw->container.margin_w;
                spot.y += cw->container.margin_h;
            }
            trial_width = MAX( trial_width,
                               spot.x +
                                  ((Widget)node->widget_ptr)->core.width );
            trial_height = MAX( trial_height,
                               spot.y +
                                  ((Widget)node->widget_ptr)->core.height );
        }

        node = GetNextNode( wid, node );
        if ( CtrPlaceStyleIsGRID( cw ) )
        {
            /*
             * CtrPlaceStyleIsGRID: One cell per cwid
             */
            cell_count++;
        }
        if ( CtrPlaceStyleIsCELLS( cw ) )
        {
            /*
             * CtrPlaceStyleIsCELLS: Need enough cells to completely
             *                              contain all cwids.
             */
            cwid_width_in_cells = ((Widget)node->widget_ptr)->core.width
                                     / cell_width;
            if ( ((Widget)node->widget_ptr)->core.width % cell_width )
                cwid_width_in_cells++;
            min_width_in_cells = MAX( min_width_in_cells,
                                      cwid_width_in_cells );
            cwid_height_in_cells = ((Widget)node->widget_ptr)->core.height
                                      / cell_height;
            if ( ((Widget)node->widget_ptr)->core.height % cell_height )
                cwid_height_in_cells++;
            min_height_in_cells = MAX( min_height_in_cells,
                                       cwid_height_in_cells );
            cell_count += cwid_width_in_cells + cwid_height_in_cells;
        }
    }

    if ( CtrPlaceStyleIsNONE( cw )  ||  CtrIncludeIsCLOSEST( cw ) )
    {
        trial_width += cw->container.margin_w;
        trial_height += cw->container.margin_h;
    }
    if ( CtrPlaceStyleIsNONE( cw ) )
    {
        desired->width = trial_width;
        desired->height = trial_height;
    }
    else        /* CtrPlaceStyleIsGRID || CtrPlaceStyleIsCELLS */
    {
        /*
         * Note: Either Width or Height might be fixed by the user.  If both
         * were fixed, then QueryGeometry would not have invoked us.
         */
        if ( cw->container.width_frozen )
        {
            /*
             * Width is fixed.  So, how much height do we need?
             */
            marginless_width = cw->core.width - 2 * cw->container.margin_w;
            width_in_cells = marginless_width / cell_width;
#if AUTOPOSITION
            if ( width_in_cells == 0 )
                width_in_cells = 1;
#else
            if ( marginless_width % cell_width )
                width_in_cells++;
#endif
            height_in_cells = cell_count / width_in_cells;
            if ( cell_count % width_in_cells )
                height_in_cells++;
        }

        if ( cw->container.height_frozen )
        {
            /*
             * Height is fixed.  So, how much width do we need?
             */
            marginless_height = cw->core.height - 2 * cw->container.margin_h;
            height_in_cells = marginless_height / cell_height;
#if AUTOPOSITION
            if ( height_in_cells == 0 )
                height_in_cells = 1;
#else
            if ( marginless_height % cell_height )
                height_in_cells++;
#endif
            width_in_cells = cell_count / height_in_cells;
            if ( cell_count % height_in_cells )
                width_in_cells++;
        }

        if ( ! cw->container.width_frozen  &&
             ! cw->container.height_frozen )
        {
            /*
             * Nothing frozen.  Simple square will do.
             */
#if DETECT_OVERFLOW
            width_in_cells = Isqrt( cell_count );
            if ( width_in_cells * cell_width >
                    MAX_SHORT - 2*cw->container.margin_w )
            {
                width_in_cells = MAX_SHORT / cell_width;
            }
            height_in_cells = ( cell_count / width_in_cells );
            if ( cell_count % width_in_cells )
                height_in_cells++;
#else
            width_in_cells = Isqrt( cell_count );
            height_in_cells = width_in_cells;
#endif
        }

        if ( CtrPlaceStyleIsCELLS( cw ) )
        {
            /*
             * Make adjustments to accomodate very wide or tall cwids.
             */
            width_in_cells = MAX( width_in_cells, min_width_in_cells );
            height_in_cells = MAX( height_in_cells, min_height_in_cells );
        }

        /*
         * Add in the margins and calculate the pixels needed.
         */
#if DETECT_OVERFLOW
        if ( overflow_detection_enabled )
        {
            long long_w = width_in_cells * cell_width
                                    + 2 * cw->container.margin_w;
            long long_h = height_in_cells * cell_height
                                    + 2 * cw->container.margin_h;
            if ( long_w > MAX_SHORT )
            {
                long_w = MAX_SHORT;
            }
            if ( long_h > MAX_SHORT )
            {
                long_h = MAX_SHORT;
            }
            desired->width  = long_w;
            desired->height = long_h;
        }
        else
        {
            desired->width = width_in_cells * cell_width
                                    + 2 * cw->container.margin_w;
            desired->height = height_in_cells * cell_height
                                    + 2 * cw->container.margin_h;
        }
#else
        desired->width = width_in_cells * cell_width
                                + 2 * cw->container.margin_w;
        desired->height = height_in_cells * cell_height
                                + 2 * cw->container.margin_h;
#endif
        if ( CtrIncludeIsCLOSEST( cw ) )
        {
            /*
             * Make adjustments to accomodate cwids' desired x,y placement.
             */
            desired->width = MAX( desired->width,trial_width );
            desired->height = MAX( desired->height,trial_height );
        }
    }

#if !AUTOPOSITION
    if ( cw->container.width_frozen )
        desired->width = cw->core.width;
    if ( cw->container.height_frozen )
        desired->height = cw->core.height;
#endif
    answer = XtGeometryYes;
    if ( ( intended->request_mode  &&  CWWidth )  &&
         ( intended->width < desired->width ) )
        answer = XtGeometryNo;
    if ( ( intended->request_mode && CWHeight )  &&
         ( intended->height < desired->height ) )
        answer = XtGeometryNo;
    return answer;
}

/*---------------------------------------------
| private functions used by Container methods |
---------------------------------------------*/
/************************************************************************
 * PlaceItemNone
 ************************************************************************/
static  void
PlaceItemNone(
    Widget      wid,
    Widget      cwid)
{
    XmContainerWidget           cw = (XmContainerWidget) wid;
    XmContainerConstraint       c = GetContainerConstraint( cwid );
    XPoint                      spot;

    if ( CtrViewIsLARGEICON( cw ) )
    {
        // Both tree view and icon view use the large icon setting.
        // They can't share coordinates, so we have to check for
        // tree view (OUTLINE) and use large_icon_x,y or
        // icon_view_x,y.  LJO
        if ( CtrLayoutIsOUTLINE( cw ) ) /* Tree view uses large */ /* LJO */
        {                                                          /* LJO */
            spot.x = (c->large_icon_x == XmUNSPECIFIED_POSITION) ? /* LJO */
                           0 : c->large_icon_x;                    /* LJO */
            spot.y = (c->large_icon_y == XmUNSPECIFIED_POSITION) ? /* LJO */
                           0 : c->large_icon_y;                    /* LJO */
        }                                                          /* LJO */
        else                        /* Icon view uses large */     /* LJO */
        {                                                          /* LJO */
            spot.x = (c->icon_view_x == XmUNSPECIFIED_POSITION) ?  /* LJO */
                           0 : c->icon_view_x;                     /* LJO */
            spot.y = (c->icon_view_y == XmUNSPECIFIED_POSITION) ?  /* LJO */
                           0 : c->icon_view_y;                     /* LJO */
        }                                                          /* LJO */
    }
    else
    {
        spot.x = (c->small_icon_x == XmUNSPECIFIED_POSITION) ?
                        0 : c->small_icon_x;
        spot.y = (c->small_icon_y == XmUNSPECIFIED_POSITION) ?
                        0 : c->small_icon_y;
    }
    PlaceCwid( cwid, spot.x, spot.y );

    /*
     * Mark the cwid as placed (any value except NO_CELL).
     */
    c->cell_idx = 1;
}

/************************************************************************
 * PlaceItemGrid
 ************************************************************************/
static  void
PlaceItemGrid(
    Widget          wid,
    Widget          cwid)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    XmContainerConstraint c = GetContainerConstraint( cwid );
    int         trial_cell = 0;
    Position    trial_x,trial_y;
    XPoint      cell_coord;
    int         cellCount = cw->container.cell_count;    // ICLUI

    if ( CtrIncludeIsAPPEND( cw ) )
    {
        // ICLUI: Replaced next_free_cell with first_free_cell.
        trial_cell = cw->container.first_free_cell;
    }
    else                                                 // ICLUI
    if ( CtrIncludeIsCLOSEST( cw ) )
    {
        // Both tree view and icon view use the large icon setting.
        // They can't share coordinates, so we have to check for
        // tree view (OUTLINE) and use large_icon_x,y or
        // icon_view_x,y.  LJO
        trial_x = ( CtrViewIsLARGEICON( cw ) ) ?
                      ( ( CtrLayoutIsOUTLINE( cw ) ) ?
                            c->large_icon_x : c->icon_view_x ) :
                            c->small_icon_x;                   /* LJO */
        trial_y = ( CtrViewIsLARGEICON( cw ) ) ?
                      ( ( CtrLayoutIsOUTLINE( cw ) ) ? c->large_icon_y :
                            c->icon_view_y) : c->small_icon_y; /* LJO */
        trial_cell = GetCellFromCoord( wid, trial_x, trial_y );
        if ( trial_cell >= cellCount )
        {
            if ( cw->container.cells[ cellCount - 1] == 0 )
                trial_cell = cellCount - 1;
            else
                // ICLUI: Replaced next_free_cell with first_free_cell.
                trial_cell = cw->container.first_free_cell;
        }
    }

    // ICLUI: Removed CtrItemIsPlaced(cwid) check from while loop.
    while ( trial_cell < cellCount )
    {
        if ( cw->container.cells[trial_cell] == NULL )
        {
            cw->container.cells[trial_cell] = cwid;
            c->cell_idx = trial_cell;

            // ICLUI: Update last_used_cell if necessary, which
            //        is used as a performance short cut in
            //        PlaceItemReset.
            if ( trial_cell > cw->container.last_used_cell )
            {
                cw->container.last_used_cell = trial_cell;
            }
            break;
        }
        else                                             // ICLUI
            trial_cell++;
    }

    // ICLUI: Changed check for not being able to add the object
    // to the cells array.
    if ( trial_cell >= cellCount )
        return;

    // ICLUI: Mark the next cell as where we should start the next
    //        search for an empty cell. This may not be an empty cell,
    //        but we'll skip any occupied cells between here and the
    //        next free cell the next time this function is called to
    //        add an item. If there is no next item to add, we save
    //        some machine cycles by skipping a loop to find the next
    //        free cell.
    // ICLUI: Replaced next_free_cell with first_free_cell, and removed
    //        a check for CtrIncludeIsAPPEND.
    cw->container.first_free_cell = trial_cell + 1;

    GetCoordFromCell( wid, cwid, c->cell_idx, &cell_coord );
    if ( CtrViewIsLARGEICON( cw ) )
    {
        // Both tree view and icon view use the large icon setting.
        // They can't share coordinates, so we have to check for
        // tree view (OUTLINE) and use large_icon_x,y or
        // icon_view_x,y.  LJO
        if ( CtrLayoutIsOUTLINE( cw ) )                        /* LJO */
        {                                                      /* LJO */
            c->large_icon_x = cell_coord.x;                    /* LJO */
            c->large_icon_y = cell_coord.y;                    /* LJO */
        }                                                      /* LJO */
        else                                                   /* LJO */
        {                                                      /* LJO */
            c->icon_view_x = cell_coord.x;                     /* LJO */
            c->icon_view_y = cell_coord.y;                     /* LJO */
        }                                                      /* LJO */
    }                                                          /* LJO */
    else
    {
        c->small_icon_x = cell_coord.x;
        c->small_icon_y = cell_coord.y;
    }
    PlaceCwid( cwid, cell_coord.x, cell_coord.y );
#ifdef  DEBUG
    printf( "cell_idx is %d\n", c->cell_idx );
    fflush( stdout );
#endif  /* DEBUG */
}

/************************************************************************
 * GetCellFromCoord
 ************************************************************************/
static  int
GetCellFromCoord(
    Widget      wid,
    Position    x,
    Position    y)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    int                 cell_width,
                        cell_height;
    int                 row,
                        col;

    cell_width = ( CtrViewIsLARGEICON( cw ) ) ?
        cw->container.large_cell_width : cw->container.small_cell_width;
    cell_height = ( CtrViewIsLARGEICON( cw ) ) ?
        cw->container.large_cell_height : cw->container.small_cell_height;
    /*
     * Note: x & y parameters are assumed not to include Container margins.
     *
     * ICLUI: Account for calls to XuiclSetVerticalDisplayOffset
     *        (y is assumed to not include verticalDisplayOffset).
     */
    long
        yPos = cw->container.verticalDisplayOffset;
    if ( yPos )
    {   // XuiclSetVerticalDisplayOffset called.
        // Correction factor, since this value includes margins.
        yPos -= cw->container.margin_h;
    }
    yPos += y;
    long
        rowCount = yPos / cell_height;
    if ( rowCount > MAX_SHORT )
    {   // Prevent overflow.
        rowCount = MAX_SHORT;
    }
    row = (int) rowCount;
    col = x / cell_width;
    if ( CtrLayoutIsRtoL( cw ) )
        col = cw->container.current_width_in_cells - col - 1;
    if ( CtrIsHORIZONTAL( cw ) )
        return( cw->container.current_width_in_cells * row + col );
    else
        return( cw->container.current_height_in_cells * col + row );
}

/************************************************************************
 * GetCoordFromCell
 ************************************************************************/
static  void
GetCoordFromCell(
    Widget      wid,
    Widget      cwid,
    int         cell_idx,
    XPoint     *point)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    int                 cell_width,
                        cell_height;
    int                 row,
                        col;

#if AUTOPOSITION
    if ( CtrIsHORIZONTAL( cw ) )
    {
        /* do not divide by 0 */
        if ( cw->container.current_width_in_cells )
        {
            row = cell_idx / cw->container.current_width_in_cells;
            col = cell_idx - (row * cw->container.current_width_in_cells);
        }
        else
        {
            row = cell_idx;
            col = 0;
        }
    }
    else
    {
        /* do not divide by 0 */
        if ( cw->container.current_height_in_cells )
        {
            col = cell_idx / cw->container.current_height_in_cells;
            row = cell_idx - (col * cw->container.current_height_in_cells);
        }
        else
        {
            col = cell_idx;
            row = 0;
        }
    }
    if ( CtrLayoutIsRtoL( cw ) )
    {
        if ( cw->container.current_width_in_cells )
            col = cw->container.current_width_in_cells - col - 1;
        /* else col = col; */
    }
#else
    if ( CtrIsHORIZONTAL( cw ) )
    {
        /* do not divide by 0 */
        if ( cw->container.current_width_in_cells )
            row = cell_idx / cw->container.current_width_in_cells;
        else
            row = cell_idx;
        col = cell_idx - (row * cw->container.current_width_in_cells);
    }
    else
    {
        /* do not divide by 0 */
        if ( cw->container.current_height_in_cells )
            col = cell_idx / cw->container.current_height_in_cells;
        else
            col = cell_idx;
        row = cell_idx - (col * cw->container.current_height_in_cells);
    }
    if ( CtrLayoutIsRtoL( cw ) )
    {
        col = cw->container.current_width_in_cells - col - 1;
    }
#endif
    cell_width = ( CtrViewIsLARGEICON( cw ) ) ?
        cw->container.large_cell_width : cw->container.small_cell_width;
    cell_height = ( CtrViewIsLARGEICON( cw ) ) ?
        cw->container.large_cell_height : cw->container.small_cell_height;
    /*
     * Note: returned point does not include Container Margins
     */
    point->x = col * cell_width;

    /*
     * ICLUI: Account for calls to XuiclSetVerticalDisplayOffset.
     */
    long
        y = ( row * cell_height ) - cw->container.verticalDisplayOffset,
        yMargin = cw->container.margin_h;
    if ( y + yMargin < MIN_SHORT )
    {   // Prevent underflow.
        y = MIN_SHORT + yMargin;
    }
    else if ( y + yMargin > MAX_SHORT )
    {   // Prevent overflow.
        y = MAX_SHORT - yMargin;
    }
    point->y = (short) y;
}

/************************************************************************
 * PlaceItemCells
 ************************************************************************/
static  void
PlaceItemCells(
    Widget          wid,
    Widget          cwid)
{
    PlaceItemGrid( wid, cwid );
}


/************************************************************************
 * InvalidateAllCells
 ************************************************************************/
static void
InvalidateAllCells(XmContainerWidget ncw)
{
    CwidNode                node;
    XmContainerConstraint   c;

    node = ncw->container.first_node;
    while ( node != NULL )
    {
        c = GetContainerConstraint( node->widget_ptr );
        c->cell_idx = NO_CELL;
        if ( node->child_ptr != NULL )
            node = node->child_ptr;
        else if ( node->next_ptr != NULL )
            node = node->next_ptr;
        else
            node = GetNextUpLevelNode( node );
    }
}

/************************************************************************
 * PlaceItemReset
 ************************************************************************/
static  void
PlaceItemReset(
    Widget          wid)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    int                 i;
    int                 cell_width = 0,
                        cell_height = 0;
    int                 width_in_cells,
                        height_in_cells;
    unsigned long       newCellCount = 0;                // ICLUI

#if 0
    /* Get current cell width and height */
    cell_width = ( CtrViewIsLARGEICON( cw ) ) ?
        cw->container.large_cell_width : cw->container.small_cell_width;
    cell_height = ( CtrViewIsLARGEICON( cw ) ) ?
        cw->container.large_cell_height : cw->container.small_cell_height;

    /* ICLUI: finding too many situations where we come in here and
     * end up with zero in cell_width or cell_height.
     * Let's just make sure, but SetCellSize is expensive so only do
     * it if needed.
     */
    if ( cell_width == 0  ||  cell_height == 0 )
    {
#endif
        SetCellSize( wid );
        cell_width = ( CtrViewIsLARGEICON( cw ) ) ?
          cw->container.large_cell_width : cw->container.small_cell_width;
        cell_height = ( CtrViewIsLARGEICON( cw ) ) ?
          cw->container.large_cell_height : cw->container.small_cell_height;
/*  } */

    /* If cell width or height still zero just get out rather than
     * dividing by zero below.
     */
    if ( cell_width == 0  ||  cell_height == 0 )
        return;

    /*
     * Clean up the old cell structure.
     */
    if ( cw->container.cells != NULL )
    {
        /* ICLUI: Changed the below loop to iterate to last_used_cell
         *        instead of cell_count, for performance, since the
         *        array is unused beyond last_used_cell.
         */
        for ( i = 0; i <= cw->container.last_used_cell; i++ )
        {
            if ( cw->container.cells[i] != NULL )
                ( *( xmContainerClassRec.container_class.remove_item ) )
                        ( wid, cw->container.cells[i] );
        }
        /* ICLUI: Performance improvement: Don't free the
         *        container.cells array if its new size will be the
         *        same as its current size. In this case we can
         *        simply reuse the existing buffer.
         */
    }

    if ( ! CtrPlaceStyleIsNONE( cw ) )
    {
        /*
         * Calculate the size needed by the new cells array.
         */
        width_in_cells = (cw->core.width - 2 * cw->container.margin_w)
                            / cell_width;
        height_in_cells = (cw->core.height - 2 * cw->container.margin_h)
                            / cell_height;
        newCellCount = width_in_cells * height_in_cells;
        /*
         * Create the "phantom" row/column that holds clipped items
         */
        if ( CtrIsHORIZONTAL( cw ) )
            newCellCount += height_in_cells;
        else
            newCellCount += width_in_cells;
    }

    // Allocate a new buffer if the old and new sizes don't match.
    if ( newCellCount != cw->container.cell_count )
    {
        if ( cw->container.cells )
        {   // Free the old buffer first.
            XtFree( (char*) cw->container.cells );
        }
        cw->container.cell_count = newCellCount;

        if ( newCellCount )           
        {   // Need a new buffer.
            cw->container.cells = (Widget*) XtCalloc( newCellCount,
                                                      sizeof( Widget ) );
        }
        else
        {
            cw->container.cells = 0;
        }
    }

    // ICLUI: Replaced next_free_cell with first_free_cell and
    //        last_used_cell.
    cw->container.first_free_cell = 0;
    cw->container.last_used_cell = 0;
}

/************************************************************************
 * PlaceCwid
 ************************************************************************/
static  void
PlaceCwid(
    Widget      cwid,
    Position    x,
    Position    y)
{
    XmContainerWidget           cw;
    XmContainerConstraint       c;

    if ( cwid == NULL )
        return;
    cw = (XmContainerWidget) XtParent( cwid );
    c = GetContainerConstraint( cwid );
    if ( CtrViewIsLARGEICON( cw ) )
    {
        // Both tree view and icon view use the large icon setting.
        // They can't share coordinates, so we have to check for
        // tree view (OUTLINE) and use large_icon_x,y or
        // icon_view_x,y.  LJO
        if ( CtrLayoutIsOUTLINE( cw ) )                 /* LJO */
        {                                               /* LJO */
            c->large_icon_x = x;                        /* LJO */
            c->large_icon_y = y;                        /* LJO */
        }                                               /* LJO */
        else                                            /* LJO */
        {                                               /* LJO */
            c->icon_view_x = x;                         /* LJO */
            c->icon_view_y = y;                         /* LJO */
        }                                               /* LJO */
    }                                                   /* LJO */
    else
    {
        c->small_icon_x = x;
        c->small_icon_y = y;
    }

    x += cw->container.margin_w;
    y += cw->container.margin_h;

    if ( ( x != ((Widget) cwid)->core.x )  ||
         ( y != ((Widget) cwid)->core.y ) )
        _XmConfigureObject( cwid, x, y, ((Widget)cwid)->core.width,
                            ((Widget)cwid)->core.height, 0 );
}

/************************************************************************
 * HideCwid
 ************************************************************************/
static  Boolean
HideCwid(
    Widget  cwid)
{
    XmContainerConstraint   c;
    CwidNode                node;
    CwidNode                child_node;
    Boolean                 bSelectedHidden = False;
    unsigned char           selectionState;

    if ( cwid ) 
    {
        c = GetContainerConstraint( cwid );
    
        /*
           Used to do:
    
           _XmConfigureObject(
              cwid,(Position)(0 - ((Widget)cwid)->core.width),
                   (Position)(0 - ((Widget)cwid)->core.height),
                   ((Widget)cwid)->core.width,((Widget)cwid)->core.height,0);
    
           But there is a problem when you change fonts to a larger font
           in tree view with collapsed gadgets present. A piece of the
           collapsed gadgets appear in the top left corner. So hide it
           far in negative hyperspace so it can't be seen.
        */

        _XmConfigureObject( cwid, (Position) HIDDEN_COORD,
                            (Position) HIDDEN_COORD,
                            ((Widget)cwid)->core.width,
                            ((Widget)cwid)->core.height, 0 );
        XtVaGetValues( cwid,
                       XmNvisualEmphasis, &selectionState,
                       NULL);
        if ( selectionState == XmSELECTED )
            bSelectedHidden = True ;
    
        if ( ! c->container_created )
        {
            /* Hide our button! */
            if ( c->outline_button != NULL )
                HideCwid( c->outline_button );
        
            /* If we're XmEXPANDED, then let's hide our children too. */
            if ( c->outline_state == XmEXPANDED )
            {
                node = c->node_ptr;
                child_node = node->child_ptr;
                while ( child_node != NULL )
                {
                    c = GetContainerConstraint( child_node->widget_ptr );
                    bSelectedHidden |= HideCwid( child_node->widget_ptr );
            
                    if ( c->outline_button != NULL )
                        HideCwid( c->outline_button );
            
                    child_node = child_node->next_ptr;
                } /* while */
            } /* outline_state */
        } /* ! container_created */
    } /* cwid */

    return bSelectedHidden ;
}

/************************************************************************
 * ChangeOutlinePixmaps
 ************************************************************************/
static  void
ChangeOutlineStatePixmaps(
    Widget  cwid)
{
   XmContainerWidget cw = (XmContainerWidget) cwid ;
   XmContainerConstraint   c;
   CwidNode                node;

   cw->container.bDefaultOutlinePixmaps = False ;
   node = cw->container.first_node;
   while ( node != NULL )
   {
       c = GetContainerConstraint( node->widget_ptr );
       if ( c->outline_button != NULL )
       {
           if ( c->outline_state == XmEXPANDED )
               XtVaSetValues( c->outline_button,
                              XmNlabelPixmap,
                              cw->container.expanded_state_pixmap,
                              NULL );
           else
               XtVaSetValues( c->outline_button,
                              XmNlabelPixmap,
                              cw->container.collapsed_state_pixmap,
                              NULL );
       }
       node = GetNextNode( cwid, node );
   } /* while */
} /* ChangeOutlineStatePixmaps */


/*------------
| ActionProcs |
------------*/

/************************************************************************
 * ContainerHelp
 *   ICLUI: Needed to add this becuase of problems with using
 *     ManagerGadgetHelp. It wasn't called if Container inside a
 *     ScrolledWindow. Also not called once an item was expanded in
 *     TreeView.
 ************************************************************************/
static  void
ContainerHelp(
    Widget          wid,
    XEvent          *event,
    String          *params,
    Cardinal        *num_params)
{
    XmAnyCallbackStruct cbs;
    if ( ! ( XtHasCallbacks( wid, XmNhelpCallback ) == XtCallbackHasSome ) )
        return;
    cbs.reason = XmCR_HELP;
    cbs.event  = event;
    XtCallCallbacks( wid, XmNhelpCallback, &cbs );
}

/************************************************************************
 * ContainerBeginSelect
 ************************************************************************/
static  void
ContainerBeginSelect(
    Widget          wid,
    XEvent          *event,
    String          *params,
    Cardinal        *num_params)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;

#ifdef DEBUG
    printf( "ContainerBeginSelect\n" );
    fflush( stdout );
#endif
    /* set the focus to the container widget if it doesn't have it */
    if ( wid != XmGetFocusWidget( wid ) )
        XmProcessTraversal( wid, XmTRAVERSE_CURRENT );

    cw->container.extending_mode = CtrPolicyIsMULTIPLE( cw );
    cw->container.cancel_pressed = False;
    StartSelect( wid,event,params,num_params );
}

/************************************************************************
 * ContainerButtonMotion
 ************************************************************************/
static  void
ContainerButtonMotion(
    Widget          wid,
    XEvent         *event,
    String         *params,
    Cardinal       *num_params)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    Boolean             selection_changes;

#ifdef DEBUG
    printf( "ContainerButtonMotion\n" );
    fflush( stdout );
#endif

    if ( cw->container.cancel_pressed )
        return;
    if ( CtrPolicyIsSINGLE( wid ) )
        return;
    selection_changes =
        ProcessButtonMotion( wid, event, params, num_params );
    cw->container.no_auto_sel_changes |= selection_changes;
    if ( CtrIsAUTO_SELECT( cw )  &&  selection_changes )
        CallSelectCB( wid, event, XmAUTO_MOTION );
}

/************************************************************************
 * ContainerEndSelect
 ************************************************************************/
static  void
ContainerEndSelect(
    Widget          wid,
    XEvent         *event,
    String         *params,
    Cardinal       *num_params)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    Boolean             selection_changes;

#ifdef DEBUG
    printf( "ContainerEndSelect\n" );
    fflush( stdout );
#endif

    if ( cw->container.cancel_pressed )
        return;
    if ( cw->container.toggle_pressed )
    {
        ContainerEndToggle( wid, event, params, num_params );
        return;
    }
    if ( cw->container.extend_pressed )
    {
        ContainerEndExtend( wid, event, params, num_params );
        return;
    }
    if ( CtrPolicyIsSINGLE( cw ) )
    {
        if ( cw->container.no_auto_sel_changes )
            CallSelectCB( wid, event, XmAUTO_UNSET );
        return;
    }

    selection_changes =
        ProcessButtonMotion( wid, event, params, num_params );
    cw->container.no_auto_sel_changes |= selection_changes;
    if ( cw->container.marquee_drawn )
    {
        DrawMarquee( wid );
        cw->container.marquee_drawn = False;
        if ( XtIsRealized( wid ) )
            XClearArea( XtDisplay( wid ), XtWindow( wid ),
                        cw->container.marquee_smallest.x,
                        cw->container.marquee_smallest.y,
                        cw->container.marquee_largest.x,
                        cw->container.marquee_largest.y, True );
    }
    if ( cw->container.anchor_cwid != NULL )
    {
        if ( ! cw->container.kaddmode )
            SetLocationCursor( (Widget) cw, cw->container.anchor_cwid );
        if ( CtrPolicyIsBROWSE( cw ) )
            cw->container.no_auto_sel_changes |=
                    MarkCwid( cw->container.anchor_cwid, False );
        else
        {
            /* CtrPolicyIsMULTIPLE || CtrPolicyIsEXTENDED */
            SetMarkedCwids( wid );
        }
    }
    if ( CtrIsAUTO_SELECT( cw ) )
    {
        if ( selection_changes )
            CallSelectCB( wid, event, XmAUTO_CHANGE );
        else
            CallSelectCB( wid, event, XmAUTO_NO_CHANGE );
    }
    else
    {
        if ( cw->container.no_auto_sel_changes )
            CallSelectCB( wid, event, XmAUTO_UNSET );
    }
}

/************************************************************************
 * ContainerBeginToggle
 ************************************************************************/
static  void
ContainerBeginToggle(
    Widget          wid,
    XEvent          *event,
    String          *params,
    Cardinal        *num_params)
{
    XmContainerWidget       cw = (XmContainerWidget) wid;

#ifdef DEBUG
    printf( "cnr::ContainerBeginToggle\n" );
    fflush( stdout );
#endif

    cw->container.toggle_pressed = True;
    cw->container.cancel_pressed = False;
    if ( CtrPolicyIsSINGLE( cw )  ||  CtrPolicyIsBROWSE( cw ) )
        return;
    cw->container.extending_mode = True;
    StartSelect( wid, event, params, num_params );
}

/************************************************************************
 * ContainerEndToggle
 ************************************************************************/
static  void
ContainerEndToggle(
    Widget          wid,
    XEvent         *event,
    String         *params,
    Cardinal       *num_params)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;

#ifdef DEBUG
    printf( "cnr::ContainerEndToggle\n" );
    fflush( stdout );
#endif
    cw->container.toggle_pressed = False;
    if ( cw->container.cancel_pressed )
        return;
    if ( CtrPolicyIsSINGLE( cw )  ||  CtrPolicyIsBROWSE( cw ) )
        return;
    ContainerEndSelect( wid, event, params, num_params );
}

/************************************************************************
 * ContainerBeginExtend
 ************************************************************************/
static  void
ContainerBeginExtend(
    Widget          wid,
    XEvent         *event,
    String         *params,        /* unused */
    Cardinal       *num_params)    /* unused */
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    Widget              current_cwid;

#ifdef DEBUG
    printf( "cnr::ContainerBeginExtend\n" );
    fflush( stdout );
#endif

    cw->container.extend_pressed = True;
    cw->container.cancel_pressed = False;
    if ( CtrPolicyIsSINGLE( cw )  ||  CtrPolicyIsBROWSE( cw ) )
        return;
    if ( ! ( CtrViewIsDETAIL( cw )  ||  CtrLayoutIsOUTLINE( cw ) ) )
        return;
    if ( ( current_cwid = LocatePointer( wid, event->xbutton.x,
                                         event->xbutton.y ) ) == NULL )
        return;
    if ( cw->container.anchor_cwid == NULL )
        return;
    MarkCwidsInRange( wid, cw->container.anchor_cwid,
                      current_cwid, True );
    if ( CtrIsAUTO_SELECT( cw ) )
       CallSelectCB( wid, event, XmAUTO_BEGIN );
}

/************************************************************************
 * ContainerEndExtend
 ************************************************************************/
static  void
ContainerEndExtend(
    Widget          wid,
    XEvent         *event,
    String         *params,        /* unused */
    Cardinal       *num_params)    /* unused */
{
    XmContainerWidget       cw = (XmContainerWidget) wid;

#ifdef DEBUG
    printf( "cnr::ContainerEndExtend\n" );
    fflush( stdout );
#endif
    cw->container.extend_pressed = False;
    if ( cw->container.cancel_pressed )
        return;
    if ( CtrPolicyIsSINGLE( cw )  ||  CtrPolicyIsBROWSE( cw ) )
        return;
    if ( ! ( CtrViewIsDETAIL( cw )  ||  CtrLayoutIsOUTLINE( cw ) ) )
        return;
    SetMarkedCwids( wid );
    if ( CtrIsAUTO_SELECT( cw ) )
        CallSelectCB( wid, event, XmAUTO_NO_CHANGE );
    else
        CallSelectCB( wid, event, XmAUTO_UNSET );
}

/************************************************************************
 * ContainerCancel
 ************************************************************************/
static  void
ContainerCancel(
    Widget          wid,
    XEvent         *event,
    String         *params,        /* unused */
    Cardinal       *num_params)    /* unused */
{
    XmContainerWidget       cw = (XmContainerWidget) wid;
    Boolean                 selection_changes = False;

#ifdef DEBUG
    printf( "cnr::ContainerCancel\n" );
    fflush( stdout );
#endif

    cw->container.toggle_pressed = False;
    cw->container.extend_pressed = False;
    if ( CtrPolicyIsSINGLE( cw ) )
        return;
    cw->container.cancel_pressed = True;
    if ( CtrPolicyIsBROWSE( cw ) )
    {
        if ( cw->container.anchor_cwid != NULL )
        {
            selection_changes =
                UnmarkCwidVisual( cw->container.anchor_cwid );
            if ( CtrIsAUTO_SELECT( cw )  &&  selection_changes )
            {
                CallSelectCB( wid, event, XmAUTO_CANCEL );
            }
        }
        return;
    }
    
    /* CtrPolicyIsMULTIPLE || CtrPolicyIsEXTENDED */
    selection_changes = ResetMarkedCwids( wid );
    if ( cw->container.marquee_drawn )
    {
        DrawMarquee( wid );
        cw->container.marquee_drawn = False;
        if ( XtIsRealized( wid ) )
        {
            XClearArea( XtDisplay( wid ), XtWindow( wid ),
                        cw->container.marquee_smallest.x,
                        cw->container.marquee_smallest.y,
                        cw->container.marquee_largest.x,
                        cw->container.marquee_largest.y, True );
        }
    }

    if ( CtrIsAUTO_SELECT( cw )  &&  selection_changes )
    {
        CallSelectCB( wid, event, XmAUTO_CANCEL );
    }
}

/************************************************************************
 * ContainerSelect
 ************************************************************************/
static  void
ContainerSelect(
    Widget          wid,
    XEvent         *event,
    String         *params,
    Cardinal       *num_params)
{
    XmContainerWidget       cw = (XmContainerWidget) wid;
    XmContainerConstraint   c;

#ifdef DEBUG
    printf( "cnr::ContainerSelect\n" );
    fflush( stdout );
#endif

    if ( cw->container.loc_cursor_cwid != NULL )
    {
        c = GetContainerConstraint( cw->container.loc_cursor_cwid );
        if ( c->container_created )
        {
            XtCallActionProc( cw->container.loc_cursor_cwid,
                              "ArmAndActivate", event,
                              params, *num_params );
            BorderHighlight( cw->container.loc_cursor_cwid );
            return;
        }
    }
    cw->container.extending_mode = cw->container.kaddmode;
    KBSelect( wid, event, params, num_params );
}

/************************************************************************
 * ContainerExtend
 ************************************************************************/
static  void
ContainerExtend(
    Widget          wid,
    XEvent         *event,
    String         *params,        /* unused */
    Cardinal       *num_params)    /* unused */
{
    XmContainerWidget       cw = (XmContainerWidget) wid;
    XmContainerConstraint   c;

#ifdef DEBUG
    printf( "cnr::ContainerExtend\n" );
    fflush( stdout );
#endif
    if ( cw->container.loc_cursor_cwid != NULL )
    {
        c = GetContainerConstraint( cw->container.loc_cursor_cwid );
        if ( c->container_created )
            return;
    }
    if ( ! cw->container.kaddmode )
        return;
    if ( ! ( CtrViewIsDETAIL( cw )  ||  CtrLayoutIsOUTLINE( cw ) ) )
        return;
    cw->container.no_auto_sel_changes |=
        MarkCwidsInRange( wid, cw->container.anchor_cwid,
                          cw->container.loc_cursor_cwid, False );
    if ( CtrIsAUTO_SELECT( cw ) )
    {
        CallSelectCB( wid, event, XmAUTO_BEGIN );
        CallSelectCB( wid, event, XmAUTO_NO_CHANGE );
    }
    else if ( cw->container.no_auto_sel_changes )
        CallSelectCB( wid, event, XmAUTO_UNSET );
}

/************************************************************************
 * ContainerMoveCursor
 ************************************************************************/
static  void
ContainerMoveCursor(
    Widget          wid,
    XEvent         *event,
    String         *params,
    Cardinal       *num_params)
{
    XmContainerWidget       cw = (XmContainerWidget) wid;
    XmContainerConstraint   c;

#ifdef DEBUG
    printf( "cnr::ContainerMoveCursor\n" );
    fflush( stdout );
#endif

    if ( *num_params == 0 )
        return;
    SetLocationCursor( (Widget) cw,
                       CalcNextLocationCursor( wid, params[0] ) );
    if ( cw->container.loc_cursor_cwid != NULL )
    {
        c = GetContainerConstraint( cw->container.loc_cursor_cwid );
        if ( c->container_created )
            return;
    }
    if ( cw->container.kaddmode )
        return;
    cw->container.extending_mode = False;
    KBSelect( wid,event,params,num_params );

    if ( XtHasCallbacks( wid, XmNcnrTraversalCallback )
                                           == XtCallbackHasSome )
    {
        XmContainerTraversalCallbackStruct cbs;
        cbs.reason = XmCR_CNRTRAVERSE;
        cbs.event  = event;
        cbs.item   = wid;
        cbs.traversal_destination = cw->container.loc_cursor_cwid;
        /* cbs.traversal_direction   = ? */
        XtCallCallbackList( wid, cw->container.traversal_callbacks, &cbs );
    }
}

/************************************************************************
 * ContainerExtendCursor
 ************************************************************************/
static  void
ContainerExtendCursor(
    Widget          wid,
    XEvent         *event,
    String         *params,
    Cardinal       *num_params)
{
#ifdef DEBUG
    printf( "cnr::ContainerExtendCursor\n" );
    fflush( stdout );
#endif

    XmContainerWidget   cw = (XmContainerWidget) wid;

    if ( *num_params == 0 )
        return;

    SetLocationCursor( (Widget) cw,
                       CalcNextLocationCursor( wid, params[0] ) );

    cw->container.kaddmode = !cw->container.kaddmode;
    ContainerExtend( wid, event, params, num_params );
    cw->container.kaddmode = !cw->container.kaddmode;
}

/************************************************************************
 * ContainerToggleMode
 ************************************************************************/
static  void
ContainerToggleMode(
    Widget          wid,
    XEvent         *event,         /* unused */
    String         *params,        /* unused */
    Cardinal       *num_params)    /* unused */
{
    XmContainerWidget       cw = (XmContainerWidget) wid;
    XmContainerConstraint   c;

#ifdef DEBUG
    printf( "cnr::ContainerToggleMode\n" );
    fflush( stdout );
#endif
    if ( CtrPolicyIsEXTENDED( cw ) )
    {
        if ( cw->container.loc_cursor_cwid != NULL )
        {
            c = GetContainerConstraint( cw->container.loc_cursor_cwid );
            if ( c->container_created )
                cw->container.kaddmode = !cw->container.kaddmode;
            else
            {
                BorderUnhighlight( cw->container.loc_cursor_cwid );
                cw->container.kaddmode = !cw->container.kaddmode;
                BorderHighlight( cw->container.loc_cursor_cwid );
            }
        }
    }
}

/************************************************************************
 * ContainerSelectAll
 ************************************************************************/
static  void
ContainerSelectAll(
    Widget          wid,
    XEvent         *event,
    String         *params,
    Cardinal       *num_params)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;

#ifdef DEBUG
    printf( "cnr::ContainerSelectAll\n" );
    fflush( stdout );
#endif

    if ( CtrPolicyIsSINGLE( cw )  ||  CtrPolicyIsBROWSE( cw ) )
    {
        ContainerSelect( wid, event, params, num_params );
        return;
    }
    cw->container.no_auto_sel_changes |= SelectAllCwids( wid );
    if ( CtrIsAUTO_SELECT( cw ) )
    {
        CallSelectCB( wid, event, XmAUTO_BEGIN );
        CallSelectCB( wid, event, XmAUTO_NO_CHANGE );
    }
    else if ( cw->container.no_auto_sel_changes )
        CallSelectCB( wid, event, XmAUTO_UNSET );
}

/************************************************************************
 * ContainerDeselectAll
 ************************************************************************/
static  void
ContainerDeselectAll(
    Widget          wid,
    XEvent         *event,
    String         *params,        /* unused */
    Cardinal       *num_params)    /* unused */
{
    XmContainerWidget       cw = (XmContainerWidget) wid;

#ifdef DEBUG
    printf( "cnr::ContainerDeselectAll\n" );
    fflush( stdout );
#endif

    cw->container.no_auto_sel_changes |= DeselectAllCwids( wid );
    if ( CtrIsAUTO_SELECT( cw )  &&  ( ! CtrPolicyIsSINGLE( cw ) ) )
    {
        CallSelectCB( wid, event, XmAUTO_BEGIN );
        CallSelectCB( wid, event, XmAUTO_NO_CHANGE );
    }
    else if ( cw->container.no_auto_sel_changes )
        CallSelectCB( wid, event, XmAUTO_UNSET );
}

/************************************************************************
 * ContainerActivate
 ************************************************************************/
static  void
ContainerActivate(
    Widget          wid,
    XEvent         *event,
    String         *params,
    Cardinal       *num_params)
{
    XmContainerWidget       cw = (XmContainerWidget) wid;
    XmContainerConstraint   c;

#ifdef DEBUG
    printf( "cnr::ContainerActivate\n" );
    fflush( stdout );
#endif

    if ( cw->container.loc_cursor_cwid != NULL )
    {
        c = GetContainerConstraint( cw->container.loc_cursor_cwid );
        if ( c->container_created )
        {
            XtCallActionProc( cw->container.loc_cursor_cwid,
                              "ArmAndActivate", event,
                              params, *num_params );
            BorderHighlight( cw->container.loc_cursor_cwid );
            return;
        }
    }
    if ( cw->container.anchor_cwid == NULL )
        return;
    CallActionCB( cw->container.anchor_cwid, event );
}

/************************************************************************
 * ContainerFocus
 ************************************************************************/
static  void
ContainerFocus(
    Widget          wid,
    XEvent         *event,         /* unused */
    String         *params,
    Cardinal       *num_params)    /* unused */
{
    XmContainerWidget       cw = (XmContainerWidget) wid;

    if ( cw->container.loc_cursor_cwid == NULL )
        return;

    /*
     * Highlight on a FocusIn,
     * Unhighlight on a FocusOut.
     */
    if ( strcmp( params[0],_IN ) == 0 )
    {
        cw->container.have_focus = True;
        BorderHighlight( cw->container.loc_cursor_cwid );
    }
    else
    {
        cw->container.have_focus = False;
        BorderUnhighlight( cw->container.loc_cursor_cwid );
    }
}



/*-------------------
| Internal functions |
-------------------*/
/************************************************************************
 * Layout
 ************************************************************************/
static  void
Layout(
    Widget  wid)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;

#ifdef  DEBUG
    printf( "cnr::Layout\n" );
    fflush( stdout );
#endif

    /* ICLUI: support for refresh On/Off.
     * Added public function XuiclSetRefreshOn(Boolean) to support this.
     */
    if ( cw->container.refreshOn )
    { 
       if ( CtrLayoutIsOUTLINE( cw )  ||  CtrViewIsDETAIL( cw ) )
           LayoutOutlineDetail( wid );
       else
           LayoutSpatial( wid );
    }
}

/************************************************************************
 * RequestNewSize
 ************************************************************************/
static  void
RequestNewSize(
    Widget  wid)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    Dimension           ideal_width,
                        ideal_height;
    XtWidgetGeometry    geo_current,
                        geo_spatial,
                        geo_desired;

#ifdef  DEBUG
    printf( "cnr::RequestNewSize\n" );
    fflush( stdout );
#endif


    if ( CtrLayoutIsOUTLINE( cw )  ||  CtrViewIsDETAIL( cw ) )
    {
        /*
         * Layout() routine keeps track of the
         * ideal width/height for "one-dimensional" layouts.
         */
        ideal_width = cw->container.ideal_width;
        ideal_height = cw->container.ideal_height;
#if AUTOPOSITION
        geo_desired.request_mode = 0;
        if ( (ideal_width != cw->core.width )  &&
             ( ! cw->container.width_frozen ) )
        {
            geo_desired.request_mode |= CWWidth;
            geo_desired.width = ideal_width;
        }
        if ( ( ideal_height != cw->core.height )  &&
             ( ! cw->container.height_frozen ) )
        {
            geo_desired.request_mode |= CWHeight;
            geo_desired.height = ideal_height;
        }
#endif
    }
    else
    {
        /*
         * Get the desired width/height for a two-dimensional
         * Spatial layout from the class method.
         */
        geo_current.request_mode = CWWidth | CWHeight;
        geo_current.width = cw->core.width;
        geo_current.height = cw->core.height;
        ( *( xmContainerClassRec.core_class.query_geometry ) )
                ( wid, &geo_current, &geo_spatial );
        ideal_width = geo_spatial.width;
        ideal_height = geo_spatial.height;
#if AUTOPOSITION
        geo_desired.request_mode = 0;
        /* For icon or text view, we need to set desired.width = ideal_width
         * regardless of whether the width is frozen, since if it is,
         * it is frozen at the width equivalent to an integral number of
         * cells, and NOT at the core width.
         */
        if ( ideal_width != cw->core.width )
        {
            geo_desired.request_mode |= CWWidth;
            geo_desired.width = ideal_width;
        }
        if ( ideal_height != cw->core.height )
        {
            geo_desired.request_mode |= CWHeight;
            geo_desired.height = ideal_height;
        }
#endif
        /*
         * ICLUI: Store XmContainerPart::logicalDisplayHeight for
         *        name, icon, and text views (everything other than
         *        details and tree views).
         */
        cw->container.logicalDisplayHeight = ideal_height;
    }

#if !AUTOPOSITION
    geo_desired.request_mode = 0;
    if ( ( ideal_width != cw->core.width )  &&
         ( ! cw->container.width_frozen ) )
    {
        geo_desired.request_mode |= CWWidth;
        geo_desired.width = ideal_width;
    }
    if ( ( ideal_height != cw->core.height )  &&
         ( ! cw->container.height_frozen ) )
    {
        geo_desired.request_mode |= CWHeight;
        geo_desired.height = ideal_height;
    }
#endif
    if ( geo_desired.request_mode != 0 )
    {
        if ( _XmMakeGeometryRequest( wid, &geo_desired )
                                             == XtGeometryYes )
            ( *( xmContainerClassRec.core_class.resize ) )( wid );
    }
}

/************************************************************************
 * LayoutOutlineDetail
 ************************************************************************/
static  void
LayoutOutlineDetail(
    Widget  wid)
{
#ifdef DEBUG
    printf( "cnr::LayoutOutlineDetail\n" );
    fflush( stdout );
#endif

    XmContainerWidget           cw = (XmContainerWidget) wid;
    XmContainerConstraint       c;
    XmContainerConstraint       pc;

    Position                    x, cwid_x, cwid_y, ob_x, ob_y;
    long                        y, workY;
    CwidNode                    node;
    CwidNode                    firstVisibleNode = 0,
                                afterLastVisibleNode = 0;
    Dimension                   cwid_width,cwid_height;
    int                         i;
    int                         n_outline_segs, n_detail_segs, seg_idx;
    int                         vspacing;
    XCnrPoint                  *point_at_depth = 0;

    n_outline_segs = n_detail_segs = seg_idx = 0;

    /* Allocate the XSegment array used for drawing Tree View lines */
    if ( CtrDrawLinesOUTLINE( cw ) )
    {
        // Iterate all nodes (loop 1).
        node = cw->container.first_node;
        while ( node != NULL )
        {
            // Each container object that has a parent object needs
            // two line segments (a vertical and horizontal).
            // Actually this is overly aggressive, since we only need
            // drawing information for the number of nodes we can
            // draw in 32K of vertical space in the container window.
            // We'll go for performance over memory use for now.
            c = GetContainerConstraint( node->widget_ptr );
            if ( c->depth != 0 )
                n_outline_segs += 2;
            node = GetNextNode( wid, node );
        }
        // Allocate a new array of XSegment structures if the size
        // doesn't match the size of the previous array.
        // ICLUI: We may not use the entire array (outline_seg_count_used
        //        may be different from outline_seg_count_allocated), but
        //        this is the maximum size we'll need based on the above
        //        quick analysis.
        if ( cw->container.outline_seg_count_allocated != n_outline_segs )
        {
            if ( cw->container.outline_segs != NULL )
                XtFree( (char*) cw->container.outline_segs );
            cw->container.outline_segs = (XSegment*)
                XtCalloc( n_outline_segs, sizeof( XSegment ) );
            cw->container.outline_seg_count_allocated = n_outline_segs;
        }
        // Allocate an array of points to help build the XSegment values.
        // ICLUI: The XCnrPoint structures support a long y value.
        point_at_depth =
          (XCnrPoint*) XtCalloc( (cw->container.max_depth + 1 ),
                                 sizeof( XCnrPoint ) );
    }
    else
    {
        // This isn't tree view, so we don't need the XSegments for
        // drawing the lines for tree view.
        if ( cw->container.outline_segs != NULL )
        {
            XtFree( (char*) cw->container.outline_segs );
            cw->container.outline_segs = NULL;
        }
        cw->container.outline_seg_count_allocated = 0;
    }
    cw->container.outline_seg_count_used = 0;

    vspacing = CtrDrawLinesDETAIL( cw ) ? 3 : 0;

    /* Handle all aspects of Tree or Detail layout other than line drawing */
    if ( CtrLayoutIsOUTLINE( cw )  ||  CtrViewIsDETAIL( cw ) )
    {
        y = cw->container.margin_h;

        // ICLUI: Account for calls to XuiclSetVerticalDisplayOffset.
        y -= cw->container.verticalDisplayOffset;

        /* Layout Detail column headings - increment y to reflect heading */
        if ( CtrViewIsDETAIL( cw ) )
        {
            if ( cw->container.detail_heading != 0 )
            {
                y += cw->container.heading_rect.height + vspacing;
                if ( cw->container.detail_count > 0 )
                    cw->container.tabs[1] =
                          MAX( cw->container.heading_col1_width,
                               cw->container.tabs[1] );

                n_detail_segs++;
            }
            else if ( ( cw->container.detail_count > 0 )  &&
                      ( cw->container.showIconInDetail ) )
            {
                cw->container.tabs[1] = 0;
            }
        }

        cw->container.ideal_width = cw->container.margin_w;
        cw->container.ideal_height = y;

        /* Loop through all nodes and handle either Outline or Detail Layout */
        // Iterate all nodes (loop 2).
        node = cw->container.first_node;
        while ( node != NULL )
        {
            cw->container.last_node = node;
            c = GetContainerConstraint( node->widget_ptr );

            workY = y;
            if ( workY > MAX_SHORT )
            {  // Prevent overflow.
               workY = MAX_SHORT;   // 32767
            }
            else if ( workY < MIN_SHORT )
            {  // Prevent underflow.
               workY = MIN_SHORT;   // -32768
            }
            c->row_y = (int) workY;

            x = cw->container.margin_w +
                        cw->container.outline_indent * c->depth;

            if ( CtrViewIsDETAIL( cw )  &&
                 ! cw->container.showIconInDetail )
                cwid_width = 0;
            else
                cwid_width = ((XmGadget)node->widget_ptr)->rectangle.width;

            cwid_height = ((XmGadget)node->widget_ptr)->rectangle.height;
            c->row_height = cwid_height;

            /* Compute row height for Detail view */
            if ( CtrViewIsDETAIL( cw ) )
            {
                if ( cw->container.showIconInDetail )
                    c->row_height = MAX( c->row_height, c->detail_height );
                else
                {
                    /* ICLUI: If not displaying icon in column 0, then height is
                     * determined by entry_details.
                     */
                    c->row_height = c->detail_height;
                }
                c->row_height = c->row_height +
                                  cw->container.detailsViewLineSpacing;
            }

            /* ICLUI: don't want to increase height in details view */
            if ( CtrLayoutIsOUTLINE( cw ) )
                c->row_height = MAX( c->row_height,
                                     cw->container.ob_height );

            /* Layout expand/collapse button for Outline view */
            workY = y + ( c->row_height - cw->container.ob_height ) / 2;
            if ( workY > MAX_SHORT )
            {   // Prevent overflow.
                workY = MAX_SHORT;   // 32767
            }
            else if ( workY < MIN_SHORT )
            {   // Prevent underflow.
                workY = MIN_SHORT;   // -32768
            }
            ob_y = (int) workY;
            if ( CtrLayoutIsOUTLINE( cw )  &&
                 ( c->outline_button != NULL ) )
            {
                ob_x = CtrLayoutIsLtoR( cw ) ?
                          x :
                          MAX( cw->container.margin_w,
                               cw->core.width - cw->container.ob_width - x );
                _XmConfigureObject( c->outline_button, ob_x,ob_y,
                                    cw->container.ob_width,
                                    cw->container.ob_height, 0 );
            }
            if ( CtrLayoutIsOUTLINE( cw ) )
                x += cw->container.ob_width;

            /* Compute Position and Place the Icon Gadget for either view */
            cwid_x = CtrLayoutIsLtoR( cw ) ?
                        x :
                        MAX( cw->container.margin_w,
                             cw->core.width - cwid_width - x );
            workY = y + ( c->row_height - cwid_height ) / 2;
            if ( workY > MAX_SHORT )
            {   // Prevent overflow.
                workY = MAX_SHORT;   // 32767
                // This node doesn't fit in the container's 32K of
                // visible pixels. It is clipped by the bottom of the
                // container window. It will be visible only by calling
                // XuiclSetVerticalDisplayOffset.
                if ( afterLastVisibleNode == 0 )
                {
                    afterLastVisibleNode = node;
                }
            }
            else if ( workY < MIN_SHORT )
            {   // Prevent underflow.
                workY = MIN_SHORT;   // -32768
            }
            else if ( ( y + c->row_height > 0 )  &&  firstVisibleNode == 0 )
            {   // This (or possibly the next node) is the first node that
                // fits in the container window's 32K of vertical pixels.
                // All previous nodes are clipped by the top of the
                // container window, and will be visible only by calling
                // XuiclSetVerticalDisplayOffset.
                firstVisibleNode = node;
            }
            cwid_y = (int) workY;
            PlaceCwid( node->widget_ptr,
                       cwid_x - cw->container.margin_w,
                       cwid_y - cw->container.margin_h );
            cw->container.ideal_width =
                  MAX( cw->container.ideal_width,
                       (Dimension)x + cwid_width + cw->container.margin_w );

            /* Set tabs[1] to max icon width for details view */
            if ( CtrViewIsDETAIL( cw )  &&
                 ( cw->container.detail_count > 0 )  &&
                 cw->container.showIconInDetail )
                cw->container.tabs[1] =
                      MAX( cw->container.tabs[1],
                           (Dimension) x + cwid_width - cw->container.margin_w );

            /* Update XSegment array for outline view */
            if ( CtrDrawLinesOUTLINE( cw ) )
            {
                if ( point_at_depth[c->depth].x == 0 )
                {
                    point_at_depth[c->depth].x = cw->container.margin_w
                                + cw->container.outline_indent * c->depth
                                + cw->container.ob_width / 2;
                }
                /*
                 * ICLUI: We only need to build drawing segments for
                 *        child nodes that are visible.
                 */
                if ( c->entry_parent  &&  firstVisibleNode  &&
                       ( ! afterLastVisibleNode  ||
                         afterLastVisibleNode == node ) )
                {
                    pc = GetContainerConstraint( c->entry_parent );
                    cw->container.outline_segs[seg_idx].x1 =
                                        point_at_depth[pc->depth].x;
                    cw->container.outline_segs[seg_idx].x2 =
                                        cw->container.outline_segs[seg_idx].x1;
                    workY = point_at_depth[ pc->depth ].y;
                    if ( workY > MAX_SHORT )
                    {   // Prevent overflow.
                        workY = MAX_SHORT;  // 32767
                    }
                    else if ( workY < 0 )
                    {   // Prevent underflow.
                        workY = -1;
                    }
                    cw->container.outline_segs[ seg_idx ].y1 = (short) workY;
                    workY = y + c->row_height/2;
                    if ( workY > MAX_SHORT )
                    {   // Prevent overflow.
                        workY = MAX_SHORT;  // 32767
                        /*
                         * ICLUI: There is room to draw only one line, the
                         *        vertical connector to this node (there is
                         *        no room to draw the horizontal connector).
                         */
                        cw->container.outline_segs[ seg_idx ].y2 =
                                                        (short) workY;
                        seg_idx++;
                    }
                    else
                    {
                        if ( workY < 0 )
                        {   // Prevent underflow.
                            workY = -1;
                        }
                        cw->container.outline_segs[ seg_idx ].y2 =
                                                        (short) workY;

                        // Add segments to draw both a horizontal and
                        // vertical connector to this node.
                        cw->container.outline_segs[seg_idx + 1].x1 =
                                  cw->container.outline_segs[seg_idx].x2;
                        cw->container.outline_segs[seg_idx + 1].y1 =
                                  cw->container.outline_segs[seg_idx].y2;
                        cw->container.outline_segs[seg_idx + 1].x2 =
                                  cw->container.margin_w +
                                    ( cw->container.outline_indent
                                                        * c->depth );
                        if ( c->outline_button == NULL )
                            cw->container.outline_segs[seg_idx + 1].x2
                                               += cw->container.ob_width;
                        cw->container.outline_segs[seg_idx + 1].y2 =
                                  cw->container.outline_segs[seg_idx].y2;
                        seg_idx += 2;
                    }
                    cw->container.outline_segs[ seg_idx ].y2 =
                                                        (short) workY;
                 }
                 point_at_depth[c->depth].y = ob_y + cw->container.ob_height;
            } /* end Outline view XSegment array update */

            /* update y for next node */
            y += c->row_height + vspacing;

            if ( firstVisibleNode  &&  ! afterLastVisibleNode )
            {   // ICLUI: The node is visible, so create a drawing segment
                //        for the horizontal divider below the details
                //        view entry.
                n_detail_segs++;
            }
            node = GetNextNode( wid, node );
        }   /* end of while loop for all nodes */
        cw->container.outline_seg_count_used = seg_idx;

        if ( CtrViewIsDETAIL( cw ) )
        {
            if ( cw->container.detail_count > 0 )
            {
                cw->container.ideal_width = cw->container.tabs[0];
            }
            else
            {
                cw->container.ideal_width = cw->container.margin_w;
            }

            for ( i = 0; i < cw->container.detail_count; i++ )
            {
                if ( ShowColumn( wid, i ) )
                {
                    cw->container.ideal_width += cw->container.tabs[i+1]
                                                + cw->container.hspacing;
                    n_detail_segs++;
                }
            }
        } /* CtrViewIsDETAIL */

        /*
         * Add the margins now.
         */
        cw->container.ideal_width += cw->container.margin_w;

        /* ICLUI: don't subtract vspacing from y so we can output horizontal
         *        separator under detail heading when no objects were added.
         */
        workY = y + cw->container.margin_h;
        cw->container.logicalDisplayHeight =
                  workY + cw->container.verticalDisplayOffset;

        if ( workY > MAX_SHORT )
        {   // Prevent overflow.
            workY = MAX_SHORT;   // 32767
        }
        else if ( workY < 0 )
        {   // Prevent underflow.
            workY = 0;
        }
        cw->container.ideal_height = (Dimension) workY;
        /* ICLUI: original code subtracted 2, don't know why.
         *        Should only subtract one since vertical separators are
         *        between columns (ie. for 3 cols you have 2 vertical lines)
         */
        n_detail_segs = MAX( 0, n_detail_segs - 1 );
    }

    if ( CtrDrawLinesDETAIL( cw )  &&  ( n_detail_segs > 0 ) )
    {
        int     vgroove = vspacing - vspacing/2;
        int     hgroove = cw->container.hspacing -
                             (cw->container.hspacing/2);
        int     x, x1, x2, y1, y2;

        if ( cw->container.detail_seg_count != n_detail_segs )
        {
            if ( cw->container.detail_segs != NULL )
                XtFree( (char*) cw->container.detail_segs );
            cw->container.detail_segs = (XSegment*)
                XtCalloc( n_detail_segs, sizeof( XSegment ) );
            cw->container.detail_seg_count = n_detail_segs;
        }

        seg_idx = 0;
        /*
         * Calculate the horizontal lines.
         */
        x1 = cw->container.margin_w;
        x2 = cw->container.ideal_width - cw->container.margin_w;
        if ( cw->container.detail_heading != NULL )
        {
            /* Account for calls to XuiclSetVerticalDisplayOffset. */
            workY = cw->container.margin_h +
                      cw->container.heading_rect.height +
                      vgroove - cw->container.verticalDisplayOffset;
            if ( workY > 0 )
            {  // ICLUI: The divider below the column headings is visible.
                cw->container.detail_segs[seg_idx].x1 = x1;
                cw->container.detail_segs[seg_idx].x2 = x2;
                cw->container.detail_segs[seg_idx].y1 = workY;
                cw->container.detail_segs[seg_idx].y2 = workY;
                seg_idx++;
            }
        }

        // Iterate all nodes (loop 3).
        node = firstVisibleNode;
        while ( node != NULL )
        {
            // Draw a horizontal divider under all visible details view
            // entries except the last one.
            if ( node == afterLastVisibleNode )
            {   // ICLUI: Stop iterating if none of the following nodes
                //        will be visible.
                break;
            }
            else if ( node != cw->container.last_node )
            {
                c = GetContainerConstraint( node->widget_ptr );
                cw->container.detail_segs[seg_idx].x1 = x1;
                cw->container.detail_segs[seg_idx].x2 = x2;
                cw->container.detail_segs[ seg_idx ].y1
                            = c->row_y + c->row_height + vgroove;
                cw->container.detail_segs[ seg_idx ].y2
                            = cw->container.detail_segs[ seg_idx ].y1;
                seg_idx++;
            }
            node = GetNextNode( wid, node );
        }
        /*
         * Calculate the vertical lines.
         */
        y1 = cw->container.margin_h;
        workY = cw->container.ideal_height - cw->container.margin_h;
        if ( workY > MAX_SHORT )
        {
            workY = MAX_SHORT;
        }
        y2 = workY;

        /* ICLUI: add horizontal spacing to line up lines with cols */
        x = cw->container.tabs[0] + cw->container.hspacing;
        for ( i = 0; i < ( (int) cw->container.detail_count - 1 ); i++ )
        {
            if ( ShowColumn( wid, i ) )
            {
                x += cw->container.tabs[i+1];
                cw->container.detail_segs[seg_idx].x1 = x + hgroove;
                cw->container.detail_segs[seg_idx].x2 = x + hgroove;
                cw->container.detail_segs[seg_idx].y1 = y1;
                cw->container.detail_segs[seg_idx].y2 = y2;
                x += cw->container.hspacing;
                seg_idx++;
            }
        }
        /*
         * If Left-to-Right, reverse all the x1's & x2's.
         * And also adjust them to fit our current size, since
         * x position changes with width in Right-to-Left layout.
         */
        if ( CtrLayoutIsRtoL( cw ) )
        {
            int adjust;

            adjust = cw->core.width - cw->container.ideal_width;
            for ( i = 0; i < cw->container.detail_seg_count; i++ )
            {
                cw->container.detail_segs[i].x1 =
                       MAX( 0,
                            cw->container.ideal_width -
                               cw->container.detail_segs[i].x1 +
                               adjust );
                cw->container.detail_segs[i].x2 =
                       MAX( 0,
                            cw->container.ideal_width -
                               cw->container.detail_segs[i].x2 +
                               adjust );
            }
        }
    }
    else
    {
        if ( cw->container.detail_segs != NULL )
            XtFree( (char*) cw->container.detail_segs );
        cw->container.detail_segs = NULL;
        cw->container.detail_seg_count = 0;
    }

    /*
     * Free the Malloc'd x_at_depth, y_at_depth.
     * If Left-to-Right, reverse all the x1's & x2's
     * and adjust, same as for Detail Lines.
     */
    if ( CtrDrawLinesOUTLINE( cw ) )
    {
        if ( point_at_depth != NULL )
            XtFree( (char*) point_at_depth );
        if ( CtrLayoutIsRtoL( cw ) )
        {
            int adjust;

            adjust = cw->core.width - cw->container.ideal_width;
            for ( i = 0; i < cw->container.outline_seg_count_used; i++ )
            {
                cw->container.outline_segs[i].x1 =
                       MAX( 0,
                            cw->container.ideal_width -
                               cw->container.outline_segs[i].x1 +
                               adjust);
                cw->container.outline_segs[i].x2 =
                       MAX( 0,
                            cw->container.ideal_width -
                               cw->container.outline_segs[i].x2 +
                               adjust);
            }
        }
    }
}

/************************************************************************
 * LayoutSpatial
 ************************************************************************/
static  void
LayoutSpatial(
    Widget  wid)
{
    XmContainerWidget     cw = (XmContainerWidget) wid;
    int                   cell_width,
                          cell_height;
    int                   width_in_cells,
                          height_in_cells;
    XmContainerConstraint c;
    CwidNode              node;
    XPoint                spot;

    /* ICLUI: If nothing's managed, get out */
    if ( cw->container.first_node == NULL )
        return;

    if ( CtrPlaceStyleIsGRID( cw )  ||  CtrPlaceStyleIsCELLS( cw ) )
        /*
         * Let's see if things have changed enough so that we have to reset.
         */
    {
        cell_width = ( CtrViewIsLARGEICON( cw ) ) ?
                          cw->container.large_cell_width :
                          cw->container.small_cell_width;
        cell_height = ( CtrViewIsLARGEICON( cw ) ) ?
                          cw->container.large_cell_height :
                          cw->container.small_cell_height;
        width_in_cells = ( cw->core.width - 2 * cw->container.margin_w )
                                / cell_width;
        height_in_cells = ( cw->core.height - 2 * cw->container.margin_h )
                                / cell_height;

        if ( ( width_in_cells != cw->container.current_width_in_cells )  ||
             ( height_in_cells != cw->container.current_height_in_cells ) )
        {
            ( *( xmContainerClassRec.container_class.place_item ) )
                    ( wid, NULL );
            cw->container.current_width_in_cells = width_in_cells;
            cw->container.current_height_in_cells = height_in_cells;
        }
    }

    node = cw->container.first_node;
    while ( node != NULL )
    {
        cw->container.last_node = node;
        if ( ! CtrItemIsPlaced( node->widget_ptr ) )
        {
            ( *( xmContainerClassRec.container_class.place_item ) )
                    ( wid, node->widget_ptr );
        }
        else
        {
            c = GetContainerConstraint( node->widget_ptr );
            if ( CtrViewIsLARGEICON( cw ) )
            {
                // Both tree view and icon view use the large icon setting.
                // They can't share coordinates, so we have to check for
                // tree view (OUTLINE) and use large_icon_x,y or
                // icon_view_x,y.  LJO
                if ( CtrLayoutIsOUTLINE( cw ) )         /* LJO */
                {                                       /* LJO */
                    spot.x = c->large_icon_x;           /* LJO */
                    spot.y = c->large_icon_y;           /* LJO */
                }                                       /* LJO */
                else                                    /* LJO */
                {                                       /* LJO */
                    spot.x = c->icon_view_x;            /* LJO */
                    spot.y = c->icon_view_y;            /* LJO */
                }                                       /* LJO */
            }                                           /* LJO */
            else
            {
                spot.x = c->small_icon_x;
                spot.y = c->small_icon_y;
            }
            PlaceCwid( node->widget_ptr, spot.x, spot.y );
        }
        node = GetNextNode( wid, node );
    }
}

/************************************************************************
 * SetCellSize
 ************************************************************************/
static  void
SetCellSize(
    Widget      wid)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    CwidNode            node;
    Dimension           cell_width = ZERO_CELL_DIM;
    Dimension           cell_height = ZERO_CELL_DIM;

    node = cw->container.first_node;
    while ( node != NULL )
    {
        if ( node == cw->container.first_node )
        {
            /*
             * Initialize to first_node width/height.
             */
            cell_width = ((Widget)node->widget_ptr)->core.width;
            cell_height = ((Widget)node->widget_ptr)->core.height;
        }
        if ( CtrPlaceStyleIsGRID( cw ) )
        {
            /*
             * GRID: cell should be size of largest cwid.
             */
            cell_width = MAX( cell_width,
                              ((Widget)node->widget_ptr)->core.width );
            cell_height = MAX( cell_height,
                               ((Widget)node->widget_ptr)->core.height );
        }
        else
        {
            /*
             * CELLS: cell should be size of smallest cwid.
             */
            cell_width = MIN( cell_width,
                              ((Widget)node->widget_ptr)->core.width );
            cell_height = MIN( cell_height,
                               ((Widget)node->widget_ptr)->core.height );
        }
        node = GetNextNode( wid, node );
    }

    if ( CtrViewIsLARGEICON( cw ) )
    {
        /* ICLUI: made assignments below unconditional.
         *   Original code only made assigment if current value
         *   was ZERO_CELL_DIM
         */
        cw->container.large_cell_width = cell_width;
        cw->container.large_cell_height = cell_height;
    }
    else
    {
        cw->container.small_cell_width = cell_width;
        cw->container.small_cell_height = cell_height;
    }
}

/************************************************************************
 * SizeOutlineButton
 ************************************************************************/
static  void
SizeOutlineButton(
    Widget  wid)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    Widget              ob;
    Dimension           width, height;

    /*
     * Create & Delete dummy outline button so we can get size.
     */
    cw->container.self = True;
    ob = XtVaCreateWidget( OBNAME,
                           xmPushButtonWidgetClass, (Widget) cw,
                           XmNtraversalOn, False,
                           XmNlabelType, XmPIXMAP,
                           XmNlabelPixmap, cw->container.expanded_state_pixmap,
                           NULL );
    XtVaGetValues( ob,
                   XmNwidth, &cw->container.ob_width,
                   XmNheight, &cw->container.ob_height,
                   NULL );
    XtVaSetValues( ob,
                   XmNlabelPixmap, cw->container.collapsed_state_pixmap,
                   NULL );
    XtVaGetValues( ob,
                   XmNwidth, &width,
                   XmNheight, &height,
                   NULL );
    XtDestroyWidget( ob );
    cw->container.self = False;
    cw->container.ob_width = MAX( cw->container.ob_width, width );
    cw->container.ob_height = MAX( cw->container.ob_height, height );
}

/************************************************************************
 * UpdateGCs
 ************************************************************************/
static  void
UpdateGCs(
    Widget  wid)
{
    XmContainerWidget       cw = (XmContainerWidget) wid;
    XFontStruct *           fs = NULL;
    XGCValues               values;
    XtGCMask                valueMask;

    /*
     * Free any previous GC's
     */
    if ( cw->container.normalGC != NULL )
        XtReleaseGC( wid, cw->container.normalGC );
    if ( cw->container.inverseGC != NULL )
        XtReleaseGC( wid, cw->container.inverseGC );
    if ( cw->container.marqueeGC != NULL )
        XtReleaseGC( wid, cw->container.marqueeGC );
    /*
     * Get GC's
     */
    _XmFontListGetDefaultFont( cw->container.render_table, &fs );
    valueMask = GCForeground | GCBackground;
    values.foreground = cw->manager.foreground;
    values.background = cw->core.background_pixel;
    if ( fs != NULL )
    {
        values.font = fs->fid;
        valueMask |= GCFont;
    }
    cw->container.normalGC = XtGetGC( wid, valueMask, &values );

    valueMask = GCForeground | GCBackground;
    values.foreground = cw->core.background_pixel;
    values.background = cw->manager.foreground;
    if ( fs != NULL )
    {
        values.font = fs->fid;
        valueMask |= GCFont;
    }
    cw->container.inverseGC = XtGetGC( wid, valueMask, &values );

    valueMask = GCForeground | GCFunction;
    values.foreground = cw->core.background_pixel ^
                            cw->manager.foreground;
    values.function = GXxor;
    cw->container.marqueeGC = XtGetGC( wid, valueMask, &values );
}

/************************************************************************
 * SizeOneSpace
 ************************************************************************/
static  Dimension
SizeOneSpace(
    XmFontList     fl)
{
    XmString       aspace;
    Dimension      width, height;

    aspace = XmStringCreateSimple( " " );
    XmStringExtent( fl, aspace, &width, &height );
    XmStringFree( aspace );
    return width;
}


/************************************************************************
 * CreateDetailHeading
 ************************************************************************/
static  void
CreateDetailHeading(
    Widget  wid)
{
#ifdef DEBUG
    printf( "cnr::CreateDetailHeading\n" );
    fflush( stdout );
#endif

    XmContainerWidget   cw = (XmContainerWidget) wid;
    _XmString          *xmstr_table;
    int                 i;
    Dimension           w, h;

    XtWidgetGeometry    geo_current;
    XtWidgetGeometry    geo_desired;
    XtGeometryResult    geo_response = XtGeometryYes;
    XtGeometryResult    pwid_geo_response = XtGeometryYes;

    cw->container.heading_rect.height = 0;
    cw->container.heading_col1_width = 0;
    if ( ( cw->container.detail_count == 0 )  ||
         ( cw->container.detail_heading == NULL ) )
        return;
    /*
     * Create internal form of Detail Column Header.
     */
    xmstr_table = (_XmString*)
        XtMalloc( cw->container.detail_count * sizeof( _XmString ) );
    for ( i = 0; i < cw->container.detail_count; i++ )
    {
         xmstr_table[i] =
             _XmStringCreate( (XmString)
                                cw->container.detail_heading[i] );
         _XmStringExtent( cw->container.render_table,
                          xmstr_table[i], &w, &h );

         cw->container.heading_rect.height =
                 MAX( h, cw->container.heading_rect.height );
         cw->container.tabs[i+1] =
                 MAX( w, cw->container.tabs[i+1] );
    }
    if ( cw->container.detail_count > 1 )
        cw->container.heading_col1_width = cw->container.tabs[1];
    cw->container.detail_heading = xmstr_table;

    /* ICLUI: to be able to display the detail headings when no objects
              have been added to the Container, we have to readjust the
              size so that Redisplay() will be able to paint.
     */
    if ( cw->container.first_node == NULL )
    {
        /* Layout will get us the right size */
        LayoutOutlineDetail( wid );
        geo_current.request_mode = CWWidth | CWHeight;
        geo_current.width = cw->core.width;
        geo_current.height = cw->core.height;
        geo_response =
             ( *( xmContainerClassRec.core_class.query_geometry ) )
                     ( wid, &geo_current, &geo_desired );
        if ( geo_response != XtGeometryYes )
            pwid_geo_response =
                  _XmMakeGeometryRequest( wid, &geo_desired );

    }
}

/************************************************************************
 * CreateEntryDetail
 ************************************************************************/
static  void
CreateEntryDetail(
    Widget  cwid)
{
#ifdef DEBUG
    printf( "cnr::CreateEntryDetail\n" );
    fflush( stdout );
#endif

    XmContainerWidget       cw = (XmContainerWidget) XtParent( cwid );
    XmContainerConstraint   c = GetContainerConstraint( cwid );
    _XmString              *xmstr_table;
    int                     i;
    Dimension               w, h;

    c->detail_height = 0;
    c->entry_detail_count = cw->container.detail_count;
    if ( ( cw->container.detail_count == 0 )  ||
         ( c->entry_detail == NULL ) )
        return;

    xmstr_table = (_XmString*)
        XtMalloc( cw->container.detail_count * sizeof( _XmString ) );
    for ( i = 0; i < cw->container.detail_count; i++ )
    {
         xmstr_table[i] =
             _XmStringCreate( (XmString) c->entry_detail[i] );
         _XmStringExtent( cw->container.render_table,
                          xmstr_table[i], &w, &h );
         c->detail_height = MAX( c->detail_height, h );
         if ( ( c->depth == 0 )  ||  CtrLayoutIsOUTLINE( cw ) )
             cw->container.tabs[i+1] =
                            MAX( cw->container.tabs[i+1], w);
    }
    c->entry_detail = xmstr_table;
}

/************************************************************************
 * ResetTabs
 ************************************************************************/
static  void
ResetTabs(
    Widget  cwid)
{
#ifdef DEBUG
    printf( "cnr::ResetTabs\n" );
    fflush( stdout );
#endif
    XmContainerWidget       cw = (XmContainerWidget) XtParent( cwid );
    XmContainerConstraint   c = GetContainerConstraint( cwid );
    int                     i;

    if ( ( cw->container.detail_count == 0 )  ||
         ( c->entry_detail == NULL ) )
        return;

    if ( ( c->depth == 0 )  ||  CtrLayoutIsOUTLINE( cw ) )
    {
        Dimension w, h;
        Boolean reset_required = False;

        /* if the deleted entry has any column sizes == to tab array entry,
         * reset tabs array to account for the deleted entry.
         */
        for ( i = 0; i < cw->container.detail_count; i++ )
        {
            _XmStringExtent( cw->container.render_table,
                             c->entry_detail[i], &w, &h );
            if ( w == cw->container.tabs[i+1] )
            {
                reset_required = True;
                break;
            }
        }

        if ( reset_required )     /* reset tabs array */
        {
            CwidNode  node;

            for ( i = 0; i < cw->container.detail_count; i++ )
                cw->container.tabs[i+1] = 0;

            if ( cw->container.detail_heading )
                for ( i = 0; i < cw->container.detail_count; i++ )
                {
                    _XmStringExtent( cw->container.render_table,
                                     cw->container.detail_heading[i],
                                     &w, &h );
                    cw->container.tabs[i+1] =
                            MAX( w, cw->container.tabs[i+1] );
                }

            node = cw->container.first_node;

            if ( node == NULL )           /* last details object */
                cw->container.heading_col1_width = 0;

            for ( node = cw->container.first_node;
                  node != 0;
                  node = node->next_ptr )
            {
                XmContainerConstraint nc;

                if ( node->widget_ptr == cwid )
                    continue;

                nc = GetContainerConstraint( node->widget_ptr );

                if ( nc->entry_detail )
                {
                    for ( i = 0; i < cw->container.detail_count; i++ )
                    {
                        _XmStringExtent( cw->container.render_table,
                                         nc->entry_detail[i], &w, &h );
                        cw->container.tabs[i+1] =
                                MAX( w, cw->container.tabs[i+1] );
                    }
                }
            }
        }
    }
}


/************************************************************************
 * ShowColumn
 ************************************************************************/
static  Boolean
ShowColumn(
    Widget  wid,
    int     column)
{
    return True;
}

/************************************************************************
 * ExposeDetail
 ************************************************************************/
static  void
ExposeDetail(
    Widget  cwid)
{
    XmContainerWidget       cw = (XmContainerWidget) XtParent( cwid );
    XmContainerConstraint   c = GetContainerConstraint( cwid );
    Position                x;
    Dimension               width;

    if ( ! XtIsRealized( XtParent( cwid ) ) )
        return;
    if ( c->entry_detail == NULL )
        return;
    x = cw->container.tabs[0] + cw->container.hspacing;
    if ( cw->container.showIconInDetail )
        x += cw->container.tabs[1];
    width = MAX( 0, cw->core.width - x );
    if ( CtrLayoutIsRtoL( cw ) )
        x = 0;
    XClearArea( XtDisplay( XtParent( cwid ) ),
                XtWindow( XtParent( cwid ) ),
                x, c->row_y, width, c->row_height, True );
}

/************************************************************************
 * ChangeView
 ************************************************************************/
static  void
ChangeView(
    Widget          wid,
    unsigned char   view)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    CwidNode            node;

    /* ICLUI: Set a flag used by GeometryManager to avoid running
     *        layout code for each icon gadget that we change in
     *        this loop.
     */
    cw->container.viewChangeInProgress = True;

    node = cw->container.first_node;
    while ( node != NULL )
    {
        cw->container.self = True;
        XtVaSetValues( node->widget_ptr, XmNviewType, view, NULL );
        cw->container.self = False;

        if ( node->child_ptr != NULL )
            node = node->child_ptr;
        else if ( node->next_ptr != NULL )
            node = node->next_ptr;
        else
            node = GetNextUpLevelNode( node );
    }

    /*
     * ICLUI: Force a new layout now that we've updated all of the
     *        icon gadgets.
     */
    cw->container.viewChangeInProgress = False;

    if ( CtrPlaceStyleIsGRID( wid ) )
    {
        PlaceItemReset( wid );
        InvalidateAllCells( cw );
    }

    Layout( wid );
    RequestNewSize( wid );
}

/************************************************************************
 * NewNode
 ************************************************************************/
static  CwidNode
NewNode(
    Widget  cwid)
{
    XmContainerConstraint   c = GetContainerConstraint( cwid );
    CwidNode                new_node;

    /*
     * Create the new CwidNode structure.
     */
    new_node = (CwidNode) XtCalloc( 1, sizeof( XmCwidNodeRec ) );
    new_node->widget_ptr = cwid;    /* node ----> widget link */
    c->node_ptr = new_node;         /* widget --> node link */
    return new_node;
}

/************************************************************************
 * InsertNode
 ************************************************************************/
static  void
InsertNode(
    CwidNode        node)
{
#ifdef DEBUG
    printf( "cnr::InsertNode\n" );
    fflush( stdout );
#endif
    XmContainerWidget       cw;
    XmContainerConstraint   c;
    XmContainerConstraint   pc;     /* parent's constraints */
    XmContainerConstraint   sc;     /* sibling's constraints */
    Widget          cwid;
    CwidNode        prev_node;
    CwidNode        next_node;
    CwidNode        parent_node;
    Boolean         all_visible;

    cwid = node->widget_ptr;
    cw = (XmContainerWidget) XtParent( cwid );
    c = GetContainerConstraint( cwid );

    /*
     * Find the first cwid within XmNentryParent, NULL if none.
     */
    if ( c->entry_parent == NULL )
    {
        parent_node = NULL;
        prev_node = cw->container.first_node;
    }
    else
    {
        pc = GetContainerConstraint( c->entry_parent );
        parent_node = pc->node_ptr;
        prev_node = parent_node->child_ptr;
    }

    if ( prev_node == NULL )
    {
        /*
         * Assume this is the first and only cwid within XmNentryParent.
         */
        next_node = NULL;
        if ( ( c->entry_parent == NULL )  &&
             ( c->position_index == UNSPECIFIED_POSITION_INDEX ) )
            c->position_index = 0;
    }
    else
    {
        /*
         * Chain through this level until we find the correct position.
         */
        next_node = prev_node;
        prev_node = NULL;
        while ( next_node != NULL )
        {
            sc = GetContainerConstraint( next_node->widget_ptr );
            if ( ( c->position_index != UNSPECIFIED_POSITION_INDEX )  &&
                 ( c->position_index <= sc->position_index ) )
                break;
            prev_node = next_node;
            next_node = next_node->next_ptr;
        }
        /*
         * Set XmNpositionIndex, if required.
         */
        if ( c->position_index == UNSPECIFIED_POSITION_INDEX )
        {
            sc = GetContainerConstraint( prev_node->widget_ptr );
            c->position_index = sc->position_index + 1;
        }
    }

    /*
     * Insert the node into the linked list.
     */
    node->child_ptr = NULL;
    node->parent_ptr = parent_node;
    if ( ( node->prev_ptr = prev_node ) != NULL )
        prev_node->next_ptr = node;
    if ( ( node->next_ptr = next_node ) != NULL )
        next_node->prev_ptr = node;
#ifdef ORI      /* ER: */
    if ( ( parent_node != NULL )  &&  ( node->prev_ptr == NULL ) )
        parent_node->child_ptr = node;
#else           /* ER: */
    if ( ( parent_node != NULL )  &&  ( node->prev_ptr == NULL ) )
    {
        parent_node->child_ptr = node;

        if ( pc->outline_button == NULL )
        {
            MakeOutlineButton( c->entry_parent );
            if ( ( ! pc->visible_in_outline )  ||
                 ( ! CtrLayoutIsOUTLINE( cw ) ) )
                HideCwid( pc->outline_button );
        }
    }
#endif          /* ER: */

    /*
     * Update cw->container.first_node, if we're now the first node.
     */
    if ( node->next_ptr == cw->container.first_node )
    {
        cw->container.first_node = node;
    }

    /* ER: */
    /*
     * Update cw->container.last_node, if we're now the last node.
     *
     * use GetPrevNode to avoid conflicts between individual
     * view types: Detail, Spatial, Outline
     */
    prev_node = GetPrevNode( (Widget) cw, node );
    if ( prev_node == cw->container.last_node )
        cw->container.last_node = node;

    /* set visible_in_outline if all parents are visible and expanded */
    all_visible = True;
    parent_node = node->parent_ptr;
    while ( parent_node  &&  all_visible )
    {
        sc = GetContainerConstraint( parent_node->widget_ptr );
        all_visible = sc->visible_in_outline  &&
                       ( sc->outline_state == XmEXPANDED );
        parent_node = sc->node_ptr->parent_ptr;
    }

    if ( all_visible )
    {
        sc = GetContainerConstraint( node->widget_ptr );
        sc->visible_in_outline = True;
    }
}

/************************************************************************
 * XuiclSeverNode
 ************************************************************************/
void
XuiclSeverNode (Widget widget)
{
    XmContainerConstraint c = GetContainerConstraint( widget );
    XmContainerWidget     cw = (XmContainerWidget) XtParent( widget );
    unsigned char         ucVisualEmphasis;

    /* XuiclSeverNode is called to remove an object from the container.
     * Some of the removal is done by ChangeManaged and ConstraintDestroy
     * called in phase 2 of XtDestroyWidget. Problem is that by that time
     * new objects might already have been created - and if the destroyed
     * object was selected and it was the last object, the first newly
     * created object will not be selected. So deselect the severed object
     * first.
     */

    CwidNode node = c->node_ptr;
    Widget wid( NULL );

    if ( node->next_ptr )
        wid = node->next_ptr->widget_ptr;
    else if ( node->prev_ptr )
        wid = node->prev_ptr->widget_ptr;
    else if ( node->parent_ptr )
        wid = node->parent_ptr->widget_ptr;

    /* ConstraintSetValues calls CallSelectCB to invoke selection callback.
     * Prevent this for case where we are severing the node - causes problems.
     */
    /* defect 27346 do let the call back go through as we now need to handle
     * cases where the selected emphasis has to move
     */
    XtVaGetValues( widget, XmNvisualEmphasis, &ucVisualEmphasis, NULL );
    if ( ucVisualEmphasis == XmSELECTED )
    {
        /* cw->container.severing_node = True;  */
        XtVaSetValues( widget, XmNvisualEmphasis, XmNOT_SELECTED, NULL );
        /* cw->container.severing_node = False; */
        /* If we are deleting the only selected cnr object, reassign selected
         * emphasis if in single selection mode. Note that the Win and OS/2
         * cnr are always in single selection mode when in tree view. The
         * Motif cnr widget does not have to be but we bow to the gods of
         * portability and consistency.
         */
        if ( wid  && 
             ( CtrPolicyIsSINGLE( cw )  || 
               ( CtrLayoutIsOUTLINE( cw )  &&
                 cw->container.selected_item_count == 0 ) ) )
        {
            unsigned char save_state = cw->container.selection_state;
            cw->container.selection_state = XmSELECTED;
            MarkCwid( wid, False );
            cw->container.anchor_cwid = wid;
            cw->container.selection_state = save_state;
            CallSelectCB( (Widget) cw, NULL, XmAUTO_CHANGE );
        }
    }

    

    /* Now reset the loc_cursor_cwid if necessary, to allow an item created
     * before ConstraintDestroy is called to have the loc cursor set, if that
     * item is the first one created after this one is desroyed
     */
    if ( cw->container.loc_cursor_cwid == widget )
    {
        /* cw->container.loc_cursor_cwid = NULL; */
        /* SetLocationCursor( (Widget) cw, NULL ); */
        SetLocationCursor( (Widget) cw, wid ); 
    }

    /* d5992 (ICnrControl::removeObjects() not working properly with modal)
     * Hide the cwid if in outline, since 2 phase destroy might
     * not run to completion before cwid shows up again (showModal case)
     */
    if ( CtrLayoutIsOUTLINE( cw ) )
    {
        HideCwid( widget );

        if ( c->outline_button != NULL )     /* has no effect */
        {
            HideCwid( c->outline_button );
        }
    }

    /* Now sever the node, which resets container.first_node if necessary */
    SeverNode( c->node_ptr );

    /* remove from the spatial layout representation */
    ( *( xmContainerClassRec.container_class.remove_item ) )
            ( XtParent( widget ), widget );

#if PERFORMANCE
    /* Now instead of resetting the location for newly placed items by
     *    PlaceItemReset( XtParent(widget) );
     * Rather force LayoutSpatial() to re-calculate new cell width
     * and height for new item. PlaceItemReset is expensive, and
     * setting current_height_in_cells = 0 forces PlaceItemReset to
     * be done fewer times. Problem is that this can cause GetCellFromCoord
     * to return negative value, so be careful. Revisit later!
     */
    XmContainerWidget cw = (XmContainerWidget) XtParent( widget );
    cw->container.current_height_in_cells = 0;
    cw->container.current_width_in_cells = 0;
#else
    /* Reset the location for newly placed items
     */
    if ( CtrLayoutIsSPATIAL( XtParent( widget ) ) )
    {
        PlaceItemReset( XtParent( widget ) );
        InvalidateAllCells( (XmContainerWidget) XtParent( widget ) );
    }
#endif

    /* call ResetTabs to reset the tabs array if necessary
     */
    ResetTabs( widget );
}

/************************************************************************
 * SeverNode
 ************************************************************************/
static  void
SeverNode(
    CwidNode        node)
{
    XmContainerWidget       cw;
    CwidNode                parent_node;
    XmContainerConstraint   pc;
    CwidNode                prev_node;
    CwidNode                next_node;

    if ( node == NULL )
        return;

    cw = (XmContainerWidget) XtParent( node->widget_ptr );

    /*
     * Find new cw->container.first_node, if we're now the first node.
     */
    if ( node == cw->container.first_node )
    {
        if ( node->next_ptr != NULL )
            cw->container.first_node = node->next_ptr;
        else
            cw->container.first_node = GetNextUpLevelNode( node );
    }

    /* ER: don't forget to set Container's last_node
     * if LayoutSpatial and LayoutDetail this is done;
     * but in othercase none takes care; so do it here!
     */
    if ( node == cw->container.last_node )
    {
        cw->container.last_node = GetPrevNode( (Widget)cw, node );
    }

    /*
     * If we're child #1, fix up parent-child pointers.
     */
    if ( ( node->prev_ptr == NULL )  &&
         ( node->parent_ptr != NULL ) )
    {
        parent_node = node->parent_ptr;
        parent_node->child_ptr = node->next_ptr;
        /*
         * Check if former parent is now childless.
         */
        pc = GetContainerConstraint( parent_node->widget_ptr );
        if ( ( parent_node->child_ptr == NULL )  &&
             ( pc->outline_button != NULL ) )
        {
            /* d5992 ICnrControl::removeObjects() not working
             *                            properly with modal
             * Hide the cwid if in outline,
             * since 2 phase destroy might
             * not run to completion before cwid
             * shows up again (showModal case)
             */
            if ( CtrLayoutIsOUTLINE( cw ) )
            {
                HideCwid( pc->outline_button );
            }
            XtDestroyWidget( pc->outline_button );
            pc->outline_button = NULL;
        }
    }

    /*
     * Unlink node from the linked list.
     */
    if ( node->prev_ptr != NULL )
    {
        prev_node = node->prev_ptr;
        prev_node->next_ptr = node->next_ptr;
    }
    if ( node->next_ptr != NULL )
    {
        next_node = node->next_ptr;
        next_node->prev_ptr = node->prev_ptr;
    }


    /* ER: clean up */
    node->next_ptr = NULL;
    node->prev_ptr = NULL;
    node->parent_ptr = NULL;
    node->child_ptr = NULL;
    /* ER: */
}

/************************************************************************
 * DeleteNode
 ************************************************************************/
static  void
DeleteNode(
    Widget  cwid)
{
    XmContainerConstraint   c = GetContainerConstraint( cwid );
    CwidNode        target_node;
    CwidNode        child_node;
    CwidNode        target_child;

#ifdef DEBUG
    printf( "cnr::DeleteNode\n" );
    fflush( stdout );
#endif

    if ( ( target_node = c->node_ptr ) == NULL )
        return;

    /*
     * Delete any children first.
     */
    child_node = target_node->child_ptr;
    while ( child_node != NULL )
    {
        target_child = child_node;
        child_node = child_node->next_ptr;
        DeleteNode( target_child->widget_ptr );
    }

    /* ICLUI: FIX
     *   Remove call to SeverNode.
     *   DeleteNode is only called from ConstraintDestroy, and that's
     *   only called by the Intrinsics in Phase 2 of Destroy.
     *   But at that point Phase 2 has already done an XtUnmanageChild
     *   (since Container is a Composite) and ChangeManaged has already called
     *   SeverNode. So we end up calling SeverNode twice. Once effect of this is
     *   that outline_buttons can be lost when the first child is destroyed.
     */
#if 0
    SeverNode( target_node );
#endif
    XtFree( (char*) target_node );
    c->node_ptr = NULL;
    c->visible_in_outline = False;
}

/************************************************************************
 * GetNextNode
 ************************************************************************/
static  CwidNode
GetNextNode(
    Widget          wid,
    CwidNode        start_node)
{
    XmContainerWidget       cw = (XmContainerWidget) wid;
    XmContainerConstraint   c;
    CwidNode                node;

    node = start_node;
    if ( ! CtrLayoutIsOUTLINE( cw ) )
    {
        while ( node != NULL )
        {
            if ( node->next_ptr == NULL )
                return NULL;
            node = node->next_ptr;
            if ( XtIsManaged( node->widget_ptr ) )
                return node;
        }
        return NULL;
    }

    while ( node != NULL )       /* depth-first search of tree */
    {
        if ( node->child_ptr != NULL )
            node = node->child_ptr;
        else if ( node->next_ptr != NULL )
            node = node->next_ptr;
        else
            node = GetNextUpLevelNode(node);
        if ( node != NULL )
        {
            c = GetContainerConstraint( node->widget_ptr );
            if ( ( c->visible_in_outline )  &&
                 XtIsManaged( node->widget_ptr ) )
                return node;
            else
                return GetNextUpLevelNode( node );
            }
    }
    return NULL;
}

/************************************************************************
 * GetNextUpLevelNode
 ************************************************************************/
static  CwidNode
GetNextUpLevelNode(
    CwidNode       start_node)
{
    CwidNode       node;

    node = start_node;
    while ( node != NULL )
    {
        node = node->parent_ptr;
        if ( node != NULL )
            if ( node->next_ptr != NULL )
                return node->next_ptr;
    }
    return NULL;
}

/************************************************************************
 * GetPrevNode
 ************************************************************************/
static  CwidNode
GetPrevNode(
    Widget          wid,
    CwidNode        start_node)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    CwidNode            node;
    CwidNode            next_node;

    if ( CtrLayoutIsSPATIAL( cw ) )
        return start_node->prev_ptr;

    node = start_node;
    while ( node != NULL )
    {
        if ( node->prev_ptr != NULL )
            node = node->prev_ptr;
        else if ( node->parent_ptr != NULL )
            node = node->parent_ptr;
        else
            return NULL;
        next_node = node;
        while ( node != NULL )
        {
            next_node = GetNextNode( (Widget) cw, node );
            if ( next_node == start_node )
                return node;
            else
                node = next_node;
        }
    }
    return NULL;
}

/************************************************************************
 * StartSelect
 ************************************************************************/
static  void
StartSelect(
    Widget          wid,
    XEvent         *event,
    String         *params,        /* unused */
    Cardinal       *num_params)    /* unused */
{
    XmContainerWidget       cw = (XmContainerWidget) wid;
    Time                    click_time;
    int                     multi_click_time;
    Widget                  current_cwid;
    XmContainerConstraint   c;

    multi_click_time = XtGetMultiClickTime( XtDisplay( wid ) );
    click_time = event->xbutton.time;
    if ( ( click_time - cw->container.last_click_time ) <
                                             multi_click_time )
    {
        cw->container.last_click_time = click_time;
        if ( cw->container.anchor_cwid != NULL )
            CallActionCB( cw->container.anchor_cwid, event );
        return;
    }
    cw->container.last_click_time = click_time;

    cw->container.no_auto_sel_changes = False;
    current_cwid = LocatePointer( wid, event->xbutton.x,
                                  event->xbutton.y );
    if ( CtrPolicyIsSINGLE( cw ) )
    {
        /*
          The following "if" statement  was commented out to allow
          selection of the cursored object when none is selected in
          single selection mode.  Defect 2357.
        */
        /*  if (current_cwid == cw->container.anchor_cwid)
                    return;
        */
        cw->container.no_auto_sel_changes |= DeselectAllCwids(wid);
        cw->container.anchor_cwid = current_cwid;
        if (cw->container.anchor_cwid == NULL)
                return;
        cw->container.no_auto_sel_changes |=
                        MarkCwid(cw->container.anchor_cwid,False);
        SetLocationCursor((Widget) cw, cw->container.anchor_cwid);
        return;
    }
    if ( CtrPolicyIsBROWSE( cw ) )
    {
        if ( current_cwid != cw->container.anchor_cwid )
        {
            cw->container.no_auto_sel_changes |=
                                   DeselectAllCwids( wid );
            cw->container.anchor_cwid = current_cwid;
            if ( cw->container.anchor_cwid != NULL )
            {
                cw->container.no_auto_sel_changes |=
                        MarkCwid( cw->container.anchor_cwid, True );
                SetLocationCursor( (Widget) cw,
                                   cw->container.anchor_cwid );
            }
        }
        if ( CtrIsAUTO_SELECT( cw ) )
            CallSelectCB( wid, event, XmAUTO_BEGIN );
        return;
    }
    if ( ! cw->container.extending_mode )
        cw->container.no_auto_sel_changes |= DeselectAllCwids( wid );
    cw->container.anchor_cwid = current_cwid;
    if ( cw->container.anchor_cwid != NULL )
        SetLocationCursor( (Widget) cw, cw->container.anchor_cwid );
    cw->container.anchor_point.x = event->xbutton.x;
    cw->container.marquee_smallest.x = event->xbutton.x;
    cw->container.marquee_largest.x = event->xbutton.x;
    cw->container.anchor_point.y = event->xbutton.y;
    cw->container.marquee_smallest.y = event->xbutton.y;
    cw->container.marquee_largest.y = event->xbutton.y;
    if ( CtrTechIsTOUCH_OVER( cw ) )
    {
        if ( cw->container.anchor_cwid == NULL )
            cw->container.marquee_mode = True;
        else
            cw->container.marquee_mode = False;
    }
    if ( cw->container.anchor_cwid == NULL )
    {
        if ( CtrIsAUTO_SELECT( cw ) )
            CallSelectCB( wid, event, XmAUTO_BEGIN );
        cw->container.started_in_anchor = False;
        return;
    }
    else
        cw->container.started_in_anchor = True;
    if ( cw->container.extending_mode )
    {
        c = GetContainerConstraint( cw->container.anchor_cwid );
        if ( c->selection_state == XmSELECTED )
            cw->container.selection_state = XmNOT_SELECTED;
        else
            cw->container.selection_state = XmSELECTED;
    }
    cw->container.no_auto_sel_changes |=
                    MarkCwid( cw->container.anchor_cwid, True );
    if ( CtrIsAUTO_SELECT( cw ) )
        CallSelectCB( wid, event, XmAUTO_BEGIN );
    if ( ( CtrTechIsMARQUEE_ES( cw )  ||
           CtrTechIsMARQUEE_EB( cw ) )  &&
         ( ! CtrViewIsDETAIL( cw ) ) )
    {
        RecalcMarquee( wid, cw->container.anchor_cwid,
                       event->xbutton.x, event->xbutton.y );
        DrawMarquee( wid );
        cw->container.marquee_drawn = True;
    }
}

/************************************************************************
 * ProcessButtonMotion
 ************************************************************************/
static  Boolean
ProcessButtonMotion(
    Widget          wid,
    XEvent         *event,
    String         *params,        /* unused */
    Cardinal       *num_params)    /* unused */
{
    XmContainerWidget       cw = (XmContainerWidget) wid;
    Widget                  current_cwid;
    Boolean                 selection_changes = False;
    Boolean                 find_anchor = False;
    XmContainerConstraint   c;

#ifdef DEBUG
    printf( "cnr::processButtonMotion\n" );
    fflush( stdout );
#endif

    current_cwid = LocatePointer( wid, event->xbutton.x,
                                  event->xbutton.y );
    if ( CtrPolicyIsBROWSE( cw ) )
    {
        if ( current_cwid == cw->container.anchor_cwid )
            return False;
        if ( cw->container.anchor_cwid != NULL )
        {
            cw->container.selection_state = XmNOT_SELECTED;
            selection_changes = MarkCwid( cw->container.anchor_cwid,
                                          False );
            cw->container.selection_state = XmSELECTED;
        }
        if ( current_cwid != NULL )
            selection_changes |= MarkCwid( current_cwid, True );
        cw->container.anchor_cwid = current_cwid;
        return selection_changes;
    }
    /* CtrPolicyIsMULTIPLE || CtrPolicyIsEXTENDED */
    /* CUA Random Selection Technique */
    if ( ! CtrViewIsDETAIL( cw )  &&
         CtrLayoutIsSPATIAL( cw )  &&
         ( ! cw->container.marquee_mode ) )
    {
        if ( current_cwid == NULL )
            return False;
        if ( cw->container.anchor_cwid == NULL )
        {
            /* Gotta have a reference point for toggling */
            c = GetContainerConstraint( current_cwid );
            if ( c->selection_visual == XmSELECTED )
                cw->container.selection_state = XmNOT_SELECTED;
            else
                cw->container.selection_state = XmSELECTED;
            cw->container.anchor_cwid = current_cwid;
        }
        return MarkCwid( current_cwid, True );
    }
    /* CUA Range Selection Technique */
    if ( CtrViewIsDETAIL( cw )  ||
         ( CtrLayoutIsOUTLINE( cw )  &&
           ! cw->container.marquee_mode ) )
        return MarkCwidsInRange( wid, cw->container.anchor_cwid,
                                 current_cwid, True );
    /* CUA Marquee Selection Technique */
    find_anchor = ( cw->container.anchor_cwid == NULL );
    RecalcMarquee( wid, current_cwid, event->xbutton.x,
                   event->xbutton.y );
    selection_changes = MarkCwidsInMarquee( wid, find_anchor, True );
    DrawMarquee( wid );
    cw->container.marquee_drawn = True;
    return selection_changes;
}

/************************************************************************
 * LocatePointer
 ************************************************************************/
static  Widget
LocatePointer(
    Widget  wid,
    int     x,
    int     y)
{
    XmContainerWidget       cw = (XmContainerWidget) wid;
    CwidNode                node;
    XmContainerConstraint   c;
    Widget                  prev_cwid;
    XmGadget                g;

    if ( CtrViewIsDETAIL( cw )  &&
         ( cw->container.detail_count != 0 ) )
    {
        int                 x1,x2;

        x1 = cw->container.margin_w;
        x2 = cw->container.ideal_width - cw->container.margin_w;
        if ( CtrLayoutIsLtoR( cw ) )
            x2 = MIN( x2, cw->core.width );
        if ( CtrLayoutIsRtoL( cw ) )
        {
            x1 = MAX( 0, cw->core.width - x2 );
            x2 = cw->core.width - cw->container.margin_w;
        }
        if ( ( x < x1 )  ||  ( x2 < x ) )
            return NULL;
        node = cw->container.first_node;
        prev_cwid = NULL;
        while ( node != NULL )
        {
            c = GetContainerConstraint( node->widget_ptr );
            if ( y < c->row_y )
                return prev_cwid;
            if ( y <= c->row_y + c->row_height )
                return node->widget_ptr;
            if ( c->row_y + c->row_height > cw->core.height )
                return NULL;
            prev_cwid = node->widget_ptr;
            node = GetNextNode( wid, node );
        }
        return NULL;
    }
    node = cw->container.first_node;
    prev_cwid = NULL;
    while ( node != NULL )
    {
        c = GetContainerConstraint( node->widget_ptr );
        g = (XmGadget) node->widget_ptr;
        if ( ( y < g->rectangle.y )  &&
             CtrLayoutIsOUTLINE( cw ) )
            return prev_cwid;
        if ( ( g->rectangle.x <= x )  &&
             ( x <= g->rectangle.x + g->rectangle.width )  &&
             ( g->rectangle.y <= y )  &&
             ( y <= g->rectangle.y + g->rectangle.height ) )
            return node->widget_ptr;
        if ( ( g->rectangle.y + g->rectangle.height >
                                         cw->core.height )  &&
             CtrLayoutIsOUTLINE( cw ) )
            return NULL;
        if ( ( g->rectangle.x <= x )  &&
             ( x <= g->rectangle.x + g->rectangle.width ) )
            prev_cwid = node->widget_ptr;
        else
            prev_cwid = NULL;
        node = GetNextNode( wid, node );
    }
    return NULL;
}

/************************************************************************
 * SelectAllCwids
 ************************************************************************/
static  Boolean
SelectAllCwids(
    Widget  wid)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    CwidNode            node;
    Boolean             selection_changes = False;

    /*
     * Mark all visible cwids as XmSELECTED
     */
    cw->container.selection_state = XmSELECTED;
    node = cw->container.first_node;
    while ( node != NULL )
    {
        selection_changes |= MarkCwid( node->widget_ptr, False );
        node = GetNextNode( wid, node );
    }
    return selection_changes;
}

/************************************************************************
 * DeselectAllCwids
 ************************************************************************/
static  Boolean
DeselectAllCwids(
    Widget  wid)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    CwidNode            node;
    Boolean             selection_changes = False;

    if ( cw->container.selected_item_count == 0 )
    {
        cw->container.selection_state = XmSELECTED;
        return False;
    }

    /*
     * Mark all visible cwids as XmNOT_SELECTED
     */
    cw->container.selection_state = XmNOT_SELECTED;
    node = cw->container.first_node;
    while ( node != NULL )
    {
        selection_changes |= MarkCwid( node->widget_ptr, False );
        node = GetNextNode( wid, node );
        if ( cw->container.selected_item_count == 0 )
        {
            cw->container.selection_state = XmSELECTED;
            return selection_changes;
        }
    }

#ifdef  DEBUG
    printf( "DeselectAllCwids searching for hidden XmSELECTED cwids\n" );
    fflush( stdout );
#endif  /* DEBUG */
    /*
     * Didn't work.  There must be some hidden child cwids that are
     * XmSELECTED.  We'll have to traverse the entire list.
     */
    node = cw->container.first_node;
    while ( node != NULL )
    {
        selection_changes |= MarkCwid( node->widget_ptr, False );
        if ( cw->container.selected_item_count == 0 )
        {
            cw->container.selection_state = XmSELECTED;
            return selection_changes;
        }
        /*
         * depth-first search of tree, whether the cwids are
         * visible or not.
         */
        if ( node->child_ptr != NULL )
            node = node->child_ptr;
        else if ( node->next_ptr != NULL )
            node = node->next_ptr;
        else
            node = GetNextUpLevelNode( node );
    }
    cw->container.selection_state = XmSELECTED;
    return selection_changes;
}

/************************************************************************
 * MarkCwid
 ************************************************************************/
static  Boolean
MarkCwid(
    Widget          cwid,
    Boolean         visual_only)
{
    XmContainerWidget       cw = (XmContainerWidget) XtParent( cwid );
    XmContainerConstraint   c = GetContainerConstraint( cwid );
    Boolean                 selection_changes = False;

    if ( cw->container.selection_state != c->selection_visual )
    {
        c->selection_visual = cw->container.selection_state;
        cw->container.self = True;
#ifdef  COSEICON
        DtIconSetState( cwid, c->selection_visual == XmSELECTED, True );
#else
        XtVaSetValues( cwid,
                       XmNvisualEmphasis, c->selection_visual,
                       NULL );
#endif  /* COSEICON */
        cw->container.self = False;
        if ( CtrViewIsDETAIL( cw ) )
            ExposeDetail( cwid );
        if ( c->selection_visual == XmSELECTED )
            cw->container.selected_item_count++;
        else
            cw->container.selected_item_count--;
        selection_changes = True;
    }
    if ( ! visual_only )
        c->selection_state = c->selection_visual;
    return selection_changes;
}

/************************************************************************
 * UnmarkCwidVisual
 ************************************************************************/
static  Boolean
UnmarkCwidVisual(
    Widget          cwid)
{
    XmContainerWidget       cw = (XmContainerWidget) XtParent( cwid );
    XmContainerConstraint   c = GetContainerConstraint( cwid );

    /*
     * If the item visual matches its select state, or the item
     * visual doesn't match our current select/unselect action,
     * then return.
     * Otherwise, restore the item's visual to its select state
     * and add to/remove from the selected items list.
     */
    if ( ( c->selection_visual == c->selection_state )  ||
         ( c->selection_visual != cw->container.selection_state ) )
        return False;
    c->selection_visual = c->selection_state;
    cw->container.self = True;
#ifdef  COSEICON
    DtIconSetState( cwid, c->selection_visual == XmSELECTED, True );
#else
    XtVaSetValues( cwid, XmNvisualEmphasis, c->selection_visual, NULL );
#endif  /* COSEICON */
    cw->container.self = False;
    if ( CtrViewIsDETAIL( cw ) )
        ExposeDetail( cwid );
    if ( c->selection_visual == XmSELECTED )
        cw->container.selected_item_count++;
    else
        cw->container.selected_item_count--;
    return True;
}

/************************************************************************
 * SetMarkedCwids
 ************************************************************************/
static  void
SetMarkedCwids(
    Widget  wid)
{
    XmContainerWidget      cw = (XmContainerWidget) wid;
    CwidNode               node;
    XmContainerConstraint  c;

    node = cw->container.first_node;
    while ( node != NULL )
    {
        c = GetContainerConstraint( node->widget_ptr );
        c->selection_state = c->selection_visual;
        node = GetNextNode( wid, node );
    }
}

/************************************************************************
 * ResetMarkedCwids
 ************************************************************************/
static  Boolean
ResetMarkedCwids(
    Widget  wid)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    CwidNode            node;
    Boolean             selection_changes = False;

    node = cw->container.first_node;
    while ( node != NULL )
    {
        selection_changes |= UnmarkCwidVisual( node->widget_ptr );
        node = GetNextNode( wid, node );
    }
    return selection_changes;
}

/************************************************************************
 * MarkCwidsInRange
 ************************************************************************/
static  Boolean
MarkCwidsInRange(
    Widget  wid,
    Widget  cwid1,
    Widget  cwid2,
    Boolean visual_only)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    CwidNode            node;
    Boolean             cwid1_found = False;
    Boolean             cwid2_found = False;
    Boolean             marking_started = False;
    Boolean             marking_ended = False;
    Boolean             selection_changes = False;

    node = cw->container.first_node;
    if ( cwid1 == NULL )
    {
        if ( (cwid1 = cwid2 ) == NULL )
            return False;
    }
    if ( cwid2 == NULL )
    {
        if ( ( cwid2 = cwid1) == NULL )
            return False;
    }
    while ( node != NULL )
    {
        if ( node->widget_ptr == cwid1 )
            cwid1_found = True;
        if ( node->widget_ptr == cwid2 )
            cwid2_found = True;
        if ( ( cwid1_found  ||  cwid2_found )  &&  !marking_started )
            marking_started = True;
        if ( marking_started  &&  !marking_ended )
            selection_changes |= MarkCwid( node->widget_ptr,
                                           visual_only );
        else
            selection_changes |= UnmarkCwidVisual( node->widget_ptr );
        if ( cwid1_found  &&  cwid2_found  &&  marking_started )
            marking_ended = True;
        node = GetNextNode( (Widget) cw, node );
    }
    return selection_changes;
}

/************************************************************************
 * MarkCwidsInMarquee
 ************************************************************************/
static  Boolean
MarkCwidsInMarquee(
    Widget  wid,
    Boolean find_anchor,
    Boolean visual_only)
{
    XmContainerWidget       cw = (XmContainerWidget) wid;
    CwidNode                node;
    Boolean                 selection_changes = False;
    XmContainerConstraint   c;

    node = cw->container.first_node;
    while ( node != NULL )
    {
        if ( InMarquee( node->widget_ptr ) )
        {
            if ( find_anchor )
            {
                cw->container.anchor_cwid = node->widget_ptr;
                c = GetContainerConstraint( node->widget_ptr );
                if ( c->selection_state == XmSELECTED )
                    cw->container.selection_state = XmNOT_SELECTED;
                else
                    cw->container.selection_state = XmSELECTED;
                find_anchor = False;
            }
            selection_changes |= MarkCwid( node->widget_ptr,
                                           visual_only );
        }
        else
            selection_changes |= UnmarkCwidVisual( node->widget_ptr );
        node = GetNextNode( wid, node );
    }
    return selection_changes;
}

/************************************************************************
 * InMarquee
 ************************************************************************/
static  Boolean
InMarquee(
    Widget  cwid)
{
    XmContainerWidget    cw = (XmContainerWidget) XtParent( cwid );
    Position             cwid_x, cwid_y, cwid_xw, cwid_yh;
    Dimension            width, height;

    XtVaGetValues( cwid,
                   XmNx, &cwid_x,
                   XmNy, &cwid_y,
                   XmNwidth, &width,
                   XmNheight, &height,
                   NULL );
    cwid_xw = cwid_x + (Position) width;
    cwid_yh = cwid_y + (Position) height;
    return ( ( cwid_x >= cw->container.marquee_start.x )  &&
             ( cwid_y >=  cw->container.marquee_start.y )  &&
             ( cwid_xw <= cw->container.marquee_end.x )  &&
             ( cwid_yh <= cw->container.marquee_end.y ) );
}

/************************************************************************
 * RecalcMarquee
 ************************************************************************/
static  void
RecalcMarquee(
    Widget          wid,
    Widget          cwid,
    Position        x,
    Position        y)
{
    XmContainerWidget    cw = (XmContainerWidget) wid;
    Dimension            width, height;
    Position             anchor_x, anchor_y, anchor_xw, anchor_yh;
    Position             cwid_x, cwid_y, cwid_xw, cwid_yh;

    /*
     * Erase any marquee that is currently drawn.
     */
    if ( cw->container.marquee_drawn )
    {
        DrawMarquee( wid );
        cw->container.marquee_drawn = False;
    }
    /*
     * Set the new marquee start and end points depending upon
     * the XmNselectionTechnique resource.
     * If XmMARQUEE_EXTEND_BOTH, use the anchor_cwid and current_cwid
     *      corners as endpoints (if they are given).
     * If XmMARQUEE_EXTEND_START, use the anchor_cwid corners (if given)
     *      and the current pointer position as endpoints.
     * If XmMARQUEE, use the original anchor points and the current
     *      pointer position, given by the x & y parameters.
     * container.marquee_start.x & marquee_start.y always marks upper left.
     * container.marquee_end.x & marquee_end.y always marks lower right.
     */
    switch ( cw->container.selection_technique )
    {
        case XmMARQUEE_EXTEND_BOTH:
               if ( ( cw->container.started_in_anchor )  &&  ( cwid != NULL ) )
               {
                   XtVaGetValues( cw->container.anchor_cwid,
                                  XmNx, &anchor_x,
                                  XmNy, &anchor_y,
                                  XmNwidth, &width,
                                  XmNheight, &height,
                                  NULL );
                   anchor_xw = anchor_x + (Position) width;
                   anchor_yh = anchor_y + (Position) height;
                   XtVaGetValues( cwid,
                                  XmNx, &cwid_x,
                                  XmNy, &cwid_y,
                                  XmNwidth, &width,
                                  XmNheight, &height,
                                  NULL );
                   cwid_xw = cwid_x + (Position) width;
                   cwid_yh = cwid_y + (Position) height;
                   cw->container.marquee_start.x =
                                  MIN( anchor_x, cwid_x );
                   cw->container.marquee_start.y =
                                  MIN( anchor_y, cwid_y );
                   cw->container.marquee_end.x =
                                  MAX( anchor_xw, cwid_xw );
                   cw->container.marquee_end.y =
                                  MAX( anchor_yh, cwid_yh );
                   break;
               }
               if ( cw->container.started_in_anchor )
                   cwid = cw->container.anchor_cwid;
               if ( ( ! cw->container.started_in_anchor )  &&
                    ( cwid != NULL ) )
               {
                   x = cw->container.anchor_point.x;
                   y = cw->container.anchor_point.y;
               }
        case XmMARQUEE_EXTEND_START:
               if ( CtrTechIsMARQUEE_ES( cw ) )
                   if ( cw->container.started_in_anchor )
                       cwid = cw->container.anchor_cwid;
                   else
                       cwid = NULL;
               if ( cwid != NULL )
               {
                   XtVaGetValues( cwid,
                                  XmNx, &cwid_x,
                                  XmNy, &cwid_y,
                                  XmNwidth, &width,
                                  XmNheight, &height,
                                  NULL );
                   cwid_xw = cwid_x + (Position) width;
                   cwid_yh = cwid_y + (Position) height;
                   if ( x <= cwid_xw )
                   {
                       cw->container.marquee_start.x =
                                  MIN( x, cwid_x );
                       cw->container.marquee_end.x = cwid_xw;
                   }
                   else
                   {
                       cw->container.marquee_start.x = cwid_x;
                       cw->container.marquee_end.x =
                                  MAX( x, cwid_xw );
                   }
                   if ( y <= cwid_yh )
                   {
                       cw->container.marquee_start.y =
                                  MIN( y, cwid_y );
                       cw->container.marquee_end.y = cwid_yh;
                   }
                   else
                   {
                       cw->container.marquee_start.y = cwid_y;
                       cw->container.marquee_end.y =
                                  MAX( y, cwid_yh );
                   }
                   break;
               }
        case XmMARQUEE:
        case XmTOUCH_OVER:
               cw->container.marquee_start.x =
                          MIN( x, cw->container.anchor_point.x );
               cw->container.marquee_start.y =
                          MIN( y, cw->container.anchor_point.y );
               cw->container.marquee_end.x =
                          MAX( x, cw->container.anchor_point.x );
               cw->container.marquee_end.y =
                          MAX( y, cw->container.anchor_point.y );
               break;
        default:
               return;
    }

    /*
     * Keep track of the largest area covered by the marquee.
     */
    cw->container.marquee_smallest.x =
            MIN( cw->container.marquee_start.x,
                 cw->container.marquee_smallest.x );
    cw->container.marquee_smallest.y =
            MIN( cw->container.marquee_start.y,
                 cw->container.marquee_smallest.y );
    cw->container.marquee_largest.x =
            MAX( cw->container.marquee_end.x,
                 cw->container.marquee_largest.x );
    cw->container.marquee_largest.y =
            MAX( cw->container.marquee_end.y,
                 cw->container.marquee_largest.y );
}

/************************************************************************
 * DrawMarquee
 ************************************************************************/
static  void
DrawMarquee(
    Widget          wid)
{
    XmContainerWidget    cw = (XmContainerWidget) wid;
    Dimension            width, height;

    /*
     * If the container widget is realized, draw the marquee rectangle
     * using the gc parameter.
     */
    if ( ! XtIsRealized( wid ) )
        return;
    width = (Dimension) ( cw->container.marquee_end.x
                             - cw->container.marquee_start.x );
    height = (Dimension) ( cw->container.marquee_end.y
                             - cw->container.marquee_start.y );
    XDrawRectangle( XtDisplay( wid ), XtWindow( wid ), 
                    cw->container.marqueeGC,
                    cw->container.marquee_start.x,
                    cw->container.marquee_start.y,
                    width, height );
}

/************************************************************************
 * KBSelect
 ************************************************************************/
static  void
KBSelect(
    Widget          wid,
    XEvent         *event,
    String         *params,        /* unused */
    Cardinal       *num_params)    /* unused */
{
    XmContainerWidget       cw = (XmContainerWidget) wid;
    XmContainerConstraint   c;

#ifdef DEBUG
    printf( "cnr::KBSelect\n" );
    fflush( stdout );
#endif
    if ( cw->container.loc_cursor_cwid == NULL )
        return;
    cw->container.no_auto_sel_changes = False;
    c = GetContainerConstraint( cw->container.loc_cursor_cwid) ;
    cw->container.anchor_cwid = cw->container.loc_cursor_cwid;
    if ( ( ! cw->container.extending_mode  ||
           CtrPolicyIsSINGLE( cw ) )  &&
         ( ( cw->container.selected_item_count > 1 )  ||
           ( c->selection_state != XmSELECTED ) ) )
        cw->container.no_auto_sel_changes |= DeselectAllCwids( wid );
    if ( cw->container.extending_mode )
    {
        if ( c->selection_state == XmSELECTED )
            cw->container.selection_state = XmNOT_SELECTED;
        else
            cw->container.selection_state = XmSELECTED;
    }
    cw->container.no_auto_sel_changes |=
                   MarkCwid( cw->container.loc_cursor_cwid, False );
    if ( CtrIsAUTO_SELECT( cw ) )
    {
        CallSelectCB( wid, event, XmAUTO_BEGIN );
        CallSelectCB( wid, event, XmAUTO_NO_CHANGE );
    }
    else if ( cw->container.no_auto_sel_changes )
        CallSelectCB( wid, event, XmAUTO_UNSET );
}

/************************************************************************
 * SetLocationCursor
 ************************************************************************/
void SetLocationCursor(
    Widget  cwid,
    Widget  wid   )
{
    XmContainerWidget    cw = (XmContainerWidget) cwid;
    XEvent               event;
    Widget               currentWidget;
    unsigned char        cursorEmphasis;

    if ( wid  &&  (! XmIsIconGadget( wid ) ) ) 
        return;

    currentWidget = cw->container.loc_cursor_cwid;

    if ( currentWidget  &&  ( wid != currentWidget ) )
    {
        BorderUnhighlight( currentWidget );
        XtVaSetValues( currentWidget,
                       XmNcursorEmphasis, XmNOT_CURSORED,
                       NULL );
        CursoredCB( (Widget) cw, currentWidget, &event,
                    XmCURSORED_REMOVE );
    }
    cw->container.loc_cursor_cwid = wid;
    if ( wid )
    {
        BorderHighlight( wid );
        XtVaGetValues( wid, XmNcursorEmphasis, &cursorEmphasis, NULL );
        if ( cursorEmphasis != XmCURSORED )
        {
            XtVaSetValues( wid, XmNcursorEmphasis, XmCURSORED, NULL );
            CursoredCB( (Widget) cw, wid, &event, XmCURSORED_ADD );
        }
    }
}

/************************************************************************
 * BorderHighlight
 ************************************************************************/
static  void
BorderHighlight(
    Widget  cwid)
{
    XmContainerWidget       cw;
    XmContainerConstraint   c;
    XmGadget                g = (XmGadget) cwid;
    XRectangle              hrect;
    XGCValues               gcValues;

    if ( cwid == NULL )
        return;
    cw = (XmContainerWidget) XtParent( cwid );
    if ( ! cw->container.have_focus )
        return;
    c = GetContainerConstraint( cwid );
    if ( c->container_created )
    {
        ( *( ( (XmPrimitiveWidgetClass) XtClass( cwid ) )
                  ->primitive_class.border_highlight ) )( cwid );
        return;
    }
    if ( CtrViewIsDETAIL( cw ) )
    {
        hrect.x = cw->container.margin_w;
        hrect.width = cw->container.ideal_width
                        - 2 * cw->container.margin_w;
        if ( cw->core.width < hrect.x + hrect.width )
            hrect.width = cw->core.width - hrect.x;
        if ( CtrLayoutIsRtoL( cw ) )
            hrect.x = MAX( 0, cw->core.width - hrect.width
                                 - cw->container.margin_w );
        hrect.y = c->row_y;
        hrect.height = c->row_height;
    }
    else
    {
        hrect.x = g->rectangle.x;
        hrect.y = g->rectangle.y;
        hrect.width = g->rectangle.width;
        hrect.height = g->rectangle.height;
    }
    g = (XmGadget) cwid;

    /* Seems to be a problem in Motif that _XmDraw is not resetting
     * context back to what it was after _XmDrawHighlight is drawn
     * with LineOnOffDash. So we will save and restore the line_style
     * and line_width in the context.
     */
    XGetGCValues( XtDisplay( cwid ),
                  ( (XmManagerWidget)(g->object.parent) )->manager.highlight_GC,
                  GCLineStyle | GCLineWidth,
                  &gcValues );


    _XmDrawHighlight( XtDisplay( cwid ), XtWindow( cwid ),
                      ( (XmManagerWidget)(g->object.parent) )->manager.highlight_GC,
                      hrect.x, hrect.y, hrect.width, hrect.height,
                      g->gadget.highlight_thickness,
                      ( cw->container.kaddmode ) ?
                            LineOnOffDash : LineSolid );

    XChangeGC( XtDisplay( cwid ),
               ( (XmManagerWidget)(g->object.parent) )->manager.highlight_GC,
               GCLineStyle | GCLineWidth,
               &gcValues );
}

/************************************************************************
 * BorderUnhighlight
 ************************************************************************/
static  void
BorderUnhighlight(
    Widget  cwid)
{
    XmContainerWidget       cw;
    XmContainerConstraint   c;
    XmGadget                g = (XmGadget)cwid;
    XRectangle              hrect;
    XGCValues  gcValues;

    if ( cwid == NULL )
        return;
    cw = (XmContainerWidget) XtParent( cwid );
    c = GetContainerConstraint( cwid );
    if ( c->container_created )
    {
        ( *( ( (XmPrimitiveWidgetClass) XtClass( cwid ) )
                   ->primitive_class.border_unhighlight ) )( cwid );
        /*
        ( *( ( (XmGadgetClass) XtClass( cwid ) )
                   ->gadget_class.border_highlight ) )( cwid );
         */
        return;
    }
    if ( CtrViewIsDETAIL( cw ) )
    {
        hrect.x = cw->container.margin_w;
        hrect.width = cw->container.ideal_width
                        - 2 * cw->container.margin_w;
        if ( cw->core.width < hrect.x + hrect.width )
            hrect.width = cw->core.width - hrect.x;
        if ( CtrLayoutIsRtoL( cw ) )
            hrect.x = MAX( 0, cw->core.width - hrect.width
                                 - cw->container.margin_w );
        hrect.y = c->row_y;
        hrect.height = c->row_height;
    }
    else
    {
        hrect.x = g->rectangle.x;
        hrect.y = g->rectangle.y;
        hrect.width = g->rectangle.width;
        hrect.height = g->rectangle.height;
    }

    /* Seems to be a problem in Motif that _XmDraw is not resetting
     * context back to what it was after _XmDrawHighlight is drawn
     * with LineOnOffDash. So we will save and restore the line_style
     * and line_width in the context.
     */
    XGetGCValues( XtDisplay( cwid ),
                  ( (XmManagerWidget)( g->object.parent ))->manager.background_GC,
                  GCLineStyle | GCLineWidth,
                  &gcValues );

    _XmDrawHighlight( XtDisplay( cwid ), XtWindow( cwid ),
                      ( (XmManagerWidget)( g->object.parent ))->manager.background_GC,
                      hrect.x, hrect.y, hrect.width, hrect.height,
                      g->gadget.highlight_thickness,
                      (cw->container.kaddmode) ?
                             LineOnOffDash : LineSolid);

    XChangeGC( XtDisplay( cwid ),
               ( (XmManagerWidget)( g->object.parent ))->manager.background_GC,
               GCLineStyle | GCLineWidth,
               &gcValues );
}

/************************************************************************
 * CalcNextLocationCursor
 ************************************************************************/
static  Widget
CalcNextLocationCursor(
    Widget  wid,
    String  direction)
{
    XmContainerWidget       cw = (XmContainerWidget) wid;
    XmContainerConstraint   c;
    CwidNode                newloc_node = NULL;

    if ( cw->container.loc_cursor_cwid == NULL )
    {
        /* ICLUI: protect against bogus loc_cursor_cwid value */
        if ( cw->container.first_node == NULL )
            cw->container.loc_cursor_cwid = NULL;
        else
            cw->container.loc_cursor_cwid =
                   cw->container.first_node->widget_ptr;
    }

    if ( strcmp( direction, _FIRST ) == 0 )
        return cw->container.first_node->widget_ptr;
    if ( strcmp( direction, _LAST ) == 0 )
        return cw->container.last_node->widget_ptr;

    c = GetContainerConstraint( cw->container.loc_cursor_cwid );
    if ( c->container_created )
    {
        if ( CtrLayoutIsOUTLINE( cw ) )
        {
           if ( CtrLayoutIsRtoL( cw )  &&
                ( strcmp( direction, _LEFT ) == 0 ) )
               return c->node_ptr->widget_ptr;
           if ( CtrLayoutIsLtoR( cw ) &&
                ( strcmp( direction, _RIGHT ) == 0 ) )
               return c->node_ptr->widget_ptr;
        }
        SetLocationCursor( (Widget) cw, c->node_ptr->widget_ptr );
        c = GetContainerConstraint( cw->container.loc_cursor_cwid );
    }

    if ( strcmp( direction, _RIGHT ) == 0 )
    {
        if ( CtrLayoutIsOUTLINE( cw )  &&  CtrLayoutIsRtoL( cw )  &&
             ( c->outline_button != NULL ) )
            return c->outline_button;
        if ( CtrViewIsDETAIL( cw )  ||  CtrLayoutIsOUTLINE( cw ) )
             return cw->container.loc_cursor_cwid;
        if ( CtrLayoutIsLtoR( cw ) )
            newloc_node = GetNextNode( (Widget) cw, c->node_ptr );
        else
            newloc_node = GetPrevNode( (Widget) cw, c->node_ptr );
    }
    else if ( strcmp( direction, _LEFT ) == 0 )
    {
        if ( CtrLayoutIsOUTLINE( cw )  &&  CtrLayoutIsLtoR( cw )  &&
           ( c->outline_button != NULL ) )
            return c->outline_button;
        if ( ( CtrViewIsDETAIL( cw ) )  ||  ( CtrLayoutIsOUTLINE( cw ) ) )
            return cw->container.loc_cursor_cwid;
        if ( CtrLayoutIsLtoR( cw ) )
            newloc_node = GetPrevNode( (Widget) cw, c->node_ptr );
        else
            newloc_node = GetNextNode( (Widget) cw, c->node_ptr );
    }
    else if ( strcmp( direction, _DOWN ) == 0 )
    {
        newloc_node = GetNextNode( (Widget) cw, c->node_ptr );
        if ( newloc_node == NULL )
            newloc_node = cw->container.first_node;
    }
    else if ( strcmp( direction, _CNR_UP ) == 0 )
    {
        newloc_node = GetPrevNode( (Widget) cw, c->node_ptr );
        if ( newloc_node == NULL )
            newloc_node = cw->container.last_node;
    }

    if ( newloc_node != NULL )
        return newloc_node->widget_ptr;
    return cw->container.loc_cursor_cwid;
}

/************************************************************************
 * MakeOutlineButton
 ************************************************************************/
static  void
MakeOutlineButton(
    Widget  cwid)
{
    XmContainerWidget       cw = (XmContainerWidget) XtParent( cwid );
    XmContainerConstraint   c = GetContainerConstraint( cwid );
    XmContainerConstraint   obc;
    Pixmap                  pm;

    if ( c->outline_state == XmEXPANDED )
        pm = cw->container.expanded_state_pixmap;
    else
        pm = cw->container.collapsed_state_pixmap;
    cw->container.self = True;

    c->outline_button =
        XtVaCreateWidget( OBNAME,
                          xmPushButtonWidgetClass, (Widget) cw,
                          XmNtraversalOn, False,
                          XmNlabelType, XmPIXMAP,
                          XmNlabelPixmap, pm,
                          XmNbackground, /* background color */
                          cw->core.background_pixel,
                          NULL );
    XtAddCallback( c->outline_button, XmNactivateCallback,
                   (XtCallbackProc) OutlineButtonCallbackMouse,
                   (XtPointer) cwid );
    cw->container.self = False;
    obc = GetContainerConstraint( c->outline_button );
    obc->node_ptr = c->node_ptr;
    XtManageChild( c->outline_button );
}

/************************************************************************
 * ExpandCwid
 ************************************************************************/
static  void
ExpandCwid(
    Widget  cwid, Boolean refreshNow)
{
    XmContainerWidget       cw = (XmContainerWidget) XtParent( cwid );
    XmContainerConstraint   c = GetContainerConstraint( cwid );
    CwidNode                node;
    CwidNode                child_node;

    if ( c->outline_button == NULL )
        return;
    cw->container.self = True;
    XtVaSetValues( c->outline_button,
                   XmNlabelPixmap, cw->container.expanded_state_pixmap,
                   NULL );
    cw->container.self = False;

    c->outline_state = XmEXPANDED;
    node = c->node_ptr;
    child_node = node->child_ptr;
    if ( child_node == NULL )
        return;
    while ( child_node != NULL )
    {
        c = GetContainerConstraint( child_node->widget_ptr );
        c->visible_in_outline = True;
        child_node = child_node->next_ptr;
    }

    if ( ! refreshNow )
        return;

    Layout ( (Widget) cw );
    RequestNewSize( (Widget) cw );
    if ( XtIsRealized( (Widget) cw ) )
        XClearArea( XtDisplay( (Widget) cw ),
                    XtWindow( (Widget) cw ), 0, 0, 0, 0, True );
}

/************************************************************************
 * CollapseCwid
 ************************************************************************/
static  Boolean
CollapseCwid(
    Widget  cwid, Boolean refreshNow)
{
    XmContainerWidget      cw = (XmContainerWidget) XtParent( cwid );
    XmContainerConstraint  c = GetContainerConstraint( cwid );
    CwidNode               node;
    CwidNode               child_node;
    unsigned char          selectionState;
    Boolean                bSelectedHidden = False ;

    if ( c->outline_button != NULL )
    {
        cw->container.self = True;
        XtVaSetValues( c->outline_button,
                       XmNlabelPixmap,
                       cw->container.collapsed_state_pixmap,
                       NULL );
        cw->container.self = False;

        c->outline_state = XmCOLLAPSED;
        node = c->node_ptr;
        child_node = node->child_ptr;
        if ( child_node )
        {
            while (child_node != NULL)
            {
               c = GetContainerConstraint(child_node->widget_ptr);
    
               c->visible_in_outline = False;
               if (c->outline_button)
                  HideCwid(c->outline_button);
               bSelectedHidden |= HideCwid(child_node->widget_ptr);
               child_node = child_node->next_ptr;
            } /* while */
        } /* child_node */
    } /* outline_button */

    if ( refreshNow )
    {
        Layout( (Widget) cw );
        RequestNewSize( (Widget) cw );
        if ( XtIsRealized( (Widget) cw ) )
            XClearArea( XtDisplay( (Widget) cw ),
                        XtWindow( (Widget) cw ), 0, 0, 0, 0, True );
    }
  
    return bSelectedHidden ;
}

/************************************************************************
 * CallActionCB
 ************************************************************************/
static  void
CallActionCB(
    Widget  cwid,
    XEvent *event)
{
    XmContainerWidget       cw = (XmContainerWidget) XtParent( cwid );
    XmContainerConstraint   c = GetContainerConstraint( cwid );
    XmContainerSelectCallbackStruct cbs;

    if ( ! ( XtHasCallbacks( (Widget) cw, XmNdefaultActionCallback )
                                == XtCallbackHasSome ) )
        return;
    cbs.reason = XmCR_DEFAULT_ACTION;
    cbs.event = event;
    cbs.select_operation = XmSELECT_CHANGE;
    if ( c->selection_state == XmSELECTED )
    {
        cbs.selected_items = GetSelectedCwids( (Widget) cw );
        cbs.selected_item_count = cw->container.selected_item_count;
    }
    else
    {
        cbs.selected_items = (WidgetList) XtMalloc( sizeof( Widget ) );
        cbs.selected_items[0] = cwid;
        cbs.selected_item_count = 1;
    }
    cbs.auto_selection_type = XmAUTO_UNSET;
    XtCallCallbackList( (Widget) cw,
                         cw->container.default_action_cb, &cbs );
    XtFree( (char*) cbs.selected_items );
}

/************************************************************************
 * CallSelectCB
 ************************************************************************/
static  void
CallSelectCB(
    Widget          wid,
    XEvent         *event,
    unsigned char   auto_selection_type)
{
    XmContainerWidget               cw = (XmContainerWidget)wid;
    XmContainerSelectCallbackStruct cbs;

    if ( cw->core.being_destroyed )
        return;

    if ( ! ( XtHasCallbacks( wid, XmNselectionCallback )
                                      == XtCallbackHasSome ) )
        return;
    cbs.selected_items = NULL;
    cbs.selected_item_count = 0;
    cbs.select_operation = XmSELECT_CHANGE;

    switch ( cw->container.selection_policy )
    {
        case XmSINGLE_SELECT:
               cbs.reason = XmCR_SINGLE_SELECT;
        case XmBROWSE_SELECT:
               if ( CtrPolicyIsBROWSE( cw ) )
                   cbs.reason = XmCR_BROWSE_SELECT;
               if ( cw->container.anchor_cwid != NULL )
               {
                   cbs.selected_items = (WidgetList)
                           XtMalloc( sizeof( Widget ) );
                   cbs.selected_items[0] =
                           cw->container.anchor_cwid;
                   cbs.selected_item_count = 1;
               }
               break;
        case XmMULTIPLE_SELECT:
               cbs.reason = XmCR_MULTIPLE_SELECT;
        case XmEXTENDED_SELECT:
               if ( CtrPolicyIsEXTENDED( cw ) )
                       cbs.reason = XmCR_EXTENDED_SELECT;
               cbs.selected_items = GetSelectedCwids( wid );
               cbs.selected_item_count =
                       cw->container.selected_item_count;
               break;
        default:
               break;
    }

    cbs.event = event;
    cbs.auto_selection_type = auto_selection_type;
    XtCallCallbackList( wid, cw->container.selection_cb, &cbs );
    if ( cbs.selected_items != NULL )
        XtFree( (char*) cbs.selected_items );
}


/************************************************************************
 * CursoredCB
 ************************************************************************/
static  void
CursoredCB(
    Widget          cwid,
    Widget          icong,
    XEvent         *event,
    unsigned char   cursored_change_type)
{
    XmContainerWidget                 cw = (XmContainerWidget) cwid;
    XmContainerCursoredCallbackStruct cbs;

    if ( cw->core.being_destroyed )
        return;

    if ( ! ( XtHasCallbacks( cwid, XmNcursoredCallback )
                                      == XtCallbackHasSome ) )
        return;

    cbs.reason = XmCR_CURSORED_CHANGE;
    cbs.event = event;
    cbs.cursored_item = icong;
    cbs.cursored_operation = cursored_change_type;

    XtCallCallbackList( cwid, cw->container.selection_cb, &cbs );
}

/************************************************************************
 * GetSelectedCwids
 ************************************************************************/
static  WidgetList
GetSelectedCwids(
    Widget          wid)
{
    XmContainerWidget      cw = (XmContainerWidget) wid;
    WidgetList             selected_items;
    CwidNode               node;
    unsigned int           tally = 0;
    XmContainerConstraint  c;

    if ( cw->container.selected_item_count == 0 )
        return NULL;

    selected_items = (WidgetList)
        XtMalloc( cw->container.selected_item_count *
                                      sizeof( Widget ) );
    /*
     * Search through all the visible items first - it'll work 99% of
     * the time and it's faster than searching through all the items.
     */
    node = cw->container.first_node;
    while ( node != NULL )
    {
        c = GetContainerConstraint( node->widget_ptr );
        if ( c->selection_visual == XmSELECTED )
        {
            selected_items[tally] = node->widget_ptr;
            tally++;
            if ( tally == cw->container.selected_item_count )
                return selected_items;
        }
        node = GetNextNode( wid, node );
    }

#ifdef  DEBUG
    printf( "GetSelectedCwids searching for hidden selected items\n" );
    fflush( stdout );
#endif  /* DEBUG */
    /*
     * Didn't work.  There must be some hidden child items that are
     * XmSELECTED.  We'll have to traverse the entire list.
     */
    tally = 0;
    node = cw->container.first_node;
    while ( node != NULL )
    {
        c = GetContainerConstraint( node->widget_ptr );
        if ( c->selection_visual == XmSELECTED )
        {
            selected_items[tally] = node->widget_ptr;
            tally++;
            if ( tally == cw->container.selected_item_count )
                return selected_items;
        }
        /*
         * depth-first search of tree, whether the items are
         * visible or not.
         */
        if ( node->child_ptr != NULL )
            node = node->child_ptr;
        else if ( node->next_ptr != NULL )
            node = node->next_ptr;
        else
            node = GetNextUpLevelNode( node );
    }

#if INTEGRITY_CHECK
    assert( 0 );
#endif
    if ( selected_items )
    {  /*
        * Free the previously allocated buffer.
        */
       XtFree( (char*) selected_items );
    }
    return NULL;
}

/************************************************************************
 * GetSelectedItems
 ************************************************************************/
static  void
GetSelectedItems(
    Widget          wid,
    int             offset, /* unused */
    XtArgVal       *value)
{
    WidgetList      selected_items;

    selected_items = GetSelectedCwids( wid );
    *value = (XtArgVal) selected_items;
}

/************************************************************************
 * GetDetailHeading
 ************************************************************************/
static  void
GetDetailHeading(
    Widget          wid,
    int             offset, /* unused */
    XtArgVal       *value)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;
    XmStringTable       xmstr_table;
    int                 i;

    xmstr_table = (XmStringTable)
        XtMalloc( cw->container.detail_count * sizeof( XmString ) );
    for ( i = 0; i < cw->container.detail_count; i++ )
        xmstr_table[i] =
            _XmStringCreateExternal( cw->container.render_table,
                                     cw->container.detail_heading[i] );
    *value = (XtArgVal) xmstr_table;
}

/************************************************************************
 * GetEntryDetail
 ************************************************************************/
static  void
GetEntryDetail(
    Widget          cwid,
    int             offset, /* unused */
    XtArgVal       *value)
{
    XmContainerWidget      cw = (XmContainerWidget) XtParent( cwid );
    XmContainerConstraint  c = GetContainerConstraint( cwid );
    XmStringTable          xmstr_table;
    int                    i;

    xmstr_table = (XmStringTable)
        XtMalloc( cw->container.detail_count * sizeof( XmString ) );
    for ( i = 0; i < cw->container.detail_count; i++ )
        xmstr_table[i] =
            _XmStringCreateExternal( cw->container.render_table,
                                     c->entry_detail[i] );
    *value = (XtArgVal) xmstr_table;
}

/************************************************************************
 * CompareInts
 ************************************************************************/
static  int
CompareInts(
    const void    *p1,
    const void    *p2)
{
    int     i1 = * (int *)p1;
    int     i2 = * (int *)p2;

    /*
     * A "qsort" function that simply compares two integers
     */
    return ( i1 - i2 );
}

/************************************************************************
 * Isqrt - Integer Square Root (using Newton's Method) - rounded up
 ************************************************************************/
static  int
Isqrt(
    int n)
{
    int current_answer,next_trial;

    if ( n <= 1 )
        return n;
    current_answer = n;
    next_trial = n / 2;
    while ( current_answer > next_trial )
    {
        current_answer = next_trial;
        next_trial = ( next_trial + n/next_trial ) / 2;
    }
    if ( current_answer * current_answer < n )
        current_answer++;
    return current_answer;
}


/*---------------------------
| Internal Callback Routines |
---------------------------*/

/************************************************************************
 * OutlineButtonCallbackMouse
 ************************************************************************/
static  void
OutlineButtonCallbackMouse(
    Widget         pbwid,
    XtPointer      client_data,
    XtPointer      call_data)
{
    OutlineButtonCallback( pbwid, client_data, call_data, True );
}

/************************************************************************
 * OutlineButtonCallbackProgram
 ************************************************************************/
static  void
OutlineButtonCallbackProgram(
    Widget         pbwid,
    XtPointer      client_data,
    XtPointer      call_data)
{
    OutlineButtonCallback( pbwid, client_data, call_data, False );
}

/************************************************************************
 * OutlineButtonCallback
 ************************************************************************/
static  void
OutlineButtonCallback(
    Widget         pbwid,
    XtPointer      client_data,
    XtPointer      call_data,
    Boolean        bMouseClicked)
{
    Widget                  cwid = (Widget) client_data;
    XmContainerWidget       cw = (XmContainerWidget) XtParent( cwid );
    unsigned char   save_state = cw->container.selection_state;
    XmContainerConstraint   c = GetContainerConstraint( cwid );
    XmGadget                g = (XmGadget) cwid;
    XmAnyCallbackStruct *   pbcbs = (XmAnyCallbackStruct*) call_data;
    XmContainerOutlineCallbackStruct cbs;
    unsigned char           state_before_callback;
#if DETECT_OVERFLOW
    int                     overflowCount;
#endif
    Boolean                 bSelectedHidden = False ;

    /*
     * PushButton's Arm() action keeps grabbing keyboard focus - ugh!
     */
    XmProcessTraversal( (Widget) cw, XmTRAVERSE_CURRENT );

    if ( c->outline_state == XmEXPANDED )
    {
        c->outline_state = XmCOLLAPSED;
        cbs.reason = XmCR_COLLAPSED;
    }
    else
    {
        c->outline_state = XmEXPANDED;
        cbs.reason = XmCR_EXPANDED;
    }
    cbs.event = pbcbs->event;
    cbs.item = cwid;
    state_before_callback = c->outline_state;
    XtCallCallbackList( (Widget) cw,
                        cw->container.value_changed_cb, &cbs );
    /*
     * In case user destroys child.
     */
    if ( g->object.being_destroyed )
        return;
    /*
     * In case user has called SetValues in XmNvalueChangedCallback
     * to prevent action from occurring.
     */
    if ( c->outline_state != state_before_callback )
        return;
    if ( c->outline_state == XmCOLLAPSED )
        bSelectedHidden = CollapseCwid( cwid, True );
    else
    {
        ExpandCwid( cwid, True );
    }
#if DETECT_OVERFLOW
    /* As part of overflow detection support, we call
     * XmNoverflowCallback's if XuiclGetOverflowCount detects an overflow.
     */
    overflowCount = XuiclGetOverflowCount( (Widget) cw );
    if ( overflowCount != 0 )
    {
        XmContainerOverflowCallbackStruct cbs;
        cbs.reason = XmCR_KBEVENT;
        cbs.event = pbcbs->event;
        cbs.item = cwid;
        cbs.overflowCount = overflowCount;
        XtCallCallbackList( cwid, cw->container.overflow_callbacks, &cbs );
    }
#endif

    /* More OS/2 behaviour ... make the root gadget selected
     * and cursored.
     */
    if ( bMouseClicked || bSelectedHidden )
    {
        DeselectAllCwids( (Widget) cw );
        SetLocationCursor( (Widget) cw, cwid );
        cw->container.selection_state = XmSELECTED;
        MarkCwid( cwid, False );
        cw->container.anchor_cwid = cwid;
        cw->container.selection_state = save_state;
        CallSelectCB( (Widget) cw, NULL, XmAUTO_CHANGE );
    }
}


/*-------------------
| External functions |
-------------------*/

/************************************************************************
 *  XmContainerGetItemByCoordinates
 ************************************************************************/
Widget
XmContainerGetItemByCoordinates(
    Widget          wid,
    Position        x,
    Position        y)
{
    /*
     * Return the item at the specified coordinates.
     */
    return LocatePointer( wid, (int) x, (int) y );
}
/************************************************************************
 * XmContainerGetItemChildren
 ************************************************************************/
int
XmContainerGetItemChildren(
    Widget          wid,
    Widget          item,
    WidgetList     *item_children)
{
    XmContainerWidget      cw = (XmContainerWidget) wid;
    XmContainerConstraint  c;
    CwidNode        node;
    CwidNode        first_child_node;
    WidgetList      clist;
    int             i, clist_count;

    if ( item == NULL )
    {
        if ( cw->container.first_node == NULL )
            return 0;
        first_child_node = cw->container.first_node;
    }
    else
    {
        if ( XtParent( item ) != wid )
            return 0;
        c = GetContainerConstraint( item );
        node = c->node_ptr;
        if ( node->child_ptr == NULL )
            return 0;
        first_child_node = node->child_ptr;
    }

    clist_count = 1;
    node = first_child_node;
    while ( node->next_ptr != NULL )
    {
        clist_count++;
        node = node->next_ptr;
    }

    clist = (WidgetList) XtMalloc( clist_count * sizeof( Widget ) );
    node = first_child_node;
    for ( i = 0; i < clist_count; i++ )
    {
        clist[i] = node->widget_ptr;
        node = node->next_ptr;
    }
    *item_children = clist;

    return clist_count;
}

/************************************************************************
 * XmContainerRelayout
 ************************************************************************/
void
XmContainerRelayout(
    Widget  wid)
{
    XmContainerWidget   cw = (XmContainerWidget) wid;

    if ( ! cw->container.refreshOn )
        return;

#ifdef ORI              /* ER: */
    if ( CtrLayoutIsOUTLINE( cw )  ||  CtrViewIsDETAIL( cw ) )
        return;
#endif                  /* ER: */

#if 0
    /* Force Layout to relayout over hidden items in spatial view */
    if(CtrLayoutIsSPATIAL( wid ))
    {
        cw->container.current_width_in_cells = 0;
        cw->container.current_height_in_cells = 0;
    }
#endif
    Layout( wid );
    // Fixed a bug in the widget where if you do a moveIconTo in icon
    // view and the icon is placed "outside" the current container
    // viewport (which is sized minimally only to include shown
    // objects, not the entire "client" area), then the object
    // would not show up.  Fix is to request a new size for the
    // widget after doing a layout.  Then it will include all
    // objects.  LJO
    RequestNewSize( wid );                              /* LJO */
    if ( XtIsRealized( wid ) )
        XClearArea( XtDisplay( wid ),
                    XtWindow( wid ), 0, 0, 0, 0, True );
}

/************************************************************************
 *  XmContainerReorder
 ************************************************************************/
void
XmContainerReorder(
    Widget          wid,
    WidgetList      cwid_list,
    int             cwid_count)
{
    XmContainerWidget      cw = (XmContainerWidget) wid;
    XmContainerConstraint  c;
    Widget                 pcwid;
    int *                  pi_list;
    int                    i, pi_count;

    if ( cwid_count <= 1 )
        return;
    c = GetContainerConstraint( cwid_list[0] );
    pcwid = c->entry_parent;
    pi_list = (int*) XtMalloc( cwid_count * sizeof( int ) );
    pi_count = 0;
    for ( i=0; i < cwid_count; i++ )
    {
        c = GetContainerConstraint( cwid_list[i] );
        if ( c->entry_parent == pcwid )
        {
            pi_list[pi_count] = c->position_index;
            pi_count++;
        }
    }
    qsort( pi_list, pi_count, sizeof( int ), CompareInts );

    pi_count = 0;
    for (i=0; i < cwid_count; i++)
    {
        c = GetContainerConstraint( cwid_list[i] );
        if ( c->entry_parent == pcwid )
        {
            c->position_index = pi_list[pi_count];
            pi_count++;
            SeverNode( c->node_ptr );
            InsertNode( c->node_ptr );
        }
    }
    XtFree( (char*) pi_list );

    if ( CtrLayoutIsOUTLINE( cw )  ||  CtrViewIsDETAIL( cw ) )
        Layout( wid );
}

/************************************************************************
 *  XmCreateContainer
 ************************************************************************/
Widget
XmCreateContainer(
    Widget          parent,
    char           *name,
    ArgList         arglist,
    Cardinal        argcount)
{
    /*
     * Create an instance of a container and return the widget id.
     */
    return XtCreateWidget( name, xmContainerWidgetClass,
                           parent, arglist, argcount );
}


/************************************************************************
 *  Methods added to support UICL...
 ************************************************************************/

/* defines needed by XuiclQueryRecord
 * NOTE: can't just inlcude icnrconst.h here because it needs stuff from
 * C++ world like IWindowHandle, IPresSpaceHandle, etc.
 */

#define CMA_FIRST            0x0010       /* Add record as first      */
#define CMA_LAST             0x0020
#define CMA_PREV             0x0080
#define CMA_NEXT             0x0100
#define CMA_PARENT           0x0001
#define CMA_FIRSTCHILD       0x0002
#define CMA_LASTCHILD        0x0004
/************************************************************************
 * XuiclQueryRecord
 ************************************************************************/
Widget
XuiclQueryRecord(
    Widget          wid,
    unsigned long   position,
    unsigned long   order)
{
    XmContainerWidget      cw;
    XmContainerConstraint  nc;

    /* if looking for the first or last wid is the Container itself
     *  otherwise it will be the IconGadget that position is relative to.
     */
    if ( position == CMA_FIRST  ||  position == CMA_LAST )
        cw = (XmContainerWidget) wid;
    else
        nc = GetContainerConstraint( wid );

    switch ( position )
    {
        case CMA_FIRST:
               if ( cw->container.first_node )
                   return cw->container.first_node->widget_ptr;
               else
                   return NULL;

        case CMA_LAST:
               if ( cw->container.last_node )
                   return cw->container.last_node->widget_ptr;
               else
                   return NULL;

        case CMA_NEXT:
               if ( nc->node_ptr->next_ptr )
                   return nc->node_ptr->next_ptr->widget_ptr;
               else
                   return NULL;

        case CMA_PREV:
               if ( nc->node_ptr->prev_ptr )
                   return nc->node_ptr->prev_ptr->widget_ptr;
               else
                   return NULL;

        case CMA_PARENT:
               if ( nc->node_ptr->parent_ptr )
                   return nc->node_ptr->parent_ptr->widget_ptr;
               else
                   return NULL;

        case CMA_FIRSTCHILD:
               if ( nc->node_ptr->child_ptr )
                   return nc->node_ptr->child_ptr->widget_ptr;
               else
                   return NULL;

        case CMA_LASTCHILD:
        {
               CwidNode next = nc->node_ptr->child_ptr;
               if ( next )
               {
                   while ( next->next_ptr != NULL )
                       next = next->next_ptr;
                   return next->widget_ptr;
               }
        }

        default:
               return NULL;
    }
}

/************************************************************************
 * SwapNode
 ************************************************************************/
static void
SwapNode(
     CwidNode S1,
     CwidNode S2)
{
    CwidNode              prev, next, parent;
    XmContainerConstraint S1c;
    XmContainerConstraint S2c;
    Widget                cwid;
    int                   temp;

    prev = S1->prev_ptr;
    next = S2->next_ptr;

    if ( prev )
        prev->next_ptr = S2;
    S2->prev_ptr = prev;
    S2->next_ptr = S1;
    S1->prev_ptr = S2;
    S1->next_ptr = next;
    if ( next )
        next->prev_ptr = S1;

    /* Swap the entryPosition constraint resources */
    cwid = S1->widget_ptr;
    S1c = GetContainerConstraint( cwid );
    cwid = S2->widget_ptr;
    S2c = GetContainerConstraint( cwid );
    temp = S1c->position_index;
    S1c->position_index = S2c->position_index;
    S2c->position_index = temp;

    /* update parent's child_ptr if needed */
    parent = S1->parent_ptr;
    if ( parent  &&  parent->child_ptr == S1 )
        parent->child_ptr = S2;
}

/************************************************************************
 * SortNodes
 ************************************************************************/
static void
SortNodes(
     Widget    widget,
     CwidNode  head,
     long    (*comp) (void*, void*, void*),
     void*     sortPckg)
{
    CwidNode          n1, n2;
    Widget            w1, w2;
    void             *obj1, *obj2;
    Boolean           needToSort = True;
    unsigned int      passes = 0, swaps;
    XmContainerWidget cw = (XmContainerWidget)widget;

    /* Yes, it's just a simple bubble sort on the current level. */
    while ( needToSort )
    {
        n1 = head;
        n2 = n1->next_ptr;
        swaps = 0;

        while ( n1 )  /* using n1 ensures children are sorted too! */
        {
            /* recursive descent to sort at child level */
            if ( passes == 0  &&  n1->child_ptr )
                SortNodes( widget, n1->child_ptr, comp, sortPckg );

            if ( n2 == NULL )
                break;

            /* get IContainerObject* from IconGadget userData */
            w1 = n1->widget_ptr;
            w2 = n2->widget_ptr;
            XtVaGetValues( w1, XmNuserData, &obj1, NULL );
            XtVaGetValues( w2, XmNuserData, &obj2, NULL );

            /* Call isEqual() override supplied by the user. */
            if ( (*comp)( obj1, obj2, sortPckg ) > 0 )
            {
                SwapNode( n1, n2 );
                swaps++;

                /* check for new head on level we are currently sorting */
                if ( head == n1 )
                    head = n2;

                /* check for new head or tail of Container widget list */
                if ( n1 == cw->container.first_node )
                    cw->container.first_node = n2;
                if ( n2 == cw->container.last_node )
                    cw->container.last_node = n1;
            }

            n1 = n2;
            n2 = n1->next_ptr;

        }  /* end while(n2) */

        passes++;
        needToSort = ( swaps? True : False );
    }  /* end while(needToSort) */
}

/************************************************************************
 * ModifySelectedChange
 ************************************************************************/
void
ModifySelectedChange(
    Widget   wid,
    Widget   cwid,
    Boolean  add)
{
    /* Don't call callbacks if being destroyed */
    if ( wid->core.being_destroyed )
        return;

    /* Add newly selected item to handleSelected list
     * of selected items.
     */
    if ( XtHasCallbacks( wid, XmNselectionCallback ) == XtCallbackHasSome )
    {
        XmContainerSelectCallbackStruct cbs;
        XmContainerWidget cw = (XmContainerWidget) wid;

        if ( add == True )
            cbs.select_operation = XmSELECT_ADD;    /*force add*/
        else
            cbs.select_operation = XmSELECT_REMOVE; /*force remove*/

        cbs.selected_items = &cwid;
        cbs.selected_item_count = 1;    /* only pass 1 item */
        cbs.auto_selection_type = XmAUTO_CHANGE;    /*not used*/
        switch ( cw->container.selection_policy )
        {
            case XmBROWSE_SELECT:
                   if ( CtrPolicyIsBROWSE( cw ) )
                   {
                       cbs.reason = XmCR_BROWSE_SELECT;
                       break;
                   }
            case XmSINGLE_SELECT:
                   cbs.reason = XmCR_SINGLE_SELECT;
                   break;
            case XmEXTENDED_SELECT:
                   if ( CtrPolicyIsEXTENDED( cw ) )
                   {
                       cbs.reason = XmCR_EXTENDED_SELECT;
                       break;
                   }
            case XmMULTIPLE_SELECT:
                   cbs.reason = XmCR_MULTIPLE_SELECT;
                   break;
            default:
                   break;
        }
        XtCallCallbackList( wid, cw->container.selection_cb, &cbs );
    }
}

/************************************************************************
 * XuiclSort
 ************************************************************************/
int
XuiclSort(
    Widget  widget,
    long  (*comp) (void*, void*, void*),
    void   *sortPckg)
{
    XmContainerWidget   cw;
    CwidNode            head;

    cw = (XmContainerWidget) widget;
    head = cw->container.first_node;
    if ( head )
    {
        SortNodes( widget, head, comp, sortPckg );

        /* Have to mark all items as not Placed so that LayoutSpatial
         * will place them in new sorted order.
         */
        if ( CtrLayoutIsSPATIAL( widget ) )
        {
            PlaceItemReset( widget );
            InvalidateAllCells( cw );
        }

        Layout( widget );
        if ( XtIsRealized( widget ) )
             XClearArea( XtDisplay( widget ),
                         XtWindow( widget ), 0, 0, 0, 0, True );
    }
    /* this function did not have a return value. This needs to be fixed! */
    return True;
}


/************************************************************************
 * XuiclPointerInfo
 *   based on LocatePointer
 ************************************************************************/
Widget
XuiclPointerInfo(
    Widget  wid,
    int     x,
    int     y,
    int*    columnPos,
    Boolean*  headingText,
    Boolean*  titleText)
{
    XmContainerWidget      cw = (XmContainerWidget) wid;
    CwidNode               node;
    XmContainerConstraint  c;
    Widget                 prev_cwid;
    XmGadget               g;
    long                   workY;

    if ( columnPos )
        *columnPos   = -1;
    if ( titleText )
        *titleText   = False;    /* not supported at present */
    if ( headingText )
        *headingText = False;

    if ( CtrViewIsDETAIL( cw )  &&  cw->container.detail_count )
    {
        int        x1,x2;
        Widget     result = 0;

        x1 = cw->container.margin_w;
        x2 = cw->container.ideal_width - cw->container.margin_w;
        if ( CtrLayoutIsLtoR( cw ) )
            x2 = MIN( x2, cw->core.width );
        if ( CtrLayoutIsRtoL( cw ) )
        {
            x1 = MAX( 0, cw->core.width - x2 );
            x2 = cw->core.width - cw->container.margin_w;
        }
        if ( ( x < x1 )  ||  ( x2 < x ) )
            return NULL;

        /*
         * ICLUI: Account for calls to XuiclSetVerticalDisplayOffset.
         */
        workY = cw->container.heading_rect.y -
                  cw->container.verticalDisplayOffset;
        if ( y >= workY  &&
             ( y <= workY + cw->container.heading_rect.height ) )
        {
            if ( headingText )
                *headingText = True;
            prev_cwid = wid;
        }
        else
        {
            prev_cwid = NULL;
        }

        node = cw->container.first_node;
        while ( node != NULL )
        {
            c = GetContainerConstraint( node->widget_ptr );
            if ( y < c->row_y )
            {
                result = prev_cwid;
                break;
            }
            if ( y <= c->row_y + c->row_height )
            {
                result = node->widget_ptr;
                break;
            }
            if ( c->row_y + c->row_height > cw->core.height )
                return NULL;
            prev_cwid = node->widget_ptr;
            node = GetNextNode( wid, node );
        }

        if ( result )
        {
            int i;
            int upper = cw->container.tabs[0] +
                                    cw->container.hspacing/2;
            int lower = upper;
            for ( i = 0; i < cw->container.detail_count; i++ )
            {
                upper += cw->container.tabs[i+1] +
                         cw->container.hspacing;
                if ( x >= lower  &&  x <= upper )
                {
                    if ( columnPos )
                        *columnPos = i;
                    break;
                }
                lower = upper;
            }
            return result;
        }
        else
            return NULL;
    }

    /* For all views other than Details */
    node = cw->container.first_node;
    prev_cwid = NULL;
    while ( node != NULL )
    {
        c = GetContainerConstraint( node->widget_ptr );
        g = (XmGadget) node->widget_ptr;
        if ( ( y < g->rectangle.y )  &&  CtrLayoutIsOUTLINE( cw ) )
            return prev_cwid;
        if ( ( g->rectangle.x <= x )  &&
             ( x <= g->rectangle.x + g->rectangle.width )  &&
             ( g->rectangle.y <= y )  &&
             ( y <= g->rectangle.y + g->rectangle.height ) )
            return node->widget_ptr;
        if ( ( g->rectangle.y + g->rectangle.height > cw->core.height )  &&
             CtrLayoutIsOUTLINE( cw ) )
            return NULL;
        if ( ( g->rectangle.x <= x )  &&
             ( x <= g->rectangle.x + g->rectangle.width ) )
            prev_cwid = node->widget_ptr;
        else
            prev_cwid = NULL;
        node = GetNextNode( wid, node );
    }

    return NULL;
}

/************************************************************************
 * XuiclExpandCollapseTree
 ************************************************************************/
void
XuiclExpandCollapseTree(
    Widget         wid,
    unsigned char  newstate,
    Boolean        children )
{
    Boolean               refresh_later = True;
    XmContainerWidget     cw = (XmContainerWidget) wid;
    WidgetList            gadget = NULL;
    int                   i, curListCount;
    XmContainerConstraint c;

    if ( XtIsSubclass( wid, xmIconGadgetClass ) )
    {
        cw = (XmContainerWidget) XtParent( wid );

        if ( children == True )
        {
            refresh_later = False;
            curListCount =
                XmContainerGetItemChildren( (Widget) cw, wid, &gadget );
            for ( i = 0; i < curListCount; i++ )
            {
                c = GetContainerConstraint( gadget[i] );
                if ( c->node_ptr->child_ptr )
                {
                    XuiclExpandCollapseTree( gadget[i], newstate, True );
                }
            }
        }

        c = GetContainerConstraint( wid );
        if ( c->outline_state != newstate )
        {
            if ( c->outline_button )
            {
                XmAnyCallbackStruct pbcbs;
                XEvent event;                   /* dummy event */
                pbcbs.event = &event;

                /* callback toggles the expand/collapse state */
                OutlineButtonCallbackProgram( c->outline_button,
                                              wid, &pbcbs );
            }
            else c->outline_state = newstate; /* set the new state anyway
                                                 for a leaf node */
        }
    }
    else if ( children )   /* container widget */
    {
        curListCount =
            XmContainerGetItemChildren( (Widget) cw, (Widget) 0, &gadget);
        for ( i = 0; i < curListCount; i++ )
        {
            c = GetContainerConstraint( gadget[i] );
            /*
             * XmContainerGetItemChildren searches one level deep,
             * so call recursively if necessary
             */
            if( c->node_ptr->child_ptr )
            {
                XuiclExpandCollapseTree( gadget[i], newstate, True );
            }
        }
    }

    if ( gadget )
        XtFree( (char*) gadget );

    /* refresh */
    if ( refresh_later  &&  CtrLayoutIsOUTLINE( cw ) )
    {
        Layout( (Widget) cw );
        RequestNewSize( (Widget) cw );
        if ( XtIsRealized( (Widget) cw ) )
        {
            XClearArea( XtDisplay( (Widget) cw),
                        XtWindow( (Widget) cw), 0, 0, 0, 0, True );
        }
    }
}

/************************************************************************
 * XuiclLocation
 ************************************************************************/
Boolean
XuiclLocation(
    Widget       cwid,
    Widget       gid,
    int          columnPos,
    Position*    label_x,
    Position*    label_y,
    XRectangle*  cell_rect)  /* detailsObjectRectangle for the cell */
{
    /*  Returns location info in X coordinates.
     *
     *                           gid         columnPos
     *                           ---         ---------
     *  details view              x              x
     *  details view heading                     x
     *  non-details record        x
     */
    XmContainerWidget   cw = (XmContainerWidget) cwid;
    XmGadget            g = (XmGadget) gid;
    long                workY;

    if ( cw == 0 )
        return False;

    if ( columnPos != -1 )
    {                      /* details view specified */
        if ( CtrViewIsDETAIL( cw )  &&
             ( cw->container.detail_count != 0 ) )
        {
            if ( gid )            /* entry detail specified */
            {
                XmContainerConstraint c = GetContainerConstraint( gid );
                CwidNode node = c->node_ptr;

                if ( node->parent_ptr == NULL )
                {   /* root icon gadget */
                    /* y position of the bottom of the detail entry */
                    if ( label_y )
                    {
                        /* If showing the icon, see if
                         * it has a widget baseline method, which changes
                         * the line spacing.
                         */
                        if ( cw->container.showIconInDetail )
                        {
                            Dimension *baselines;
                            int        baseline_count;
                            Position   string_y = c->row_y;
                            XmGadgetClassExt *gcePtr =
                                _XmGetGadgetClassExtPtr(
                                    (XmGadgetClass)XtClass( gid ),
                                    NULLQUARK );
                            if ( *gcePtr  &&  (*gcePtr)->widget_baseline )
                            {
                                if ( ( *( (*gcePtr)->widget_baseline ) )
                                             ( node->widget_ptr,&baselines,
                                               &baseline_count ) )
                                {
                                    string_y = MAX( c->row_y,
                                                    baselines[baseline_count-1]
                                                      - c->detail_height );
                                    XtFree( (char*) baselines );
                                }
                            }
                            *label_y =  string_y;
                        }
                        else
                        {   /* not showing the icon */
                            *label_y = c->row_y;
                        }
                    }

                    if ( label_x  ||  cell_rect )
                    {
                        int i;
                        Position pos_x = cw->container.tabs[ 0 ] +
                                         cw->container.hspacing;
                        for ( i = 0; i < columnPos; i++ )
                        {
                            if ( ShowColumn( cwid, i ) )
                            {
                                pos_x += cw->container.tabs[ i+1 ] +
                                         cw->container.hspacing;
                            }
                        }

                        while ( ShowColumn( cwid, i ) == 0 )
                        {
                            i++;
                            assert( i < cw->container.detail_count );
                        }

                        if ( label_x )
                            *label_x = pos_x;

                        if ( cell_rect )
                        {
                            cell_rect->x      = pos_x
                                                 - cw->container.hspacing/2;
                            cell_rect->width  = cw->container.tabs[ i+1 ]
                                                 + cw->container.hspacing;
                            if ( i == 0 )
                            {   /* first */
                                cell_rect->x     -= cw->container.hspacing/2;
                                cell_rect->width += cw->container.hspacing/2;
                            }
                            else if ( i == cw->container.detail_count - 1 )
                            {   /* last */
                                cell_rect->width -= cw->container.hspacing/2;
                            }
                            cell_rect->y      = c->row_y;
                            cell_rect->height = c->row_height;
                        }
                    }
                    return True;
                }
                else
                {   /* no entry details for non-root icon gadgets */
                    return False;
                }
            }
            else
            {   /* detail heading specified */
                /*
                 * ICLUI: Account for calls to XuiclSetVerticalDisplayOffset.
                 */
                workY = cw->container.heading_rect.y -
                          cw->container.verticalDisplayOffset;
                if ( workY <= MIN_SHORT )
                {   // Prevent underflow.
                    workY = MIN_SHORT;   // -32768
                }
                if ( label_y )
                {
                    *label_y = workY;
                }
                if ( label_x || cell_rect )
                {
                    int i;
                    Position pos_x = cw->container.tabs[ 0 ] +
                                     cw->container.hspacing;
                    for ( i = 0; i < columnPos; i++ )
                    {
                        if ( ShowColumn( cwid, i ) )
                        {
                            pos_x += cw->container.tabs[ i+1 ] +
                                     cw->container.hspacing;
                        }
                    }

                    while ( ShowColumn( cwid, i ) == 0 )
                    {
                        i++;
                        assert( i < cw->container.detail_count );
                    }

                    if ( label_x )
                        *label_x = pos_x;

                    if ( cell_rect )
                    {
                        cell_rect->x      = pos_x
                                             - cw->container.hspacing/2;
                        cell_rect->width  = cw->container.tabs[ i+1 ]
                                             + cw->container.hspacing;
                        if ( i == 0 )
                        {   /* first */
                            cell_rect->x     -= cw->container.hspacing/2;
                            cell_rect->width += cw->container.hspacing/2;
                        }
                        else if ( i == cw->container.detail_count - 1 )
                        {   /* last */
                            cell_rect->width -= cw->container.hspacing/2;
                        }
                        cell_rect->y      = workY;
                        cell_rect->height =
                                       cw->container.heading_rect.height;
                    }
                }
                return True;
            }
        }
        else
            return False;    /* not-found */
    }
    else
    {                      /* non-details view specified */
        if ( gid == 0 )
            return False;
        return XuiclIconGadgetLabelCoords( gid, label_x, label_y );
    }
}

/************************************************************************
 *  XuiclSetLocationCursor
 ************************************************************************/
void XuiclSetLocationCursor(
    Widget wid)
{
    Widget cw = XtParent( wid );

    SetLocationCursor( cw, wid );
}

/************************************************************************
 * XuiclRectangle
 ************************************************************************/
XRectangle
XuiclRectangle(
    Widget        cwid,
    Widget        gid,
    unsigned long extent, /* XmICON_EXTENT | XmTEXT_EXTENT */
    int           columnPos)
{
    XmContainerWidget  cw = (XmContainerWidget) cwid;
    XmGadget           g = (XmGadget) gid;
    XRectangle         badrect;

    badrect.x = badrect.y = -1;
    badrect.height = badrect.width = 0;

    if ( cw == 0 )
        return badrect;

    if ( CtrViewIsDETAIL( cw ) )
    {
        static XRectangle nullRect; /* readonly */
        XRectangle rect;

        if ( cw->container.detail_count == 0 )
            return nullRect;

        if ( columnPos == -1 )      /* return details cell only */
        {
            XmContainerConstraint c = GetContainerConstraint( gid );
            CwidNode node = c->node_ptr;

            if ( node->parent_ptr == NULL )
            {   /* root icon gadget */
                rect.x = cw->container.margin_w;
                rect.width = cw->container.ideal_width
                                - 2 * cw->container.margin_w;
                if ( cw->core.width < rect.x + rect.width )
                    rect.width = cw->core.width - rect.x;
                if ( CtrLayoutIsRtoL( cw ) )
                    rect.x = MAX( 0, cw->core.width - rect.width
                                        - cw->container.margin_w );
                rect.y = c->row_y;
                rect.height = c->row_height;

                return rect;
            }
            else
            {   /* no entry details for non-root icon gadgets */
                return nullRect;
            }
        }
        else                 /* return details column rectangle */
        {
            return nullRect; /* not implemented yet */
        }
    }
    else
        return XuiclIconGadgetRectangle( gid, extent );
}

/************************************************************************
 * XuiclTabWidth
 ************************************************************************/
unsigned long
XuiclTabWidth(
    Widget    wid,
    int       columnPos )
{
    XmContainerWidget cw = (XmContainerWidget) wid;

    if ( cw->container.detail_count > columnPos )
        return cw->container.tabs[ columnPos + 1 ];
    else
        return 0;
}

/* There is a need to do some additional work when refresh() is celled
 * so we added a method XuiclRefresh. This does not do the same things as
 * XuiclRefresh, discussed below, which is left in place for
 * information purposes.
 */
/************************************************************************
 * XuiclRefresh
 ************************************************************************/
void XuiclRefresh(
    Widget  wid)
{
    XmContainerWidget  cw = (XmContainerWidget) wid;

    if ( CtrLayoutIsSPATIAL( cw ) )
    {
        /* When we add objects in spatial view with refresh turned off,
         * we need to reset cell width and height so ChangeManaged will
         * lay out cells correctly - for case where there are already
         * items present and their cell size is smaller than the new items
         */
        cw->container.large_cell_width  = 0;
        cw->container.large_cell_height = 0;
        cw->container.small_cell_width  = 0;
        cw->container.small_cell_height = 0;

        /* Note: d3602 had a problem where adding objects
         * in spatial view with refresh off would not
         * recalculate a new cell size for the new objects
         * if the added objects did not cause the
         * current_height_in_cells or current_width_in_cells
         * to increment in LayoutSpatial(). So force
         * current_height(width)_in_cells = 0 here and
         * force LayoutSpatial() to re-calculate new cell width
         * and height for new item.
         */
        cw->container.current_height_in_cells = 0;
        cw->container.current_width_in_cells  = 0;
    }
    else if ( ( CtrDrawLinesOUTLINE( cw )  ||
                CtrViewIsDETAIL( cw ) )  &&
              XtIsRealized( wid ) )
    {
        /*
         * Refreshing a tree view or details view container requires
         * that Redisplay be called with an expose event to draw the
         * lines/separators for the view.
         *
         * ICLUI: Added details view to this.
         */
        XClearArea( XtDisplay( wid ), XtWindow( wid ), 0, 0, 0, 0, True );
    }
}

XtGeometryResult XuiclReplyToQueryGeometry(
    Widget            widget,
    XtWidgetGeometry *intended,
    XtWidgetGeometry *desired)
{
    /* this code needs to be checked against GMutils.c */

    desired->request_mode = ( CWWidth | CWHeight );

    if ( ( intended->request_mode & CWWidth    ) &&
         ( intended->width == desired->width   ) &&
         ( intended->request_mode & CWHeight   ) &&
         ( intended->height == desired->height ) )
    {
        return XtGeometryYes;
    }

    if ( ( desired->width == XtWidth( widget ) )  &&
         ( desired->height == XtHeight( widget ) ) )
    {
        return XtGeometryNo;
    }

    return XtGeometryAlmost;
}

/************************************************************************
 * XuiclDetailsTitleRectangle
 ************************************************************************/
extern void XuiclDetailsTitleRectangle(
    Widget      wid,
    XRectangle *rect)
{
    XmContainerWidget cwid = (XmContainerWidget) wid;

    rect->x      = cwid->container.margin_w;
    rect->y      = cwid->container.margin_h;
    rect->width  = cwid->container.ideal_width -
                     ( 2 * cwid->container.margin_w );
    rect->height = cwid->container.heading_rect.height;
}

#if DETECT_OVERFLOW

/************************************************************************
 *  XuiclGetOverflowCount
 ************************************************************************/
int XuiclGetOverflowCount(
    Widget wid)
{
    /* Gadget overflow count in XmContainer widget might have been set
     * during one of the Layouts. Reset it and return it.
     */
    XmContainerWidget cw = (XmContainerWidget) wid;
    int n = cw->container.nodes_laidout;
    cw->container.nodes_laidout = 0;
    return n;
}
#endif  /* DETECT_OVERFLOW */

#if EMPTY_CNR_REGION
/************************************************************************
 *  XuiclMouseAction
 ************************************************************************/
void XuiclMouseAction(
    Widget        wid,
    XButtonEvent *xbutton,
    String       *params,
    Cardinal     *numParams)
{
    if ( xbutton->type == ButtonPress )
    {
        ContainerBeginSelect( wid, (XEvent*) xbutton, params, numParams );
    }
    else if( xbutton->type == ButtonRelease )
    {
        ContainerEndSelect( wid, (XEvent*) xbutton, params, numParams );
    }
}
#endif  /* EMPTY_CNR_REGION */

#if 0
#ifdef IC_NOTYET
/* The following 2 methods for "refresh" are not yet being called
 * from the C++ code. They had no apparent effect in speeding up adding or
 * removing objects, and there were several problems encountered:
 *   last added item couldn't be scrolled to in tree view
 *   crashed once when switching from tree to icon view (couldn't duplicate)
 *   doing a removeAll after adding lots of objects caused a hange
 *     (couldn't duplicate the hang either)
 * Kind of scary, don't have time to try this for GA, but will leave the
 * source here if we want to try it again.
 */
/************************************************************************
 *  XuiclSetRefreshOn
 ************************************************************************/
void XuiclSetRefreshOn(
    Widget  wid,
    Boolean turnItOn)
{
    XmContainerWidget  cw = (XmContainerWidget) wid;

    if ( turnItOn )
        cw->container.refreshOn = True;
    else
        cw->container.refreshOn = False;
}

/*if 0      #if 0   was added when we added XuiclRefresh above */
/*ifdef IC_NOTYET */
/************************************************************************
 *  XuiclRefresh
 ************************************************************************/
void XuiclRefresh(
    Widget wid )
{
    XmContainerWidget  cw = (XmContainerWidget) wid;
    Boolean            currentState = cw->container.refreshOn;

    cw->container.refreshOn = True;
    Layout( wid );
    if ( XtIsRealized( wid ) )
        XClearArea( XtDisplay( wid ),
                    XtWindow( wid ), 0, 0, 0, 0, True );
    cw->container.refreshOn = currentState;
}
#endif
#endif

/************************************************************************
 *  XuiclGetLogicalDisplayHeight
 *  Return the total height in pixels of the displayable data of the
 *  container widget (this will easily exceed 32K for a large number of
 *  objects in some views).
 ************************************************************************/
unsigned long XuiclGetLogicalDisplayHeight (
    Widget widget )
{
    XmContainerWidget cw = (XmContainerWidget) widget;
    return cw->container.logicalDisplayHeight;
}

/************************************************************************
 *  XuiclGetVerticalDisplayOffset
 *  Return the offset in vertical pixels to the displayable data of the
 *  container widget that is currently formatted to be displayed
 *  at 0,0 of the widget.
 *  (See XuiclSetVerticalDisplayOffset for additional information.)
 ************************************************************************/
unsigned long XuiclGetVerticalDisplayOffset (
    Widget widget )
{
    XmContainerWidget cw = (XmContainerWidget) widget;
    return cw->container.verticalDisplayOffset;
}

/************************************************************************
 *  XuiclSetVerticalDisplayOffset
 *  Set the offset in vertical pixels to the displayable data of the
 *  container widget that is to be displayed at 0,0 of the widget.
 *
 *  A container widget will have three levels of displayable data:
 *   1. The logical formatted display buffer of the container widget,
 *      which can require more than 32K vertical pixels to display 
 *   2. The 32K of vertical pixels of currently displayable data,
 *      which is actually drawn by the container widget in its window
 *      (this is a subset of 1)
 *   3. The container contents drawn on the screen and seen by the
 *      user, which is the displayed data drawn by the container widget
 *      and clipped by the parent scrolling window (this is a subset of
 *      2)
 *
 *               +-----------------------+           <---+
 *               |                       |               |
 *               |                       |               |
 *               |                       |               |
 *   vertical    |                       |               |
 *    display    |                       |               | Logical
 *    offset --->|- - - - - - - - - - - -|   A           |  formatted
 *               |                       |   |           |  display
 *               | +- - - - - - +        |   |           |  buffer
 *               | | Screen     |        |  Currently    |  of the
 *               |    contents           |   displayed   |  container
 *               | |  of the    |        |   32K of      |  widget
 *               |    container          |   vertical    |  (>32K of
 *               | |  widget    |        |   pixels      |  vertical
 *               | +- - - - - - +        |   |           |  pixels,
 *               |                       |   |           |  in this
 *               |                       |   |           |  case)
 *               |- - - - - - - - - - - -|   V           |
 *               |                       |               |
 *               |                       |               |
 *               +-----------------------+           <---+
 *
 *  Calling this function sets the data described by 2.
 ************************************************************************/
unsigned long XuiclSetVerticalDisplayOffset (
    Widget        widget,
    unsigned long offset,
    Boolean       update )
{
    unsigned long
        newOffset = offset;
    XmContainerWidget cw = (XmContainerWidget) widget;
    if ( newOffset > cw->container.logicalDisplayHeight )
    {
        newOffset = cw->container.logicalDisplayHeight;
    }
    cw->container.verticalDisplayOffset = newOffset;

    if ( update )
    {
        // Update the positions of the icon gadgets now, and rerun
        // Layout and Redisplay.
        // Ideally we could just walk collections/array/linked lists to
        // update Y positions of visible elements, rather than call
        // Layout to rebuild and recalculate all this information from
        // scratch. However, some of the arrays are X structures, such as
        // XmContainerPart::outline_segs, the collection of line segments
        // for drawing tree view lines, which is an array of XSegment
        // structures, which only contains shorts.
        Layout( widget );
        if ( CtrDrawLinesOUTLINE( cw )  ||  CtrViewIsDETAIL( cw ) )
        {
            XFillRectangle( XtDisplay( widget ), XtWindow( widget),
                            cw->container.inverseGC,
                            0, 0, cw->core.width, cw->core.height );
        }
        XuiclRefresh( widget );
    }

    return newOffset;
}
