// Revision: 40 1.14.2.2 source/ui/extapp/iflytext.cpp, staticctls, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: iflytext.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in iflytext.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#pragma priority( -2147481524 )

extern "C"
{
  #define INCL_WINWINDOWMGR
  #define INCL_WINSTATICS
  #define INCL_WINCOUNTRY
  #define INCL_WINHOOKS
  #include <iwindefs.h>
  #ifdef IC_WIN
    #include <commctrl.h>
  #endif
  #ifdef IC_MOTIF
    #include <Xm/Label.h>
    #include <Xm/MwmUtil.h>
  #endif
}

#include <iflytext.hpp>
#include <iflypain.hpp>
#include <icoordsy.hpp>

#ifdef IC_PM
#include <ibundles.hpp>
#include <igraph2d.hpp>
#endif

#include <inotifev.hpp>
#include <iptarray.hpp>
#include <irect.hpp>
#include <ithread.hpp>
#include <icolor.hpp>
#include <ifont.hpp>
#include <iexcept.hpp>
#include <istring.hpp>
#include <ireslib.hpp>
#include <itrace.hpp>
#ifdef IC_MOTIF
  #include <imstring.hpp>
#endif
#include <ilanglvl.hpp>

// Segment definitions.
#ifdef IC_PAGETUNE
  #define _IFLYTEXT_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_MOTIF
extern "C" Widget ICreateFlyText(Widget   parent,
                      char*    name,
                      ArgList  arglist,
                      Cardinal argcount);
#endif

#ifdef IC_PM
//------------------------------------------------------------------------------
// IFlyTextData : private data for IFlyText.
//------------------------------------------------------------------------------
#pragma enum(4)
#pragma pack(push,4)

class IFlyTextData {
public:
  IFlyTextData ( )
   : fPaintHandler ( )
   { }
 ~IFlyTextData ( )
   { }

IFlyTextPaintHandler
  fPaintHandler;
}; // IFlyTextData

#pragma pack(pop)
#pragma enum(pop)

#endif

#ifdef IC_MOTIF
// Function to create the fly text shell and widget.
extern "C" Widget ICreateFlyText(Widget   parent,
                                 char*    name,
                                 ArgList  arglist,
                                 Cardinal argcount)
{
  Widget shell;
  shell = XtCreatePopupShell( name,
                              overrideShellWidgetClass,
                              parent,
                              arglist,
                              argcount);
  if (shell)
  {
     Arg            args[3];
     int            n = 0;

     // need the following to get colors to stick in the label widget
     XtSetArg(args[n], XmNbackground, IColor(IColor::yellow).asPixel() ); n++;
     XtSetArg(args[n], XmNforeground, IColor(IColor::black).asPixel() ); n++;

     // Set alignment to beginning
     XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING);  n++;

     // Merge the local argument list with the one passed by the caller.
     ArgList
       mergedArgList = XtMergeArgLists( args,
                                        n,
                                        arglist,
                                        argcount );
     Cardinal
       mergedArgCount = n + argcount;

     Widget label = XmCreateLabel( shell,
                                   name,
                                   mergedArgList,
                                   mergedArgCount );
     XtManageChild( label );
  }
  return shell;
}
#endif


bool    IFlyText::fgRegistered(false);
IRectangle IFlyText::fgScreen(IRectangle(0,0,0,0));

/*------------------------------------------------------------------------------
| IFlyText::IFlyText                                                           |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyText::IFlyText ( unsigned long id, IWindow *owner )
  : IFlyText::Inherited( ), fFlyTextData(0),
#ifdef IC_PM
    fHelpArrow(),
#endif
    fArrowPos( IFlyText::upperLeft )
{
  IASSERTPARM(owner != 0);

#ifdef IC_WIN
  // insure common controls DLL is loaded
  InitCommonControls();

  // Find the first window in the owner chain which can be a
  // real owner in Windows.  Cannot be a child.
  while ( (owner) && (!owner->isFrameWindow() ) )
     owner = owner->owner();
#endif

  IWindowHandle ownerHandle = owner->handle();

#ifdef IC_PM
  fFlyTextData = new IFlyTextData;
#endif //IC_PM

  if (!fgRegistered)
  {
    fgRegistered = true;
    // query the dimension of the desktop
    fgScreen = IWindow::desktopWindow()->nativeRect();
  }

#ifdef IC_WIN
  IWindowHandle flytext(
    this -> create ( 0,
                     0,
  #ifdef IC_TRACE_ALL
                     TTS_ALWAYSTIP |      // Allow debugger to have focus!!
  #endif
                     WS_POPUP,
                     TOOLTIPS_CLASS,
                     IWindow::desktopWindow()->handle(),
                     ownerHandle,
                     IRectangle(),
                     0,
                     0,
                     defaultOrdering(),
                     WS_EX_TOOLWINDOW ) );
#endif // IC_WIN
#ifdef IC_PM
  IWindowHandle flytext(
    this -> create ( id,
                     0,
                     SS_TEXT | WS_SAVEBITS,
                     WC_STATIC,
                     IWindow::desktopWindow()->handle(),
                     ownerHandle,
                     IRectangle(),
                     0,
                     0 ));
#endif
#ifdef IC_MOTIF
  IArgList
    iargList;
  if ( IBidiSettings::isBidiSupported() )
  {
     // Give the fly-over help the bidi attributes of its owner window.
     IBidiSettings
       bidiSettings( *owner );
     iargList = bidiSettings.asArgList();
  }

  Colormap       colorMap;
  //  Set font here ?
  XtVaGetValues (ownerHandle,
                 XmNcolormap, &colorMap,
                 NULL);
  if (colorMap)
  {
     iargList
      .setResource( XmNcolormap, colorMap );
  }
  IWindowHandle flytext(
     this-> create( id,                   // id
                    0,                    // no text (yet)
                    0,                    // style is 0
                    (IXmCreateFunction)ICreateFlyText,
                    IWindow::desktopWindow()->handle(), // parent handle
                    ownerHandle,                        // owner  handle
                    IRectangle(),                 // size
                    (ArgList) iargList.argList(),
                    iargList.numberOfArgs() ) );
#endif

  startHandlingEventsFor(flytext);

#ifdef IC_PM
  fFlyTextData->fPaintHandler.handleEventsFor( this );

  // Set default font to Helv.8
  // Note: DBCS OS/2 systems should use the default font instead of Helv
  //       since the double-byte characters do not exist fot this font

  unsigned long codepage = WinQueryCp(HMQ_CURRENT);
  switch (codepage)
  {
    // Note: The following list represents the DBCS code pages supported
    //       by OS/2 2.1 and Warp as of June 1995

    case  949: // Korean                      (replaces older 934/944)
    case  944: // Korean
    case  934: // Korean
    case 1381: // People's Republic of China  (replaces older 936/946)
    case  936: // People's Republic of China
    case  946: // People's Republic of China
    case  950: // Taiwan                      (replaces older 938/948)
    case  938: // Taiwan
    case  948: // Taiwan
    case  932: // Japanese
    case  942: // Japanese
    {
      IFont fnt(this);
      fnt.setPointSize(8);
      fnt.setWindowFont(this);
    }
    break;
    default:
    {
      IFont fnt("Helv",8);
      fnt.setWindowFont(this);
    }
    break;
  }

  // Set the default colors
  setBorderColor( IColor::black );
  setShadowColor( IColor::darkGray );
  setBackgroundColor( IColor::yellow );
  setForegroundColor( IColor::black );
#endif  //IC_PM

}

#if IC_EXTENDED_RTTI_ENABLED
IFlyText::IFlyText(const IFlyText&)
{
}
#endif // IC_EXTENDED_RTTI_ENABLED

/*------------------------------------------------------------------------------
| IFlyText::~IFlyText                                                          |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyText::~IFlyText()
{
#ifdef IC_PM
  fFlyTextData->fPaintHandler.stopHandlingEventsFor( this );
  delete fFlyTextData;
#endif
}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IFlyText::text                                                               |
|                                                                              |
| Returns the control window's text.                                           |
------------------------------------------------------------------------------*/
IString  IFlyText::text() const
{
   IString              textString;

   // Get the label widget and return its text value
   IWindow::ChildCursor cursor( *(IWindow*)this );
   cursor.setToFirst();
   if (cursor.isValid())
      {
      IWindowHandle::Value label = this->childAt(cursor);
      textString = IMString( label, XmNlabelString).asString( ) ;
      }
   return textString;
}
#endif //IC_MOTIF


/*------------------------------------------------------------------------------
| IFlyText::setText                                                            |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyText& IFlyText::setText( const char* text )
{
#ifdef IC_PMWIN
  Inherited::setText( IString::change(text, (char*)"\xA", (char*)""));
#endif

#ifdef IC_MOTIF
  IString str(text);
  str.change((char*)"\xA", (char*)"");
  // Get the label widget to set its text value
  IWindow::ChildCursor cursor( *this );
  cursor.setToFirst();
  if (cursor.isValid())
     {
     IWindowHandle::Value label = this->childAt(cursor);
     IMString  theText = IMString( str );

     // If the new string is different then set it and send the
     // notification of text change.
     if (theText != IMString( label, XmNlabelString ) )
        {
        XtVaSetValues(
           label,
           XmNlabelString, (XmString)theText,
           NULL );

        this->notifyObservers(INotificationEvent(
          ITextControl::textId, *this));
        ISize strSize = theText.size( label );
        // size to the new string
        ITRACE_ALL(IString("String size is ") + strSize.asString() );
        strSize += ISize(4,10);         // Add a pad ... size seems too small
        this->sizeTo( strSize );
        }
     }
#endif

#ifdef IC_PM
  this->sizeTo( displaySize() + ISize(6,1) );
#endif
  return *this;
}

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IFlyText::setForegroundColor                                                 |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyText& IFlyText::setForegroundColor( const IColor& color )
{
  IWindowHandle::Value label;
  IWindow::ChildCursor cursor( *(IWindow*)this );
  cursor.setToFirst();
  if (cursor.isValid())
    label = this->childAt(cursor);
  XtVaSetValues ( handle(),
                  XmNforeground, color.index(),
                  NULL );
  XtVaSetValues ( label,
                  XmNforeground, color.index(),
                  NULL );
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyText::setBackgroundColor                                                 |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyText& IFlyText::setBackgroundColor( const IColor& color )
{
  IWindowHandle::Value label;
  IWindow::ChildCursor cursor( *(IWindow*)this );
  cursor.setToFirst();
  if (cursor.isValid())
    label = this->childAt(cursor);
  XtVaSetValues ( handle(),
                  XmNbackground, color.index(),
                  NULL );
  XtVaSetValues ( label,
                  XmNbackground, color.index(),
                  NULL );
  return *this;
}
#endif //IC_MOTIF

/*------------------------------------------------------------------------------
| IFlyText::setText                                                            |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyText& IFlyText::setText( const IResourceId& text )
{
  Inherited::setText( text );
  return *this;
}

/*------------------------------------------------------------------------------
| IFlyText::setRelativeWindowRect                                              |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IFlyText& IFlyText::setRelativeWindowRect ( const IRectangle& rect )
{
  fWinrc = rect;
  // This function has no effect in Windows.  We simply store the
  // value given and return it in relativeWindowRect().
#ifdef IC_MOTIFPM

#ifdef IC_PM
  IUPDATEWINDOW(IWindow::desktopWindow()->handle());
#endif

  // The fWinrc rectangle in Motif is the pointer position in desktop
  // coordinates.  Move the flytext below and to the right of it
  // so that the pointer does not seem to be in the fly text.
  // OS/2 also now positions based on mouse pointer.

  const IPoint overlap(10,-10);
  IRectangle textRect(IPoint(0,0), this->size());

  IPoint newPos;
  
  if ( ICoordinateSystem::applicationOrientation() ==
       ICoordinateSystem::originLowerLeft )
  {
     newPos = IPoint(  fWinrc.maxX() + overlap.x(),
                       fWinrc.minY() + overlap.y() - textRect.height());
  }
  else
  {
      newPos = IPoint(  fWinrc.maxX() + overlap.x(),
                       fWinrc.maxY() - overlap.y() );
  }

  //Make sure the text does not go off the screen
  //Shift it to the left if necessary
  long offSetX = fgScreen.width() - (textRect.width() + newPos.x() );
  if( offSetX < 10 )  //the < 10 is just a little insurance that the text is not off the screen
  {
     newPos.setX(newPos.x() + offSetX - overlap.x());
  }
		
  //Make sure the text does not go off the bottom of the screen
  //Shift it up if necessary
  if ( ICoordinateSystem::applicationOrientation() ==
       ICoordinateSystem::originLowerLeft )
  {
     if( textRect.height() > newPos.y() )
     {
     	newPos.setY( fWinrc.maxY() - overlap.y());
     }
  }
  else
  {
     if( fgScreen.height() < (textRect.height() + newPos.y()) )
     {
        newPos.setY( fWinrc.minY() + overlap.y() - textRect.height());
     }
  }

  this->moveTo(newPos);  
#endif
  return *this;
}


/*------------------------------------------------------------------------------
| IFlyText::relativeWindowRect                                                 |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IRectangle IFlyText::relativeWindowRect( ) const
{
  return fWinrc;
}

/*------------------------------------------------------------------------------
| IFlyText::hide                                                               |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IWindow& IFlyText::hide( )
{
#ifdef IC_MOTIFWIN
  Inherited::hide();
#endif
#ifdef IC_PM
  bool invalidate = false;
  if (this->isVisible())
  {
    // Check to see if the entire fly text is visible (we do this by
    // checking each corner point to see if the window under that point
    // is the fly text control).  In the future, the WinQueryVisibleRegion
    // API may provide a better solution, but it is not available on
    // OS/2 2.1 systems.
    IRectangle rctl = this->rect().shrinkBy(ISize(1,1));
    POINTL pt = rctl.bottomLeft().asPOINTL();
    if ( IWINDOWFROMPOINT ( IWindow::desktopWindow()->handle(), &pt, true )
                            != this->handle() )
    {
      invalidate = true;
    }
    pt = rctl.topLeft().asPOINTL();
    if ( IWINDOWFROMPOINT ( IWindow::desktopWindow()->handle(), &pt, true )
                            != this->handle() )
    {
      invalidate = true;
    }
    pt = rctl.topRight().asPOINTL();
    if ( IWINDOWFROMPOINT ( IWindow::desktopWindow()->handle(), &pt, true )
                            != this->handle() )
    {
      invalidate = true;
    }
    pt = rctl.bottomRight().asPOINTL();
    if ( IWINDOWFROMPOINT ( IWindow::desktopWindow()->handle(), &pt, true )
                            != this->handle() )
    {
      invalidate = true;
    }
  }
  Inherited::hide();
  if ( invalidate )
  {
     IWindow::desktopWindow()->refresh(this->rect());
  }
#endif
  return *this;
}
