// Revision: 13 1.7.1.10 source/ui/cnr/icnrmhdr.cpp, container, ioc.v400, 001006 
/*******************************************************************************
* FILE NAME: icnrmhdr.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in icnrmhdr.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#define INCL_WINSTDCNR
#define INCL_WINWINDOWMGR
#define INCL_WININPUT
#define INCL_WINFRAMEMGR          // WM_FOCUSCHANGE, SC_CLOSE
#define INCL_WINMESSAGEMGR

extern "C" {
  #include <stdlib.h>
  #include <icconst.h>
  }

#include <icnrrec.hpp>  // Must be first for OS flags

#include <icnrmhdr.hpp>
#include <icmdevt.hpp>
#include <icnrctl.hpp>
#include <ipoint.hpp>
#include <itrace.hpp>
#include <ithread.hpp>
#include <iexcept.hpp>
#include <imenuevt.hpp>
#include <ictlevt.hpp>
#include <iexcept.hpp>
#include <ipopmenu.hpp>
#include <iwcname.hpp>
#include <imenuprv.hpp>
#include <icoordsy.hpp>

// Segment definitions
#ifdef IC_PAGETUNE
  #define _ICNRMHDR_CPP_
  #include <ipagetun.h>
#endif

/*------------------------------------------------------------------------------
| ICnrMenuHandler::~ICnrMenuHandler                                            |
------------------------------------------------------------------------------*/
ICnrMenuHandler :: ~ICnrMenuHandler      ( ) {}

/*------------------------------------------------------------------------------
| ICnrMenuHandler::ICnrMenuHandler() : IMenuHandler                            |
------------------------------------------------------------------------------*/
ICnrMenuHandler::ICnrMenuHandler() : IMenuHandler(),
                                       pcnrobjClMenu(0)
{ }

/*------------------------------------------------------------------------------
| ICnrMenuHandler::dispatchHandlerEvent                                        |
|                                                                              |
| Routes the edit events to the appropriate event functions.                   |
------------------------------------------------------------------------------*/
bool ICnrMenuHandler::dispatchHandlerEvent(IEvent& evt)
{
   switch (evt.eventId())
   {
     case WM_CONTROL:
     {
        IControlEvent ctlevt(evt);
        IContainerControl* pcnrctl =
                                (IContainerControl*)ctlevt.controlWindow();
        if(pcnrctl)
        {
          if ( pcnrctl->handle() )
          {
            IWindowClassName className(pcnrctl->handle());
            unsigned long ulMsg = evt.parameter1().number2();

#ifdef IC_WIN
            if (className == WC_CONTAINER || className == WC_NATIVECONTAINER)
#endif
#ifdef IC_PM
            if (className == WC_CONTAINER)
#endif
            {                        // container
              switch(ulMsg)
              {
                case CN_CONTEXTMENU:
                {
                   // We need to simulate an IMenuEvent that would occur from
                   // a WM_CONTEXTMENU. Get the mouse position in
                   // container window coordinates.  Since the container
                   // does not tell us if this event is from a keyboard
                   // or a mouse, we assume the mouse (to get them from the
                   // keyboard requires an accelorator and the IMenuEvent does
                   // currently support this anyway). Note that we change
                   // the handle in the event from the owner of the container
                   // to the container itself so that the function window()
                   // returns the container as expected.
                   IPoint ptl ;
                   short x(0), y(0) ;
#ifdef IC_PMWIN
                   IQUERYMSGPOS(IThread::current().anchorBlock(), (POINTL *) &ptl);
#endif
#ifdef IC_MOTIF
                   ptl = IWindow::pointerPosition();
                   // IEvent (IMenuEvent) expects desktop native coords, must undo pointerPosition's "convertToApplication"
                   ptl = ICoordinateSystem::convertToNative(
                           ptl, IWindow::desktopWindow()->size() );
#endif
                   //IPoint pt(IWindow::mapPoint( ptl,
                   //                             IWindow::desktopWindow()->handle(),
                   //                             pcnrctl->handle()));
                   x = (short)(ptl.x()); // TTD
                   y = (short)(ptl.y());
                   IEvent evtNew(pcnrctl,
                                 WM_CONTEXTMENU,
                                 IEventData(x,y).asUnsignedLong(),
                                 true);
                   IMenuEvent mnEvt(evtNew);
                   PRECORDCORE pRecord =
#ifdef IC_WIN
                             ((PCNRMENUINIT)(void*)(evt.parameter2()))->pRecord;
#endif
#ifdef IC_MOTIFPM
                             (PRECORDCORE)(unsigned long)(evt.parameter2());
#endif
                   if((void*)pRecord)
                     pcnrobjClMenu = IObjFromRec((IMiniCnrRecord*)pRecord);
                   else
                     pcnrobjClMenu = 0;    //Menu meant for complete cnr.

                  if (makePopUpMenu(mnEvt)) {
                     addSourceEmphasis(mnEvt);
                     evt.setResult(true);   //Tell PM action taken.
                     return true;
                  } /* endif */
                }
              } /* end switch ulMsg */
            } /* endif  ulClassName == WC_CONTAINER */
          } /* endif handle valid */
        } /* pcnrctl != 0 */
        break;
     } /* endif WM_CONTROL */
#ifdef IC_MOTIF
     case WM_CONTEXTMENU:
     {
        // Event to trigger a pop-up menu.
        ITRACE_DEVELOP( "WM_CONTEXTMENU" );
        XButtonPressedEvent * pevent =
           (XButtonPressedEvent *)evt.parameter2().asUnsignedLong();
        // See if button 3 pressed over an IconGadget
        IContainerControl* pCnr = (IContainerControl *) evt.controlWindow() ;
        IPoint clickPoint(pevent->x_root, pevent->y_root) ;
        clickPoint = ICoordinateSystem::convertToApplication(
                         clickPoint,
                         IWindow::desktopWindow()->size()) ;
        clickPoint = IWindow::mapPoint(clickPoint,
                                       IWindow::desktopWindow()->handle(),
                                       pCnr->handle() ) ;
        IMiniCnrRecord* pRec(0);

        //
        if ( pCnr->isPMCompatible() && pCnr->isDetailsView() )
        {
          IPair::Coord coef=-1;
          if ( ICoordinateSystem::isConversionNeeded() )
            coef=1;

          if ( pCnr->areDetailsViewTitlesVisible() )
            clickPoint.setY( clickPoint.y() +
                         coef * pCnr->detailsTitleRectangle().height() );

          if ( pCnr->isTitleVisible() )
            clickPoint.setY( clickPoint.y() + coef * pCnr->titleRectangle().height() );
        }
        //

        IContainerObject *pcnrObj(pCnr->objectUnderPoint(clickPoint)) ;
        if (pcnrObj)
           pRec = IRecFromObj(pcnrObj) ;
        pCnr->sendEvent( WM_CONTROL,
                         IEventParameter1( pCnr->id(),CN_CONTEXTMENU ),
                         IEventParameter2( pRec ));
        return true ;
     } // case WM_BUTTON3DOWN
#endif // IC_MOTIF
#ifdef IC_PMWIN
   case WM_CONTEXTMENU:
   {
      return false;
   } /* endifelse */
   case WM_COMMAND:
   case WM_SYSCOMMAND:
   {                           // These aren't normally sent to owner
      /**********************************************************/
      /* Must ensure that WM_COMMAND and WM_SYSCOMMAND are not  */
      /* sent to the owner window if this cnr is the client     */
      /* area, in the cases where doing so would cause an       */
      /* endless loop between the frame and cnr handlers.       */
      /* The underlying problem is that the frame handler sends */
      /* WM_COMMAND and WM_SYSCOMMAND/SC_CLOSE events, and PM's */
      /* default frame procedure sends WM_COMMAND messages back */
      /* to the client area (FID_CLIENT), which the cnr         */
      /* would then send back to the owner frame, ad infinitum. */
      /* To remedy this problem, the cnr handler sets a bit     */
      /* reserved by the class library in mp2 of the event      */
      /* before sending it on to the owner frame, but doen't    */
      /* send on such events if the bit is already set (the bit */
      /* is used to signal whether the event has already been   */
      /* routed to the frame, and doesn't need to be sent again */
      /* since it would just come back from the frame).         */
      /**********************************************************/
      IContainerControl* pcnrctl = (IContainerControl*)evt.window();
      const IWindow* pwndOwner = pcnrctl->owner();
      ICommandEvent cmdevt(evt);
      bool bClient = (pcnrctl->id() == FID_CLIENT  &&
                         pwndOwner  &&
                         pwndOwner->isFrameWindow());
      if (!bClient  ||  cmdevt.isFromFrame() == false)
      {       // cnr is not client or event never sent to frame
         IWindowHandle whOwner = pwndOwner->handle();

         if (whOwner != IWindow::desktopWindow()->handle()  &&
             whOwner != IWindow::objectWindow()->handle())
         {                     // Valid owner window
            // Dispatch the event to any handlers after this one in
            // then handler list.  If none handle it pass the event
            // on to the owner.
            if (!pcnrctl->dispatchRemainingHandlers( evt, false ))
            {
    #ifdef IC_PM
                unsigned long ul2 = (unsigned long)evt.parameter2();
                if (bClient)
                {                  // Container is client window
                   ul2 |= 0x8000;  // Set reserved bit in source value
                }
                evt.setResult(pwndOwner->handle().
                                    sendEvent(evt.eventId(),
                                              evt.parameter1(),
                                              IEventParameter2(ul2)));
                                   // Forward command event to owner window
    #endif //IC_PM
    #ifdef IC_WIN
                unsigned long ul1 = (unsigned long)evt.parameter1();
                if ( bClient  &&
                     ( evt.eventId() == WM_COMMAND  ||
                       evt.parameter1().number1() != SC_KEYMENU ) )
                {                       // Container is client window.
                   // Don't modify wparam for a WM_SYSCOMMAND/SC_KEYMENU
                   // message, since this causes menu bar mnemonics to not
                   // work from a container.
                   ul1 |= 0x80000000;  // Set reserved bit in source value
                }
                evt.setResult(pwndOwner->handle().
                                    sendEvent(evt.eventId(),
                                              IEventParameter1(ul1),
                                              evt.parameter2()));
                                   // Forward command event to owner window
    #endif //IC_WIN
            }     // if not handled
            return true;
         }
      } /* endif */
      break;
   } /* endcase */
#endif //IC_PMWIN
   default:
      break;

 } /* end switch */

   return Inherited::dispatchHandlerEvent(evt);
}


/*------------------------------------------------------------------------------
| ICnrMenuHandler::menuEnded                                                   |
|                                                                              |
| Reset the object pointer and call our parent to process menu end.            |
------------------------------------------------------------------------------*/
bool ICnrMenuHandler::menuEnded( IMenuEvent& menuEvent )
{
#ifdef IC_PMWIN
#ifdef IC_WIN
  pcnrobjClMenu = 0;
#endif
#ifdef IC_PM
  //Instead of calling Inherited::menuEnded(), process here instead.
  //Do this so we can properly reset pcnrobjClMenu only when the main
  //popup menu is ending(not when the cascading sub menus go away).
  IWindow* popUpWindow =
           IWindow::windowWithHandle(IWindowHandle(menuEvent.parameter2()));

  //Only the main popup menu will satisfy this condition.
  if (popUpWindow && (popUpWindow->id() != FID_MENU))
  {
    removeSourceEmphasis(menuEvent);
    pcnrobjClMenu = 0;
  } /* endif */
#endif  //IC_PM
  return false;
#endif //IC_PMWIN

#ifdef IC_MOTIF
   bool fContinue = Inherited::menuEnded (menuEvent);
   pcnrobjClMenu = 0;
   return fContinue;
#endif //IC_MOTIF
}

/*------------------------------------------------------------------------------
| ICnrMenuHandler::popupMenuObject                                             |
|                                                                              |
| Returns the object for which a pop-up menu was requested.                    |
------------------------------------------------------------------------------*/
IContainerObject* ICnrMenuHandler::popupMenuObject()
{
   return pcnrobjClMenu;
}

/*------------------------------------------------------------------------------
| ICnrMenuHandler::addSourceEmphasis                                           |
|                                                                              |
| If over an object, add source emphasis on the object, otherwise add source   |
| emphasis on the container.                                                   |
------------------------------------------------------------------------------*/
void ICnrMenuHandler::addSourceEmphasis(const IMenuEvent& menuEvent )
{
  ITRACE_MOTIF_NOP();
#ifdef IC_PMWIN
  IContainerControl* pcnrctl = (IContainerControl*)menuEvent.window();
  if(pcnrobjClMenu)
  {
     if(pcnrctl->isSelected(pcnrobjClMenu))
     {
        IContainerControl::ObjectCursor cursor(*pcnrctl,
                                           IContainerObject::selected);
        for(cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
        {
          pcnrctl->showSourceEmphasis(pcnrctl->objectAt(cursor));
        }
     }
     else
       pcnrctl->showSourceEmphasis(pcnrobjClMenu);
  }
  else
     pcnrctl->showSourceEmphasis();
#endif //IC_PMWIN
}



/*------------------------------------------------------------------------------
| ICnrMenuHandler::removeSourceEmphasis                                        |
|                                                                              |
| If over an object, remove source emphasis on the object, otherwise remove    |
| source emphasis on the container.                                            |
------------------------------------------------------------------------------*/
void ICnrMenuHandler::removeSourceEmphasis(const IMenuEvent& menuEvent )
{
  ITRACE_MOTIF_NOP();
#ifdef IC_PMWIN
  IContainerControl* pcnrctl = (IContainerControl*)menuEvent.window();
  IContainerObject* pcnrobj;
  if(pcnrobjClMenu)
  {
     if(pcnrctl->isSelected(pcnrobjClMenu))
     {
        /************************************************************/
        /* Need to remove source emphasis on all selected objects.  */
        /* More than 1 object may be selected, so turn of refresh   */
        /* so that it doesn't flash every time we remove the        */
        /* source emphasis on each selected object.                 */
        /************************************************************/
        if (pcnrctl->isRefreshOn())
        {
          pcnrctl->setRefreshOff();
          IContainerControl::ObjectCursor cursor(*pcnrctl,
                                                IContainerObject::selected);
          for(cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
          {
            pcnrctl->hideSourceEmphasis(pcnrctl->objectAt(cursor));
          }
          pcnrctl->setRefreshOn();
          pcnrctl->refresh();
        }
        else
        {
          IContainerControl::ObjectCursor cursor(*pcnrctl,
                                                IContainerObject::selected);
          for(cursor.setToFirst(); cursor.isValid(); cursor.setToNext())
          {
            pcnrctl->hideSourceEmphasis(pcnrctl->objectAt(cursor));
          }
        }
     }
     else
       /***************************************************************/
       /* Only need to remove source emphasis for the cursored object */
       /***************************************************************/
       pcnrctl->hideSourceEmphasis(pcnrobjClMenu);
  }
  else
     /***************************************************************/
     /* Remove source emphasis on the whole container.              */
     /***************************************************************/
     pcnrctl->hideSourceEmphasis();
#endif //IC_PMWIN
}


/*------------------------------------------------------------------------------
| ICnrMenuHandler::handleEventsFor                                             |
|                                                                              |
| Attaches the handler to the container control passed in the argument.        |
------------------------------------------------------------------------------*/
ICnrMenuHandler& ICnrMenuHandler::handleEventsFor( IContainerControl *container)
{
  IASSERTPARM(container != 0);
  IHandler::handleEventsFor(container);
  return *this;
}


/*------------------------------------------------------------------------------
| ICnrMenuHandler::stopHandlingEventsFor                                       |
|                                                                              |
| Detaches the handler from the container control passed in the argument.      |
------------------------------------------------------------------------------*/
ICnrMenuHandler& ICnrMenuHandler::stopHandlingEventsFor(
                                                 IContainerControl *container )
{
  IASSERTPARM(container != 0);
  IHandler::stopHandlingEventsFor(container);
  return *this;
}

IHandler& ICnrMenuHandler :: handleEventsFor( IWindow *window )
{
    ITHROWLIBRARYERROR(IC_MEMBER_ACCESS_ERROR,
                         IBaseErrorInfo::invalidRequest,
                         IException::recoverable);
    return *this;
}

IHandler& ICnrMenuHandler :: stopHandlingEventsFor( IWindow *window )
{
    ITHROWLIBRARYERROR(IC_MEMBER_ACCESS_ERROR,
                         IBaseErrorInfo::invalidRequest,
                         IException::recoverable);
    return *this;
}
