/* Revision: 12 1.3.2.1 source/ui/cnr/icnrm.h, container, ioc.v400, 001006  */
/* NOSHIP */
/*******************************************************************************
* FILE NAME: icnrm.h                                                           *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file includes all the PM structures and definitions needed to compile *
*   icnr*.cpp files in a Motif environment.                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1997, 1997                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _ICNRM_
#define _ICNRM_

#include <ipfx.h>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#define HWND IWindowHandle
#define HPS  IPresSpaceHandle
#define PRECORDCORE IMiniCnrRecord*

#define VOID        void

#define CHAR    char            /* ch  */
#define SHORT   short           /* s   */
#define LONG    long            /* l   */


typedef unsigned char  UCHAR;   /* uch */
typedef unsigned short USHORT;  /* us  */
typedef unsigned long  ULONG;   /* ul  */


typedef char BYTE;     /* b   */

typedef char *PSZ;
typedef char *NPSZ;

typedef char *PCH;
typedef char *NPCH;
typedef const char *PCSZ;

typedef BYTE *PBYTE;
typedef BYTE *NPBYTE;

typedef CHAR *PCHAR;
typedef SHORT *PSHORT;
typedef LONG *PLONG;


typedef UCHAR *PUCHAR;
typedef USHORT *PUSHORT;
typedef ULONG *PULONG;

typedef VOID   *PVOID;
typedef PVOID  *PPVOID;

typedef unsigned long BOOL;     /* f   */
typedef BOOL *PBOOL;


/* Combine l & h to form a 32 bit quantity. */
#define MAKEULONG(l, h)  ((ULONG)(((USHORT)(l)) | ((ULONG)((USHORT)(h))) << 16))
#define MAKELONG(l, h)   ((LONG)MAKEULONG(l, h))

/* Combine l & h to form a 16 bit quantity. */
#define MAKEUSHORT(l, h) (((USHORT)(l)) | ((USHORT)(h)) << 8)
#define MAKESHORT(l, h)  ((SHORT)MAKEUSHORT(l, h))

/***************************************************************************/
/***        General Window Management types, constants and macros        ***/
/***************************************************************************/

typedef VOID *MPARAM;    /* mp    */
typedef MPARAM *PMPARAM;   /* pmp   */
typedef VOID *MRESULT;   /* mres  */
typedef MRESULT *PMRESULT;  /* pmres */

/*** Macros to make an MPARAM from standard types. *************************/

#define MPVOID                     ((MPARAM)0L)
#define MPFROMP(p)                 ((MPARAM)((ULONG)(p)))
#define MPFROMHWND(hwnd)           ((MPARAM)(HWND)(hwnd))
#define MPFROMCHAR(ch)             ((MPARAM)(USHORT)(ch))
#define MPFROMSHORT(s)             ((MPARAM)(USHORT)(s))
#define MPFROM2SHORT(s1, s2)       ((MPARAM)MAKELONG(s1, s2))
#define MPFROMSH2CH(s, uch1, uch2) ((MPARAM)MAKELONG(s, MAKESHORT(uch1, uch2)))
#define MPFROMLONG(l)              ((MPARAM)(ULONG)(l))

/*** Macros to extract standard types from an MPARAM ***********************/

#define PVOIDFROMMP(mp)            ((VOID *)(mp))
#define HWNDFROMMP(mp)             ((HWND)(mp))
#define CHAR1FROMMP(mp)            ((UCHAR)(mp))
#define CHAR2FROMMP(mp)            ((UCHAR)((ULONG)mp >> 8))
#define CHAR3FROMMP(mp)            ((UCHAR)((ULONG)mp >> 16))
#define CHAR4FROMMP(mp)            ((UCHAR)((ULONG)mp >> 24))
#define SHORT1FROMMP(mp)           ((USHORT)(ULONG)(mp))
#define SHORT2FROMMP(mp)           ((USHORT)((ULONG)mp >> 16))
#define LONGFROMMP(mp)             ((ULONG)(mp))

/*** Macros to make an MRESULT from standard types. ************************/

#define MRFROMP(p)                 ((MRESULT)(VOID *)(p))
#define MRFROMSHORT(s)             ((MRESULT)(USHORT)(s))
#define MRFROM2SHORT(s1, s2)       ((MRESULT)MAKELONG(s1, s2))
#define MRFROMLONG(l)              ((MRESULT)(ULONG)(l))

/*** Macros to extract standard types from an MRESULT **********************/

#define PVOIDFROMMR(mr)            ((VOID *)(mr))
#define SHORT1FROMMR(mr)           ((USHORT)((ULONG)mr))
#define SHORT2FROMMR(mr)           ((USHORT)((ULONG)mr >> 16))
#define LONGFROMMR(mr)             ((ULONG)(mr))

// See idrag/idmdnfo.hpp where _DRAGINFO is defined to IDragInfo
#define _DRAGINFO IDragInfo
#define DRAGINFO IDragInfo
class _DRAGINFO;
class DRAGINFO;
//@@Rob.  Is there a nicer way to do this?
//   typedef struct _DRAGINFO     /* dinfo */
//   {
//      ULONG    cbDraginfo;               /* Size of DRAGINFO and DRAGITEMs*/
//      USHORT   cbDragitem;               /* size of DRAGITEM              */
//      USHORT   usOperation;              /* current drag operation        */
//      HWND     hwndSource;               /* window handle of source       */
//      SHORT    xDrop;                    /* x coordinate of drop position */
//      SHORT    yDrop;                    /* y coordinate of drop position */
//      USHORT   cditem;                   /* count of DRAGITEMs            */
//      USHORT   usReserved;               /* reserved for future use       */
//   } DRAGINFO;
   typedef DRAGINFO *PDRAGINFO;


   /**********************************************************************/
   /* Field Info data structure, attribute and data types, CV_DETAIL     */
   /**********************************************************************/
   typedef struct _FIELDINFO      /* fldinfo */
   {
      ULONG      cb;                  /* size of FIELDINFO struct       */
      ULONG      flData;              /* attributes of field's data     */
      ULONG      flTitle;             /* attributes of field's title    */
      PVOID      pTitleData;          /* title data (default is string) */
      /*                                 If CFT_BITMAP, must be HBITMAP */
      ULONG      offStruct;           /* offset from RECORDCORE to data */
      PVOID      pUserData;           /* pointer to user data           */
      struct _FIELDINFO *pNextFieldInfo; /* pointer to next linked  */
      /*                                          FIELDINFO structure   */
      ULONG      cxWidth;             /* width of field in pels         */
   } FIELDINFO;
   typedef FIELDINFO *PFIELDINFO;

   /**********************************************************************/
   /*   Data Structures for Message Parameters                           */
   /**********************************************************************/

   /**********************************************************************/
   /* Container Direct Manipulation structures                           */
   /**********************************************************************/
   typedef struct _CNRDRAGINIT     /* cdrginit */
   {
      HWND        hwndCnr;                 /* Container window handle   */
      PRECORDCORE pRecord;                 /* record under mouse ptr    */
      LONG        x;                       /* x coordinate of mouse ptr */
      LONG        y;                       /* y coordinate of mouse ptr */
      LONG        cx;                      /* x offset from record      */
      LONG        cy;                      /* y offset from record      */
   } CNRDRAGINIT;
   typedef CNRDRAGINIT *PCNRDRAGINIT;

   /**********************************************************************/
   /* Data structure for CM_INSERTDETAILFIELDINFO                        */
   /* This structure is used by the application to specify the position  */
   /* of the FieldInfo structures they are inserting.                    */
   /**********************************************************************/
   typedef struct _FIELDINFOINSERT     /* fiins */
   {
      ULONG       cb;                  /* Size of structure.             */
      PFIELDINFO  pFieldInfoOrder;     /* Specifies the order of the     */
      /*                                  FieldInfo structures.          */
      ULONG       fInvalidateFieldInfo;/* Invalidate on Insert.          */
      ULONG       cFieldInfoInsert;    /* The number of FieldInfo        */
      /*                                  structures to insert.          */
   } FIELDINFOINSERT;
   typedef FIELDINFOINSERT *PFIELDINFOINSERT;

   /**********************************************************************/
   /* Data structure for CM_INSERTRECORD                                 */
   /**********************************************************************/
   typedef struct _RECORDINSERT     /* recins */
   {
      ULONG       cb;
      PRECORDCORE pRecordOrder;
      PRECORDCORE pRecordParent;
      ULONG       fInvalidateRecord;
      ULONG       zOrder;
      ULONG       cRecordsInsert;
   } RECORDINSERT;
   typedef RECORDINSERT *PRECORDINSERT;

   /**********************************************************************/
   /* Data structure for CM_QUERYRECORDFROMRECT                          */
   /**********************************************************************/
   typedef struct _QUERYRECFROMRECT     /* qrecfrct */
   {
      ULONG   cb;
      RECTL   rect;
      ULONG   fsSearch;
   } QUERYRECFROMRECT;
   typedef QUERYRECFROMRECT *PQUERYRECFROMRECT;

   /**********************************************************************/
   /* Data structure for CM_QUERYRECORDRECT                              */
   /**********************************************************************/
   typedef struct _QUERYRECORDRECT     /* qrecrct */
   {
      ULONG        cb;
      PRECORDCORE  pRecord;
      ULONG        fRightSplitWindow;
      ULONG        fsExtent;
   } QUERYRECORDRECT;
   typedef QUERYRECORDRECT *PQUERYRECORDRECT;

   /**********************************************************************/
   /* Data structure for CM_SEARCHSTRING                                 */
   /**********************************************************************/
   typedef struct _SEARCHSTRING     /* srchstr */
   {
      ULONG  cb;
      PSZ    pszSearch;
      ULONG  fsPrefix;
      ULONG  fsCaseSensitive;
      ULONG  usView;
   } SEARCHSTRING;
   typedef SEARCHSTRING *PSEARCHSTRING;

   /*******************************************************************/
   /* Data Structure for CN_DRAGLEAVE,CN_DRAGOVER,CN_DROP,CN_DROPHELP */
   /*******************************************************************/
   typedef struct _CNRDRAGINFO     /* cdrginfo */
   {
      PDRAGINFO   pDragInfo;
      PRECORDCORE pRecord;
   } CNRDRAGINFO;
   typedef CNRDRAGINFO *PCNRDRAGINFO;

   /**********************************************************************/
   /* Data structure for CN_EMPHASIS                                     */
   /**********************************************************************/
   typedef struct _NOTIFYRECORDEMPHASIS     /* nrecemph */
   {
      HWND        hwndCnr;
      PRECORDCORE pRecord;
      ULONG       fEmphasisMask;
      ULONG       fAcquired; 
   } NOTIFYRECORDEMPHASIS;
   typedef NOTIFYRECORDEMPHASIS *PNOTIFYRECORDEMPHASIS;

   /**********************************************************************/
   /* Data structure for CN_ENTER                                        */
   /**********************************************************************/
   typedef struct _NOTIFYRECORDENTER     /* notrecen */
   {
      HWND        hwndCnr;
      ULONG       fKey;
      PRECORDCORE pRecord;
   } NOTIFYRECORDENTER;
   typedef NOTIFYRECORDENTER *PNOTIFYRECORDENTER;

   /**********************************************************************/
   /* Data structure for CN_QUERYDELTA                                   */
   /**********************************************************************/
   typedef struct _NOTIFYDELTA     /* notdlt */
   {
      HWND        hwndCnr;
      ULONG       fDelta;
   } NOTIFYDELTA;
   typedef NOTIFYDELTA *PNOTIFYDELTA;

   /**********************************************************************/
   /* Data structure for CN_SCROLL                                       */
   /**********************************************************************/
   typedef struct _NOTIFYSCROLL     /* notscr */
   {
      HWND        hwndCnr;
      LONG        lScrollInc;
      ULONG       fScroll;
   } NOTIFYSCROLL;
   typedef NOTIFYSCROLL *PNOTIFYSCROLL;

   /**********************************************************************/
   /* Data structure for CN_REALLOCPSZ                                   */
   /**********************************************************************/
   typedef struct _CNREDITDATA     /* cnredat */
   {
      ULONG        cb;
      HWND         hwndCnr;
      PRECORDCORE  pRecord;
      PFIELDINFO   pFieldInfo;
      PSZ *ppszText;                   /* address of PSZ        */
      ULONG        cbText;                     /* size of the new text  */
      ULONG        id;
   } CNREDITDATA;
   typedef CNREDITDATA *PCNREDITDATA;

   /**********************************************************************/
   /* Data structure for CM_PAINTBACKGROUND                              */
   /**********************************************************************/
   typedef struct _OWNERBACKGROUND     /* ownbckg */
   {
      HWND    hwnd;
      HPS     hps;
      RECTL   rclBackground;
      LONG    idWindow;
   } OWNERBACKGROUND;
   typedef OWNERBACKGROUND *POWNERBACKGROUND;

   /**********************************************************************/
   /* Data structure used as part of WM_DRAWITEM                         */
   /**********************************************************************/
   typedef struct _CNRDRAWITEMINFO     /* cnrdrwii */
   {
      PRECORDCORE  pRecord;
      PFIELDINFO   pFieldInfo;
   } CNRDRAWITEMINFO;
   typedef CNRDRAWITEMINFO *PCNRDRAWITEMINFO;


   /**********************************************************************/
   /* Error constants                                                    */
   /**********************************************************************/
   #define PMERR_NOFILTERED_ITEMS          0x1f02
   #define PMERR_COMPARISON_FAILED         0x1f03
   #define PMERR_RECORD_CURRENTLY_INSERTED 0x1f04
   #define PMERR_FI_CURRENTLY_INSERTED     0x1f05

   /**********************************************************************/
   /* Container control styles.                                          */
   /**********************************************************************/
   #define CCS_EXTENDSEL             0x00000001L
   #define CCS_MULTIPLESEL           0x00000002L
   #define CCS_SINGLESEL             0x00000004L
   #define CCS_AUTOPOSITION          0x00000008L
   #define CCS_VERIFYPOINTERS        0x00000010L
   #define CCS_READONLY              0x00000020L
   #define CCS_MINIRECORDCORE        0x00000040L

   /**********************************************************************/
   /* view identifiers           (flWindowAttr)                          */
   /**********************************************************************/
   #define CV_TEXT                  0x00000001L  /* text view            */
   #define CV_NAME                  0x00000002L  /* name view            */
   #define CV_ICON                  0x00000004L  /* icon view            */
   #define CV_DETAIL                0x00000008L  /* detail view          */
   #define CV_FLOW                  0x00000010L  /* flow items           */
   #define CV_MINI                  0x00000020L  /* use mini icon        */
   #define CV_TREE                  0x00000040L  /* tree view            */
   #define CV_EXACTMATCH            0x10000000L  

   /**********************************************************************/
   /* Container Attributes        (flWindowAttr)                         */
   /**********************************************************************/
   #define CA_CONTAINERTITLE        0x00000200L
   #define CA_TITLESEPARATOR        0x00000400L
   #define CA_TITLELEFT             0x00000800L
   #define CA_TITLERIGHT            0x00001000L
   #define CA_TITLECENTER           0x00002000L
   #define CA_OWNERDRAW             0x00004000L
   #define CA_DETAILSVIEWTITLES     0x00008000L
   #define CA_ORDEREDTARGETEMPH     0x00010000L
   #define CA_DRAWBITMAP            0x00020000L
   #define CA_DRAWICON              0x00040000L
   #define CA_TITLEREADONLY         0x00080000L
   #define CA_OWNERPAINTBACKGROUND  0x00100000L
   #define CA_MIXEDTARGETEMPH       0x00200000L
   #define CA_TREELINE              0x00400000L

   /**********************************************************************/
   /* child window IDs                                                   */
   /**********************************************************************/
   #define CID_LEFTCOLTITLEWND     0x7FF0   /* column title (left)       */
   #define CID_RIGHTCOLTITLEWND    0x7FF1   /* right column title        */
   #define CID_BLANKBOX            0x7FF2   /* blank box at bottom right */
   #define CID_HSCROLL             0x7FF3   /* horizontal scroll bar     */
   #define CID_RIGHTHSCROLL        0x7FF4   /* right horz scroll bar     */
   #define CID_CNRTITLEWND         0x7FF5   /* Container title window    */
   #define CID_LEFTDVWND           0x7FF7   /* Left Details View window  */
   #define CID_RIGHTDVWND          0x7FF8   /* Right Details View window */
   #define CID_VSCROLL             0x7FF9   /* vertical scroll bar       */
   #define CID_MLE                 0x7FFA   /* MLE window for direct edit*/


   /**********************************************************************/
   /* attribute and type values for flData and flTitle members of        */
   /* FIELDINFO, CFA_ (attributes), CFT_ (types)                         */
   /**********************************************************************/
   #define CFA_LEFT            0x00000001L /* left align text            */
   #define CFA_RIGHT           0x00000002L /* right align text           */
   #define CFA_CENTER          0x00000004L /* center text                */
   #define CFA_TOP             0x00000008L /* top-align text             */
   #define CFA_VCENTER         0x00000010L /* vertically center text     */
   #define CFA_BOTTOM          0x00000020L /* bottom-align text          */
   #define CFA_INVISIBLE       0x00000040L /* Specify invisible column.  */
   #define CFA_BITMAPORICON    0x00000100L /* field title is bitmap      */
   #define CFA_SEPARATOR       0x00000200L /* vert sep, right of fld     */
   #define CFA_HORZSEPARATOR   0x00000400L /* horz sep, bottom of fld    */

   #define CFA_STRING          0x00000800L /* string of characters       */
   #define CFA_OWNER           0x00001000L /* ownerdraw field            */
   #define CFA_DATE            0x00002000L /* date structure             */
   #define CFA_TIME            0x00004000L /* time structure             */
   #define CFA_FIREADONLY      0x00008000L /* Column is read-only.       */
   #define CFA_FITITLEREADONLY 0x00010000L /* Column Title is read-only  */
   #define CFA_ULONG           0x00020000L /* Column is number format    */

   /**********************************************************************/
   /* attribute values for flRecordAttr member of RECORDCORE             */
   /**********************************************************************/
   #define CRA_SELECTED        0x00000001L /* record is selected         */
   #define CRA_TARGET          0x00000002L /* record has target emphasis */
   #define CRA_CURSORED        0x00000004L /* cursor is on the record    */
   #define CRA_INUSE           0x00000008L /* record has in-use emphasis */
   #define CRA_FILTERED        0x00000010L /* record has been filtered   */
   #define CRA_DROPONABLE      0x00000020L /* record can be dropped on   */
   #define CRA_RECORDREADONLY  0x00000040L /* record is read-only        */
   #define CRA_EXPANDED        0x00000080L /* record is expanded         */
   #define CRA_COLLAPSED       0x00000100L /* record is collapsed        */

   /**********************************************************************/
   /* Container messages                                                 */
   /**********************************************************************/
   #define CM_ALLOCDETAILFIELDINFO       0x0330
   #define CM_ALLOCRECORD                0x0331
   #define CM_ARRANGE                    0x0332
   #define CM_ERASERECORD                0x0333
   #define CM_FILTER                     0x0334
   #define CM_FREEDETAILFIELDINFO        0x0335
   #define CM_FREERECORD                 0x0336
   #define CM_HORZSCROLLSPLITWINDOW      0x0337
   #define CM_INSERTDETAILFIELDINFO      0x0338
   #define CM_INSERTRECORD               0x0339
   #define CM_INVALIDATEDETAILFIELDINFO  0x033a
   #define CM_INVALIDATERECORD           0x033b
   #define CM_PAINTBACKGROUND            0x033c
   #define CM_QUERYCNRINFO               0x033d
   #define CM_QUERYDETAILFIELDINFO       0x033e
   #define CM_QUERYDRAGIMAGE             0x033f
   #define CM_QUERYRECORD                0x0340
   #define CM_QUERYRECORDEMPHASIS        0x0341
   #define CM_QUERYRECORDFROMRECT        0x0342
   #define CM_QUERYRECORDRECT            0x0343
   #define CM_QUERYVIEWPORTRECT          0x0344
   #define CM_REMOVEDETAILFIELDINFO      0x0345
   #define CM_REMOVERECORD               0x0346
   #define CM_SCROLLWINDOW               0x0347
   #define CM_SEARCHSTRING               0x0348
   #define CM_SETCNRINFO                 0x0349
   #define CM_SETRECORDEMPHASIS          0x034a
   #define CM_SORTRECORD                 0x034b
   #define CM_OPENEDIT                   0x034c
   #define CM_CLOSEEDIT                  0x034d
   #define CM_COLLAPSETREE               0x034e
   #define CM_EXPANDTREE                 0x034f
   #define CM_QUERYRECORDINFO            0x0350

   /**********************************************************************/
   /* Container notifications                                            */
   /**********************************************************************/
   #define CN_DRAGAFTER                  101
   #define CN_DRAGLEAVE                  102
   #define CN_DRAGOVER                   103
   #define CN_DROP                       104
   #define CN_DROPHELP                   105
   #define CN_ENTER                      106
   #define CN_INITDRAG                   107
   #define CN_EMPHASIS                   108
   #define CN_KILLFOCUS                  109
   #define CN_SCROLL                     110
   #define CN_QUERYDELTA                 111
   #define CN_SETFOCUS                   112
   #define CN_REALLOCPSZ                 113
   #define CN_BEGINEDIT                  114
   #define CN_ENDEDIT                    115
   #define CN_COLLAPSETREE               116
   #define CN_EXPANDTREE                 117
   #define CN_HELP                       118
   #define CN_CONTEXTMENU                119

   /**********************************************************************/
   /* Message parameter flags                                            */
   /**********************************************************************/
   #define CMA_TOP              0x0001       /* Place at top of zorder   */
   #define CMA_BOTTOM           0x0002       /* Place at bottom of zorder*/
   #define CMA_LEFT             0x0004
   #define CMA_RIGHT            0x0008

   #define CMA_FIRST            0x0010       /* Add record as first      */
   #define CMA_LAST             0x0020
   #define CMA_END              0x0040       /* Add record to end of list*/
   #define CMA_PREV             0x0080
   #define CMA_NEXT             0x0100

   #define CMA_HORIZONTAL       0x0200
   #define CMA_VERTICAL         0x0400
   #define CMA_ICON             0x0800
   #define CMA_TEXT             0x1000
   #define CMA_PARTIAL          0x2000
   #define CMA_COMPLETE         0x4000

   #define CMA_PARENT           0x0001
   #define CMA_FIRSTCHILD       0x0002
   #define CMA_LASTCHILD        0x0004

   #define CMA_CNRTITLE         0x0001       /* Container title          */
   #define CMA_DELTA            0x0002       /* Application defined      */
   #define CMA_FLWINDOWATTR     0x0004       /* Container attributes     */
   #define CMA_LINESPACING      0x0008
   #define CMA_PFIELDINFOLAST   0x0010       /* Ptr to last column in    */

   #define CMA_PSORTRECORD      0x0020       /* Pointer to sort function */
   #define CMA_PTLORIGIN        0x0040       /* Lower left origin        */
   #define CMA_SLBITMAPORICON   0x0080       /* Size  of bitmap          */
   #define CMA_XVERTSPLITBAR    0x0100       /* Splitbar position        */
   #define CMA_PFIELDINFOOBJECT 0x0200       /* Pointer to IN-USE        */
   /*                                             emphasis column.       */


   #define CMA_TREEICON           0x0400     /* Icon for tree node      */
   #define CMA_TREEBITMAP         0x0800     /* bitmap for tree node    */
   #define CMA_CXTREEINDENT       0x1000     /* indent for children     */
   #define CMA_CXTREELINE         0x2000     /* thickness of tree line  */
   #define CMA_SLTREEBITMAPORICON 0x4000     /* size of icon of tree node */
   #define CMA_DATAWIDTH          0x8000     /* */

   #define CMA_ITEMORDER        0x0001       /* QueryRecord search flags */
   #define CMA_WINDOW           0x0002
   #define CMA_WORKSPACE        0x0004
   #define CMA_ZORDER           0x0008

   #define CMA_DELTATOP         0x0001       /* Industrial - top delta   */
   #define CMA_DELTABOT         0x0002       /* Industrial - bottom delta*/
   #define CMA_DELTAHOME        0x0004       /* Industrial - top of list */
   #define CMA_DELTAEND         0x0008       /* Industrial - end of list */

   #define CMA_NOREPOSITION     0x0001       /* InvalidateRecord flags   */
   #define CMA_REPOSITION       0x0002
   #define CMA_TEXTCHANGED      0x0004
   #define CMA_ERASE            0x0008

   #define CMA_FREE             0x0001
   #define CMA_INVALIDATE       0x0002

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
